Require Import lp_inf lp_ind lp_labels lp_tactics sigs forall_depth_inf.
Require Import Coq.Program.Equality.
From Hammer Require Import Tactics.

Module LTy
  (Import lc : lc_sig)
  (Import wff : wff_sig)
  (Import regularity : regularity_sig)
  (Import subst : subst_sig)
  (Import narrow : typing_narrowing_sig) <: LTy_sig.

  (* LTy really should be defined mutually recursively with CLTy *)
  (* but I don't want to repeat the substitution proofs again *)

Lemma type_in_type_impossible :
  forall Γ, ~ Typing Γ t_L a_TYPE a_TYPE.
Proof.
  sauto lq:on rew:off inv:Typing.
Qed.

Lemma ctx_no_tyvar : forall G,
  Ctx G -> forall x ρ0 A,
      binds x (ρ0, t_L, A) G -> A <> a_TYPE.
  induction 1.
  - eauto.
  - intros.
    hauto q:on  depth:2 use:Ctx_uniq, binds_cons_iff, type_in_type_impossible.
Qed.

Lemma LTy_subst : forall A, LTy A -> forall x a, lc_tm a -> LTy (subst_tm a x A).
Proof.
  induction 1; intros; simpl in *; auto.
  - pick fresh y and apply LTy_PiLogic; repeat (spec y); eauto.
    rewrite subst_tm_open_tm_wrt_tm_var; eauto.

  - pick fresh y and apply LTy_PiProg; repeat (spec y); eauto.
    strivial use: subst_tm_lc_tm unfold: tmvar.
    rewrite subst_tm_open_tm_wrt_tm_var; eauto.
  - sfirstorder use: subst_tm_lc_tm unfold:tmvar.
Qed.

Lemma LTy_Pi_inv : forall ρ0 θ0 A1 A2, LTy (a_Pi (ρ0, θ0) A1 A2) ->
                                    forall x, LTy (open_tm_wrt_tm A2 (a_Var_f x)).
Proof.
  inversion 1; subst; auto; intros; pick fresh y.
  - repeat (spec y).
    rewrite (subst_tm_intro y); auto.
    apply LTy_subst; eauto.
  - repeat (spec y).
    rewrite (subst_tm_intro y); auto.
    apply LTy_subst; eauto.
Qed.


Lemma L_typing_special_form :
  forall Γ A, Typing Γ t_L A a_TYPE -> LTy A.
Proof.
  intros Γ A h.
  dependent induction h; intros; auto.
  - sfirstorder use:type_in_type_impossible.
  - sauto use:ctx_no_tyvar.
  - destruct theta0.
    + pick fresh y and apply LTy_PiLogic; eauto with lc.
    + pick fresh y and apply LTy_PiProg; eauto with lc.
  - apply typing_regularity in h.
    destruct h as [h | h].
    + inversion h; subst.
      pick fresh y. repeat (spec y).
      enough (Typing (meet_ctx_l_rho q_R G) t_L (open_tm_wrt_tm B a) a_TYPE) by hauto use:type_in_type_impossible.
      rewrite (subst_tm_intro y).
      change a_TYPE with (subst_tm a y a_TYPE).
      eapply typing_subst_nil; eauto.
      qauto l:on inv:CTyping db:narrow.
      fsetdec.
    + inversion h.
  - hauto l:on db:lc.
  - assert (h :Typing G t_L (a_Ind a1 a2 a3 (a_Pi (q_R, t_L) a_Nat A)) (open_tm_wrt_tm A a1)) by
      hauto l:on.
    assert (hlc :lc_tm (a_Ind a1 a2 a3 (a_Pi (q_R, t_L) a_Nat A))) by
      hauto l:on use:typing_lc1.
    assert (hlc2 :lc_tm a1) by
      hauto lq:on rew:off inv:lc_tm.
    pick fresh y; repeat (spec y).
    specialize (IHh1 ltac:(reflexivity) ltac:(reflexivity)).
    inversion IHh1; subst.
    pick fresh z.
    repeat (spec z).
    assert (LTy (subst_tm a1 z (open_tm_wrt_tm A (a_Var_f z)))).
    apply LTy_subst; eauto.
    rewrite subst_tm_open_tm_wrt_tm in H2; auto.
    simpl in H2.
    rewrite eq_dec_refl in H2.
    rewrite subst_tm_fresh_eq in H2; auto.
    rewrite x in H2.
    inversion H2.
Qed.


Lemma subst_forall_depth :
  forall B, LTy B -> forall x a, lc_tm a -> tm_forall_depth (subst_tm a x B) = tm_forall_depth B.
Proof.
  induction 1; intros; eauto.
  - pick fresh y; repeat (spec y).
    simpl.
    rewrite IHLTy; auto.
    f_equal.
    f_equal.
    specialize (H3 x a ltac:(auto)).
    rewrite subst_tm_open_tm_wrt_tm in H3; auto.
    simpl in H3.
    set (b := y == x).
    replace (y == x) with b in H3; auto.
    destruct b; subst; auto.
    fsetdec.
    scongruence use:open_tm_wrt_tm_var_forall_depth.
  - pick fresh y; repeat (spec y).
    simpl.
    f_equal.
    specialize (H3 x a ltac:(auto)).
    rewrite subst_tm_open_tm_wrt_tm in H3; auto.
    simpl in H3.
    set (b := y == x).
    replace (y == x) with b in H3; auto.
    destruct b; subst; auto.
    fsetdec.
    scongruence use:open_tm_wrt_tm_var_forall_depth.
Qed.

Lemma subst_valuation_LTy : forall ξ B, LTy B -> valuation_lc ξ -> LTy (subst_valuation ξ B).
Proof.
  induction ξ; eauto.
  - simpl.
    inv_atom_rel_tm.
    simpl_env; intros.
    apply LTy_subst.
    apply IHξ; auto.
    sfirstorder.
    unfold valuation_lc in H0.
    fcrush.
Qed.

Lemma subst_valuation_forall_depth :
  forall ξ B, LTy B -> valuation_lc ξ -> tm_forall_depth (subst_valuation ξ B) = tm_forall_depth B.
Proof.
  induction ξ; auto.
  intros.
  simpl.
  inv_atom_rel_tm.
  rewrite subst_forall_depth; eauto.
  sfirstorder.
  eapply subst_valuation_LTy; eauto.
  sfirstorder.
Qed.

End LTy.
