# System Specification
The full specification of the DE type system is in the file [lp_ott.v](lp_ott.v]. This
file has been mechanically generated from the Ott specification in
[lp.ott](lp.ott). `DefEqAlt`, `aRedAlt` and `VWff` are unused in our
mechanization. We include them [lp.ott](lp.ott) so we can
automatically render them in LaTeX. As a result, ott also outputs some
useless coq definitions that we don't use.
 The actual definitions of the
admissible definitional equality and reduction rules are
directly written in Coq as lemmas (we marked locations of those lemmas
in the main text). The well-formedness of valuation is defined in
[sn_def.v](sn_def.v) and is called `valuation_wff`.

In the Ott specification, you will see certain premises wrapped around
in square brackets. These premises are not rendered in the LaTeX file
but appear in the Coq output. We prove that those premises are
admissible through the introduction lemmas we prove in [introalt.v](introalt.v).

# Compilation Instructions
The development has been tested with the following package versions:
```
coq                   8.16.0
coq-equations         1.3+8.16
coq-hammer            1.3.2+8.16
coq-hammer-tactics    1.3.2+8.16
```
You can install these packages manually or import the saved switch state we
provided ([coq-switch](coq-switch)):
```sh
# create a switch named system-de
opam switch import coq-switch --switch=system-de
# switch to system-de
opam switch set system-de
```
Depending on your shell type, `opam` will hint you to run a specific command to update the environment variables of your shell after setting `system-de` as your switch.


To compile this code with Coq, you also need to install a copy of the Metalib
library. This library is available from
https://github.com/plclub/metalib and we have tested our development with
the commit be0f81c.

Once Coq and metalib have been installed, the files can be compiled using
```sh
make coq
```
or
```sh
# replace n with the number of cpu cores you want to use
make -jn coq
```

# Contents

## Module signatures
To speed up compilation, we define a signature file [sigs.v](sigs.v) that contains
all the lemma/theorem signatures as axioms in module types. Each
module type is implemented by a concrete coq file. The file
[toplevel.v](toplevel.v) instantiates all the signatures to ensure
every module type is properly implemented as there is no circular
dependency.
[toplevel.v](toplevel.v) can be used as a quick overview on how lemmas depend
on each other.

## Miscellaneous
| File  | Description |
| ---------- | --------------------- |
| [lattice.v] | Definition of the relevance and fragment modes |
| [lattice_solver.v] | A simple lattice solver |
| [lp_tactics.v] | Helper tactics |

## Structural lemmas
| File  | Description |
| ---------- | --------------------- |
|  [lp_lc.v]    |  Locally-nameless specific lemmas   |
|  [lp_wff.v]   |  Judgments imply context well-formedness |
|  [lp_narrowing.v] | Narrowing lemmas |
| [lp_weak.v] | Weakening lemmas |
| [typing_unique.v] | Every term can be assigned a unique type |
| [subsumption.v] | Subsumption lemmas |
| [typing_fv.v] | A typed term can only contain variables from the context |
| [lp_subst.v] | Substitution lemmas |
| [regularity.v] | Regularity lemmas |
| [LTy.v] | Properties about the computation, polymorphism-free types |

## Type soundness
| File  | Description |
| ---------- | --------------------- |
| [preservation.v] | Preservation and several reduction related lemmas |
| [progress.v] | Progress lemma |

## Simulation and erasure
| File  | Description |
| ---------- | --------------------- |
| [simulation.v] | Simulation between the typed language and an erased language |

## Admissible premises
| File  | Description |
| ---------- | --------------------- |
| [introalt.v] | Admissible alternative introduction rules |

## Consistency
| File  | Description |
| ---------- | --------------------- |
| [par.v]    |   Parallel reduction and confluence  |
| [sn_def.v] |   Definition of logical relation      |
| [sn_proof.v] | Fundamental theorem and consistency |
