Require Import lp_inf lp_labels lp_tactics.
Require Import Coq.Program.Equality.
From Hammer Require Import Tactics.

Definition CMultiPar P ρ A1 A2 :=
  match ρ with
  | q_R => MultiPar P A1 A2
  | q_I => lc_tm A1 /\ lc_tm A2 /\ uniq P
  end.

Definition CJoins P ρ A1 A2 :=
  match ρ with
  | q_R => Joins P A1 A2
  | q_I => lc_tm A1 /\ lc_tm A2 /\ uniq P
  end.

Lemma CJoins_CMultiPar : forall P ρ a b,
    CJoins P ρ a b <->
    exists c, CMultiPar P ρ a c /\ CMultiPar P ρ b c.
Proof.
  destruct ρ.
  - sauto.
  - sfirstorder.
Qed.

Lemma open_tm_wrt_tm_var_forall_depth_rec :
  forall B n x, tm_forall_depth (open_tm_wrt_tm_rec n (a_Var_f x) B) = tm_forall_depth B.
Proof.
  induction B; inv_atom_rel_tm; eauto; intros.
  - destruct f;
      scongruence.
  - pose proof (lt_eq_lt_dec n n0) as h.
    hauto q:on.
Qed.

Lemma open_tm_wrt_tm_var_forall_depth :
  forall B x, tm_forall_depth (open_tm_wrt_tm B (a_Var_f x)) = tm_forall_depth B.
Proof.
  hauto l:on use:open_tm_wrt_tm_var_forall_depth_rec.
Qed.
