From LP Require Import lp_inf lp_ind lp_tactics lp_labels sigs.

From Hammer Require Import Tactics.
From Ltac2 Require Import Ltac2 Constr Control.
Require Import Coq.Program.Equality.

Set Default Proof Mode "Classic".

(* Alternative introduction rules *)
(* Some of the lemmas are necessary for injecting ~> into defeq *)
Module introalt
  (Import lty : LTy_sig)
  (Import regularity : regularity_sig)
  (Import narrow : typing_narrowing_sig)
  (Import wff : wff_sig)
  (Import subsumption : subsumption_sig)
  (Import unique : unique_sig)
  (Import preservation : preservation_sig).

Lemma app_has_kind_TYPE :
  forall Γ θ a δ0 b A,
    Typing Γ θ (a_App a δ0 b) A ->
    Typing (meet_ctx_l_rho q_R Γ) θ A a_TYPE.
Proof.
  destruct θ.
  - intros.
    pose proof H as H0.
    apply typing_regularity in H.
    destruct H.
    + auto.
    + subst.
      apply L_typing_special_form in H0.
      inversion H0.
  - intros.
    assert (tr0 : Ctx Γ) by sfirstorder use:typing_wff.
    assert (tr1 : Ctx (meet_ctx_l_rho q_R Γ)) by sfirstorder use:ctx_meet_ctx_l.
    hauto lq:on use:typing_regularity.
Qed.

Lemma app_cong_same_arg_intro_rel :
  forall (G:context) (theta0:fragment) (g:co) (G0:context) (theta:fragment) (a1 a2 b  A B:tm),
     DefEq G g G0 theta a1 a2 ->
     Typing  ( G0  ++  G )  theta (a_App a1  (   q_R  ,  theta0  )  b) A ->
     Typing  ( G0  ++  G )  theta (a_App a2  (   q_R  ,  theta0  )  b) A ->
     exists g0,
     DefEq G g0 G0 theta  (a_App a1  (   q_R  ,  theta0  )  b)  (a_App a2  (   q_R  ,  theta0  )  b).
Proof.
  intros.
  (* TODO: Show that A : a_TYPE *)
  assert (tr0 : Typing (meet_ctx_l_rho q_R (G0 ++ G)) theta A a_TYPE)
           by hauto l:on use:app_has_kind_TYPE.

  assert (h0: DefEq G (g_AppCong g theta0 (g_Reflex b) (g_Reflex A)) G0 theta (a_Conv (a_App a1 (q_R, theta0) b) (g_Reflex A))  (a_App a2 (q_R, theta0) b)).
  eapply E_AppCong; eauto.
  - inversion H0; subst.
    econstructor; eauto.
    sauto lq:on.
  - eexists.
    apply E_Trans with (a1 := (a_Conv (a_App a1 (q_R, theta0) b) (g_Reflex A))).
    eapply E_Sym.
    eapply E_Red.
    econstructor.
    econstructor; eauto.
    econstructor; eauto.
    eassumption.
    eauto.
Qed.

Lemma app_cong_same_arg_intro_irrel :
  forall (G:context) (theta0:fragment) (g:co) (G0:context) (theta:fragment) (a1 a2 b  A B:tm),
     DefEq G g G0 theta a1 a2 ->
     Typing  ( G0  ++  G )  theta (a_App a1  (   q_I  ,  theta0  )  b) A ->
     Typing  ( G0  ++  G )  theta (a_App a2  (   q_I  ,  theta0  )  b) A ->
     exists g0,
       DefEq G g0 G0 theta  (a_App a1  (   q_I  ,  theta0  )  b)  (a_App a2  (   q_I  ,  theta0  )  b).
Proof.
  intros.
  assert (tr0 : Typing (meet_ctx_l_rho q_R (G0 ++ G)) theta A a_TYPE)
    by hauto l:on use:app_has_kind_TYPE.
  assert (h0: DefEq G (g_AppCongIrrel g theta0 b b (g_Reflex A)) G0 theta (a_Conv (a_App a1 (q_I, theta0) b) (g_Reflex A))  (a_App a2 (q_I, theta0) b)).
  inversion H0; subst.
  eapply E_AppCongIrrel; eauto.
  - sauto lq:on.
  - sauto lq:on.
  - eexists.
    apply E_Trans with (a1 := (a_Conv (a_App a1 (q_I, theta0) b) (g_Reflex A))).
    eapply E_Sym.
    eapply E_Red.
    econstructor.
    econstructor; eauto.
    econstructor; eauto.
    eassumption.
    eauto.
Qed.

Lemma app_cong_same_arg_intro :
  forall (G:context) (δ0:relevance * fragment) (g:co) (G0:context) (theta:fragment) (a1 a2 b  A B:tm),
     DefEq G g G0 theta a1 a2 ->
     Typing  ( G0  ++  G )  theta (a_App a1  δ0  b) A ->
     Typing  ( G0  ++  G )  theta (a_App a2  δ0  b) A ->
     exists g0,
       DefEq G g0 G0 theta  (a_App a1  δ0  b)  (a_App a2  δ0  b).
Proof.
  destruct δ0 as [[] θ].
  - sfirstorder use:app_cong_same_arg_intro_rel.
  - sfirstorder use:app_cong_same_arg_intro_irrel.
Qed.

Lemma ered_intro :
  forall (G:context) (a b:tm) (G0:context) (theta:fragment),
     aBeta  ( G0  ++  G )  theta a b ->
     DefEq G (g_Beta a b) G0 theta a b.
Proof.
  hauto l:on use:preservation_primitive.
Qed.

Lemma abeta_defeq_inj :
  forall Γ θ a b,
    aBeta Γ θ a b ->
    DefEq Γ (g_Beta a b) nil θ a b.
Proof.
  hauto l:on use:preservation_primitive.
Qed.

Lemma cored_defeq_inj :
  forall Γ θ a b,
    aCoRed Γ θ a b ->
    forall A, Typing Γ θ a A ->
         exists g, DefEq Γ g nil θ a b.
Proof.
  induction 1; eauto;
    intros A0 h0;
    try solve [eexists; eapply ered_intro; eauto].
  inversion h0; subst.
  specialize (IHaCoRed _ H3).
  destruct IHaCoRed as [g0 hg].
  eexists.
  eapply E_ConvCong; eauto.
  simpl.
  apply T_Conv with (A := A); eauto.
  sfirstorder use:defeq_same_type_nil.
  (* Guard the sauto so we don't accidentally hit the wrong goal and diverge *)
  lazymatch goal with [|- context[a_Succ]] => sauto lq:on rew:off end.
Qed.

Lemma coreds_defeq_inj :
  forall Γ θ a b,
    aCoReds Γ θ a b ->
    forall A,
      Typing Γ θ a A ->
      exists g, DefEq Γ g nil θ a b.
Proof.
  induction 1; intros A0 hA0.
  - hauto lq:on ctrs:DefEq.
  - sauto lq:on rew:off use:cored_defeq_inj, preservation_cored1.
Qed.

Lemma red_defeq_inj :
  forall Γ θ a b,
    aRed Γ θ a b ->
    forall A, Typing Γ θ a A ->
         exists g, DefEq Γ g nil θ a b.
Proof.
  induction 1; intros A0 hA0.
  - assert (hred : aRed G theta (a_App a delta0 b) (open_tm_wrt_tm a1 b))
      by sfirstorder.
    assert (h0 : exists g0, DefEq G g0 nil theta a (a_Abs delta0 A a1))
      by sauto lq:on rew:off use:coreds_defeq_inj.
    destruct h0 as [g0 hg0].
    assert (h1 : exists g1, DefEq G g1 nil theta
                    (a_App a delta0 b)
                    (a_App (a_Abs delta0 A a1) delta0 b)).
    {
      eapply app_cong_same_arg_intro; eauto.
      ecrush use:preservation_coreds.
    }

    destruct h1 as [g1 hg1].
    eexists.
    apply E_Trans with (a1 := (a_App (a_Abs delta0 A a1) delta0 b)); eauto.
    eapply ered_intro.
    apply aBeta_AppAbs with (A0 := A0); simpl; eauto.
    inversion hA0; subst.
    assert (tr2 : Typing G theta (a_Abs delta0 A a1) (a_Pi delta0 A1 B))
      by sfirstorder use:preservation_coreds.
    sfirstorder.
  - inversion hA0; subst.
    specialize (IHaRed _ H7).
    destruct IHaRed as [g hg].
    eapply app_cong_same_arg_intro; eauto.
    sfirstorder use:preservation_red.
  - inversion hA0; subst.
    specialize (IHaRed _ H3).
    destruct IHaRed as [g0 hg0].
    sauto depth:2 lq:on use:preservation_red.
  - sauto depth:2 lq:on.
  - assert (tr0 : aBeta G theta (a_Ind (a_Succ a1) a2 a3 (a_Pi (q_R, t_L) a_Nat A))
                   (a_App (open_tm_wrt_tm a3 a1) (q_R, t_L) (a_Ind a1 a2 a3 (a_Pi (q_R, t_L) a_Nat A))))
      by strivial.
    assert (tr1 : Typing G theta (a_App (open_tm_wrt_tm a3 a1) (q_R, t_L) (a_Ind a1 a2 a3 (a_Pi (q_R, t_L) a_Nat A))) B1)
      by sfirstorder use:preservation_primitive0.
    assert (tr2 : Typing G t_L a0 a_Nat)
             by qauto l:on inv:Typing.
    assert (tr3 : Typing G t_L (a_Succ a1) a_Nat)
             by qauto l:on use:preservation_coreds.
    assert (tr4 : exists g, DefEq G g nil t_L a0 (a_Succ a1))
      by sfirstorder use:coreds_defeq_inj.
    inversion H1; subst.
    assert (tr00 : Ctx G) by hauto l:on use:typing_wff.
    assert (A0 = (open_tm_wrt_tm A a0)) by sfirstorder use:typing_unique; subst.
    destruct tr4 as [g0 tr4].
    pose proof tr0 as tr5.
    apply abeta_defeq_inj in tr5.
    eexists.
    apply E_Sym.
    apply E_Trans with (a1 := a_Conv (a_Ind (a_Succ a1) a2 a3 (a_Pi (q_R, t_L) a_Nat A)) g).
    apply E_ConvCong with (A := (open_tm_wrt_tm A a0)); auto.
    apply E_Sym.
    apply tr5.
    sblast use:ind_has_kind_TYPE.
    sblast use:ind_has_kind_TYPE.
    pick fresh y and apply E_IndCong; eauto.
    instantiate (1 := (g_Reflex a3)).
    eapply E_Reflex; eauto.
    sfirstorder.
  - assert (tr0 : aBeta G theta (a_Ind a_Zero a2 a3 (a_Pi (q_R, t_L) a_Nat A)) a2)
      by strivial.
    assert (tr1 : Typing G theta a2 B1)
      by sfirstorder use:preservation_primitive0.
    assert (tr2 : Typing G t_L a1 a_Nat)
             by qauto l:on inv:Typing.
    assert (tr3 : Typing G t_L a_Zero a_Nat)
             by qauto l:on use:preservation_coreds.
    assert (tr4 : exists g, DefEq G g nil t_L a1 a_Zero)
      by sfirstorder use:coreds_defeq_inj.
    inversion H1; subst.
    assert (tr00 : Ctx G) by hauto l:on use:typing_wff.
    assert (A0 = (open_tm_wrt_tm A a1)) by sfirstorder use:typing_unique; subst.
    destruct tr4 as [g0 tr4].
    pose proof tr0 as tr5.
    apply abeta_defeq_inj in tr5.
    eexists.
    apply E_Sym.
    apply E_Trans with (a1 := a_Conv (a_Ind a_Zero a2 a3 (a_Pi (q_R, t_L) a_Nat A)) g).
    apply E_ConvCong with (A := (open_tm_wrt_tm A a1)); eauto.
    ecrush use:ind_has_kind_TYPE.
    sblast use:ind_has_kind_TYPE.
    pick fresh y and apply E_IndCong; eauto.
    instantiate (1 := (g_Reflex a3)).
    eapply E_Reflex; eauto.
    sfirstorder.
  - inversion H0; subst.
    assert (tr0 : Typing G theta a1 a_Nat)
      by sauto depth:2 lq:on use:typing_subsumption.
    specialize (IHaRed _ H11).
    destruct IHaRed as [g0 hg0].
    eexists.
    apply E_Sym.
    pick fresh y and apply E_IndCong; eauto.
    instantiate (1 := (g_Reflex a3)).
    eapply E_Reflex; eauto.
    sfirstorder.
    enough ((open_tm_wrt_tm A a1) = A0) by scongruence.
    hauto l:on use:typing_unique.
Qed.

Lemma reds_defeq_inj :
  forall Γ θ a b,
    aReds Γ θ a b ->
    forall A, Typing Γ θ a A ->
         exists g, DefEq Γ g nil θ a b.
Proof.
  induction 1; intros A0 hA0.
  - hauto lq:on ctrs:DefEq.
  - sauto lq:on rew:off use:red_defeq_inj, preservation_red.
Qed.

Lemma pisnd_intro_same_type :
  forall G g theta0 g1 G0 theta B1 a1 B2 a2 rho1 theta1 A,
    theta0  ≤  theta  ->
    DefEq G g G0 theta0  (a_Pi  (rho1 ,  theta1)  A B1)   (a_Pi  (rho1, theta1)  A B2)  ->
    DefEq G g1 G0 theta1 a1 a2 ->
    Typing (G0 ++ G) theta1 a2 A ->
    exists g0,
    DefEq G g0 G0 theta  (open_tm_wrt_tm B1 a1)  (open_tm_wrt_tm B2 a2).
Proof.
  intros Γ γ θ0 γ1 Γ0 θ B1 a1 B2 a2 ρ θ1 A h_leq h_pi h_arg h_A.
  assert (tr0 : Typing (Γ0 ++ Γ) θ1 a1 A).
  {
    assert (h_arg' : DefEq Γ (g_Sym γ1) Γ0 θ1 a2 a1) by sfirstorder.
    sfirstorder use:defeq_same_type.
  }

  pose proof h_pi as h_pi'.
  apply defeq_regularity in h_pi'.
  destruct h_pi' as [T [h0 h1]].
  inversion h0; subst.
  eexists.
  pick fresh x.
  apply E_Trans with (a1 := open_tm_wrt_tm B1 (a_Conv a1 (g_Sym (g_PiFst θ0 γ)))).
  apply E_Sym.
  eapply E_PiSnd.
  - eassumption.
  - apply E_Reflex with (a := (a_Pi (ρ, θ1) A B1)) (A := a_TYPE); eauto.
  - apply defeq_regularity in h_arg.
    destruct h_arg; split_hyp.
    eapply E_Reflex with (a := a1); eauto.
  - assumption.
  - econstructor; eauto.
    econstructor; eauto.
    reflexivity.
    sfirstorder use:defeq_avail_narrowing_nil.
  - apply T_Conv with (A := A); eauto.
    sfirstorder use:typing_meet_ctx_l.
    constructor.
    econstructor; eauto.
    reflexivity.
    apply defeq_avail_narrowing_nil in h_pi.
    sfirstorder use:defeq_meet_ctx_l.
  - eapply E_PiSnd; eauto.
    econstructor; eauto.
    econstructor; eauto.
    reflexivity.
    apply defeq_avail_narrowing_nil in h_pi; eauto.
    econstructor; eauto.
    sfirstorder use:typing_meet_ctx_l.
    constructor.
    econstructor; eauto.
    reflexivity.
    apply defeq_avail_narrowing_nil in h_pi.
    sfirstorder use:defeq_meet_ctx_l.
Qed.

(* E-ReifyCong *)
Lemma E_ReifyCong_alt :
  forall (G:context) (theta0:fragment) (g1 g2:co) (G0:context) (theta:fragment) (a b:tm),
     Ctx  ( G0  ++  G )  ->
     DefEq  (  ( G0  ++  G )  )  g1  nil  theta0 a b ->
     DefEq  (  ( G0  ++  G )  )  g2  nil  theta0 a b ->
     (* ----------------------------------------------- *)
     DefEq G (g_ReifyCong theta0 g1 g2) G0 theta  ( (a_Reify theta0 g1) )   ( (a_Reify theta0 g2) ) .
Proof.
  sfirstorder use:E_ReifyCong, ctx_weakening.
Qed.

(* E-Red *)
Lemma E_Red_alt :
  forall (G:context) (a b:tm) (G0:context) (theta:fragment) (A:tm),
     aBeta  ( G0  ++  G )  theta a b ->
     (* -------------------------------- *)
     DefEq G (g_Beta a b) G0 theta a b.
  strivial use:ered_intro.
Qed.

(* E-PiSnd *)
Lemma E_PiSnd_alt : forall (G:context) (g:co) (theta0:fragment) (g1 g2:co) (G0:context) (theta:fragment) (B1 a1 B2 a2:tm) (rho1:relevance) (theta1:fragment) (A1 A2:tm),
      (  theta0  ≤  theta  )  ->
     DefEq G g G0 theta0  ( (a_Pi  (  rho1 ,  theta1  )  A1 B1) )   ( (a_Pi  (  rho1 ,  theta1  )  A2 B2) )  ->
     DefEq G g1 G0 theta1 a1 a2 ->
     Typing  ( G0  ++  G )  theta1 a2 A2 ->
     DefEq  ( G0  ++  G )  g2  nil  theta1 A2 A1 ->
     (* -------------------------------------------- *)
     DefEq G (g_PiSnd g theta0 g1 g2) G0 theta  (open_tm_wrt_tm  B1   (a_Conv a1 g2) )   (open_tm_wrt_tm  B2   a2 ) .
Proof.
  intros.
  enough (Typing  ( G0  ++  G )  theta1 (a_Conv a1 g2) A1) by hauto l:on use:E_PiSnd.
  apply T_Conv with (A := A2).
  - hecrush use:defeq_same_type.
  - apply defeq_regularity in H0.
    destruct H0.
    qauto l:on inv:Typing use:typing_meet_ctx_l.
  - hauto lq:on use:defeq_meet_ctx_l.
Qed.

(* T-Reify *)
Lemma T_Reify_alt : forall (G:context) (theta theta0:fragment) (g:co) (a b:tm),
     DefEq G g  nil  theta0 a b ->
     (* ----------------------------------- *)
     Typing G theta  ( (a_Reify theta0 g) )   ( (a_Eq theta0 a b) ) .
Proof.
  intros.
  enough (Typing  (meet_ctx_l_rho q_R  G  )  theta  ( (a_Eq theta0 a b) )  a_TYPE) by sfirstorder.
  sauto lq:on use:typing_meet_ctx_l, defeq_regularity.
Qed.

(* T-Conv *)
Lemma T_Conv_alt : forall (G:context) (theta:fragment) (a:tm) (g:co) (B A:tm),
     Typing G theta a A ->
     DefEq  (meet_ctx_l_rho q_R  G  )  g  nil  theta A B ->
     (* ---------------------------- *)
     Typing G theta (a_Conv a g) B.
Proof.
  intros G theta a g B A h0 h1.
  enough (Typing  (meet_ctx_l_rho q_R  G  )  theta B a_TYPE) by sfirstorder.
  apply defeq_regularity in h1.
  apply typing_regularity in h0.
  destruct h0.
  - hauto l:on use:typing_unique.
  - qauto l:on use:typing_unique inv:Typing.
Qed.

End introalt.
