(* Lemmas related to labels *)
From LP Require Import lp_ott lp_inf lattice lp_tactics lattice_solver.
From Hammer Require Import Tactics.
From Ltac2 Require Ltac2.
From Coq Require Import ssreflect.


Lemma meet_ctx_l_one : forall q x ρ0 θ0 A,  meet_ctx_l_rho q [(x, ((ρ0, θ0), A))] = [(x, ((q ⊓ ρ0, θ0), A))].
Proof.
intros; eauto.
Qed.

Lemma meet_ctx_l_app :forall W2 W1 q, meet_ctx_l_rho q (W2 ++ W1) = meet_ctx_l_rho q W2 ++ meet_ctx_l_rho q W1.
Proof. sfirstorder use:map_app. Qed.

Lemma meet_ctx_l_fusion (W : context) (q1 q2 : relevance) :
  meet_ctx_l_rho q1 (meet_ctx_l_rho q2 W) = meet_ctx_l_rho (meet q1 q2) W.
Proof.
  induction W; hauto.
Qed.

Lemma meet_ctx_l_meet_ctx_l (W :context) (q : relevance) :  meet_ctx_l_rho q (meet_ctx_l_rho q W) = meet_ctx_l_rho q W.
Proof.
    induction W; hauto q: on use: meet_idempotent.
Qed.

Lemma meet_ctx_l_subst_ctx : forall W q a x, meet_ctx_l_rho q (subst_ctx a x W) = subst_ctx a x (meet_ctx_l_rho q W).
Proof.
    induction W; hauto lq:on.
Qed.

Lemma meet_ctx_l_uniq : forall W q, uniq W -> uniq (meet_ctx_l_rho q W). intros. unfold meet_ctx_l_rho. solve_uniq. Qed.

Lemma meet_ctx_l_uniq2 : forall W q, uniq (meet_ctx_l_rho q W) -> uniq W. intros. unfold meet_ctx_l_rho in H. solve_uniq. Qed.

Lemma dom_meet_ctx_l : forall G rho, dom (meet_ctx_l_rho rho G) = dom G.
Proof. intros. induction G. simpl. auto.
       destruct a.
       simpl; f_equal; auto.
Qed.

#[export]Hint Rewrite
    meet_ctx_l_meet_ctx_l
    meet_ctx_l_one
    meet_ctx_l_app
    meet_ctx_l_subst_ctx
    : rewr_list.

#[export]Hint Rewrite -> map_app :rewr_list.

#[export] Hint Resolve meet_ctx_l_uniq : core.

Opaque meet leq_lat.

(* Invert a tuple of atom * (relevance * tm)
 so we can expose relevance to the top *)

Import Ltac2.Control.
Import Ltac2.Notations.

Set Default Proof Mode "Ltac2".

Lemma meet_ctx_l_ctx_sub_uniq (G : context) (q : relevance) :
    uniq G ->  ctx_sub (meet_ctx_l_rho q G) G.
Proof.
    induction 1;
    Control.enter (fun _ =>
        lazy_match! goal with
        | [ |- ctx_sub _ nil ] => done
        | [ |- _ ]  =>
            inv_atom_rel_tm; simpl; econstructor;
            Control.enter (fun _ =>
                lazy_match! goal with
                | [ |- _ ≤ _ ] =>
                    enter solve_lattice;
                    intuition
                    (* intuition *)
                | [ |- _ `notin` dom (meet_ctx_l_rho _ _)] =>
                    rewrite dom_meet_ctx_l; done
                | [ |- _ ] => done
                end)
        end).
Qed.

Lemma meet_ctx_l_ctx_sub (G : context) (q : relevance) :
    Ctx G ->  ctx_sub (meet_ctx_l_rho q G) G.
Proof.
    induction 1;
    Control.enter (fun _ =>
        lazy_match! goal with
        | [ |- ctx_sub _ nil ] => done
        | [ |- _ ]  =>
            inv_atom_rel_tm; simpl; econstructor;
            Control.enter (fun _ =>
                lazy_match! goal with
                | [ |- _ ≤ _ ] =>
                    enter solve_lattice;
                    intuition
                    (* intuition *)
                | [ |- _ `notin` dom (meet_ctx_l_rho _ _)] =>
                    rewrite dom_meet_ctx_l; done
                | [ |- _ ] => done
                end)
        end).
Qed.

Lemma ctx_sub_refl (G : context) : uniq G -> ctx_sub G G.
Proof.
    induction G; intros;
    try (enter ( fun _ =>
    lazy_match! goal with
    | [ |- ctx_sub nil nil ] => done
    | [ |- ctx_sub (_::_) _ ] =>
        inv_atom_rel_tm; constructor;
        enter ( fun _ =>
        lazy_match! goal with
        | [ |-  _ ≤ _ ] => enter solve_lattice; intuition
        | [ |- ctx_sub ?a ?a ] => ltac1:(hauto lq: on inv: uniq)
        | [ |- _ `notin` _] => solve_uniq
        | [ |- _] => trivial
        end)
    end)).
Qed.

#[export] Hint Rewrite -> dom_meet_ctx_l : meet_ctx_db.

Lemma ctx_sub_same_dom (G1 G2 : context) :
    ctx_sub G1 G2 -> dom G1 = dom G2.
Proof.
    induction 1; simpl; ltac1:(congruence).
Qed.

(* this is a really terrible tactic *)
(* TODO: replace it with something that is more structured *)
Ltac2 rewrite_dom_l_r l :=
  repeat(
    progress
     (
    ltac1:(simpl_env);
    lazy_match! goal with
    [ h : ctx_sub ?g1 ?g2 |- _  ] =>
        let h_c := hyp h in
        ltac1:(simpl_env);
        (if l
         then (rewrite <- (ctx_sub_same_dom $g1 $g2) in * )
         else (rewrite -> (ctx_sub_same_dom $g1 $g2) in * ));
        auto
    end)).

Ltac2 rewrite_dom () := rewrite_dom_l_r Init.true.

Lemma ctx_sub_app (G1 G2 G3 G4 : context) :
    ctx_sub G1 G2 -> ctx_sub G3 G4 -> uniq (G1 ++ G3) -> ctx_sub (G1 ++ G3) (G2 ++ G4).
Proof.
    induction 1; intros;
    enter ( fun _ =>
        lazy_match! goal with
        | [ |- context[nil] ] => done
        | [ |- _ ] => simpl; constructor;
            enter (fun _ =>
            lazy_match! goal with
            | [ |- ctx_sub _ _ ] => ltac1:(hauto lq:on inv:uniq)
            | [ |- ?x `notin` dom (?g1 ++ ?g3)] =>
                rewrite_dom (); solve_uniq
            | [ |- _ ] => auto
            end)
        end
    ).
Qed.

Local Ltac2 solve_ctx_sub_app_uniq_l_r () :=
  enter ( fun _ =>
        lazy_match! goal with
        | [ |- context[nil] ] => ltac1:(sfirstorder use:ctx_sub_uniq)
        (* | [ |- _ `notin` _] =>  erewrite <- ctx_sub_same_dom; eauto; *)
        (*                       apply ctx_sub_app; eauto *)
        | [ h : uniq (_ ++ _) |- _ ] =>
            let hc := hyp h in
            inversion_clear $hc;
            simpl;
            constructor; auto;
            ltac1:(hauto lq:on use:ctx_sub_same_dom, ctx_sub_app)
        end).

Lemma ctx_sub_uniq (G1 G2 : context) :
    ctx_sub G1 G2 -> (uniq G1 <-> uniq G2).
Proof.
    induction 1; ltac1:(sauto lq:on rew:off).
Qed.

Lemma ctx_sub_app_uniq (G1 G2 G3 G4 : context) :
  ctx_sub G1 G2 -> ctx_sub G3 G4 -> uniq (G1 ++ G3) -> uniq (G2 ++ G4).
Proof.
  induction 1; intros;
    solve_ctx_sub_app_uniq_l_r ().
Qed.

Lemma ctx_sub_app_uniq2 (G1 G2 G3 G4 : context) :
  ctx_sub G1 G2 -> ctx_sub G3 G4 -> uniq (G2 ++ G4) -> uniq (G1 ++ G3).
Proof.
  induction 1; intros;
    solve_ctx_sub_app_uniq_l_r ().
Qed.

Lemma ctx_sub_app2 (G1 G2 G3 G4 : context) :
  ctx_sub G1 G2 -> ctx_sub G3 G4 -> uniq (G2 ++ G4) -> ctx_sub (G1 ++ G3) (G2 ++ G4).
Proof.
  ltac1:(hauto lq:on use: ctx_sub_app, ctx_sub_app_uniq2).
Qed.

Lemma meet_ctx_l_sub_mono (G1 G2 : context) (rho : relevance) :
    ctx_sub G1 G2 -> ctx_sub (meet_ctx_l_rho rho G1) (meet_ctx_l_rho rho G2).
Proof.
    induction 1; try (enter(fun _ =>
    lazy_match! goal with
    | [ |- context[nil]] => done
    | [ |- _] =>     inv_atom_rel_tm; simpl; constructor;
        enter (fun _ =>
        lazy_match! goal with
        | [ h : _ ≤ _ |- _ ≤ _] =>
            enter solve_lattice; intuition
        | [ |- ctx_sub ?a ?a ] => ltac1:(hauto lq: on inv: uniq)
        | [ |- _ `notin` _] => ltac1: (by rewrite dom_meet_ctx_l)
        | [ |- _ ] => done
        end)
    end)).
Qed.

Lemma ctx_sub_binds : forall {W W2 : context}, ctx_sub W2 W -> forall {x ρ θ A},
      binds x ( ((ρ, θ), A)) W -> exists ρ0 θ0 , (ρ0 ≤ ρ) /\ θ0 ≤ θ /\ binds x (((ρ0, θ0), A)) W2.
Proof.
    induction 1;
    ltac1:(hecrush use:binds_cons_1).
Qed.

Lemma meet_ctx_lt_ctx_sub : forall G rho rho1,
    rho ≤ rho1 -> uniq G -> ctx_sub (meet_ctx_l_rho rho G) (meet_ctx_l_rho rho1 G).
Proof.
  induction G; intros; eauto.
  inv_atom_rel_tm.
  simpl.
  constructor; eauto.
  solve_lattice; intuition; try reflexivity.
  reflexivity.
  ltac1:(sauto lq:on).
  rewrite dom_meet_ctx_l; eauto.
  solve_uniq.
  rewrite dom_meet_ctx_l; eauto.
  solve_uniq.
Qed.

Lemma ctx_sub_trans : forall G0 G1, ctx_sub G0 G1 -> forall G2, ctx_sub G1 G2 -> ctx_sub G0 G2.
Proof.
  induction 1; eauto.
  intros G0 h0.
  inversion h0; subst.
  constructor; eauto.
  ltac1:(transitivity rho2); auto.
  ltac1:(transitivity theta2); auto.
Qed.

#[export] Hint Rewrite -> fv_tm_open_tm_wrt_tm_upper dom_meet_ctx_l fv_co_subst_co_upper fv_tm_subst_tm_upper : solve_fv_all.

#[export] Hint Rewrite <- fv_co_open_co_wrt_tm_lower fv_tm_open_tm_wrt_tm_lower  : solve_fv_all.
