Require Import LP.lp_ott.
Require Import LP.lp_ind.
From Coq Require Import ssreflect.
Require Import LP.lp_inf.
(* lp_tactics has to be imported last *)
Require Import LP.lp_tactics.
From Hammer Require Import Tactics.
From Ltac2 Require Import Ltac2.
From LP Require Import sigs.

Module lc <: lc_sig.

Ltac2 solve_open_tm_tm () :=
  lazy_match! goal with
  | [ |- lc_tm (open_tm_wrt_tm ?a0 ?b0)] =>
      let x_c := lazy_match! goal with
                  | [ _ : ?y `notin` _ |- _ ] => y
                  | [ |- _ ] =>
                      let x := Fresh.in_goal @x in
                      pick fresh x;
                      Control.hyp x
                  end in
      rewrite (subst_tm_intro $x_c $a0 $b0);
      eauto using subst_tm_lc_tm
  end.

Ltac2 Notation "solve_open_tm_tm" := solve_open_tm_tm ().

Ltac2 solve_lc_beta () :=
  lazy_match! goal with
  | [ |-context [open_tm_wrt_tm]] => inv_lc; solve_open_tm_tm
  | [ |-_] => assumption
  end.

(* works for both grades and typing *)
Ltac2 solve_well_formedness_with tac :=
  intros; split_hyp; repeat split;
  (* Repetitively apply either the constructor or the existential intro lemma *)
  repeat (Control.enter apply_lc);
  (* Invert all hypotheses in the context *)
  split_hyp;
  inv_lc;
  Control.enter (fun _ => lazy_match! goal with
    (* difficult goals *)
    | [ |-context [open_tm_wrt_tm]] => try (solve [solve_open_tm_tm])
     (* DefEq Var *)
    | [_ : Ctx (?g0 ++ ?g),
       h : context [binds _ _ (?g0 ++ ?g) -> _],
       b0 : binds ?c ?s ?g  |- _ ] =>
        (assert (binds $c $s ($g0 ++ $g)) by auto);
        ltac1:(hauto lq:on depth:2)
    (* binds goals *)
    | [ h : binds _ _ nil |- _] => let h_c := Control.hyp h in inversion $h_c
    | [ h : binds ?x0 _ _ |- _] =>
        ltac1:(hauto drew:off  depth:2 use: binds_cons_1)
    (* easy goals *)
    | [ |-_] =>
        lazy_match! goal with
        | [ _ : ?y `notin` _ |- _] => () (* repeat (spec_more $y); try (solve [tac ()]) *)
        | [ |- _ ] =>
          let x := Fresh.in_goal @x_tmp in
          pick fresh $x; repeat (spec $x);
          split_hyp
        end; try (solve [eauto 2 | tac ()])
      end).

Lemma lc_mutual :
  (forall G θ a A, Typing G θ a A -> lc_tm a /\ lc_tm A) /\
  (forall G g G0 θ A B, DefEq G g G0 θ A B -> lc_co g /\ lc_tm A /\ lc_tm B) /\
  (forall G, Ctx G -> forall x δ a, binds x (δ, a) G -> lc_tm a) /\
  (forall G δ a b, aBeta G δ a b -> lc_tm a) /\ (* lc_tm b is given in the defeq red rule *)
  (forall G δ a A, CTyping G δ a A -> lc_tm a /\ lc_tm A).
Proof.
  apply typing_mutual; intros;
    try (solve [solve_well_formedness_with
                  (fun _ => ())]).
  (* The funky picong and abscong cases *)
  - split.
    + pick fresh x; repeat (spec x); eauto; split_hyp.
      ltac1:(qauto l:on use:lc_a_Ind_exists).
    + pick fresh x; repeat (spec x); eauto; split_hyp.
      inversion H4; subst.
      solve_open_tm_tm.
  - split.
    + pick fresh x; repeat (spec x); eauto; split_hyp.
      ltac1:(hauto lq:on use:lc_g_PiCong_exists).
    + pick fresh x; repeat (spec x); eauto; split_hyp.
      split.
      ++ ltac1:(sfirstorder use:lc_g_PiCong_exists).
      ++ apply lc_a_Pi_exists with (x1 := x); eauto.
         rewrite H3.
         apply lc_body_tm_wrt_tm.
         ltac1:(qauto l:on db:lngen).
         ltac1:(sfirstorder).
  - split.
    + pick fresh x; repeat (spec x); eauto; split_hyp.
      apply (lc_g_IndCong_exists x); eauto.
      inversion H3; subst; auto.
    + split.
      ltac1:(sfirstorder).
      ltac1:(sfirstorder).
  - pick fresh x; repeat (spec x); eauto; split_hyp.
    ltac1:(hauto lq:on use:lc_a_Ind_exists).
  - pick fresh x; repeat (spec x); eauto; split_hyp.
    ltac1:(hauto lq:on use:lc_a_Ind_exists).
Qed.

Set Default Proof Mode "Classic".
Lemma typing_lc1 : forall G θ a A, Typing G θ a A -> lc_tm a.
Proof. hauto use:lc_mutual. Qed.
Lemma typing_lc2 : forall G θ a A, Typing G θ a A -> lc_tm A.
Proof. hauto use:lc_mutual. Qed.
Lemma defeq_lc1 : forall G g G0 θ A B, DefEq G g G0 θ A B -> lc_co g.
Proof. hauto use:lc_mutual. Qed.
Lemma defeq_lc2 : forall G g G0 θ A B, DefEq G g G0 θ A B -> lc_tm A.
Proof. hauto use:lc_mutual. Qed.
Lemma defeq_lc3 : forall G g G0 θ A B, DefEq G g G0 θ A B -> lc_tm B.
Proof. hauto use:lc_mutual. Qed.
Lemma ctyping_lc1 : forall G δ a A, CTyping G δ a A -> lc_tm a.
Proof. hauto use:lc_mutual. Qed.
Lemma ctyping_lc2 : forall G δ a A, CTyping G δ a A -> lc_tm A.
Proof. hauto use:lc_mutual. Qed.

End lc.
