From Hammer Require Import Tactics.
From Ltac2 Require Import Ltac2 Control Constr.
From Coq Require Import ssreflect.
From LP Require Import sigs lp_ott lp_ind lp_labels lp_tactics.

Module narrowing
  (Import wff : wff_sig)
  <: typing_narrowing_sig.


Set Default Proof Mode "Classic".

Lemma ctx_meet_ctx_l_wff : forall G rho, Ctx G -> Ctx (meet_ctx_l_rho rho G).
Proof.
  induction 1; auto.
  simpl_env.
  constructor; auto.
  rewrite meet_ctx_l_fusion; auto.
  rewrite dom_meet_ctx_l.
  auto.
Qed.


#[local]Ltac solve_refl :=
  lazymatch goal with
    [ |- ?a ≤ ?a] => reflexivity
  | _ => idtac
  end.

Lemma meet_ctx_l_sub_trans : forall G0 G1, Ctx G0 -> ctx_sub G0 G1 -> forall ρ, ctx_sub (meet_ctx_l_rho ρ G0) G1.
Proof.
  intros G0 G1 h1 h0 ρ.
  apply ctx_sub_trans with (G1 := G0); auto.
  sfirstorder use:meet_ctx_l_ctx_sub.
Qed.

#[local]Ltac solve_non_binding := sfirstorder q:on depth:3 use:ctx_meet_ctx_l_wff,meet_ctx_l_sub_mono, ctx_weakening, ctx_sub_app, ctx_sub_app_uniq2, ctx_sub_app2, wff_mutual, ctx_sub_uniq, meet_ctx_l_sub_mono, uniq_mutual, ctx_meet_ctx_l_wff, meet_ctx_l_sub_trans solve:solve_refl.

Lemma ctx_weakening : forall G G0,
    Ctx (G ++ G0) ->
    Ctx G0.
Proof.
  induction G; sauto depth:1.
Qed.

Lemma typing_narrowing_mutual :
  (forall G θ a A, Typing G θ a A -> forall G0, Ctx G0 -> ctx_sub G0 G -> Typing G0 θ a A) /\
  (forall G g G0 θ A B, DefEq G g G0 θ A B -> forall G1 G2, Ctx (G2 ++ G1) -> ctx_sub G1 G -> ctx_sub G2 G0 -> DefEq G1 g G2 θ A B) /\
  (forall G, Ctx G -> True) /\
  (forall G δ a b, aBeta G δ a b -> forall G0, Ctx G0 -> ctx_sub G0 G -> aBeta G0 δ a b) /\
  (forall G δ a A, CTyping G δ a A -> forall G0, Ctx G0 -> ctx_sub G0 G -> CTyping G0 δ a A).
Proof.
  apply typing_mutual; intros; eauto.
  - solve_non_binding.
  - econstructor; eauto;
      eapply_first_hyp; 
      solve_non_binding.
  - apply (ctx_sub_binds H1) in b.
    destruct b as [ρ0 [θ0 [h0 [h1 h2]]]].
    apply T_Var with (theta0 := θ0); auto.
    + hauto use:@transitivity.
    + sauto.
  - pick fresh x and apply T_Pi; repeat (spec x); eauto.
    eapply_first_hyp; auto.
    constructor; eauto.
    eapply_first_hyp; eauto.
    solve_non_binding.
    sfirstorder use:meet_ctx_l_sub_trans.
    constructor; solve_refl; auto.
  - destruct delta0 as [ρ0 θ0].
    pick fresh x and apply T_Abs; repeat (spec x); eauto.
    eapply_first_hyp; auto;
      solve_non_binding.
    eapply_first_hyp.
    constructor; auto.
    specialize (H (meet_ctx_l_rho q_R G0) ltac:(solve_non_binding) ltac:(solve_non_binding)).
    inversion H; subst; auto.
    constructor; auto; try reflexivity.
  - pick fresh y and apply T_Ind; eauto.
    solve_non_binding.
    eapply_first_hyp; eauto.
    econstructor; solve_non_binding.
    econstructor; solve_non_binding.
  - econstructor; eauto;
      eapply_first_hyp; 
      solve_non_binding.
  - econstructor; eauto;
    eapply_first_hyp; solve_non_binding.
  - econstructor; eauto;
      eapply_first_hyp; solve_non_binding.
  - econstructor; eauto;
      eapply_first_hyp; solve_non_binding.
  - econstructor; solve_non_binding.
  - econstructor; solve_non_binding.
  - pose proof H2 as H2'.
    specialize (H2 (meet_ctx_l_rho q_R (G2 ++ G1)) ltac:(solve_non_binding) ltac:(solve_non_binding)).
    specialize (H2' (G2 ++ G1) ltac:(solve_non_binding) ltac:(solve_non_binding)).
    specialize (H1 (G2 ++ G1) ltac:(solve_non_binding) ltac:(solve_non_binding)).
    inversion H2; subst.
    pick fresh x and apply E_PiCong; repeat (spec x); eauto.
    eapply_first_hyp; eauto.
    rewrite app_assoc.
    constructor; auto.
    constructor; auto.
    reflexivity.
  - pick fresh x and apply E_AbsCong; eauto.
    solve_non_binding.
    eapply_first_hyp; eauto.
    rewrite app_assoc.
    constructor; auto.
    eapply_first_hyp. solve_non_binding.
    solve_non_binding.
    constructor; auto;
      reflexivity.
    solve_non_binding.
  - econstructor; eauto.
    solve_non_binding.
    solve_non_binding.
    eapply_first_hyp;
      solve_non_binding.
  - econstructor; eauto.
    solve_non_binding.
    solve_non_binding.
    solve_non_binding.
    solve_non_binding.
    eapply_first_hyp;
      solve_non_binding.
  - econstructor; eauto.
    solve_non_binding.
    eapply_first_hyp;
      solve_non_binding.
    solve_non_binding.
  - solve_non_binding.
  - pick fresh y and apply E_IndCong; eauto.
    eapply_first_hyp; eauto.
    rewrite app_assoc.
    constructor; auto. solve_non_binding.
    constructor; auto; reflexivity.
    solve_non_binding.
    solve_non_binding.
    eapply_first_hyp; auto.
    solve_non_binding.
    solve_non_binding.
  - econstructor; eauto.
    eapply_first_hyp; eauto;
    solve_non_binding.
  - econstructor; eauto.
    eapply_first_hyp; eauto;
      solve_non_binding.
  - econstructor; eauto.
    eapply_first_hyp; eauto;
    solve_non_binding.
Qed.

(* Lemma 3.1 (Narrowing) *)
(* See typing_narrowing_mutual for the main proof *)
Lemma typing_narrowing : forall G θ a A,
    Typing G θ a A -> forall G0,
    Ctx G0 ->
    ctx_sub G0 G ->
    (* ----------------- *)
    Typing G0 θ a A.
Proof.
  pose typing_narrowing_mutual; firstorder.
Qed.

(* Lemma 3.4 (Resurrection for ρ) *)
(* See typing_narrowing_mutual for the main proof *)
(* The lemma is slightly more general than the one presented in the
paper. When rho is instantiated to q_R, the operation meet_ctx_l_rho
rho becomes the same as the resurrection operation *)
Lemma typing_meet_ctx_l : forall G θ a A,
    Typing G θ a A -> forall rho,
    (* --------------------------------- *)
    Typing (meet_ctx_l_rho rho G) θ a A.
Proof.
  hauto lq: on use:typing_narrowing_mutual, meet_ctx_l_ctx_sub, wff_mutual, ctx_meet_ctx_l_wff.
Qed.

Lemma ctx_narrowing : forall G, Ctx G -> forall G0, Ctx G0 -> ctx_sub G0 G -> Ctx G0.
Proof.
  pose typing_narrowing_mutual; firstorder.
Qed.

Lemma ctx_meet_ctx_l : forall G rho, Ctx G -> Ctx (meet_ctx_l_rho rho G).
Proof.
  hauto lq:on use:ctx_narrowing, meet_ctx_l_ctx_sub, ctx_meet_ctx_l_wff.
Qed.

Lemma ctx_meet_ctx_l_app2 : forall G1 G2 rho, Ctx (G1 ++ G2) -> Ctx (meet_ctx_l_rho rho G1 ++ meet_ctx_l_rho rho G2).
  hauto use: ctx_meet_ctx_l, meet_ctx_l_app unfold: context.
Qed.

Lemma defeq_narrowing : forall G g G0 θ A B, DefEq G g G0 θ A B -> forall G1 G2, Ctx (G2 ++ G1) -> ctx_sub G1 G -> ctx_sub G2 G0 -> DefEq G1 g G2 θ A B.
  sfirstorder use:typing_narrowing_mutual.
Qed.

Lemma defeq_meet_ctx_l : forall G g G0 θ A B, DefEq G g G0 θ A B -> DefEq (meet_ctx_l_rho q_R G) g (meet_ctx_l_rho q_R G0) θ A B.
  intros.
  assert (Ctx (G0 ++ G)) by sfirstorder use:wff_mutual.
  assert (uniq (G0 ++ G)) by sfirstorder use:Ctx_uniq.
  eapply defeq_narrowing; eauto; 
  try (rewrite <- meet_ctx_l_app);
    sfirstorder  use:uniq_app_1, uniq_app_2, meet_ctx_l_ctx_sub_uniq, defeq_narrowing, ctx_meet_ctx_l_wff.
Qed.

Lemma ctx_meet_ctx_l_app3 :
  forall G1 G2 G3 rho, Ctx (G1 ++ G2 ++ G3) -> Ctx (meet_ctx_l_rho rho G1 ++ meet_ctx_l_rho rho G2 ++ meet_ctx_l_rho rho G3).
  hauto use: ctx_meet_ctx_l, meet_ctx_l_app, ctx_meet_ctx_l_app2 unfold: context.
Qed.

Lemma typing_meet_ctx_l_app2 : forall G1 G2 θ a A,  Typing (G1 ++ G2) θ a A -> forall rho, Typing (meet_ctx_l_rho rho G1 ++ meet_ctx_l_rho rho G2) θ a A.
Proof.
  qauto use: typing_meet_ctx_l, meet_ctx_l_app unfold: context.
Qed.

Lemma typing_meet_ctx_l_app3 : forall G1 G2 G3 θ a A,  Typing (G1 ++ G2 ++ G3) θ a A -> forall rho, Typing (meet_ctx_l_rho rho G1 ++ meet_ctx_l_rho rho G2 ++ meet_ctx_l_rho rho G3) θ a A.
Proof.
  qauto use: typing_meet_ctx_l, typing_meet_ctx_l_app2, meet_ctx_l_app unfold: context.
Qed.

Lemma ctyping_meet_ctx_l : forall G δ a A,  CTyping G δ a A -> forall rho, CTyping (meet_ctx_l_rho rho G) δ a A.
Proof.
  intros.
  inversion H; subst.
  - hauto lq:on  use:typing_narrowing_mutual, meet_ctx_l_ctx_sub, wff_mutual, ctx_meet_ctx_l_wff.
  - constructor.
    rewrite -> meet_ctx_l_fusion.
    rewrite rel_meet_R2; auto.
Qed.

Lemma ctx_meet_ctx_l_app4 :
  forall G1 G2 G3 G4 rho, Ctx (G1 ++ G2 ++ G3 ++ G4) ->
                  Ctx (meet_ctx_l_rho rho G1 ++ meet_ctx_l_rho rho G2 ++ meet_ctx_l_rho rho G3 ++ meet_ctx_l_rho rho G4).
  hauto use: ctx_meet_ctx_l, meet_ctx_l_app, ctx_meet_ctx_l_app3 unfold: context.
Qed.

Lemma abeta_narrowing : forall G θ a A, aBeta G θ a A -> forall G0, Ctx G0 -> ctx_sub G0 G -> aBeta G0 θ a A.
Proof.
  pose typing_narrowing_mutual; firstorder.
Qed.

Lemma abeta_meet_ctx_l : forall G θ a A,  aBeta G θ a A -> forall rho, aBeta (meet_ctx_l_rho rho G) θ a A.
Proof.
  hauto lq: on use:abeta_narrowing, meet_ctx_l_ctx_sub, wff_mutual, ctx_meet_ctx_l_wff.
Qed.

Lemma acored_narrowing :
  forall Γ θ a b,
    aCoRed Γ θ a b ->
    forall Γ0, Ctx Γ0 -> ctx_sub Γ0 Γ -> aCoRed Γ0 θ a b.
Proof.
  induction 1.
  - intros.
    econstructor; eauto.
    eapply defeq_narrowing; eauto.
    eapply ctx_meet_ctx_l_wff; auto.
    solve_non_binding.
  - intros.
    econstructor; eauto.
  - intros.
    econstructor; eauto.
    sfirstorder use:typing_narrowing.
    eapply defeq_narrowing; eauto.
    eapply ctx_meet_ctx_l_wff; auto.
    solve_non_binding.
  - sfirstorder.
  - sfirstorder.
Qed.

Lemma acoreds_narrowing :
  forall Γ θ a b,
    aCoReds Γ θ a b ->
    forall Γ0, Ctx Γ0 -> ctx_sub Γ0 Γ -> aCoReds Γ0 θ a b.
Proof.
  induction 1; hauto l:on use:acored_narrowing.
Qed.

Lemma ared_narrowing :
  forall Γ θ a b,
    aRed Γ θ a b ->
    forall Γ0, Ctx Γ0 -> ctx_sub Γ0 Γ -> aRed Γ0 θ a b.
Proof.
  induction 1.
  - hauto l:on use:acoreds_narrowing.
  - hauto l:on use:acoreds_narrowing.
  - hauto l:on use:acoreds_narrowing.
  - hauto l:on use:acoreds_narrowing.
  - intros Γ0 h_sub.
    econstructor; eauto.
    + sfirstorder use:acoreds_narrowing.
    + sfirstorder use:typing_narrowing.
    + sfirstorder use:typing_narrowing.
    + eapply defeq_narrowing; eauto;
      solve_non_binding.
  - intros Γ0 h_sub.
    econstructor; eauto.
    + sfirstorder use:acoreds_narrowing.
    + sfirstorder use:typing_narrowing.
    + sfirstorder use:typing_narrowing.
    + eapply defeq_narrowing; eauto;
      solve_non_binding.
  - intros Γ0 h_sub.
    econstructor; eauto.
    + sfirstorder use:typing_narrowing.
    + sfirstorder use:typing_narrowing.
    + eapply defeq_narrowing; eauto;
      solve_non_binding.
Qed.

Lemma acoreds_meet_ctx_l :
  forall Γ θ a b,
    Ctx Γ ->
    aCoReds Γ θ a b ->
    aCoReds (meet_ctx_l_rho q_R Γ) θ a b.
Proof.
  intros.
  eapply acoreds_narrowing; eauto.
  solve_non_binding.
  sfirstorder use:meet_ctx_l_ctx_sub, acoreds_narrowing, ctx_meet_ctx_l_wff.
Qed.

Lemma ared_meet_ctx_l :
  forall Γ θ a b,
    Ctx Γ ->
    aRed Γ θ a b ->
    aRed (meet_ctx_l_rho q_R Γ) θ a b.
Proof.
  intros.
  eapply ared_narrowing; eauto.
  solve_non_binding.
  sfirstorder use:meet_ctx_l_ctx_sub, acoreds_narrowing.
Qed.

End narrowing.
