From LP Require Import lp_ott lp_inf  lp_ind lp_tactics lp_labels sigs.

From Hammer Require Import Tactics.
From Ltac2 Require Import Ltac2 Constr Control.

Opaque meet.

Lemma subst_ctx_dom : forall a x0 F, dom F = dom (subst_ctx a x0 F).
Proof.
  induction F; ltac1:(hauto q:on).
Qed.

#[export] Hint Rewrite <- subst_ctx_dom : solve_fv_all .

Module subst
  ( Import fv : typing_fv_sig)
  ( Import narrow : typing_narrowing_sig )
  ( Import weak : weak_sig )
  ( Import lc : lc_sig)
  ( Import wff : wff_sig)
  ( Import subsumption : subsumption_sig) <: subst_sig.

Lemma ctyping_meet_ctx_l_helper :
  forall G ρ θ a A,
    CTyping G (ρ, θ) a A ->
    CTyping (meet_ctx_l_rho q_R G) (q_R ⊓ ρ, θ) a A.
Proof.
  intros; rewrite rel_meet_R2;
  ltac1:(hauto q: on inv: CTyping db: narrow).
Qed.

Lemma unsubst_ctx_cons :
  forall y δ0 a x A G,
    y ~ (δ0, subst_tm a x A) ++ subst_ctx a x G =
      subst_ctx a x (y ~ (δ0, A) ++ G).
Proof.
  eauto.
Qed.

Lemma subst_ctx_app :
  forall a x Γ Γ0,
    subst_ctx a x Γ ++ subst_ctx a x Γ0 = subst_ctx a x (Γ ++ Γ0).
Proof. ltac1:(sfirstorder unfold:subst_ctx). Qed.

Local Ltac2 solve_subst_2_subst () :=
  simpl_env;
  enter (fun _ =>
           match! goal with
           | [ |- context[subst_ctx _ _ _ ++ subst_ctx _ _ _ ++ _]] =>
               rewrite <- app_assoc;
               rewrite -> subst_ctx_app;
               eapply_first_hyp; eauto using ctyping_meet_ctx_l_helper;
               simpl_env; reflexivity
           end).
Local Ltac2 Notation "solve_subst_2_subst" := solve_subst_2_subst ().

Local Ltac2 solve_subst_ty_wf () :=
  simpl_env;
  eapply_first_hyp;
  eauto using ctyping_meet_ctx_l_helper;
  simpl_env;
  reflexivity.
Local Ltac2 Notation "solve_subst_ty_wf" := solve_subst_ty_wf ().

Lemma subst_mutual :
  (forall G θ b B,
      Typing G θ b B ->
      forall K δ0 a A, CTyping K δ0 a A ->
                  forall F x,
                    (G = F ++ (x ~ (δ0, A)) ++ K) ->
                    Typing (subst_ctx a x F ++ K) θ (subst_tm a x b) (subst_tm a x B)) /\
    (forall G g G0 θ B0 B1,
        DefEq G g G0 θ B0 B1 ->
        forall K δ0 a A, CTyping K δ0 a A ->
                 forall F x,
                   (G = F ++ (x ~ (δ0, A)) ++ K) ->
                   DefEq (subst_ctx a x F ++ K) (subst_co a x g) (subst_ctx a x G0) θ (subst_tm a x B0) (subst_tm a x B1)) /\
  (forall G, Ctx G ->
      forall K δ0 a A,  CTyping K δ0 a A ->
                  forall F x,
                    (G = F ++ (x ~ (δ0, A)) ++ K) ->
                    Ctx (subst_ctx a x F ++ K)) /\
 (forall G θ b1 b2, aBeta G θ b1 b2 ->
    forall K δ0 a A, CTyping K δ0 a A ->
                 forall F x,
                   (G = F ++ (x ~ (δ0, A)) ++ K) ->
                   aBeta (subst_ctx a x F ++ K) θ (subst_tm a x b1) (subst_tm a x b2)) /\
  (forall G δ b B, CTyping G δ b B ->
    forall K δ0 a A, CTyping K δ0 a A ->
                 forall F x,
                   (G = F ++ (x ~ (δ0, A)) ++ K) ->
                   CTyping (subst_ctx a x F ++ K) δ (subst_tm a x b) (subst_tm a x B)  ).
Proof.
  apply typing_mutual; intros; subst; simpl; eauto; inv_atom_rel_tm.
  - econstructor; eauto; solve_subst_ty_wf.
  - econstructor; eauto; solve_subst_ty_wf.
  (* Var case, very hard *)
  - (* solve_subst should handle everything except var *)
    destruct (x == x0); auto; subst.
    + apply binds_mid_eq in b.
      inversion b; subst; eauto.
      clear b.
      inversion H0; subst.
      apply typing_weakening; eauto.
      rewrite subst_tm_fresh_eq; eauto.
      (* subsumption *)
      * eauto using typing_subsumption.
      * apply typing_fv2 in H3.
        rewrite H3.
        apply Ctx_uniq in c.
        apply uniq_app_iff in c; split_hyp.
        apply uniq_app_3 in H2; split_hyp.
        ltac1:(sfirstorder use: disjoint_one_1 unfold: context).
      * apply Ctx_uniq; eauto.
    + assert (uniq (F ++ x0 ~ (r, f, A0) ++ K)); eauto using Ctx_uniq.
      econstructor; eauto.
      apply binds_app_uniq_1 in b; eauto using Ctx_uniq.
      destruct b; subst; split_hyp.
      * apply binds_app_2.
        unfold subst_ctx in *.
        change (q_R, theta0, subst_tm a x0 A) with ((fun '(g, A) => (g, subst_tm a x0 A)) (q_R, theta0, A)).
        eauto using binds_map.
      * apply binds_app_3.
        rewrite subst_tm_fresh_eq.
        ** inversion H2; subst.
           inversion H4; subst; ltac1:(tauto).
           unfold binds.
           simpl; eauto.
        ** apply ctx_weakening in c.
           apply binds_app_iff in H2.
           destruct H2.
           apply binds_one_iff in H2.
           split_hyp;
             ltac1:(congruence).
           apply ctx_fv in H2.
           destruct H2 as [_ h0].
           rewrite h0.
           apply uniq_app_iff in H1; split_hyp.
           apply uniq_app_iff in H2; split_hyp.
           enough (x0 `notin` dom K) by fsetdec.
           ltac1:(fcrush).
           ltac1:(hauto lq:on rew:off inv:Ctx).
  - pick fresh y and apply T_Pi; eauto.
    rewrite -> subst_tm_open_tm_wrt_tm_var; eauto with lc.
    rewrite <- app_assoc.
    rewrite -> unsubst_ctx_cons.
    eapply_first_hyp; eauto.
  - pick fresh y and apply T_Abs; eauto.
    + solve_subst_ty_wf.
    + do 2 (rewrite -> subst_tm_open_tm_wrt_tm_var; eauto with lc).
      rewrite <- app_assoc.
      rewrite -> unsubst_ctx_cons.
      eapply_first_hyp; eauto.
  - rewrite -> subst_tm_open_tm_wrt_tm; eauto with lc.
  - assert (tr0: lc_tm a) by ltac1:(sfirstorder use:ctyping_lc1).
    rewrite subst_tm_open_tm_wrt_tm; auto.
    pick fresh y and apply T_Ind; repeat (spec y); eauto.
    solve_subst_ty_wf.
    change a_Zero with (subst_tm a x a_Zero).
    rewrite <- subst_tm_open_tm_wrt_tm; auto.
    solve_subst_ty_wf.
    rewrite -> subst_tm_open_tm_wrt_tm_var; eauto with lc.
    rewrite subst_tm_open_tm_wrt_tm_var; auto.
    rewrite <- (subst_tm_fresh_eq (a_Succ (a_Var_f y)) a x); auto.
    rewrite <- subst_tm_open_tm_wrt_tm; auto.
    change a_Nat with (subst_tm a x a_Nat).
    rewrite <- app_assoc.
    rewrite -> unsubst_ctx_cons.
    eapply_first_hyp; eauto.
  - econstructor; eauto; solve_subst_2_subst.
  - econstructor; eauto; solve_subst_2_subst.
  - econstructor; eauto; solve_subst_2_subst.
  - econstructor; eauto; try (solve_subst_2_subst).
  - econstructor; eauto; try (solve_subst_2_subst).
    rewrite <- app_assoc.
    rewrite -> subst_ctx_app.
    eapply H; eauto.
    simpl_env; reflexivity.
  - econstructor; eauto; solve_subst_2_subst.
  - pick fresh y and apply E_PiCong; try (first [solve_subst_2_subst | solve_subst_ty_wf]).
    + do 2 (rewrite subst_tm_open_tm_wrt_tm_var; eauto with lc).
      rewrite subst_co_open_co_wrt_tm_var; eauto with lc.
      rewrite -> unsubst_ctx_cons.
      eapply_first_hyp; eauto.
    + rewrite subst_tm_open_tm_wrt_tm_var; eauto with lc.
      repeat (spec y).
      rewrite H4.
      rewrite subst_tm_open_tm_wrt_tm; eauto with lc.
      set (b := y == x).
      simpl.
      ltac1:(replace (y == x) with b); eauto.
      destruct b; subst; eauto.
      enough (x <> x) by ltac1:(congruence).
      fsetdec.
  - pick fresh y and apply E_AbsCong; try (first [solve_subst_2_subst | solve_subst_ty_wf]).
    rewrite subst_tm_open_tm_wrt_tm_var; eauto with lc.
    rewrite subst_co_open_co_wrt_tm_var; eauto with lc.
    rewrite subst_tm_open_tm_wrt_tm_var; eauto with lc.
    repeat (spec y).
    rewrite -> unsubst_ctx_cons.
    eapply_first_hyp; eauto.
  - econstructor; eauto; solve_subst_2_subst.
  - econstructor; eauto; solve_subst_2_subst.
  - do 2 (rewrite subst_tm_open_tm_wrt_tm; eauto with lc).
    econstructor; eauto; solve_subst_2_subst.
  - econstructor; eauto; solve_subst_2_subst.
  - pick fresh y and apply E_IndCong; repeat (spec y); try (first [solve_subst_2_subst | solve_subst_ty_wf]).
    rewrite subst_co_open_co_wrt_tm_var; eauto with lc.
    rewrite subst_tm_open_tm_wrt_tm_var; eauto with lc.
    rewrite subst_tm_open_tm_wrt_tm_var; eauto with lc.
    eapply_first_hyp; eauto.
  (* Contradiction case for empty context *)
  - ltac1:(sauto q: on depth:2 dep: on).
  (* Ctx *)
  - destruct F.
    + inversion H2; subst; eauto.
    + inversion H2; subst; eauto.
      simpl.
      constructor; eauto.
      * solve_subst_ty_wf.
      * simpl_env;
        rewrite <- subst_ctx_dom; auto.
  - econstructor; eauto; solve_subst_ty_wf.
  - rewrite subst_tm_open_tm_wrt_tm; eauto with lc.
    econstructor; eauto; solve_subst_ty_wf.
  - econstructor; eauto; solve_subst_ty_wf.
  - pick fresh y and apply aBeta_AbsPush; repeat (spec y); try (solve_subst_ty_wf).
    (* hard/intersting case *)
    + rewrite subst_tm_open_tm_wrt_tm_var; eauto with lc.
      rewrite H3.
      rewrite subst_tm_open_tm_wrt_tm; eauto with lc.
      simpl.
      set (b := y == x).
      ltac1:(replace (y == x) with b); eauto.
      destruct b; subst; eauto.
      enough (x <> x) by ltac1:(congruence).
      fsetdec.
    + rewrite subst_co_open_co_wrt_tm_var; eauto with lc.
      rewrite H2.
      simpl.
      set (b := y == x).
      ltac1:(replace (y == x) with b); eauto.
      destruct b; subst; eauto.
      enough (x <> x) by ltac1:(congruence).
      fsetdec.
  - assert (tr0: lc_tm a) by ltac1:(sfirstorder use:ctyping_lc1).
    rewrite subst_tm_open_tm_wrt_tm; auto.
    econstructor; eauto.
    solve_subst_ty_wf.
  - assert (tr0: lc_tm a) by ltac1:(sfirstorder use:ctyping_lc1).
    econstructor; eauto;
    solve_subst_ty_wf.
  - econstructor; eauto; solve_subst_ty_wf.
Qed.

Lemma abeta_substc :
  forall F x δ0 A K θ b B,
    aBeta (F ++ (x ~ (δ0, A)) ++ K) θ b B ->
    forall a, CTyping K δ0 a A ->
         aBeta (subst_ctx a x F ++ K) θ (subst_tm a x b) (subst_tm a x B).
Proof.
  ltac1:(strivial use:subst_mutual).
Qed.

Lemma typing_substc :
  forall F x δ0 A K θ b B,
    Typing (F ++ (x ~ (δ0, A)) ++ K) θ b B ->
    forall a, CTyping K δ0 a A ->
         Typing (subst_ctx a x F ++ K) θ (subst_tm a x b) (subst_tm a x B).
Proof.
  ltac1:(strivial use:subst_mutual).
Qed.

(* Lemma 4.2 (Substitution) *)
(* See subst_mutual for the main proof *)
Lemma typing_substc_nil :
  forall {x δ0 A K θ b B},
    Typing ((x ~ (δ0, A)) ++ K) θ b B ->
    forall {a}, CTyping K δ0 a A ->
    (* -------------------------------------------- *)
    Typing K θ (subst_tm a x b) (subst_tm a x B).
Proof.
  ltac1:(sfirstorder use:(typing_substc nil)).
Qed.

Lemma typing_subst_nil :
  forall {x θ0 A K θ b B},
    Typing ((x ~ (q_R, θ0, A)) ++ K) θ b B ->
    forall {a}, Typing K θ0 a A ->
         Typing K θ (subst_tm a x b) (subst_tm a x B).
Proof.
  intros;
    ltac1:(sauto lq:on depth:1 use:typing_substc_nil).
Qed.

Lemma typing_substc_nil2 :
  forall F x δ0 A θ b B,
    Typing (F ++ (x ~ (δ0, A))) θ b B ->
    forall a, CTyping nil δ0 a A ->
         Typing (subst_ctx a x F) θ (subst_tm a x b) (subst_tm a x B).
  specialize typing_substc with (K := nil).
  ltac1:(qauto l:on use:app_nil_r).
Qed.

Lemma abeta_substc_nil2 :
  forall F x δ0 A θ b B,
    aBeta (F ++ (x ~ (δ0, A))) θ b B ->
    forall a, CTyping nil δ0 a A ->
         aBeta (subst_ctx a x F) θ (subst_tm a x b) (subst_tm a x B).
  specialize abeta_substc with (K := nil).
  ltac1:(qauto l:on use:app_nil_r).
Qed.

Lemma defeq_substc :
  forall F x δ0 A K g G0 θ A0 B0,
    DefEq (F ++ (x ~ (δ0, A)) ++ K) g G0 θ A0 B0 ->
    forall a, CTyping K δ0 a A ->
         DefEq (subst_ctx a x F ++ K) (subst_co a x g) (subst_ctx a x G0) θ (subst_tm a x A0) (subst_tm a x B0).
Proof.
  ltac1:(strivial use:subst_mutual).
Qed.

Lemma defeq_substc_nil2 :
  forall F x δ0 A g θ A0 B0,
    DefEq (F ++ (x ~ (δ0, A))) g nil θ A0 B0 ->
    forall a, CTyping nil δ0 a A ->
         DefEq (subst_ctx a x F) (subst_co a x g) nil θ (subst_tm a x A0) (subst_tm a x B0).
Proof.
  specialize defeq_substc with (K := nil) (G0 := nil).
  ltac1:(qauto l:on use:app_nil_r).
Qed.
End subst.
