Require Export Metalib.Metatheory.
Require Export Metalib.LibLNgen.
From Coq Require Import ssreflect.
Require Import LP.lp_ott.
Require Import LP.lp_inf.
Require Import LP.lp_ind.
From Ltac2 Require Import Ltac2 Control Constr.
From Hammer Require Import Tactics.

Ltac2 i_th_constr t i :=
  match Unsafe.kind t with
  | Unsafe.Ind ty ins =>
      Unsafe.make (Unsafe.Constructor (Unsafe.constructor ty i) ins)
  | _ => zero (Invalid_argument (Some (Message.of_string "Not an inductive type")))
  end.

Ltac2 Type 'a boxed_int  := { mutable b_data : 'a }.

Ltac2 count_constrs t :=
  let cnt := {b_data := 0} in
  let _ := '(ltac2:(destruct 1;
                    enter (fun _ => cnt.(b_data) := Int.add (cnt.(b_data)) 1; exact I )) : $t -> True) in
  cnt.(b_data).

(* Ltac2 Eval count_constrs 'tm. *)

(* Ltac2 Eval count_constrs '(Typing nil t_L (a_Var_b 0) (a_Var_b 0)). *)



Ltac spec y :=
  let h0 := fresh in
  match goal with [H0 : forall x : atom, x \notin ?L -> _ |- _ ] =>
     move: (H0 y ltac:(auto)) => h0; clear H0 end.

Ltac spec_more y :=
  let h0 := fresh in
  match goal with
  | [H0 : forall x, x \notin ?L -> _ |- _ ] =>
      move: (H0 y ltac:(auto)) => h0; clear H0
  | [H0 : forall x, _ |- _] =>
      move: (H0 y) => h0; clear H0
  end.

Ltac2 spec y :=
  ltac1:(y |- spec y) (Ltac1.of_ident y).

Ltac2 Notation "spec" y(ident) := spec y.

Ltac2 spec_more y :=
  ltac1:(y |- spec_more y) (Ltac1.of_constr y).

Ltac2 Notation "spec_more" y(ident) := spec_more y.

#[global] Ltac gather_atoms ::=
  let A := gather_atoms_with (fun x : vars => x) in
  let B := gather_atoms_with (fun x : var => {{ x }}) in
  let C1 := gather_atoms_with (fun x : context => dom x) in
  let A1 := gather_atoms_with (fun x : econtext => dom x) in
  let D1 := gather_atoms_with (fun x => fv_tm x) in
  let E1 := gather_atoms_with (fun g => fv_co g) in
  let F1 := gather_atoms_with (fun ξ : valuation => dom ξ) in
  constr:(A \u B \u C1 \u D1 \u E1 \u A1 \u F1).

Ltac2 pick_fresh_and_apply (x : ident) (c : constr) :=
  ltac1:( x c |- pick fresh x and apply c) (Ltac1.of_ident x) (Ltac1.of_constr c).

Ltac2 Notation "pick" "fresh" x(ident) "and" "apply" c(constr) :=
  pick_fresh_and_apply x c.

Ltac2 pick_fresh (x : ident) :=
  ltac1:(x |- pick fresh x) (Ltac1.of_ident x).

Ltac2 Notation "pick" "fresh" x(ident) := pick_fresh x.

Ltac2 split_hyp () :=
  repeat (lazy_match! goal with | [ h : _ /\ _ |- _] => 
    let h_c := Control.hyp h in
    destruct $h_c end).

Ltac2 Notation "split_hyp" := split_hyp ().

Import Ltac2.Constr.

Ltac2 lc_exists_lemmas () :=
  [ ('a_Pi, 'lc_a_Pi_exists)
  ; ('a_Abs, 'lc_a_Abs_exists)
  ; ('g_PiCong, 'lc_g_PiCong_exists)
  ; ('g_AbsCong, 'lc_g_AbsCong_exists) ].


Ltac2 get_headctr (c : constr) :=
  match Unsafe.kind c with
  | Unsafe.App h _ =>
      if is_constructor h then Some h else None
  | _ => None
end.

Ltac2 apply_lc () :=
  let go t :=
    (Option.map_default
          (fun e_intro _ =>
             let x := Fresh.in_goal @x_apply_lc in
             pick fresh $x;
             let xc := hyp x in
             apply ($e_intro $xc); repeat (spec $x))
          (fun _ => constructor)
          (Option.bind (get_headctr t)
             (fun p => List.assoc_opt Constr.equal p (lc_exists_lemmas ()))))
        () in
  lazy_match! goal with
  | [ |- lc_tm ?t ] =>
      go t
  | [ |- lc_co ?t] =>
      go t
  end.

Ltac2 inv_lc () :=
  let go h t :=
    match get_headctr t with
    | None => fail
    | Some _ => let hc := Control.hyp h in
               inversion_clear $hc
    end in
    repeat (match! goal with
    | [ h : lc_tm ?t  |- _ ] => go h t
    | [ h : lc_co ?t |- _] => go h t
    end).

Ltac2 Notation "inv_lc" := inv_lc ().
Ltac2 Notation "apply_lc" := apply_lc ().

Ltac apply_lc := ltac2:(apply_lc).
Ltac inv_lc := ltac2:(inv_lc).

(* Ltac2 refuses to match products... *)
Ltac2 inv_atom_rel_tm () :=
    repeat 
    (Control.enter (fun _ =>
        lazy_match! goal with
        | [ a : prod atom _ |- _ ] => 
            let a_c := Control.hyp a in
            destruct $a_c
        | [ a : prod (prod relevance fragment)  tm |- _ ] =>
            let a_c := Control.hyp a in
            destruct $a_c as [[? ?] ?]
        | [ a : prod relevance fragment |- _ ] =>
            let a_c := Control.hyp a in
            destruct $a_c
        end
    )).

Ltac2 Notation "inv_atom_rel_tm"  := inv_atom_rel_tm ().

Ltac inv_atom_rel_tm := ltac2:(inv_atom_rel_tm).

Ltac2 done () := ltac1:(done).
Ltac2 Notation "done" := done ().


Ltac2 simpl_env h :=
  ltac1:(h |- simpl_env in h) (Ltac1.of_ident h).

Ltac2 Notation "simpl_env" "in" h(ident) := simpl_env h.

Ltac2 simpl_env_goal () :=
  ltac1:(simpl_env).

Ltac2 Notation "simpl_env" := simpl_env_goal ().

Ltac2 apply_first_hyp () :=
  ltac1:(apply_first_hyp).

Ltac2 eapply_first_hyp () :=
  ltac1:(eapply_first_hyp).

Ltac2 Notation "apply_first_hyp" := apply_first_hyp ().
Ltac2 Notation "eapply_first_hyp" := eapply_first_hyp ().


Ltac2 assert_by h tac :=
  assert $h;
  focus 1 1 tac.
Ltac2 Notation "assert" h(constr) "by" t(thunk(tactic)) :=
  assert_by h t.

Ltac2 fsetdec () := ltac1:(fsetdec).
Ltac2 Notation "fsetdec" := fsetdec ().

Ltac2 pick_fresh_for (x : ident) (l : constr) :=
  ltac1:( x l |- pick fresh x for l) (Ltac1.of_ident x) (Ltac1.of_constr l).

Ltac2 Notation "pick" "fresh" x(ident) "for" l(constr) :=
  pick_fresh_for x l.

Ltac2 destruct_notin () := ltac1:(destruct_notin).
Ltac2 Notation "destruct_notin" := destruct_notin ().

Ltac2 pose_proof c := ltac1:(c |- pose proof c) (Ltac1.of_constr c).


Ltac2 Notation "pose" "proof" c(constr) := pose_proof c.


(* Ltac2 grade_binder_table () := *)
(*   [ ('a_Pi, 'GEq_Pi); *)
(*     ('a_Abs, 'GEq_Abs); *)
(*     ('g_PiCong, 'CoGEq_PiCong); *)
(*     ('g_AbsCong, 'CoGEq_AbsCong)]. *)

Ltac2 find_constructor g :=
  match Unsafe.kind g with
  | Unsafe.App _ args =>
      List.hd_opt (List.flat_map
                     (fun a => match Unsafe.kind a with
                             | Unsafe.App c _ => if is_constructor c then [c] else []
                             | _ => []
                             end)
                     (Array.to_list args))
  | _ => None
  end.

Ltac2 find_constructor_from_goal () :=
  lazy_match! goal with
    [ |- ?g ] => find_constructor g
  end.

(* Ltac2 find_binding_grade_ctr g := *)
(*   Option.bind (find_constructor g) *)
(*               (fun h => List.assoc_opt Constr.equal h (grade_binder_table ())). *)

(* Ltac2 find_binding_grade_ctr_from_goal () := *)
(*   Option.bind (find_constructor_from_goal ()) *)
(*     (fun h => List.assoc_opt Constr.equal h (grade_binder_table ())). *)

Ltac2 typing_binder_table () :=
  [ ('a_Pi, 'T_Pi) ;
    ('g_PiCong, 'E_PiCong);
    ('a_Abs, 'T_Abs);
    ('g_AbsCong, 'E_AbsCong) ].

Ltac2 find_binding_constructor_from_goal () :=
  Option.bind (find_constructor_from_goal ())
                (fun h => List.assoc_opt Constr.equal h (typing_binder_table ())).

Ltac2 solve_uniq () := ltac1:(solve_uniq).

Ltac2 Notation "solve_uniq" := solve_uniq ().

Ltac2 lc_tm_or_lc_co ctr :=
  Bool.or (Constr.equal ctr 'lc_tm)  (Constr.equal ctr 'lc_co).

Ltac2 get_head t :=
  match Unsafe.kind t with
  | Unsafe.App h _ => Some h
  | _ => None
  end.


Ltac2 is_lc () :=
  lazy_match! goal with
    [ |- ?g] => match get_head g with
             | Some ctr => lc_tm_or_lc_co ctr
             | None => false
             end
  end.

Ltac2 get_goal_head () :=
  lazy_match! goal with
  | [ |- ?g ] => get_head g
  end.

Ltac2 intuition () := ltac1:(intuition).
Ltac2 Notation "intuition" := intuition ().

Set Default Proof Mode "Classic".
Lemma LTy_inv :
    forall T, LTy T ->
         (exists ρ0 θ0 A B L, T = a_Pi (ρ0, θ0) A B /\ CLTy θ0 A /\ forall x, x `notin` L -> LTy (open_tm_wrt_tm B (a_Var_f x))) \/
           (exists θ0 A B, T = a_Eq θ0 A B /\ lc_tm A /\ lc_tm B) \/ 
           (T = a_Nat).
Proof.
  inversion 1; hauto lq:on.
Qed.

Ltac invert_lty h :=
  destruct (LTy_inv _ h) as
    [ [?ρ [?θ [?A [?B [?L [?H [?H ?H]]]]]]]
    | [[?θ [?A [?B [?H [?H ?H]]]]] | ]].

(* TODO: move these proofs somewhere else *)
Lemma open_a_Conv : forall a g b,
    open_tm_wrt_tm (a_Conv a g) b = a_Conv (open_tm_wrt_tm a b) (open_co_wrt_tm g b).
Proof.
  reflexivity.
Qed.

Lemma open_g_PiSnd : forall g θ g1 g2 b,
    open_co_wrt_tm (g_PiSnd g θ g1 g2) b = g_PiSnd (open_co_wrt_tm g b) θ (open_co_wrt_tm g1 b) (open_co_wrt_tm g2 b).
Proof.
  reflexivity.
Qed.

Lemma open_g_Sym : forall g b,
    open_co_wrt_tm (g_Sym g) b = g_Sym (open_co_wrt_tm g b).
Proof.
  reflexivity.
Qed.

Lemma open_g_Reflex : forall b a,
    open_co_wrt_tm (g_Reflex b) a = g_Reflex (open_tm_wrt_tm b a).
Proof.
  reflexivity.
Qed.

#[export] Hint Rewrite open_a_Conv open_g_PiSnd open_g_Reflex : open_aux.
