From LP Require Import sigs lp_ott lp_ind lp_labels lp_tactics.
From Hammer Require Import Tactics.
From Ltac2 Require Import Ltac2 Constr Control.

Module weak
  (Import narrow : typing_narrowing_sig) <: weak_sig.

Local Ltac2 solve_simple_ty_wf () :=
  lazy_match! goal with
  (* the matching is just for sanity check: making sure the tactic is
  used at the right place *)
  | [ |- context[meet_ctx_l_rho _ (_ ++ _ ++ _)] ] =>
      simpl_env; eapply_first_hyp; simpl_env; eauto using ctx_meet_ctx_l_app3
  end.

Ltac2 Notation "solve_simple_ty_wf" := enter solve_simple_ty_wf.

Local Ltac2 solve_defeq_wf_assoc () :=
  lazy_match! goal with
  | [|- context[_ ++ _ ++ _ ++ _]] =>
      simpl_env;
      rewrite <- app_assoc; eapply_first_hyp; simpl_env;
      eauto with narrow
  end.

Ltac2 Notation "solve_defeq_wf_assoc" := enter solve_defeq_wf_assoc.

Lemma typing_weakening_mutual:
  (forall G θ a A,  Typing G θ a A ->
     forall F E Q, (G = F ++ Q) -> Ctx (F ++ E ++ Q) -> Typing (F ++ E ++ Q) θ a A) /\
  (forall G g1 G0 θ A1 A2 ,  DefEq G g1 G0 θ A1 A2 ->
     forall F E Q, (G = F ++ Q) -> Ctx (F ++ E ++ Q) -> Ctx (G0 ++ F ++ E ++ Q) -> DefEq (F ++ E ++ Q) g1 G0 θ A1 A2) /\
  (forall G,         Ctx G ->
     forall F E Q, (G = F ++ Q) -> Ctx (F ++ E ++ Q) -> Ctx (F ++ E ++ Q)) /\
  (forall G θ a b, aBeta G θ a b ->
               forall F E Q, (G = F ++ Q) -> Ctx (F ++ E ++ Q) -> aBeta (F ++ E ++ Q) θ a b) /\
  (forall G δ a A, CTyping G δ a A ->
               forall F E Q, (G = F ++ Q) -> Ctx (F ++ E ++ Q) -> CTyping (F ++ E ++ Q) δ a A).
Proof.
  apply typing_mutual; intros; subst; eauto.
  (* a_Reify *)
  - econstructor; eauto; solve_simple_ty_wf.
  (* a_Conv *)
  - econstructor; eauto; solve_simple_ty_wf.
  (* Pi *)
  - pick fresh x and apply T_Pi; eauto; solve_defeq_wf_assoc.
  (* Abs *)
  - pick fresh x and apply T_Abs; eauto;
      first [solve_defeq_wf_assoc | solve_simple_ty_wf ].
    inv_atom_rel_tm.
    (* Ctx well-formedness *)
    constructor; auto.
    enough (Typing (meet_ctx_l_rho q_R (F ++ E ++ Q)) theta (a_Pi (r, f) A B) a_TYPE)
      by ltac1:(sauto lq:on rew:off inv:Typing).
    solve_simple_ty_wf.
  - pick fresh x and apply T_Ind; eauto;
      first [solve_defeq_wf_assoc | solve_simple_ty_wf].
  - econstructor; eauto; solve_defeq_wf_assoc.
  - econstructor; eauto; solve_defeq_wf_assoc.
  - econstructor; eauto; solve_defeq_wf_assoc.
  - econstructor; eauto; solve_defeq_wf_assoc.
  - econstructor; eauto; solve_defeq_wf_assoc.
  - pick fresh x and apply E_PiCong; eauto;
      try (first [solve_defeq_wf_assoc | solve_simple_ty_wf ]).
    (* Won't discharge because of Ctx *)
    eapply_first_hyp; eauto.

    (* Ctx well-formedness *)
    simpl.
    econstructor; eauto.
    enough (Typing (G0 ++ F ++ E ++ Q) theta (a_Pi (rho0, theta0) A1 B2) a_TYPE) by ltac1:(hauto use:typing_meet_ctx_l lq: on rew: off inv: Typing).
    solve_defeq_wf_assoc.
  - pick fresh x and apply E_AbsCong; eauto;
      try (first [solve_defeq_wf_assoc | solve_simple_ty_wf ]).
    (* Won't discharge because of Ctx *)
    eapply_first_hyp; eauto.
    simpl; econstructor; eauto.
    enough (Typing (G0 ++ F ++ E ++ Q) theta (a_Abs (rho0, theta0) A a2) B) by ltac1:(hauto use:typing_meet_ctx_l lq: on rew: off inv: Typing).
    solve_defeq_wf_assoc.
  - econstructor; eauto; solve_defeq_wf_assoc.
  - econstructor; eauto; solve_defeq_wf_assoc.
  - econstructor; eauto; solve_defeq_wf_assoc.
  - econstructor; eauto; solve_defeq_wf_assoc.
  - pick fresh x and apply E_IndCong; eauto;
      try (first [solve_defeq_wf_assoc | solve_simple_ty_wf ]).
    eapply_first_hyp; eauto.
    rewrite app_assoc.
    econstructor; eauto.
    ltac1:(sfirstorder use:ctx_meet_ctx_l).
  - econstructor; eauto; solve_simple_ty_wf.
  - econstructor; eauto; solve_simple_ty_wf.
  - econstructor; eauto; solve_simple_ty_wf.
Qed.

Lemma typing_weakening_middle :
  forall F G θ a A,  Typing (F ++ G) θ a A -> forall E, Ctx (F ++ E ++ G) -> Typing (F ++ E ++ G) θ a A.
Proof.
  ltac1:(sfirstorder use:typing_weakening_mutual).
Qed.

(* Lemma 4.1 (Weakening) *)
(* See typing_weakening_mutual for the main proof *)
Lemma typing_weakening : forall G1 θ a A,
    Typing G1 θ a A ->
    forall G2, Ctx (G2 ++ G1) ->
    (* ----------------------- *)
    Typing (G2 ++ G1) θ a A.
Proof.
  intros;
  eapply typing_weakening_middle with (F := nil); simpl_env; eauto.
Qed.

Lemma defeq_weakening_middle :
  forall F Q g1 G0 θ A1 A2 ,  DefEq (F ++ Q) g1 G0 θ A1 A2 ->
                       forall E, Ctx (F ++ E ++ Q) -> Ctx (G0 ++ F ++ E ++ Q) -> DefEq (F ++ E ++ Q) g1 G0 θ A1 A2.
Proof.
  ltac1:(sfirstorder use:typing_weakening_mutual).
Qed.

Lemma defeq_weakening :
  forall Q g1 G0 θ A1 A2 ,  DefEq Q g1 G0 θ A1 A2 ->
                     forall E, Ctx (E ++ Q) -> Ctx (G0 ++ E ++ Q) -> DefEq (E ++ Q) g1 G0 θ A1 A2.
Proof.
  intros;
    eapply defeq_weakening_middle with (F := nil); simpl_env; eauto.
Qed.
End weak.
