Require Import LP.lp_ind.
From Coq Require Import ssreflect.
Require Import LP.lp_inf.
(* lp_tactics has to be imported last *)
Require Import LP.lp_tactics.
From Hammer Require Import Tactics.
From Ltac2 Require Import Ltac2.
From LP Require Import sigs.

Module wff <: wff_sig.

Local Ltac2 spec_ctx_hyp h := let x := Fresh.in_goal @x in
               ltac1:(x h |- pick fresh x; move: (h x ltac:(auto)))
                       (Ltac1.of_ident x) (Ltac1.of_ident h) ; ().

#[local] Hint Extern 1  =>
  ltac2:(
  lazy_match! goal with
  | [h : context [Ctx ?g] |- Ctx ?g] =>
      spec_ctx_hyp h
  | [h : context [Ctx (_ ++ ?g)] |- Ctx ?g  ] =>
      spec_ctx_hyp h; inversion 1
       end) : ctx_tac_db.

Lemma wff_mutual :
  (forall G θ a A, Typing G θ a A -> Ctx G) /\
  (forall G g G0 θ A B, DefEq G g G0 θ A B -> Ctx (G0 ++ G)) /\
  (forall G, Ctx G -> True) /\
  (forall G δ a b, aBeta G δ a b -> Ctx G) /\ (* lc_tm b is given in the defeq red rule *)
  (forall G δ a A, CTyping G δ a A -> True).  (* in the top case gives Ctx meet_ctx_l G instead of Ctx G *)
Proof.
  apply typing_mutual;
    intros;
    auto with ctx_tac_db.
Qed.

Ltac2 solve_uniq_mutual () :=
  match! goal with
  | [h : context [uniq (_ ++ _ ++ _)] |- _] =>
      let x := Fresh.in_goal @x in
      pick fresh $x; spec $x; eauto using uniq_remove_mid
  | [h : context [uniq (_ ++ ?g)] |- _  ] =>
      spec_ctx_hyp h; inversion 1; subst; auto
  | [h : context [uniq ?g] |- _] =>
      spec_ctx_hyp h; solve_uniq
  | [ |- _] => solve_uniq
  end.

Lemma uniq_mutual :
  (forall G θ a A, Typing G θ a A -> uniq G) /\
  (forall G g G0 θ A B, DefEq G g G0 θ A B -> uniq (G0 ++ G)) /\
  (forall G, Ctx G -> uniq G) /\
  (forall G δ a b, aBeta G δ a b -> uniq G) /\
  (forall G δ a A, CTyping G δ a A -> True).
Proof.
  apply typing_mutual; intros;
    try (Control.enter solve_uniq_mutual).
Qed.

Lemma typing_wff : forall G θ a A, Typing G θ a A -> Ctx G.
Proof.
  ltac1:(sfirstorder use:wff_mutual).
Qed.

Lemma defeq_wff : forall G g G0 θ A B, DefEq G g G0 θ A B -> Ctx (G0 ++ G).
Proof.
  ltac1:(sfirstorder use:wff_mutual).
Qed.

#[export]Hint Resolve wff_mutual : ctx_db.

Lemma Ctx_uniq : forall G, Ctx G -> uniq G.
Proof.
  induction 1; ltac1:(sfirstorder use:uniq_mutual).
Qed.

#[export]Hint Resolve Ctx_uniq : ctx_db.

(* For every Ctx G, add uniq G to the proof state *)
Ltac2 ctx_uniq () :=
  List.iter (fun (h,_,ty) =>
               lazy_match! ty with
               | Ctx ?g => 
                   if (List.exist
                         (fun (_,_,ty) => Constr.equal ty '(uniq $g))
                         (Control.hyps ()))
                   then ()
                   else assert (uniq $g) by eauto using Ctx_uniq
               | _ => ()
               end )  
    (Control.hyps ()).

Ltac2 Notation "ctx_uniq" := Control.enter ctx_uniq.

End wff.
