From LP Require Import lp_inf lp_labels lp_tactics forall_depth_inf.
Require Import Coq.Program.Equality.
From Hammer Require Import Tactics.
From Ltac2 Require Import Ltac2.
Import Ltac2.Control.
From LP Require Import sigs.

Module par <: par_sig.

Scheme par_ind'  := Induction for Par Sort Prop
    with cpar_ind' := Induction for CPar Sort Prop.

Combined Scheme par_mutual from par_ind', cpar_ind'.

Local Ltac2 solve_par_inv () := ltac1:(hauto lq: on rew: off inv: Par depth:2).

Local Ltac2 Notation "solve_par_inv" := solve_par_inv ().

Lemma Par_Type_inv : forall P B, Par P a_TYPE B -> B = a_TYPE.
Proof.
  solve_par_inv.
Qed.

Lemma Par_Pi_inv P ρ A1 A2 B
    (H : Par P (a_Pi ρ A1 A2) B) :
    exists B1 B2, B = (a_Pi ρ B1 B2).
Proof.
  solve_par_inv.
Qed.

Lemma Par_Eq_inv : forall P θ A1 B1 B,
    Par P (a_Eq θ A1 B1) B -> exists A2 B2, B = a_Eq θ A2 B2.
Proof.
  solve_par_inv.
Qed.

Lemma Par_uniq_mutual :
  (forall P A1 A2,
      Par P A1 A2 ->
      uniq P) /\
  (forall P ρ A1 A2,
      CPar P ρ A1 A2 ->
      uniq P).
Proof.
  apply par_mutual; trivial.
  (* Abs *)
  intros.
  pick fresh x; repeat (spec x).
  solve_uniq.
Qed.

#[local] Ltac2 solve_par_lc () :=
  lazy_match! goal with
  (* AppAbs *)
  | [ |- context[a_Ind]] => ()
  | [ |- lc_tm (a_App ?a1 ?rho ?b1) /\ lc_tm (open_tm_wrt_tm ?a2 ?b2)] =>
      ltac1:(sfirstorder use: lc_a_App, lc_body_tm_wrt_tm, lc_body_a_Abs_3)
  | [ |- context [ a_Pi ]] => ()
  | [ |- context [ a_Abs ]] => ()
  | [ |- _ ] => ltac1:(sfirstorder)
  end.

Lemma Par_lc_mutual :
  (forall P A1 A2,
      Par P A1 A2 ->
      lc_tm A1 /\ lc_tm A2) /\
  (forall P ρ A1 A2,
      CPar P ρ A1 A2 ->
      lc_tm A1 /\ lc_tm A2).
Proof.
  apply par_mutual; intros; enter solve_par_lc.
  - pick fresh c; repeat (spec c).
    ltac1:(sfirstorder use: lc_a_Pi_exists unfold: tmvar).
  - pick fresh c; repeat (spec c).
    ltac1:(sfirstorder use: lc_a_Abs_exists unfold: tmvar).
  - pick fresh c; repeat (spec c).
    ltac1:(sfirstorder use: lc_a_Ind_exists unfold: tmvar).
  - split.
    pick fresh c; repeat (spec c).
    ltac1:(sfirstorder use: lc_a_Ind_exists unfold: tmvar).
    econstructor; eauto.
    pick fresh x; repeat (spec x).
    rewrite (subst_tm_intro x); auto.
    ltac1:(sauto l:on use:subst_tm_lc_tm).
    pick fresh x; repeat (spec x).
    ltac1:(hauto inv:lc_tm use: lc_a_Ind_exists unfold: tmvar).
  - pick fresh x; repeat (spec x).
    ltac1:(hauto inv:lc_tm use: lc_a_Ind_exists unfold: tmvar).
Qed.

Lemma Par_weak_mutual :
  (forall P A1 A2,
      Par P A1 A2 ->
      forall (P1 P3 : econtext),
        P = P1 ++ P3 ->
        forall P2, uniq (P1 ++ P2 ++ P3) -> Par (P1 ++ P2 ++ P3) A1 A2) /\
  (forall P ρ A1 A2,
      CPar P ρ A1 A2 ->
      forall (P1 P3 : econtext),
        P = P1 ++ P3 ->
        forall P2, uniq (P1 ++ P2 ++ P3) -> CPar (P1 ++ P2 ++ P3) ρ A1 A2).
Proof.
  apply par_mutual; eauto; intros; subst.
  (* Var *)
  - ltac1:(fcrush).
  - pick fresh x and apply P_Pi; repeat (spec x); eauto.
    rewrite <- app_assoc.
    apply_first_hyp; eauto.
    solve_uniq.
  - pick fresh x and apply P_Abs; repeat (spec x); eauto.
    rewrite <- app_assoc.
    apply_first_hyp; eauto.
    solve_uniq.
  - pick fresh x and apply P_IndZero; repeat (spec x); eauto.
    rewrite <- app_assoc.
    apply_first_hyp; eauto.
    solve_uniq.
  - pick fresh x and apply P_IndSucc; repeat (spec x); eauto.
    rewrite <- app_assoc.
    apply_first_hyp; eauto.
    solve_uniq.
  - pick fresh x and apply P_IndCong; repeat (spec x); eauto.
    rewrite <- app_assoc.
    apply_first_hyp; eauto.
    solve_uniq.
Qed.

Lemma Par_weak :
  forall P1 P3 A1 A2,
    Par (P1 ++ P3) A1 A2 ->
      forall P2, uniq (P1 ++ P2 ++ P3) -> Par (P1 ++ P2 ++ P3) A1 A2.
  ltac1:(sfirstorder use:Par_weak_mutual). Qed.

Lemma Par_weak_nil :
  forall P3 A1 A2,
      Par P3 A1 A2 ->
      forall P2, uniq (P2 ++ P3) -> Par (P2 ++ P3) A1 A2.
Proof.
  ltac1:(sfirstorder use:(Par_weak nil)).
Qed.

Lemma Par_cong_mutual :
  (forall P A1 A2,
      Par P A1 A2 ->
      forall P1 x ρ P3,
        P = P1 ++ x ~ ρ ++ P3 ->
        forall B1 B2,
          CPar P3 ρ B1 B2 ->
          Par (P1 ++ P3) (subst_tm B1 x A1) (subst_tm B2 x A2)) /\
  (forall P ρ A1 A2,
      CPar P ρ A1 A2 ->
      forall P1 x ρ0 P3,
        P = P1 ++ x ~ ρ0 ++ P3 ->
        forall B1 B2,
          CPar P3 ρ0 B1 B2 ->
          CPar (P1 ++ P3) ρ (subst_tm B1 x A1) (subst_tm B2 x A2)).
Proof.
  apply par_mutual; intros; subst; simpl; eauto.
  - destruct (x == x0); subst.
    + inversion H0; subst.
      ++ apply Par_weak_nil; auto.
         solve_uniq.
      ++ enough (q_R = q_I) by ltac1:(congruence).
         ltac1:(sfirstorder use:binds_mid_eq).
    + constructor.
      ++ solve_uniq.
      ++ ltac1:(hauto lq:on use: binds_remove_mid).
  (* reify *)
  - ltac1:(qauto l:on ctrs:lc_tm, lc_co, Par use: subst_co_lc_co, Par_lc_mutual).
  (* app abs *)
  - rewrite subst_tm_open_tm_wrt_tm; eauto.
    ltac1:(strivial use: Par_lc_mutual).
  - apply P_Conv.
    + ltac1:(qauto use: Par_lc_mutual, subst_co_lc_co unfold: tmvar, econtext).
    + ltac1:(hauto q:on ctrs:Par use: subst_tm_lc_tm, Par_lc_mutual).
  - apply P_ConvCong; eauto.
    + ltac1:(qauto use: Par_lc_mutual, subst_co_lc_co unfold: tmvar, econtext).
    + ltac1:(qauto use: Par_lc_mutual, subst_co_lc_co unfold: tmvar, econtext).
  - pick fresh y and apply P_Pi; eauto.
    repeat (spec y).
    rewrite <- app_assoc.
    rewrite subst_tm_open_tm_wrt_tm_var; eauto.
    rewrite subst_tm_open_tm_wrt_tm_var; eauto.
    eapply_first_hyp; eauto.
    simpl_env; reflexivity.
    ltac1:(hauto l:on use:Par_lc_mutual).
    ltac1:(hauto l:on use:Par_lc_mutual).
  - pick fresh y and apply P_Abs; eauto.
    ltac1:(qauto use: Par_lc_mutual, subst_tm_lc_tm unfold: tmvar, econtext).
    ltac1:(qauto use: Par_lc_mutual, subst_tm_lc_tm unfold: tmvar, econtext).
    repeat (spec y).
    rewrite <- app_assoc.
    rewrite subst_tm_open_tm_wrt_tm_var; eauto.
    rewrite subst_tm_open_tm_wrt_tm_var; eauto.
    eapply_first_hyp; eauto.
    simpl_env; reflexivity.
    ltac1:(hauto l:on use:Par_lc_mutual).
    ltac1:(hauto l:on use:Par_lc_mutual).
  - pick fresh y and apply P_IndZero; eauto.
    ltac1:(qauto use: Par_lc_mutual, subst_tm_lc_tm unfold: tmvar, econtext).
    repeat (spec y).
    rewrite <- app_assoc.
    ltac1:(instantiate (1 := (subst_tm B2 x b3))).
    rewrite subst_tm_open_tm_wrt_tm_var; eauto.
    rewrite subst_tm_open_tm_wrt_tm_var; eauto.
    eapply_first_hyp; auto.
    simpl_env; reflexivity.
    ltac1:(hauto l:on use:Par_lc_mutual).
    ltac1:(hauto l:on use:Par_lc_mutual).
    ltac1:(hauto l:on use:Par_lc_mutual).
  - assert (tr0: lc_tm B1) by ltac1:(hauto l:on use:Par_lc_mutual).
    assert (tr1: lc_tm B2) by ltac1:(hauto l:on use:Par_lc_mutual).
    rewrite subst_tm_open_tm_wrt_tm; eauto.
    pick fresh y and apply P_IndSucc; eauto.
    ltac1:(qauto use: Par_lc_mutual, subst_tm_lc_tm unfold: tmvar, econtext).
    ltac1:(qauto use: Par_lc_mutual, subst_tm_lc_tm unfold: tmvar, econtext).
    repeat (spec y).
    rewrite <- app_assoc.
    rewrite subst_tm_open_tm_wrt_tm_var; eauto.
    rewrite subst_tm_open_tm_wrt_tm_var; eauto.
    eapply_first_hyp; auto.
    simpl_env; reflexivity.
    ltac1:(hauto l:on use:Par_lc_mutual).
  - assert (tr0: lc_tm B1) by ltac1:(hauto l:on use:Par_lc_mutual).
    assert (tr1: lc_tm B2) by ltac1:(hauto l:on use:Par_lc_mutual).
    pick fresh y and apply P_IndCong; eauto.
    ltac1:(qauto use: Par_lc_mutual, subst_tm_lc_tm unfold: tmvar, econtext).
    ltac1:(qauto use: Par_lc_mutual, subst_tm_lc_tm unfold: tmvar, econtext).
    repeat (spec y).
    rewrite <- app_assoc.
    rewrite subst_tm_open_tm_wrt_tm_var; eauto.
    rewrite subst_tm_open_tm_wrt_tm_var; eauto.
    eapply_first_hyp; auto.
    simpl_env; reflexivity.
    ltac1:(hauto l:on use:Par_lc_mutual).
  - ltac1:(qauto l:on ctrs:CPar use: subst_tm_lc_tm, Par_lc_mutual unfold: econtext, tmvar).
Qed.

Lemma Par_cong :
  (forall P1 x ρ P3 A1 A2,
      Par (P1 ++ x ~ ρ ++ P3) A1 A2 ->
        forall B1 B2,
          CPar P3 ρ B1 B2 ->
          Par (P1 ++ P3) (subst_tm B1 x A1) (subst_tm B2 x A2)).
Proof.
  ltac1:(strivial use:Par_cong_mutual).
Qed.

Lemma Par_cong_nil :
  forall x ρ P3 A1 A2,
    Par (x ~ ρ ++ P3) A1 A2 ->
        forall B1 B2,
          CPar P3 ρ B1 B2 ->
          Par P3 (subst_tm B1 x A1) (subst_tm B2 x A2).
Proof.
  ltac1:(strivial use:(Par_cong nil)).
Qed.

Lemma Par_renaming :
  forall x ρ P3 A1 A2,
    Par (x ~ ρ ++ P3) A1 A2 ->
    forall x0,
      x0 `notin` fv_tm A1 ->
      x0 `notin` fv_tm A2 ->
      x0 `notin` dom P3 ->
      x0 <> x ->
      Par (x0 ~ ρ ++ P3) (subst_tm (a_Var_f x0) x A1) (subst_tm (a_Var_f x0) x A2).
Proof.
  intros.
  apply Par_cong_nil with (x := x) (B1 := (a_Var_f x0)) (B2 := (a_Var_f x0)) (ρ := ρ); auto.
  apply Par_weak; auto.
  ltac1:(qauto l:on use:Par_uniq_mutual final:solve_uniq).
  assert (uniq ( x ~ ρ ++ P3)) by ltac1:(sfirstorder use:Par_uniq_mutual).
  destruct ρ;
    ltac1:(fcrush).
Qed.

Lemma Par_PiCong_exists :
  forall P A1 A2,
    Par P A1 A2 ->
    forall x ρ B1 B2,
      x `notin` fv_tm B1 ->
      x `notin` fv_tm B2 ->
      Par (x ~ q_R ++ P) (open_tm_wrt_tm B1 (a_Var_f x)) (open_tm_wrt_tm B2 (a_Var_f x)) ->
      Par P (a_Pi ρ A1 B1) (a_Pi ρ A2 B2).
Proof with auto.
  intros; pick fresh x0 and apply P_Pi...
  rewrite (subst_tm_intro x B1)...
  rewrite (subst_tm_intro x B2)...
  apply Par_renaming; auto 2.
  rewrite fv_tm_open_tm_wrt_tm_upper; auto.
  rewrite fv_tm_open_tm_wrt_tm_upper; auto.
Qed.

Lemma Par_AbsCong_exists :
  forall P A1 A2,
    lc_tm A1 ->
    lc_tm A2 ->
    forall x ρ θ B1 B2,
      x `notin` fv_tm B1 ->
      x `notin` fv_tm B2 ->
      Par (x ~ ρ ++ P) (open_tm_wrt_tm B1 (a_Var_f x)) (open_tm_wrt_tm B2 (a_Var_f x)) ->
      Par P (a_Abs (ρ, θ) A1 B1) (a_Abs (ρ, θ) A2 B2).
Proof with auto.
  intros; pick fresh x0 and apply P_Abs...
  rewrite (subst_tm_intro x B1)...
  rewrite (subst_tm_intro x B2)...
  apply Par_renaming; auto 2.
  rewrite fv_tm_open_tm_wrt_tm_upper; auto.
  rewrite fv_tm_open_tm_wrt_tm_upper; auto.
Qed.

Lemma Par_IndSucc_exists :
  forall (y : atom) (W:econtext) (a1 a2 a3 A b3 b1 b2 A0:tm),
    y `notin` fv_tm a3 \u fv_tm b3 ->
     lc_tm A ->
     lc_tm A0 ->
      uniq  W  ->
     Par W a1 (a_Succ b1) ->
     Par W a2 b2 ->
     Par  (  ( y ~  q_R  )  ++ W )   ( open_tm_wrt_tm a3 (a_Var_f y) )   ( open_tm_wrt_tm b3 (a_Var_f y) )  ->
     Par W (a_Ind a1 a2 a3 A) (a_App  (  (open_tm_wrt_tm  b3   b1 )  )   (   q_R  ,   t_L   )   ( (a_Ind b1 b2 b3 A0) ) ).
Proof with auto.
  intros.
  pick fresh z and apply P_IndSucc; eauto.
  rewrite (subst_tm_intro y a3)...
  rewrite (subst_tm_intro y b3)...
  apply Par_renaming; auto 2;
    rewrite fv_tm_open_tm_wrt_tm_upper...
Qed.

Lemma Par_IndCong_exists :
  forall (y:atom) (W:econtext) (a1 a2 a3 A b1 b2 b3 A0:tm),
    y `notin` fv_tm a3 \u fv_tm b3 ->
     lc_tm A ->
     lc_tm A0 ->
      uniq  W  ->
     Par W a1 b1 ->
     Par W a2 b2 ->
     Par  (  ( y ~  q_R  )  ++ W )   ( open_tm_wrt_tm a3 (a_Var_f y) )   ( open_tm_wrt_tm b3 (a_Var_f y) )  ->
     Par W (a_Ind a1 a2 a3 A) (a_Ind b1 b2 b3 A0).
Proof with auto.
  intros.
  pick fresh z and apply P_IndCong; eauto.
  rewrite (subst_tm_intro y a3)...
  rewrite (subst_tm_intro y b3)...
  apply Par_renaming; auto 2;
    rewrite fv_tm_open_tm_wrt_tm_upper...
Qed.

(* Par a b implies Par b b *)
Lemma Par_grade_mutual :
  (forall P A1 B1,
      Par P A1 B1 ->
      Par P B1 B1 /\ Par P A1 A1) /\
  (forall P ρ A1 B1,
      CPar P ρ A1 B1 ->
      CPar P ρ A1 A1 /\
      CPar P ρ B1 B1).
Proof.
  apply par_mutual; intros; split_hyp; split;
    try ltac1:(sfirstorder depth:1).
  (* AppCong *)
  - inversion H; subst.
    pick fresh y; spec y.
    rewrite (subst_tm_intro y); auto.
    ltac1:(sfirstorder use:Par_cong_nil).
  (* PiCong *)
  - pick fresh x; repeat (spec x).
    apply Par_PiCong_exists with (x := x); auto.
    ltac1:(tauto).
  - pick fresh x; repeat (spec x).
    apply Par_PiCong_exists with (x := x); auto.
    ltac1:(tauto).
  - pick fresh x; repeat (spec x).
    apply Par_AbsCong_exists with (x := x); auto.
    ltac1:(tauto).
  - pick fresh x; repeat (spec x).
    apply Par_AbsCong_exists with (x := x); auto.
    ltac1:(tauto).
  - pick fresh x and apply P_IndCong; repeat (spec x); eauto.
    ltac1:(tauto).
  - econstructor; eauto.
    pick fresh x; repeat (spec x).
    rewrite (subst_tm_intro x); auto.
    eapply Par_cong_nil; eauto.
    ltac1:(hauto lq:on).
    constructor; auto.
    inversion H; subst; auto.
    constructor.
    pick fresh y and apply P_IndCong; repeat (spec x); eauto.
    inversion H; subst; auto.
    repeat (spec y).
    ltac1:(tauto).
  - pick fresh x and apply P_IndCong; repeat (spec x); eauto.
    ltac1:(tauto).
  - pick fresh x and apply P_IndCong; repeat (spec x); eauto.
    ltac1:(tauto).
  - pick fresh x and apply P_IndCong; repeat (spec x); eauto.
    ltac1:(tauto).
Qed.

Lemma Par_confluence :
  (forall P A1 B1,
      Par P A1 B1 ->
      forall B2,
        Par P A1 B2 ->
       exists C, Par P B1 C /\ Par P B2 C) /\
  (forall P ρ A1 B1,
      CPar P ρ A1 B1 ->
      forall B2,
        CPar P ρ A1 B2 ->
        exists C, CPar P ρ B1 C /\ CPar P ρ B2 C).
Proof.
  apply par_mutual; intros; subst; simpl; eauto; ltac1:(rename W into P).
  - ltac1:(hauto depth:1 inv:Par ctrs:Par).
  - ltac1:(hauto depth:1 inv:Par ctrs:Par).
  - ltac1:(hauto depth:1 inv:Par ctrs:Par).
  - inversion H1; subst; auto.
    + ltac1:(hauto depth:1 inv:Par ctrs:Par).
    + assert (h0 : exists C0, Par P a2 C0 /\ Par P (a_Abs (rho, theta) A a3) C0) by auto.
      assert (h1 : exists C1, CPar P rho b2 C1 /\ CPar P rho b3 C1) by auto.
      destruct h0 as [C0 [h00 h01]].
      destruct h1 as [C1 [h10 h11]].
      inversion h01; subst; eauto.
      exists (open_tm_wrt_tm b4 C1).
      split.
      ++ ltac1:(sfirstorder).
      ++ pick fresh x; repeat (spec x).
         rewrite (subst_tm_intro x a3); auto.
         rewrite (subst_tm_intro x b4); auto.
         ltac1:(sfirstorder use: Par_cong_nil).
  - inversion H1; subst; auto.
    + assert (h0 : exists C0, Par P (a_Abs (rho, theta) A a2) C0 /\ Par P a3 C0) by auto.
      assert (h1 : exists C1, CPar P rho b2 C1 /\ CPar P rho b3 C1) by auto.
      destruct h0 as [C0 [h00 h01]].
      destruct h1 as [C1 [h10 h11]].
      inversion h00; subst; eauto.
      exists (open_tm_wrt_tm b4 C1).
      split.
      ++ pick fresh x; repeat (spec x).
         rewrite (subst_tm_intro x a2); auto.
         rewrite (subst_tm_intro x b4); auto.
         ltac1:(sfirstorder use: Par_cong_nil).
      ++ ltac1:(sfirstorder).
    (* both appabs *)
    + assert (h0 : exists C0, Par P (a_Abs (rho, theta) A a2) C0 /\ Par P (a_Abs (rho, theta) A0 a3) C0) by auto.
      assert (h1 : exists C1, CPar P rho b2 C1 /\ CPar P rho b3 C1) by auto.
      destruct h0 as [C0 [h00 h01]].
      destruct h1 as [C1 [h10 h11]].
      inversion h00;
        inversion h01; subst.
      injection H17; intros; subst.
      exists (open_tm_wrt_tm b4 C1).
      pick fresh x; repeat (spec x).
      split.
      ++ rewrite (subst_tm_intro x a2); auto.
         rewrite (subst_tm_intro x b4); auto.
         ltac1:(sfirstorder use: Par_cong_nil).
      ++
         rewrite (subst_tm_intro x a3); auto.
         rewrite (subst_tm_intro x b4); auto.
         ltac1:(sfirstorder use: Par_cong_nil).
  (* Two Conv cases *)
  - ltac1:(hauto depth:3 lq:on ctrs:Par inv:Par).
  - ltac1:(hauto depth:3 lq:on ctrs:Par inv:Par).
  - inversion H1; subst.
    pick fresh x; repeat (spec x).
    assert (h0 : exists C0, Par P A2 C0 /\ Par P A3 C0) by auto.
    assert (h1 : exists C1, Par (x ~ q_R ++ P) (open_tm_wrt_tm B2 (a_Var_f x)) C1 /\ Par (x ~ q_R ++ P) (open_tm_wrt_tm B4 (a_Var_f x)) C1) by auto.
    destruct h0 as [C0 [h00 h01]].
    destruct h1 as [C1 [h10 h11]].
    exists (a_Pi delta5 C0 (close_tm_wrt_tm x C1)).
    split.
    + apply Par_PiCong_exists with (x := x); eauto.
      rewrite fv_tm_close_tm_wrt_tm; auto.
      ltac1:(scongruence use: open_tm_wrt_tm_close_tm_wrt_tm).
    + apply Par_PiCong_exists with (x := x); eauto.
      rewrite fv_tm_close_tm_wrt_tm; auto.
      ltac1:(scongruence use: open_tm_wrt_tm_close_tm_wrt_tm).
  - inversion H0; subst.
    pick fresh x; repeat (spec x).
    (* This no longer works because par straight up ignores the annotation *)
    assert (h1 : exists C1, Par (x ~ rho ++ P) (open_tm_wrt_tm b2 (a_Var_f x)) C1 /\ Par (x ~ rho ++ P) (open_tm_wrt_tm b3 (a_Var_f x)) C1) by auto.
    destruct h1 as [C1 [h10 h11]].
    exists (a_Abs (rho, theta) A3 (close_tm_wrt_tm x C1)).
    split.
    + apply Par_AbsCong_exists with (x := x); eauto.
      rewrite fv_tm_close_tm_wrt_tm; auto.
      ltac1:(scongruence use: open_tm_wrt_tm_close_tm_wrt_tm).
    + apply Par_AbsCong_exists with (x := x); eauto.
      rewrite fv_tm_close_tm_wrt_tm; auto.
    ltac1:(scongruence use: open_tm_wrt_tm_close_tm_wrt_tm).
  - ltac1:(hauto depth:3 lq:on ctrs:Par inv:Par).
  - ltac1:(sauto lq:on depth:3 ctrs:Par).
  - ltac1:(sauto lq:on depth:3 ctrs:Par).
  - ltac1:(sauto lq:on depth:3).
  - inversion H2; subst.
    + pick fresh x; repeat (spec x).
      ltac1:(hauto l:on).
    + assert (exists b, Par P a_Zero b /\ Par P (a_Succ b1) b)
        by ltac1:(sfirstorder).
      destruct H3; split_hyp.
      ltac1:(qauto l:on inv:Par).
    + assert (h0 : Par P b1 a_Zero)
        by ltac1:(qauto l:on inv:Par).
      assert (h1 : exists c, Par P b2 c /\ Par P b0 c) by ltac1:(sfirstorder).
      destruct h1 as [c [? ?]].
      exists c.
      split; auto.
      pick fresh x and apply P_IndZero; repeat (spec x); eauto.
      ltac1:(hauto l:on use:Par_grade_mutual).
  - inversion H2; subst.
    + assert (tr0 : exists b, Par P a_Zero b /\ Par P (a_Succ b1) b)
        by ltac1:(sfirstorder).
      destruct tr0; split_hyp.
      ltac1:(qauto l:on inv:Par).
    + assert (tr0: exists b0, Par P (a_Succ b4) (a_Succ b0) /\ Par P (a_Succ b1) (a_Succ b0)) by ltac1:(sauto lq:on inv:Par).
      destruct tr0 as [c1 [hc11 hc12]].
      inversion hc11; subst.
      inversion hc12; subst.
      assert (tr1: exists c2, Par P b2 c2 /\ Par P b5 c2) by ltac1:(sfirstorder).
      destruct tr1 as [c2 [hc21 hc22]].
      pick fresh x; repeat (spec x).
      assert (tr2 : exists c3,
                 Par (x ~ q_R ++ P) (open_tm_wrt_tm b3 (a_Var_f x)) c3 /\
                   Par (x ~ q_R ++ P) (open_tm_wrt_tm b0 (a_Var_f x)) c3)
        by ltac1:(hauto l:on).
      destruct tr2 as [c3 [hc31 hc32]].
      exists (a_App (subst_tm c1 x c3) (q_R, t_L) (a_Ind c1 c2 (close_tm_wrt_tm x c3) A0)).
      split.
      * apply P_AppCong; eauto.
        rewrite (subst_tm_intro x); auto.
        eapply Par_cong_nil; eauto.
        constructor.
        apply (Par_IndCong_exists x); try (rewrite fv_tm_close_tm_wrt_tm); eauto.
        rewrite open_tm_wrt_tm_close_tm_wrt_tm; auto.
      * apply P_AppCong; eauto.
        rewrite (subst_tm_intro x); auto.
        eapply Par_cong_nil; eauto.
        constructor.
        apply (Par_IndCong_exists x); try (rewrite fv_tm_close_tm_wrt_tm); eauto.
        rewrite open_tm_wrt_tm_close_tm_wrt_tm; auto.
    + assert (tr0 : exists c0, Par P (a_Succ b1) c0 /\ Par P b0 c0) by ltac1:(sfirstorder).
      destruct tr0 as [c0 [hc00 hc01]].
      assert (tr1 : exists c1, Par P b2 c1 /\ Par P b4 c1) by ltac1:(sfirstorder).
      destruct tr1 as [c1 [hc10 hc11]].
      pick fresh x; repeat (spec x).
      assert (tr2 : exists c2, Par (x ~ q_R ++ P) (open_tm_wrt_tm b3 (a_Var_f x)) c2 /\ Par (x ~ q_R ++ P) (open_tm_wrt_tm b5 (a_Var_f x)) c2) by ltac1:(sfirstorder).
      destruct tr2 as [c2 [hc20 hc21]].
      inversion hc00; subst.
      exists (a_App (subst_tm a4 x c2) (q_R, t_L) (a_Ind a4 c1 (close_tm_wrt_tm x c2) A2)).
      split.
      * apply P_AppCong; eauto.
        rewrite (subst_tm_intro x); auto.
        eapply Par_cong_nil; eauto.
        constructor.
        apply (Par_IndCong_exists x); try (rewrite fv_tm_close_tm_wrt_tm); eauto.
        rewrite open_tm_wrt_tm_close_tm_wrt_tm; auto.
      * rewrite subst_tm_spec.
        apply (Par_IndSucc_exists x); auto 1.
        rewrite fv_tm_close_tm_wrt_tm; auto.
        rewrite open_tm_wrt_tm_close_tm_wrt_tm; auto.
  - inversion H2; subst.
    + assert (tr0: uniq P) by ltac1:(strivial use:Par_uniq_mutual).
      assert (tr1 : Par P b1 a_Zero /\ Par P a_Zero a_Zero) by ltac1:(hauto l:on inv:Par).
      assert (tr2 : exists c2, Par P b2 c2 /\ Par P B2 c2) by ltac1:(sfirstorder).
      destruct tr2 as [c2 [hc20 hc21]].
      destruct tr1 as [hc00 hc01].
      exists c2.
      split.
      * pick fresh y and apply P_IndZero; eauto.
        ltac1:(hauto l:on use:Par_grade_mutual).
      * ltac1:(sfirstorder).
    + assert (tr1 : exists c1, Par P b1 c1 /\ Par P (a_Succ b4) c1) by ltac1:(sfirstorder).
      destruct tr1 as [c1 [hc10 hc11]].
      inversion hc11; subst.
      assert (tr2: exists c2, Par P b2 c2 /\ Par P b5 c2) by ltac1:(sfirstorder).
      destruct tr2 as [c2 [hc20 hc21]].
      pick fresh x; repeat (spec x).
      assert (tr3: exists c3, Par (x ~ q_R ++ P) (open_tm_wrt_tm b3 (a_Var_f x)) c3 /\ Par (x ~ q_R ++ P) (open_tm_wrt_tm b0 (a_Var_f x)) c3) by ltac1:(sfirstorder).
      destruct tr3 as [c3 [hc30 hc31]].
      exists (a_App (subst_tm a4 x c3) (q_R, t_L) (a_Ind a4 c2 (close_tm_wrt_tm x c3) A2)).
      split.
      * rewrite subst_tm_spec.
        apply (Par_IndSucc_exists x); auto 1.
        rewrite fv_tm_close_tm_wrt_tm; auto.
        rewrite open_tm_wrt_tm_close_tm_wrt_tm; auto.
      * apply P_AppCong; eauto.
        rewrite (subst_tm_intro x); auto.
        eapply Par_cong_nil; eauto.
        constructor.
        apply (Par_IndCong_exists x); try (rewrite fv_tm_close_tm_wrt_tm); eauto.
        rewrite open_tm_wrt_tm_close_tm_wrt_tm; auto.
    + assert (tr1 : exists c1, Par P b1 c1 /\ Par P b0 c1) by ltac1:(sfirstorder).
      destruct tr1 as [c1 [hc10 hc11]].
      assert (tr2 : exists c2, Par P b2 c2 /\ Par P b4 c2) by ltac1:(sfirstorder).
      destruct tr2 as [c2 [hc20 hc21]].
      pick fresh x; repeat (spec x).
      assert (tr3 : exists c3, Par (x ~ q_R ++ P) (open_tm_wrt_tm b3 (a_Var_f x)) c3 /\ Par (x ~ q_R ++ P) (open_tm_wrt_tm b5 (a_Var_f x)) c3) by ltac1:(sfirstorder).
      destruct tr3 as [c3 [hc30 hc31]].
      exists (a_Ind c1 c2 (close_tm_wrt_tm x c3) A2).
      split;
        apply (Par_IndCong_exists x); try (rewrite fv_tm_close_tm_wrt_tm);
        try (rewrite open_tm_wrt_tm_close_tm_wrt_tm); eauto.
  - ltac1:(hauto ctrs:CPar inv:CPar lq:on depth:3).
  - ltac1:(hauto ctrs:CPar inv:CPar lq:on depth:3).
Qed.

Lemma Par_headform_preservation :
  forall P A B, Par P A B ->
       forall h, Some h = tm_to_headform A -> Some h = tm_to_headform B.
Proof.
  induction 1;
    ltac1:(hauto depth:1).
Qed.

Lemma MultiPar_headform_preservation :
  forall P A B, MultiPar P A B ->
           forall h, Some h = tm_to_headform A -> Some h = tm_to_headform B.
Proof.
  induction 1;
    ltac1:(hauto depth:1 use:Par_headform_preservation).
Qed.

(* Lemma 4.6 (Joinability consistency) *)
Lemma Join_Consistent :
  forall P A B, Joins P A B ->
           (* ----------- *)
           Consistent A B.
Proof.
  unfold Consistent.
  ltac1:(qblast depth:1 use: MultiPar_headform_preservation).
Qed.

Lemma MultiPar_AppCong1 : forall P ρ a a',
    MultiPar P a a' ->
    forall b b',
      CPar P ρ b b' ->
      forall θ,
    MultiPar P (a_App a (ρ, θ) b) (a_App a' (ρ, θ) b').
Proof.
  induction 1; intros; auto.
  apply MP_Step with (b := (a_App b (ρ, θ) b')).
  - constructor; auto.
  - ltac1:(hauto lq:on rew:off use:Par_grade_mutual, CP_Leq).
Qed.

Lemma MultiPar_PiFst : forall P ρ (A B A' B' : tm),
    MultiPar P (a_Pi ρ A B) (a_Pi ρ A' B') ->
    MultiPar P A A'.
Proof.
  (* dependent induction would have done the generalization
  automatically *)
  intros P ρ A B A' B' h0.
  remember (a_Pi ρ A B) as C.
  ltac1:(generalize dependent A).
  ltac1:(generalize dependent B).
  remember (a_Pi ρ A' B') as C'.
  induction h0; intros; subst; auto; ltac1:(sauto depth:2 lq:on rew:off).
Qed.

Lemma MultiPar_trans : forall P A B C,
    MultiPar P A B -> MultiPar P B C -> MultiPar P A C.
Proof.
  induction 1; ltac1:(sfirstorder).
Qed.

Lemma CMultiPar_trans : forall P ρ A B C,
    CMultiPar P ρ A B -> CMultiPar P ρ B C -> CMultiPar P ρ A C.
Proof.
  destruct ρ; ltac1:(sfirstorder use:MultiPar_trans).
Qed.

Lemma MultiPar_weak_mutual : forall P1 P2 P3 A B,
    MultiPar (P1 ++ P3) A B ->
    uniq (P1 ++ P2 ++ P3) ->
    MultiPar (P1 ++ P2 ++ P3) A B.
Proof.
  intros P1 P2 P3 A B H.
  ltac1:(dependent induction H; hauto l:on ctrs:Par use:Par_weak).
Qed.

Lemma Join_weak : forall P1 P2 P3 A B,
    Joins (P1 ++ P3) A B ->
    uniq (P1 ++ P2 ++ P3) ->
    Joins (P1 ++ P2 ++ P3) A B.
Proof.
  ltac1:(sauto use:MultiPar_weak_mutual).
Qed.

Lemma Join_weak_from_nil : forall P A B,
    Joins nil A B ->
    uniq P ->
    Joins P A B.
Proof.
  intros P A B.
  pose proof (Join_weak nil P nil A B).
  repeat (rewrite app_nil_r in H).
  simpl in H; auto.
Qed.

Lemma MultiPar_lc : forall P A1 A2,
    MultiPar P A1 A2 -> lc_tm A1 /\ lc_tm A2.
Proof.
  induction 1; ltac1:(sfirstorder use: Par_lc_mutual).
Qed.

Lemma MultiPar_uniq : forall P A1 A2,
    MultiPar P A1 A2 ->
    uniq P.
Proof.
  ltac1:(hauto use: Par_uniq_mutual inv: MultiPar).
Qed.

Lemma CMultiPar_uniq : forall P ρ A1 A2,
    CMultiPar P ρ A1 A2 ->
    uniq P.
Proof.
  ltac1:(hauto use: MultiPar_uniq unfold: CMultiPar).
Qed.

Lemma CMultiPar_lc : forall P ρ A1 A2,
    CMultiPar P ρ A1 A2 -> lc_tm A1 /\ lc_tm A2.
Proof.
  ltac1:(hauto use: MultiPar_lc unfold: CMultiPar).
Qed.

Lemma MultiPar_Par_cong :
  forall P1 x ρ P3 A1 A2,
    MultiPar (P1 ++ x ~ ρ ++ P3) A1 A2 ->
    forall B1 B2,
      CPar P3 ρ B1 B2 ->
      MultiPar (P1 ++ P3) (subst_tm B1 x A1) (subst_tm B2 x A2).
Proof.
  intros P1 x ρ P3 A1 A2 h0.
  ltac1:(dependent induction h0); intros; auto.
  - eauto using Par_cong.
  - apply MP_Step with (b := subst_tm B2 x b).
    + eauto using Par_cong.
    + ltac1:(qauto l:on use: Par_grade_mutual unfold: econtext).
Qed.

Lemma CMultiPar_Par_cong :
  forall ρ0 P1 x ρ P3 A1 A2,
    CMultiPar (P1 ++ x ~ ρ ++ P3) ρ0 A1 A2 ->
    forall B1 B2,
      CPar P3 ρ B1 B2 ->
      CMultiPar (P1 ++ P3) ρ0 (subst_tm B1 x A1) (subst_tm B2 x A2).
Proof.
  destruct ρ0; intros.
  - ltac1:(sfirstorder use:MultiPar_Par_cong).
  - simpl; repeat split.
    + ltac1:(qauto use: Par_lc_mutual, subst_tm_lc_tm unfold: one, tmvar, econtext, CMultiPar).
    + ltac1:(qauto use: Par_lc_mutual, subst_tm_lc_tm unfold: one, tmvar, econtext, CMultiPar).
    + ltac1:(hauto l:on use:CMultiPar_uniq).
Qed.

Lemma MultiPar_cong :
  forall P1 x ρ P3 A1 A2,
    MultiPar (P1 ++ x ~ ρ ++ P3) A1 A2 ->
    forall B1 B2,
      CMultiPar P3 ρ B1 B2 ->
      MultiPar (P1 ++ P3) (subst_tm B1 x A1) (subst_tm B2 x A2).
Proof.
  intros.
  destruct ρ.
  - simpl in H0.
    ltac1:(dependent induction H0).
    + ltac1:(sfirstorder use: MultiPar_Par_cong, CP_Leq unfold: econtext).
    + apply MultiPar_trans with (B := subst_tm b x A1).
      ++ apply MP_One.
         ltac1:(qauto depth:1 use: Par_grade_mutual, CP_Leq, Par_cong unfold: econtext inv: MultiPar).
      ++ auto.
  - simpl in H0.
    ltac1:(sfirstorder use: MP_One, P_Type, MultiPar_Par_cong, CP_Nleq, MP_Step unfold:  econtext, tmvar inv: MultiPar).
Qed.

Lemma CMultiPar_cong :
  forall P1 x ρ P3 ρ0 A1 A2,
    CMultiPar (P1 ++ x ~ ρ ++ P3) ρ0 A1 A2 ->
    forall B1 B2,
      CMultiPar P3 ρ B1 B2 ->
      CMultiPar (P1 ++ P3) ρ0 (subst_tm B1 x A1) (subst_tm B2 x A2).
Proof.
  destruct ρ0.
  - ltac1:(sfirstorder use: MultiPar_cong unfold: CMultiPar, one inv: lattice.relevance).
  - intros.
    simpl.
    simpl in H.
    repeat split.
    + ltac1:(hauto lq: on use: subst_tm_lc_tm, CMultiPar_lc unfold: econtext, tmvar).
    + ltac1:(hauto lq: on use: subst_tm_lc_tm, CMultiPar_lc unfold: econtext, tmvar).
    + split_hyp; solve_uniq.
Qed.

Lemma MultiPar_confluence_helper :
  forall P A B,
    MultiPar P A B ->
    forall C,
    Par P A C ->
    exists D, MultiPar P B D /\ MultiPar P C D.
Proof.
  induction 1; auto.
  - ltac1:(hfcrush depth:1 use: Par_confluence, MP_One).
  - intros c h0.
    assert (exists d, Par W c d /\ Par W b d)
      by ltac1:(sfirstorder use: Par_confluence).
    destruct H1; split_hyp.
    ltac1:(sfirstorder).
Qed.

Lemma MultiPar_confluence :
  forall P A B,
    MultiPar P A B ->
    forall C,
    MultiPar P A C ->
    exists D, MultiPar P B D /\ MultiPar P C D.
Proof.
  induction 1.
  - ltac1:(hauto lq: on use: MP_Step, MultiPar_confluence_helper, MP_One).
  - ltac1:(hauto use: MP_Step, MultiPar_trans, MultiPar_confluence_helper, MP_One inv: MultiPar).
Qed.

Lemma CMultiPar_confluence :
  forall P ρ A B,
    CMultiPar P ρ A B ->
    forall C,
    CMultiPar P ρ A C ->
    exists D, CMultiPar P ρ B D /\ CMultiPar P ρ C D.
Proof.
  ltac1:(hauto lq: on use: CMultiPar_uniq, MultiPar_confluence, CMultiPar_lc unfold: CMultiPar inv: lattice.relevance).
Qed.

Set Default Proof Mode "Classic".

Lemma Par_preserves_forall_depth :
  forall A1, LTy A1 -> forall P A2, Par P A1 A2 -> LTy A2 /\ tm_forall_depth A1 = tm_forall_depth A2.
Proof.
  induction 1; inversion 1; subst; split; eauto.
  - pick fresh y and apply LTy_PiLogic; repeat (spec y); eauto.
    sfirstorder.
    hauto l:on.
  - pick fresh y; repeat (spec y); eauto.
    simpl.
    f_equal.
    f_equal; eauto.
    hauto l:on.
    rewrite <- (open_tm_wrt_tm_var_forall_depth B1 y).
    rewrite <- (open_tm_wrt_tm_var_forall_depth B2 y).
    hauto l:on.
  - pick fresh y and apply LTy_PiProg; repeat (spec y); eauto.
    hauto l:on use:Par_lc_mutual.
    hauto l:on.
  - pick fresh y; repeat (spec y); eauto.
    simpl.
    f_equal.
    rewrite <- (open_tm_wrt_tm_var_forall_depth B1 y).
    rewrite <- (open_tm_wrt_tm_var_forall_depth B2 y).
    hauto l:on.
  - sauto use:Par_lc_mutual.
Qed.


Lemma MultiPar_preserves_forall_depth :
  forall P A1 A2, MultiPar P A1 A2 -> LTy A1 -> LTy A2 /\ tm_forall_depth A1 = tm_forall_depth A2.
Proof.
  induction 1; sfirstorder use:Par_preserves_forall_depth.
Qed.

Lemma Join_forall_depth_same :
  forall P A1 A2, Joins P A1 A2 -> LTy A1 -> LTy A2 -> tm_forall_depth A1 = tm_forall_depth A2.
  intros.
  destruct H.
  qauto l:on use:MultiPar_preserves_forall_depth.
Qed.

Set Default Proof Mode "Classic".
(* Time to nail down the termination metric  *)
Lemma MultiPar_Proj1 :
  forall P δ0 A1 B1 A2 B2, MultiPar P (a_Pi δ0 A1 B1) (a_Pi δ0 A2 B2) -> MultiPar P A1 A2.
  intros P δ0 A1 B1 A2 B2 h.
  dependent induction h; sauto lq:on.
Qed.

Lemma MultiPar_Pi_inv :
  forall P δ0 A1 B1 C, MultiPar P (a_Pi δ0 A1 B1) C -> exists A2 B2, C = a_Pi δ0 A2 B2.
Proof.
  intros P δ0 A1 B1 C h; dependent induction h; sauto lq:on.
Qed.

Lemma Join_Pi_Proj1' :
  forall P δ0 δ1 A1 B1 A2 B2, Joins P (a_Pi δ0 A1 B1) (a_Pi δ1 A2 B2) -> Joins P A1 A2 /\ δ0 = δ1.
Proof.
  sauto lq:on use:MultiPar_Pi_inv, MultiPar_Proj1.
Qed.

Lemma Join_Pi_Proj1 :
  forall P δ0 A1 B1 A2 B2, Joins P (a_Pi δ0 A1 B1) (a_Pi δ0 A2 B2) -> Joins P A1 A2.
Proof.
  hauto use:Join_Pi_Proj1'.
Qed.

Lemma Joins_sym :
  forall P A B, Joins P A B -> Joins P B A.
Proof.
  sauto lq:on.
Qed.

Lemma MultiPar_Eq_inv :
  forall P θ A1 B1 C,
    MultiPar P (a_Eq θ A1 B1) C ->
    exists A2 B2, C = (a_Eq θ A2 B2).
Proof.
  intros P θ A1 B1 C h.
  dependent induction h; sauto.
Qed.

Lemma MultiPar_Eq_proj :
  forall P θ1 A1 B1 θ2 A2 B2,
    MultiPar P (a_Eq θ1 A1 B1) (a_Eq θ2 A2 B2) ->
    MultiPar P A1 A2 /\
      MultiPar P B1 B2 /\
      θ1 = θ2.
Proof.
  intros P θ1 A1 B1 θ2 A2 B2 h0.
  dependent induction h0; sauto lq:on.
Qed.

Lemma Join_Eq_Proj :
  forall P θ1 A1 B1 θ2 A2 B2,
    Joins P (a_Eq θ1 A1 B1) (a_Eq θ2 A2 B2) ->
    Joins P A1 A2 /\
    Joins P B1 B2 /\
    θ1 = θ2.
Proof.
  fcrush use:MultiPar_Eq_inv, MultiPar_Eq_proj.
Qed.

Lemma MultiPar_conv_intro :
  forall P a1 a2 g1 g2,
    MultiPar P a1 a2 ->
    lc_co g1 ->
    lc_co g2 ->
    MultiPar P (a_Conv a1 g1) (a_Conv a2 g2).
Proof.
  induction 1; sauto lq:on.
Qed.

Lemma Join_conv_intro :
  forall P a1 a2 g1 g2,
    Joins P a1 a2 ->
    lc_co g1 ->
    lc_co g2 ->
    Joins P (a_Conv a1 g1) (a_Conv a2 g2).
Proof.
  sauto lq:on use:MultiPar_conv_intro.
Qed.

Lemma Join_trans :
  forall P a1 a2 a3,
    Joins P a1 a2 ->
    Joins P a2 a3 ->
    Joins P a1 a3.
Proof.
  intros P a1 a2 a3 H1 H2.
  inversion H1; inversion H2; subst.
  assert (h : exists c, MultiPar P b c /\ MultiPar P b0 c) by sfirstorder use:MultiPar_confluence.
  destruct h as [c [h1 h2]].
  enough (h : MultiPar P a1 c /\ MultiPar P a3 c) by sfirstorder.
  sfirstorder use:MultiPar_trans.
Qed.

Lemma MultiPar_eq_intro1:
  forall P θ a1 a2,
    MultiPar P a1 a2 ->
    forall b,
      Par P b b ->
    MultiPar P (a_Eq θ a1 b) (a_Eq θ a2 b).
Proof.
  induction 1; auto.
  sauto lq:on.
Qed.

Lemma MultiPar_eq_intro2:
  forall P θ a1 a2,
    MultiPar P a1 a2 ->
    forall b,
      Par P b b ->
    MultiPar P (a_Eq θ b a1) (a_Eq θ b a2).
Proof.
  induction 1;
  sauto lq:on.
Qed.

Lemma MultiPar_grade :
  forall P a1 a2,
    MultiPar P a1 a2 ->
    Par P a1 a1 /\
      Par P a2 a2.
Proof.
  induction 1;
    hauto l:on use:Par_grade_mutual.
Qed.

Lemma MultiPar_eq_intro:
  forall P θ a1 a2 b1 b2,
    MultiPar P a1 a2 ->
    MultiPar P b1 b2 ->
    MultiPar P (a_Eq θ a1 b1) (a_Eq θ a2 b2).
Proof.
  intros P θ a1 a2 b1 b2 h0 h1.
  (* probably handy to have multipar grade *)
  apply MultiPar_trans with (B := a_Eq θ a1 b2);
  sauto lq:on use:MultiPar_grade, MultiPar_eq_intro1, MultiPar_eq_intro2.
Qed.

Lemma Join_eq_intro :
  forall P θ a1 a2 b1 b2,
    Joins P a1 a2 ->
    Joins P b1 b2 ->
    Joins P (a_Eq θ a1 b1) (a_Eq θ a2 b2).
Proof.
  sauto lq:on rew:off use:MultiPar_eq_intro.
Qed.

Lemma MultiPar_reify_intro :
  forall P θ g1 g2,
    uniq P ->
      lc_co g1 -> lc_co g2 ->
      MultiPar P (a_Reify θ g1) (a_Reify θ g2).
Proof.
  sfirstorder ctrs:MultiPar,Par.
Qed.

Lemma Join_reify_intro :
  forall P θ g1 g2,
    uniq P ->
      lc_co g1 -> lc_co g2 ->
      Joins P (a_Reify θ g1) (a_Reify θ g2).
Proof.
  hauto l:on use:MultiPar_reify_intro.
Qed.


Lemma MultiPar_AppCong : forall P ρ b b',
    CMultiPar P ρ b b' ->
    forall a a',
      MultiPar P a a' ->
      forall θ,
      MultiPar P (a_App a (ρ, θ) b) (a_App a' (ρ, θ) b').
Proof.
  destruct ρ; simpl; auto.
  - induction 1.
    + sfirstorder use: MultiPar_AppCong1, CP_Leq.
    + intros.
      apply MP_Step with (b := a_App a0 (q_R, θ) b); auto.
      qauto depth:1 use: P_AppCong, Par_grade_mutual, CP_Leq inv: MultiPar.
  - sfirstorder use: MultiPar_AppCong1, CP_Nleq.
Qed.

Lemma Join_app_intro : forall P ρ θ a a' b b',
    Joins P a a' ->
    CJoins P ρ b b' ->
    Joins P (a_App a (ρ, θ) b) (a_App a' (ρ, θ) b').
Proof.
  sauto lq:on rew:off use:CJoins_CMultiPar, MultiPar_AppCong.
Qed.

Lemma MultiPar_γ_intro : forall P a a',
    MultiPar P a a' ->
    forall γ,
      lc_co γ ->
      MultiPar P (a_Conv a γ) a'.
Proof.
  induction 1; sauto lq:on.
Qed.

Lemma Join_γ_intro : forall P a a',
    Joins P a a' ->
    forall γ,
      lc_co γ ->
      Joins P (a_Conv a γ) a'.
Proof.
  induction 1; sauto use:MultiPar_γ_intro lq:on.
Qed.

Lemma Join_app_intro_γ : forall P ρ θ a a' b b' γ,
    lc_co γ ->
    Joins P a a' ->
    CJoins P ρ b b' ->
    Joins P (a_Conv (a_App a (ρ, θ) b) γ) (a_App a' (ρ, θ) b').
Proof.
  sfirstorder use:Join_γ_intro, Join_app_intro.
Qed.

Lemma MultiPar_Pi_Proj2 :
  forall P ρ0 θ0 A1 B1 A2 B2,
    MultiPar P (a_Pi (ρ0, θ0) A1 B1) (a_Pi (ρ0, θ0) A2 B2) ->
    exists L,
    forall x,
      x `notin` L ->
      MultiPar (x ~ q_R ++ P) (open_tm_wrt_tm B1 (a_Var_f x)) (open_tm_wrt_tm B2 (a_Var_f x)).
Proof.
  intros P ρ0 θ0 A1 B1 A2 B2 h0.
  dependent induction h0.
  - sauto.
  - inversion H; subst.
    specialize (IHh0 ρ0 θ0 _ _ _ _ ltac:(reflexivity) ltac:(reflexivity)).
    destruct IHh0 as [L0 ?].
    exists (L \u L0).
    intros x h_x; repeat (spec x).
    sfirstorder.
Qed.

Lemma Join_Pi_Proj2 :
  forall P ρ0 θ0 A1 B1 A2 B2,
    Joins P (a_Pi (ρ0, θ0) A1 B1) (a_Pi (ρ0, θ0) A2 B2) ->
    exists L,
    forall x,
      x `notin` L ->
      Joins (x ~ q_R ++ P) (open_tm_wrt_tm B1 (a_Var_f x)) (open_tm_wrt_tm B2 (a_Var_f x)).
Proof.
  intros P ρ0 θ0 A1 B1 A2 B2 h0.
  inversion h0; subst.
  pose proof H0 as H0_dup.
  apply MultiPar_Pi_inv in H0_dup.
  destruct H0_dup as [A3 [B3 h1]]; subst.
  apply MultiPar_Pi_Proj2 in H0.
  apply MultiPar_Pi_Proj2 in H.
  destruct H0 as [L ?].
  destruct H as [L0 ?].
  exists (L \u L0).
  intros.
  repeat (spec x).
  hauto l:on use:Join_trans.
Qed.

(* Sufficient to specialize to the left-most var in the context *)
Lemma Par_γ_left :
  forall x ρ0 P B1 γ B2,
    lc_co γ ->
    x `notin` fv_tm B1 ->
    x `notin` fv_tm B2 ->
    Par (x ~ ρ0 ++ P) (open_tm_wrt_tm B1 (a_Var_f x)) (open_tm_wrt_tm B2 (a_Var_f x)) ->
    Par (x ~ ρ0 ++ P) (open_tm_wrt_tm B1 (a_Conv (a_Var_f x) γ)) (open_tm_wrt_tm B2 (a_Var_f x)).
Proof with auto.
  intros x ρ0 P B1 γ B2 h_γ h_1 h_2 h0.
  pick fresh y.
  assert (tr_1 : y `notin` fv_tm (open_tm_wrt_tm B1 (a_Var_f x)))
    by (rewrite fv_tm_open_tm_wrt_tm_upper; auto).
  assert (tr_2 : y `notin` fv_tm (open_tm_wrt_tm B2 (a_Var_f x)))
    by (rewrite fv_tm_open_tm_wrt_tm_upper; auto).
  assert (tr_3 : uniq (x ~ ρ0 ++ P)) by sfirstorder use:Par_uniq_mutual.
  assert (tr_4 : uniq P) by hauto l:on use:uniq_app_iff.
  assert (h3 : uniq (y ~ ρ0 ++ P)) by sfirstorder.
  assert (h2 : CPar (x ~ ρ0 ++ P) ρ0 (a_Conv (a_Var_f x) γ) (a_Var_f x))
    by (destruct ρ0; sfirstorder).

  assert (h1 : Par (y ~ ρ0 ++ P) (open_tm_wrt_tm B1 (a_Var_f y))
                 (open_tm_wrt_tm B2 (a_Var_f y))).
  {
    rewrite (subst_tm_intro x B1)...
    rewrite (subst_tm_intro x B2)...
    apply Par_renaming; auto.
  }

  apply Par_weak with (P2 := x ~ ρ0) in h1.
  rewrite (subst_tm_intro y B1)...
  rewrite (subst_tm_intro y B2)...
  apply Par_cong_nil with (ρ := ρ0)...
  sfirstorder.
Qed.

Lemma MultiPar_γ_left :
  forall x ρ0 P B1 γ B2,
    lc_co γ ->
    x `notin` fv_tm B1 ->
    MultiPar (x ~ ρ0 ++ P) (open_tm_wrt_tm B1 (a_Var_f x)) (open_tm_wrt_tm B2 (a_Var_f x)) ->
    MultiPar (x ~ ρ0 ++ P) (open_tm_wrt_tm B1 (a_Conv (a_Var_f x) γ)) (open_tm_wrt_tm B2 (a_Var_f x)).
Proof with auto.
  intros x ρ0 P B1 γ B2 h0 h1 h2.
  assert (Par (x ~ ρ0 ++ P) (open_tm_wrt_tm B1 (a_Var_f x)) (open_tm_wrt_tm B1 (a_Var_f x))) by hauto l:on use:MultiPar_grade.
  assert (Par (x ~ ρ0 ++ P) (open_tm_wrt_tm B1 (a_Conv (a_Var_f x) γ))
            (open_tm_wrt_tm B1 (a_Var_f x))) by hauto l:on use:Par_γ_left.
  sfirstorder.
Qed.

Lemma MultiPar_γ_Pi_Proj2 :
  forall P ρ0 θ0 A1 B1 A2 B2 g,
    lc_co g ->
    MultiPar P (a_Pi (ρ0, θ0) A1 B1) (a_Pi (ρ0, θ0) A2 B2) ->
    exists L,
    forall x,
      x `notin` L ->
      MultiPar (x ~ q_R ++ P) (open_tm_wrt_tm B1 (a_Conv (a_Var_f x) g)) (open_tm_wrt_tm B2 (a_Var_f x)).
Proof.
  intros P ρ0 θ0 A1 B1 A2 B2 g h0 h1.
  apply MultiPar_Pi_Proj2 in h1; auto.
  destruct h1 as [L h1].
  pick fresh y.
  exists (union L
                 (union (fv_tm A1)
                    (union (fv_tm B1)
                       (union (fv_tm A2)
                          (union (fv_tm B2) (union (fv_co g) (dom P))))))).
  intros x h_x.
  repeat (spec x).
  apply MultiPar_trans with (B := (open_tm_wrt_tm B1 (a_Var_f x))); auto.
  apply MultiPar_γ_left; auto.
  hauto l:on use:MultiPar_grade.
Qed.

Lemma Join_γ_Pi_Proj2 :
  forall P ρ0 θ0 A1 B1 A2 B2 g,
    lc_co g ->
    Joins P (a_Pi (ρ0, θ0) A1 B1) (a_Pi (ρ0, θ0) A2 B2) ->
    exists L,
    forall x,
      x `notin` L ->
      Joins (x ~ q_R ++ P) (open_tm_wrt_tm B1 (a_Conv (a_Var_f x) g)) (open_tm_wrt_tm B2 (a_Var_f x)).
Proof.
  intros P ρ0 θ0 A1 B1 A2 B2 g h_lc h0.
  inversion h0; subst.
  pose proof H as H_dup.
  apply MultiPar_Pi_inv in H_dup.
  destruct H_dup as [A3 [B3 ?]]; subst.
  apply MultiPar_γ_Pi_Proj2 with (g := g) in H; auto.
  apply MultiPar_Pi_Proj2 in H0.
  destruct H as [L ?].
  destruct H0 as [L0 ?].
  exists (L \u L0).
  intros x h_x.
  repeat (spec x).
  sfirstorder.
Qed.

Lemma Joins_cong :
  forall P1 x ρ P3 A1 A2,
    Joins (P1 ++ x ~ ρ ++ P3) A1 A2 ->
    forall B1 B2,
      CJoins P3 ρ B1 B2 ->
      Joins (P1 ++ P3) (subst_tm B1 x A1) (subst_tm B2 x A2).
Proof.
  intros P1 x ρ P3 A1 A2 h0 B1 B2 h1.
  apply CJoins_CMultiPar in h1.
  sauto  lq:on use:MultiPar_cong.
Qed.

Lemma Joins_cong_nil :
  forall x ρ P3 A1 A2,
    Joins (x ~ ρ ++ P3) A1 A2 ->
    forall B1 B2,
      CJoins P3 ρ B1 B2 ->
      Joins P3 (subst_tm B1 x A1) (subst_tm B2 x A2).
Proof.
  pose proof (Joins_cong nil).
  sfirstorder.
Qed.

Lemma Join_γ_open_Proj:
  forall a b x ρ P B1 g B2,
    x `notin` fv_tm B1 \u fv_tm B2 \u fv_co g \u dom P ->
    CJoins P ρ a b ->
    Joins (x ~ ρ ++ P) (open_tm_wrt_tm B1 (a_Conv (a_Var_f x) g)) (open_tm_wrt_tm B2 (a_Var_f x)) ->
    Joins P (open_tm_wrt_tm B1 (a_Conv a g)) (open_tm_wrt_tm B2 b).
Proof.
  intros a b x ρ P B1 g B2 h0 h1 h2.
  assert (tr0 : lc_tm a /\ lc_tm b) by hauto l:on use:CJoins_CMultiPar, CMultiPar_lc; split_hyp.
  assert (h_j : Joins P (subst_tm a x (open_tm_wrt_tm B1 (a_Conv (a_Var_f x) g))) (subst_tm b x (open_tm_wrt_tm B2 (a_Var_f x)))) by hauto l:on use:Joins_cong_nil.
  rewrite subst_tm_open_tm_wrt_tm in h_j; auto.
  simpl in h_j.
  rewrite eq_dec_refl in h_j.
  rewrite subst_tm_fresh_eq in h_j; auto.
  rewrite subst_co_fresh_eq in h_j; auto.
  rewrite subst_tm_open_tm_wrt_tm in h_j; auto.
  simpl in h_j.
  rewrite eq_dec_refl in h_j.
  rewrite subst_tm_fresh_eq in h_j; auto.
Qed.

Lemma Join_γ_Pi_Proj2' :
  forall P ρ0 θ0 A1 B1 A2 B2 a g,
    Par P a a ->
    lc_co g ->
    Joins P (a_Pi (ρ0, θ0) A1 B1) (a_Pi (ρ0, θ0) A2 B2) ->
    Joins P (open_tm_wrt_tm B1 (a_Conv a g)) (open_tm_wrt_tm B2 a).
Proof.
  intros P ρ0 θ0 A1 B1 A2 B2 a g h0 h1 h2.
  apply Join_γ_Pi_Proj2 with (g := g) in h2; auto.
  destruct h2 as [L h2].
  pick fresh x.
  spec x.
  assert (CJoins P q_R a a) by hauto l:on.
  eapply Join_γ_open_Proj; eauto.
Qed.

Lemma MultiPar_PiCong_intro1 :
  forall P A1 A2,
    MultiPar P A1 A2 ->
    forall B δ0 x,
      x `notin` fv_tm B ->
      Par (x ~ q_R ++ P) (open_tm_wrt_tm B (a_Var_f x)) (open_tm_wrt_tm B (a_Var_f x)) ->
    MultiPar P (a_Pi δ0 A1 B) (a_Pi δ0 A2 B).
Proof.
  induction 1; intros.
  - apply MP_One.
    apply Par_PiCong_exists with (x := x); auto.
  - apply MultiPar_trans with (B := a_Pi δ0 b B); auto.
    apply MP_One.
    apply Par_PiCong_exists with (x := x); auto.
    hauto l:on.
Qed.

Lemma MultiPar_AbsCong_intro1:
  forall P A1 A2,
    lc_tm A1 ->
    lc_tm A2 ->
    forall B ρ0 θ0 x,
      x `notin` fv_tm B ->
      Par (x ~ ρ0 ++ P) (open_tm_wrt_tm B (a_Var_f x)) (open_tm_wrt_tm B (a_Var_f x)) ->
      MultiPar P (a_Abs (ρ0, θ0) A1 B) (a_Abs (ρ0, θ0) A2 B).
Proof.
  intros.
  apply MP_One.
  apply Par_AbsCong_exists with (x := x); eauto.
Qed.

Lemma MultiPar_AbsCong_intro2 :
  forall P A,
    lc_tm A ->
    forall B1 B2 ρ0 θ0 x,
      x `notin` fv_tm B1 \u fv_tm B2 ->
    MultiPar (x ~ ρ0 ++ P) (open_tm_wrt_tm B1 (a_Var_f x)) (open_tm_wrt_tm B2 (a_Var_f x)) ->
    MultiPar P (a_Abs (ρ0,θ0) A B1) (a_Abs (ρ0,θ0) A B2).
Proof.
  intros P A h0 B1 B2 ρ0 θ0 x h_f h.
  dependent induction h.
  - apply MP_One.
    apply Par_AbsCong_exists with (x := x); auto.
  - specialize (IHh x ρ0 B2 (close_tm_wrt_tm x b)).
    rewrite fv_tm_close_tm_wrt_tm in IHh.
    specialize (IHh ltac:(auto) ltac:(auto) P ltac:(auto) ltac:(scongruence use:open_tm_wrt_tm_close_tm_wrt_tm)
               ltac:(reflexivity)).
    assert (h_lc : lc_tm b) by hauto l:on use:Par_lc_mutual.
    apply MultiPar_trans with (B := a_Abs (ρ0,θ0) A (close_tm_wrt_tm x b)); auto.
    apply MP_One.
    pick fresh y.
    apply Par_AbsCong_exists with (x := y); auto.
    rewrite fv_tm_close_tm_wrt_tm; auto.
    apply (Par_renaming x) with (x0 := y) in H; auto.
    rewrite -> subst_tm_open_tm_wrt_tm in H; auto.
    rewrite <- subst_tm_spec.
    rewrite subst_tm_fresh_eq in H; auto.
    simpl in H.
    rewrite eq_dec_refl in H; auto.
    rewrite fv_tm_open_tm_wrt_tm_upper; auto.
Qed.

Lemma MultiPar_PiCong_intro2 :
  forall P A,
    Par P A A ->
    forall B1 B2 δ0 x,
      x `notin` fv_tm B1 \u fv_tm B2 ->
    MultiPar (x ~ q_R ++ P) (open_tm_wrt_tm B1 (a_Var_f x)) (open_tm_wrt_tm B2 (a_Var_f x)) ->
    MultiPar P (a_Pi δ0 A B1) (a_Pi δ0 A B2).
Proof.
  intros P A h0 B1 B2 δ0 x h_f h.
  dependent induction h.
  - apply MP_One.
    apply Par_PiCong_exists with (x := x); auto.
  - specialize (IHh x B2 (close_tm_wrt_tm x b)).
    rewrite fv_tm_close_tm_wrt_tm in IHh.
    specialize (IHh ltac:(auto) P ltac:(auto) ltac:(reflexivity) ltac:(scongruence use:open_tm_wrt_tm_close_tm_wrt_tm)
               ltac:(reflexivity)).

    assert (h_lc : lc_tm b) by hauto l:on use:Par_lc_mutual.
    apply MultiPar_trans with (B := a_Pi δ0 A (close_tm_wrt_tm x b)); auto.
    apply MP_One.
    pick fresh y.
    apply Par_PiCong_exists with (x := y); auto.
    rewrite fv_tm_close_tm_wrt_tm; auto.
    apply (Par_renaming x) with (x0 := y) in H; auto.
    rewrite -> subst_tm_open_tm_wrt_tm in H; auto.
    rewrite <- subst_tm_spec.
    rewrite subst_tm_fresh_eq in H; auto.
    simpl in H.
    rewrite eq_dec_refl in H; auto.
    rewrite fv_tm_open_tm_wrt_tm_upper; auto.
Qed.

Lemma MultiPar_PiCong_intro :
  forall P A1 A2,
    MultiPar P A1 A2 ->
    forall B1 B2 δ0 x,
      x `notin` fv_tm B1 \u fv_tm B2 ->
      MultiPar (x ~ q_R ++ P) (open_tm_wrt_tm B1 (a_Var_f x)) (open_tm_wrt_tm B2 (a_Var_f x)) ->
      MultiPar P (a_Pi δ0 A1 B1) (a_Pi δ0 A2 B2).
  intros P A1 A2 h0 B1 B2 δ0 x h_fv h1.
  apply MultiPar_trans with (B := (a_Pi δ0 A2 B1)).
  - qauto l:on use:MultiPar_PiCong_intro1, MultiPar_grade.
  - eapply MultiPar_PiCong_intro2; eauto.
    hauto l:on use:MultiPar_grade.
Qed.

Lemma MultiPar_AbsCong_intro :
  forall P A1 A2,
    lc_tm A1 ->
    lc_tm A2 ->
    forall B1 B2 ρ0 θ0 x,
      x `notin` fv_tm B1 \u fv_tm B2 ->
      MultiPar (x ~ ρ0 ++ P) (open_tm_wrt_tm B1 (a_Var_f x)) (open_tm_wrt_tm B2 (a_Var_f x)) ->
      MultiPar P (a_Abs (ρ0,θ0) A1 B1) (a_Abs (ρ0,θ0) A2 B2).
  intros P A1 A2 h0 h00 B1 B2 ρ0 θ0 x h_fv h1.
  apply MultiPar_trans with (B := (a_Abs (ρ0,θ0) A2 B1)).
  - eapply MultiPar_AbsCong_intro1; eauto.
    hauto l:on use:MultiPar_AbsCong_intro1, MultiPar_grade.
  - eapply MultiPar_AbsCong_intro2; eauto.
Qed.

Ltac solve_fv :=
  lazymatch goal with
    [ |- _ `notin` _] =>
      auto
  end.

Lemma Joins_PiCong_intro :
  forall P A1 A2,
    Joins P A1 A2 ->
    forall B1 B2 δ0 x,
      x `notin` fv_tm B1 \u fv_tm B2 ->
      Joins (x ~ q_R ++ P) (open_tm_wrt_tm B1 (a_Var_f x)) (open_tm_wrt_tm B2 (a_Var_f x)) ->
      Joins P (a_Pi δ0 A1 B1) (a_Pi δ0 A2 B2).
Proof.
  intros.
  inversion H; subst.
  inversion H1; subst; auto.
  assert (h3 : lc_tm b0 ) by hauto l:on use:MultiPar_lc.
  assert (h_b0 : b0 = open_tm_wrt_tm (close_tm_wrt_tm x b0) (a_Var_f x)) by scongruence use:open_tm_wrt_tm_close_tm_wrt_tm.
  rewrite h_b0 in H4, H5.
  apply join with (b :=  a_Pi δ0 b (close_tm_wrt_tm x b0)).
  eapply MultiPar_PiCong_intro; eauto.
  rewrite fv_tm_close_tm_wrt_tm; auto.
  eapply MultiPar_PiCong_intro; eauto.
  rewrite fv_tm_close_tm_wrt_tm; auto.
Qed.

Lemma Joins_lc :
  forall P A1 A2,
    Joins P A1 A2 ->
    lc_tm A1 /\ lc_tm A2.
Proof. hauto l:on use:MultiPar_lc inv :Joins. Qed.

Lemma Joins_AbsCong_intro :
  forall P A1 A2,
    lc_tm A1 ->
    lc_tm A2 ->
    forall B1 B2 ρ0 θ0 x,
      x `notin` fv_tm B1 \u fv_tm B2 ->
      Joins (x ~ ρ0 ++ P) (open_tm_wrt_tm B1 (a_Var_f x)) (open_tm_wrt_tm B2 (a_Var_f x)) ->
      Joins P (a_Abs (ρ0,θ0) A1 B1) (a_Abs (ρ0,θ0) A2 B2).
Proof.
  intros P A1 A2 h0 h1. intros.
  inversion H0; subst; auto.
  assert (tr : lc_tm A1) by hauto l:on use:Joins_lc.
  assert (tr0 : lc_tm A2) by hauto l:on use:Joins_lc.
  assert (h4 : lc_tm b ) by hauto l:on use:MultiPar_lc.
  assert (h_b0 : b = open_tm_wrt_tm (close_tm_wrt_tm x b) (a_Var_f x)) by scongruence use:open_tm_wrt_tm_close_tm_wrt_tm.
  rewrite h_b0 in H1, H2.
  apply join with (b :=  a_Abs (ρ0, θ0) b (close_tm_wrt_tm x b)).
  eapply MultiPar_AbsCong_intro; eauto.
  rewrite fv_tm_close_tm_wrt_tm; auto.
  eapply MultiPar_AbsCong_intro; eauto.
  rewrite fv_tm_close_tm_wrt_tm; auto.
Qed.

Lemma MultiPar_SuccCong : forall P a a',
      MultiPar P a a' ->
      MultiPar P (a_Succ a) (a_Succ a').
Proof.
  induction 1; sauto depth:2 lq:on.
Qed.

Lemma Join_succ_intro : forall P a a',
    Joins P a a' ->
    Joins P (a_Succ a) (a_Succ a').
Proof.
  sauto lq:on use:MultiPar_SuccCong.
Qed.


Lemma MultiPar_ind_intro1:
  forall P a1 a2,
    MultiPar P a1 a2 ->
    forall A1 A2 cz x cs,
      x `notin` fv_tm cs ->
      lc_tm A1 ->
      lc_tm A2 ->
      Par P cz cz ->
      Par (x ~ q_R ++ P) (open_tm_wrt_tm cs (a_Var_f x)) (open_tm_wrt_tm cs (a_Var_f x)) ->
      MultiPar P (a_Ind a1 cz cs A1) (a_Ind a2 cz cs A2).
Proof.
  induction 1; eauto 2.
  - intros A1 A2 cz x cs h_fv lc_A1 lc_A2 P_cz P_cs.
    apply MP_One.
    apply (Par_IndCong_exists x); eauto.
    sfirstorder use:Par_uniq_mutual.
  - intros A1 A2 cz x cs h_fv lc_A1 lc_A2 P_cz P_cs.
    apply MP_Step with (b := (a_Ind b cz cs A1)).
    + apply  (Par_IndCong_exists x); eauto.
      sfirstorder use:Par_uniq_mutual.
    + eapply_first_hyp; eauto.
Qed.

Lemma MultiPar_ind_intro2:
  forall P cz1 cz2,
    MultiPar P cz1 cz2 ->
    forall A1 A2 a x cs,
      x `notin` fv_tm cs ->
      lc_tm A1 ->
      lc_tm A2 ->
      Par P a a ->
      Par (x ~ q_R ++ P) (open_tm_wrt_tm cs (a_Var_f x)) (open_tm_wrt_tm cs (a_Var_f x)) ->
      MultiPar P (a_Ind a cz1 cs A1) (a_Ind a cz2 cs A2).
Proof.
  induction 1; eauto 2.
  - intros A1 A2 a0 x cs h_fv lc_A1 lc_A2 P_a P_cs.
    apply MP_One.
    apply (Par_IndCong_exists x); eauto.
    sfirstorder use:Par_uniq_mutual.
  - intros A1 A2 a0 x cs h_fv lc_A1 lc_A2 P_a P_cs.
    apply MP_Step with (b := (a_Ind a0 b cs A1)).
    + apply  (Par_IndCong_exists x); eauto.
      sfirstorder use:Par_uniq_mutual.
    + eapply_first_hyp; eauto.
Qed.

Lemma MultiPar_ind_intro3:
  forall P x cs1 cs2,
    x `notin` fv_tm cs1 \u fv_tm cs2 ->
    MultiPar (x ~ q_R ++ P) (open_tm_wrt_tm cs1 (a_Var_f x)) (open_tm_wrt_tm cs2 (a_Var_f x)) ->
    forall A1 A2 a cz,
      Par P cz cz ->
      lc_tm A1 ->
      lc_tm A2 ->
      Par P a a ->
      MultiPar P (a_Ind a cz cs1 A1) (a_Ind a cz cs2 A2).
Proof.
  intros P x cs1 cs2 h_fv h_mp.
  dependent induction h_mp.
  - intros A1 A2 a cz h_cz lc_A1 lc_A2 P_a.
    apply MP_One.
    apply (Par_IndCong_exists x); eauto.
    sfirstorder use:Par_uniq_mutual.
  - intros A1 A2 a cz h_cz lc_A1 lc_A2 P_a.
    assert (tr0 : uniq P) by sfirstorder use:Par_uniq_mutual.
    apply MP_Step with (b := a_Ind a cz (close_tm_wrt_tm x b) A1).
    apply (Par_IndCong_exists x); eauto.
    rewrite fv_tm_close_tm_wrt_tm; eauto.
    rewrite open_tm_wrt_tm_close_tm_wrt_tm; auto.
    eapply_first_hyp; auto.
    rewrite fv_tm_close_tm_wrt_tm; eauto.
    sfirstorder use: open_tm_wrt_tm_close_tm_wrt_tm.
Qed.

Lemma MultiPar_ind_intro:
  forall P x A1 A2 a1 a2 cz1 cz2 cs1 cs2,
    lc_tm A1 ->
    lc_tm A2 ->
    x `notin` fv_tm cs1 \u fv_tm cs2 ->
    MultiPar P a1 a2 ->
    MultiPar P cz1 cz2 ->
    MultiPar (x ~ q_R ++ P) (open_tm_wrt_tm cs1 (a_Var_f x)) (open_tm_wrt_tm cs2 (a_Var_f x)) ->
    MultiPar P (a_Ind a1 cz1 cs1 A1) (a_Ind a2 cz2 cs2 A2).
Proof.
  intros P x A1 A2 a1 a2 cz1 cz2 cs1 cs2; intros.
  apply MultiPar_trans with (B := (a_Ind a2 cz1 cs1 A1)).
  qauto l:on use:MultiPar_ind_intro1, MultiPar_grade.
  apply MultiPar_trans with (B := (a_Ind a2 cz2 cs1 A1)).
  qauto l:on use:MultiPar_ind_intro2, MultiPar_grade.
  qauto l:on use:MultiPar_ind_intro3, MultiPar_grade.
Qed.

Lemma Join_ind_intro:
  forall P x A1 A2 a1 a2 cz1 cz2 cs1 cs2,
    lc_tm A1 ->
    lc_tm A2 ->
    x `notin` fv_tm cs1 \u fv_tm cs2 ->
    Joins P a1 a2 ->
    Joins P cz1 cz2 ->
    Joins (x ~ q_R ++ P) (open_tm_wrt_tm cs1 (a_Var_f x)) (open_tm_wrt_tm cs2 (a_Var_f x)) ->
    Joins P (a_Ind a1 cz1 cs1 A1) (a_Ind a2 cz2 cs2 A2).
Proof.
  intros.
  inversion H2; subst.
  inversion H3; subst.
  inversion H4; subst.
  apply join with (b := (a_Ind b b0 (close_tm_wrt_tm x b1)) A2).
  replace b1 with (open_tm_wrt_tm (close_tm_wrt_tm x b1) (a_Var_f x)) in H9, H10.
  apply MultiPar_ind_intro with (x := x); auto.
  rewrite fv_tm_close_tm_wrt_tm; fsetdec.
  rewrite open_tm_wrt_tm_close_tm_wrt_tm; auto.
  apply MultiPar_ind_intro with (x := x); auto.
  rewrite fv_tm_close_tm_wrt_tm; fsetdec.
  rewrite open_tm_wrt_tm_close_tm_wrt_tm; auto.
Qed.

Lemma MultiPar_join :
  forall P a1 a2,
    MultiPar P a1 a2 ->
    Joins P a1 a2.
Proof.
  hauto l:on use:MultiPar_grade.
Qed.

Lemma Join_grade :
    forall P a1 a2,
      Joins P a1 a2 ->
      Par P a1 a1 /\
        Par P a2 a2.
Proof.
  hauto l:on inv:Joins use:MultiPar_grade.
Qed.

End par.
