From LP Require Import lp_ott lp_inf lp_wff lp_tactics lp_labels sigs.

From Hammer Require Import Tactics.
From Ltac2 Require Import Ltac2 Constr Control.

Module preservation
  (Import lc : lc_sig)
  (Import wff : wff_sig)
  (Import unique : unique_sig)
  (Import subst : subst_sig)
  (Import subsumption : subsumption_sig)
  (Import narrow : typing_narrowing_sig)
  (Import weak : weak_sig) <: preservation_sig.

Lemma ctx_rename :
  forall x δ0 A0 G,
    Ctx (x ~ (δ0, A0) ++ G) ->
    forall y, y `notin` dom G ->
         Ctx (y ~ (δ0, A0) ++ G).
Proof.
  ltac1:(sauto lq:on inv:Ctx).
Qed.

Lemma typing_rename :
  forall {G x δ0 A0 θ a A},
    Typing (x ~ (δ0, A0) ++ G) θ a A ->
    forall y,
      y `notin` add x (dom G) ->
      Typing (y ~ (δ0, A0) ++ G) θ (subst_tm (a_Var_f y) x a) (subst_tm (a_Var_f y) x A).
Proof.
  intros G x δ0 A0 θ a A H0 y H1.
  assert (h1 : Ctx (x ~ (δ0, A0) ++ G)) by ltac1:(sfirstorder use:typing_wff).
  assert (h5 : Ctx (y ~ (δ0, A0) ++ G)) by eauto using ctx_rename.
  apply typing_weakening_middle with (E := y ~ (δ0, A0)) in H0.
  - assert (h0 : CTyping (y ~ (δ0, A0) ++ G) δ0 (a_Var_f y) A0).
    destruct δ0 as [ρ0 θ0].
    destruct ρ0.
    + constructor; eauto.
      apply T_Var with (theta0 := θ0); eauto.
      reflexivity.
    + constructor; eauto.
      simpl_env.
      rewrite rel_meet_R2.
      apply T_Var with (theta0 := θ0); eauto.
      reflexivity.
      enough (h3 : Ctx (meet_ctx_l_rho q_R (y ~ (q_I, θ0, A0) ++ G))).
      simpl_env in h3.
      rewrite rel_meet_R2 in h3; eauto.
      eauto with narrow.
    + ltac1:(firstorder using typing_substc_nil).
  - destruct δ0 as [ρ0 θ0].
    constructor; auto.
    simpl_env.
    apply typing_weakening.
    + ltac1:(sauto lq:on).
    + change (y ~ (q_R ⊓ ρ0, θ0, A0) ++ meet_ctx_l_rho q_R G) with
        (meet_ctx_l_rho q_R (y ~ (ρ0, θ0, A0) ++ G)).
      eauto with narrow.
    + simpl.
      inversion h1; fsetdec.
Qed.

Lemma T_Ind_exists :
  forall G theta a1 a2 a3 A y,
     Typing  (meet_ctx_l_rho q_R  G  )   t_L  (a_Pi  (   q_R  ,   t_L   )  a_Nat A) a_TYPE ->
     Typing G  t_L  a1 a_Nat ->
     Typing G  t_L  a2  (open_tm_wrt_tm  A   a_Zero )  ->
     y `notin` fv_tm a1 \u fv_tm A \u fv_tm a3 ->
     Typing  (  [ ( y , (  q_R  ,   t_L   ,  a_Nat )) ]   ++  G )   t_L   ( open_tm_wrt_tm a3 (a_Var_f y) )   ( (a_Pi  (   q_R  ,   t_L   )   (  (open_tm_wrt_tm  A   (a_Var_f y) )  )   (  (open_tm_wrt_tm  A   (a_Succ (a_Var_f y)) )  ) ) )  ->
     Typing G theta (a_Ind a1 a2 a3  ( (a_Pi  (   q_R  ,   t_L   )  a_Nat A) ) )  (open_tm_wrt_tm  A   a1 ).
Proof.
  intros Γ θ a1 a2 a3 A y h0 h1 h2 h_fv h3.
  pick fresh z and apply T_Ind; eauto.
  apply typing_rename with (y := z) in h3; auto.
  rewrite subst_tm_open_tm_wrt_tm in h3; auto.
  simpl in h3.
  rewrite eq_dec_refl in h3.
  rewrite subst_tm_fresh_eq in h3; auto.
  rewrite subst_tm_open_tm_wrt_tm in h3; auto.
  simpl in h3.
  rewrite eq_dec_refl in h3.
  rewrite subst_tm_open_tm_wrt_tm in h3; auto.
  rewrite subst_tm_fresh_eq in h3; auto.
  simpl in h3.
  rewrite eq_dec_refl in h3; auto.
Qed.

Lemma ind_succ_wt_implies_ind_wt :
  forall G θ a1 a2 a3 A,
    Typing G θ (a_Ind (a_Succ a1) a2 a3 (a_Pi (q_R, t_L) a_Nat A)) (open_tm_wrt_tm A (a_Succ a1)) ->
    Typing G t_L (a_Ind a1 a2 a3 (a_Pi (q_R, t_L) a_Nat A)) (open_tm_wrt_tm A a1).
Proof.
  inversion 1; subst.
  pick fresh y ; repeat (spec y).
  apply T_Ind_exists with (y := y); eauto.
  inversion H7; subst; auto.
Qed.

Lemma typing_implies_ctyping :
  forall Γ θ a A, Typing Γ θ a A -> forall ρ, CTyping Γ (ρ,θ) a A.
Proof.
  destruct ρ.
  - econstructor; eauto.
  - econstructor; eauto with narrow.
Qed.

Lemma preservation_primitive :
  forall G θ a b, aBeta G θ a b -> exists A, (Typing G θ b A /\ Typing G θ a A).
Proof.
  inversion 1; subst; eauto.
  - exists B; split; eauto.
    inversion H0; subst.
    enough (A = A0 /\ A = B) by ltac1:(hauto l:on).
    eauto using defeq_unique1, defeq_unique2.
  - exists A0; split; eauto.
    inversion H0; subst.
    inversion H7; subst.
    pick fresh x; repeat (spec x).
    rewrite (subst_tm_intro x a0); eauto.
    rewrite (subst_tm_intro x B); eauto.
    eapply typing_substc_nil; eauto.
  - exists A; split; eauto.
    inversion H0; subst.
    inversion H3; subst.
    ltac1:(hfcrush).
  - exists A; split; eauto.
    inversion H0; subst.
    inversion H7; subst.
    assert (h0 : DefEq (meet_ctx_l_rho q_R G) g nil θ (a_Pi delta0 A1 B1)
                   (a_Pi delta0 A2 B2)).
    eapply defeq_subsumption; eauto.
    assert (h1 : (a_Pi delta0 A1 B1) = (a_Pi delta0 A1 B)) by ltac1:(sfirstorder use:defeq_unique1).
    assert (h2 : (a_Pi delta0 A2 B2) = A) by ltac1:(sfirstorder use:defeq_unique2).
    subst.
    inversion h1; subst; clear h1.
    inversion H10; subst.
    ltac1:(rename rho0 into ρ1).
    ltac1:(rename theta1 into θ1).
    pick fresh y and apply T_Abs; eauto.
    repeat (spec y).
    change (open_tm_wrt_tm (a_Conv a2 g2) (a_Var_f y)) with
      (a_Conv (open_tm_wrt_tm a2 (a_Var_f y)) (open_co_wrt_tm g2 (a_Var_f y))).
    rewrite H8.
    rewrite H4.
    assert (h4 : Ctx (y ~ ((ρ1,θ1), A1) ++ G)) by eauto using typing_wff.
    assert (h5 : Typing (meet_ctx_l_rho q_R G) θ1 A2 a_TYPE) by eauto.
    pick fresh z.
    apply typing_rename with (y := z) in H6; auto.
    rewrite -> subst_tm_open_tm_wrt_tm in H6; auto.
    rewrite -> subst_tm_open_tm_wrt_tm in H6; auto.
    simpl in H6.
    rewrite eq_dec_refl in H6.
    rewrite subst_tm_fresh_eq in H6; auto.
    rewrite subst_tm_fresh_eq in H6; auto.
    simpl_env in H6.
    ltac1:(pose proof H6 as H6_dup).
    assert (h6 : Ctx (z ~ ((ρ1,θ1), A1) ++ G)) by eauto using typing_wff.
    assert (h7 : Ctx (y ~ (q_R, θ1, A2) ++ G)) by ltac1:(sauto depth:1 lq: on rew: off ctrs: Ctx inv: Ctx).
    assert (hc1 : Ctx (y ~ (q_R ⊓ q_R, θ1, A2) ++ meet_ctx_l_rho q_R G)).
    change (y ~ (q_R ⊓ q_R, θ1, A2) ++ meet_ctx_l_rho q_R G) with
      (meet_ctx_l_rho q_R (y ~ (q_R, θ1, A2) ++ G)).
    eauto with narrow.
    apply typing_weakening_middle with (E := y ~ ((ρ1,θ1), A2)) in H6_dup.
    assert (h3 : CTyping (y ~ ((ρ1,θ1), A2) ++ G) (ρ1,θ1) (a_Conv (a_Var_f y) (g_Sym (g_PiFst theta0 g))) A1).
    + destruct ρ1.
      * constructor.
        apply T_Conv with (A := A2); eauto.
        apply T_Var with (theta0 := θ1); eauto.
        reflexivity.
        simpl_env.
        apply typing_weakening; auto. inversion H14; subst; auto.
        simpl_env.
        apply defeq_weakening; auto.
        econstructor; eauto.
        econstructor; eauto.
        reflexivity.
      * constructor.
        simpl_env.
        rewrite rel_meet_R2.
        apply T_Conv with (A := A2).
        apply T_Var with (theta0 := θ1); eauto.
        reflexivity.
        simpl_env.
        apply typing_weakening; auto. inversion H14; subst; auto.
        simpl_env.
        apply defeq_weakening; auto.
        econstructor; eauto.
        econstructor; eauto.
        reflexivity.
    + ltac1:( pose proof (hc := typing_substc_nil H6_dup h3)).
      rewrite -> subst_tm_open_tm_wrt_tm in hc; auto.
      rewrite -> subst_tm_open_tm_wrt_tm in hc; auto.
      simpl in hc.
      rewrite eq_dec_refl in hc.
      rewrite -> subst_tm_fresh_eq in hc; auto.
      rewrite -> subst_tm_fresh_eq in hc; auto.
      apply T_Conv with (A := open_tm_wrt_tm B (a_Conv (a_Var_f y) (g_Sym (g_PiFst theta0 g)))); eauto.
      simpl_env.
      rewrite rel_meet_R2.
      econstructor; eauto.
      apply defeq_weakening; eauto.
      (* apply typing_implies_ctyping; eauto. *)
      econstructor; eauto.
      econstructor; eauto.
      reflexivity.
      econstructor; eauto.
      reflexivity.
      econstructor; eauto.
      econstructor; eauto.
      reflexivity.
      ltac1:(hauto lq:on rew:off use:defeq_weakening).
      (* apply typing_implies_ctyping; eauto. *)
      apply T_Conv with (A := A2); eauto.
      econstructor; eauto.
      reflexivity.
      simpl_env.
      apply typing_weakening; eauto with narrow.
      inversion H14; subst; auto.
      simpl_env.
      apply defeq_weakening; eauto; eauto with narrow.
      econstructor; eauto.
      econstructor; eauto.
      reflexivity.
      ltac1:(sauto lq: on rew: off use:defeq_lc1).
      ltac1:(sauto lq: on rew: off use:defeq_lc1).
    + constructor; eauto.
      constructor; eauto.
      inversion h6; auto.
      simpl_env; apply typing_weakening; eauto.
      inversion H14; subst; auto.
  -  assert (tr0: lc_tm (a_Ind (a_Succ a1) a2 a3 (a_Pi (q_R, t_L) a_Nat A))) by ltac1:(hauto l:on use:lc_mutual).
     assert (tr1: lc_tm a1) by ltac1:(hauto l:on inv:lc_tm).
     inversion H0; subst.
     exists (open_tm_wrt_tm A (a_Succ a1)).
     split; auto.
     rewrite <- (open_tm_wrt_tm_lc_tm (open_tm_wrt_tm A (a_Succ a1)) (a_Ind a1 a2 a3 (a_Pi (q_R, t_L) a_Nat A))).
     pick fresh y; repeat (spec y).
     apply T_App with (A := (open_tm_wrt_tm A a1)).
     rewrite (subst_tm_intro y); auto.
     ltac1:(replace (open_tm_wrt_tm A (a_Succ a1)) with
             (subst_tm a1 y (open_tm_wrt_tm A (a_Succ (a_Var_f y))))).
     rewrite (subst_tm_intro y _ a1); auto.
     change (a_Pi (q_R, t_L) (subst_tm a1 y (open_tm_wrt_tm A (a_Var_f y))) (subst_tm a1 y (open_tm_wrt_tm A (a_Succ (a_Var_f y))))) with
       (subst_tm a1 y (a_Pi (q_R, t_L) (open_tm_wrt_tm A (a_Var_f y)) (open_tm_wrt_tm A (a_Succ (a_Var_f y))))).
     eapply typing_substc_nil; eauto.
     ltac1:(sauto depth:2 lq:on use:typing_subsumption).
     constructor.
     inversion H9; subst; auto.
     rewrite subst_tm_open_tm_wrt_tm; auto.
     simpl.
     rewrite eq_dec_refl.
     rewrite subst_tm_fresh_eq; auto.
     constructor; auto.
     inversion tr0; subst.
     eapply ind_succ_wt_implies_ind_wt; eauto.
     ltac1:(hauto l:on use:lc_body_tm_wrt_tm inv:lc_tm).
  - exists (open_tm_wrt_tm A a_Zero); split; auto.
    inversion H0; subst.
    ltac1:(sauto lq:on use:typing_subsumption).
    ltac1:(sauto l:on use:typing_subsumption).
Qed.

Lemma preservation_primitive0 :
  forall G θ a b, aBeta G θ a b -> forall A, Typing G θ a A -> Typing G θ b A.
Proof.
  ltac1:(hauto lq:on use:typing_unique, preservation_primitive).
Qed.

(* Lemma 4.3 (Preservation(Co)) *)
Lemma preservation_cored :
  forall G θ a b,
    aCoRed G θ a b -> forall A,
    Typing G θ a A ->
    (* ------------ *)
    Typing G θ b A.
Proof.
  induction 1; intros.
  - assert (h : aBeta G theta (a_Conv a g) a) by eauto.
    ltac1:(hauto lq:on use: preservation_primitive, typing_unique).
  - assert (h : aBeta G theta (a_Conv (a_Conv a g1) g2) (a_Conv a (g_Trans g1 g2))) by eauto.
    ltac1:(hauto lq:on use: preservation_primitive, typing_unique).
  - assert (h : aBeta G theta (a_Conv (a_Abs delta0 A1 a1) g) (a_Abs delta0 A2 (a_Conv a2 g2))) by eauto.
    ltac1:(hauto lq:on use: preservation_primitive, typing_unique).
  - inversion H1; subst.
    apply T_Conv with (A := A0); eauto.
  - ltac1:(hauto l:on ctrs:Typing inv:Typing).
Qed.

Lemma preservation_cored1 :
  forall G θ a b A, Typing G θ a A -> aCoRed G θ a b -> Typing G θ b A.
Proof.
  ltac1:(sauto lq:on use:preservation_cored, typing_unique_mutual).
Qed.

Lemma preservation_coreds :
  forall G θ a A, Typing G θ a A -> forall b, aCoReds G θ a b -> Typing G θ b A.
Proof.
  intros G θ a A Ht b H.
  ltac1:(generalize dependent Ht).
  induction H; intros; eauto.
    ltac1:(hauto lq:on use:preservation_cored1).
Qed.

Lemma coreds_conv_cong :
  forall G θ a b, aCoReds G θ a b ->
              forall g, lc_co g -> aCoReds G θ (a_Conv a g) (a_Conv b g).
Proof.
  induction 1; eauto.
Qed.

Lemma reds_conv_cong :
  forall G θ a b, aReds G θ a b ->
              forall g, lc_co g -> aReds G θ (a_Conv a g) (a_Conv b g).
Proof.
  induction 1; eauto.
Qed.

Lemma coreds_trans :
  forall b G θ a,
    aCoReds G θ a b ->
    forall c,
    aCoReds G θ b c ->
    aCoReds G θ a c.
Proof.
  induction 1; ltac1:(sfirstorder).
Qed.

Lemma reds_app_cong :
  forall G θ a δ0 b,
    aReds G θ a b ->
    forall c, lc_tm c -> aReds G θ (a_App a δ0 c) (a_App b δ0 c).
Proof.
  induction 1; ltac1:(sauto lq:on).
Qed.

Set Default Proof Mode "Classic".

Lemma ind_has_kind_TYPE :
  forall G theta a0 a2 a3 A B0,
  Typing G theta (a_Ind a0 a2 a3 (a_Pi (q_R, t_L) a_Nat A)) B0 ->
  Typing (meet_ctx_l_rho q_R G) theta B0 a_TYPE.
Proof.
  inversion 1; subst.
  inversion H6; subst.
  pick fresh z; repeat (spec z).
  change a_TYPE with (subst_tm a0 z a_TYPE).
  rewrite (subst_tm_intro z); auto.
  eapply typing_subst_nil; eauto.
  hauto lq:on use:typing_subsumption.
  hauto l:on use:typing_meet_ctx_l.
Qed.

(* Lemma 4.4 (Preservation) *)
Lemma preservation_red :
  forall G θ a b,
    aRed G θ a b -> forall A,
    Typing G θ a A ->
    (* --------------- *)
    Typing G θ b A.
Proof.
  induction 1; auto.
  - intros.
    inversion H2; subst.
    assert (Typing G theta (a_Abs delta0 A a1) (a_Pi delta0 A1 B)) by sfirstorder use:preservation_coreds.
    inversion H3; subst.
    pick fresh y; repeat (spec y).
    rewrite -> (subst_tm_intro y a1); auto.
    rewrite -> (subst_tm_intro y B); auto.
    destruct delta0 as [ρ0 θ0].
    sfirstorder use:typing_substc_nil.
  - hauto l:on inv:Typing.
  - hauto l:on inv:Typing.
  - hauto l:on inv:Typing.
  - intros A0 h0.
    assert (A0 = B0) by hauto l:on use:typing_unique; subst.
    apply T_Conv with (A := B1); auto.
    assert (tr0: aBeta G theta (a_Ind (a_Succ a1) a2 a3 (a_Pi (q_R, t_L) a_Nat A)) (a_App (open_tm_wrt_tm a3 a1) (q_R, t_L) (a_Ind a1 a2 a3 (a_Pi (q_R, t_L) a_Nat A)))) by sfirstorder.
    assert (tr1: Typing G t_L (a_Succ a1) a_Nat) by hauto inv:Typing l:on use:preservation_coreds.
    qauto l:on use:preservation_primitive, typing_unique.
    sfirstorder use:ind_has_kind_TYPE.
  - intros A0 h0.
    assert (A0 = B0) by hauto l:on use:typing_unique; subst.
    apply T_Conv with (A := B1); auto.
    assert (tr0: aBeta G theta (a_Ind a_Zero a2 a3 (a_Pi (q_R, t_L) a_Nat A)) a2) by sfirstorder.
    assert (tr1: Typing G t_L a_Zero a_Nat) by hauto inv:Typing l:on use:preservation_coreds.
    qauto l:on use:preservation_primitive, typing_unique.
    sfirstorder use:ind_has_kind_TYPE.
  - intros A0 h0.
    assert (A0 = B0) by hauto l:on use:typing_unique; subst.
    apply T_Conv with (A := B1); auto.
    sfirstorder use:ind_has_kind_TYPE.
Qed.

Lemma preservation_reds :
  forall G θ a A, Typing G θ a A -> forall b, aReds G θ a b -> Typing G θ b A.
Proof.
  intros G θ a A H b Hb.
  generalize dependent H.
  induction Hb; sfirstorder use:preservation_red.
Qed.

Lemma reds_trans :
  forall b G θ a,
    aReds G θ a b ->
    forall c,
    aReds G θ b c ->
    aReds G θ a c.
Proof.
  induction 1; sfirstorder.
Qed.

Lemma reds_one :
  forall G A θ a b,
    Typing G θ a A ->
    aRed G θ a b ->
    aReds G θ a b.
Proof.
  sauto lq:on use:typing_lc1, preservation_red.
Qed.

Lemma coreds_one :
  forall G A θ a b,
    Typing G θ a A ->
    aCoRed G θ a b ->
    aCoReds G θ a b.
Proof.
  sauto lq:on use:typing_lc1, preservation_cored.
Qed.

Lemma reds_succ_cong :
  forall G θ a b, aReds G θ a b -> aReds G θ (a_Succ a) (a_Succ b).
Proof.
  induction 1; sauto lq:on depth:1.
Qed.

Lemma coreds_succ_cong :
  forall G θ a b, aCoReds G θ a b -> aCoReds G θ (a_Succ a) (a_Succ b).
  induction 1; sauto lq:on depth:1.
Qed.

End preservation.
