From LP Require Import lp_inf lp_ind lp_tactics lp_labels sigs.

Require Import Coq.micromega.Lia.
Require Import Coq.Program.Equality.
From Equations Require Import Equations.
From Hammer Require Import Tactics.
From Ltac2 Require Import Ltac2 Constr Control.

Set Default Proof Mode "Classic".

Module progress
  (Import subsumption : subsumption_sig)
  (Import preservation : preservation_sig)
  (Import lc : lc_sig)
  (Import consistent : consistent_sig).

Lemma Value_lc :
  forall a, Value a -> lc_tm a.
  induction 1; firstorder.
Qed.

Lemma CoValue_lc :
  forall a, CoValue a -> lc_tm a.
  induction 1; eauto using Value_lc.
Qed.

Definition not_conv_b (a : tm) :=
  match a with
  | a_Conv _ _ => false
  | _ => true
  end.

Lemma value_not_conv_b : forall b,
    Value b -> not_conv_b b = true.
Proof.
  inversion 1; sfirstorder.
Qed.

(* Every CoValue can step into v |> g or v *)
(* Lemma 4.18 (Progress-Semi (Co)) *)
(* not_conv_b is a predicate that is true if and only if its argument is not a coerced term *)
(* The lemma is strengthened with side conditions about the size of the erased terms *)
Lemma covalue_semi_progress :
  forall G θ a,
    CoValue a ->
    forall A,
    Typing G θ a A ->
    (* ---------------------------------------- *)
    not_conv_b a = true \/ exists v g, not_conv_b v = true /\ aCoReds G θ a (a_Conv v g) /\ size_tm (erase_tm v) = size_tm (erase_tm a) /\ CoValue v.
Proof.
  induction 1; eauto.
  intros.
  sfirstorder use:value_not_conv_b.
  intros.
  inversion H1; subst.
  specialize (IHCoValue _ H4).
  destruct IHCoValue.
  - right.
    exists A.
    sauto lq:on rew:off use:CoValue_lc,Value_lc,value_not_conv_b.
  - destruct H2 as [v [g0 [h1 h2]]].
    right.
    exists v.
    exists (g_Trans g0 g).
    assert (aCoReds G θ (a_Conv A g) (a_Conv (a_Conv v g0) g)) by
      sfirstorder use:coreds_conv_cong.
    assert (Typing G θ (a_Conv (a_Conv v g0) g) A0) by
      sfirstorder use:preservation_coreds.
    assert (lc_tm (a_Conv (a_Conv v g0) g)) by
      sfirstorder use:typing_lc1.
    repeat split; auto.
    apply coreds_trans with (b := (a_Conv (a_Conv v g0) g)); auto.
    eapply coreds_one.

    sfirstorder use:preservation_coreds.
    sauto lq:on inv:lc_tm.
    sfirstorder.
    sfirstorder.
Qed.

Inductive succ_or_zero : tm -> Prop :=
| h_succ : forall a, succ_or_zero (a_Succ a)
| h_zero : succ_or_zero a_Zero.

Lemma size_tm_geq_one :
  forall a, size_tm a >= 1.
Proof.
  induction a; simpl in *; lia.
Qed.

Lemma covalue_not_conv_nat :
  forall θ a, CoValue a ->
          Typing nil θ a a_Nat ->
          not_conv_b a = true ->
          succ_or_zero a.
Proof.
  sauto.
Qed.

Lemma value_no_cored :
  forall a, Value a ->
       forall G θ b, ~ (aCoRed G θ a b).
Proof.
  induction 1; sauto lq:on depth:2.
Qed.

Lemma value_no_coreds :
  forall a, Value a ->
       forall G θ b, a <> b -> ~ (aCoReds G θ a b).
Proof.
  intros a h0 G θ b h1 h2.
  dependent induction h2.
  - auto.
  - sfirstorder use:value_no_cored.
Qed.

Lemma covalue_nat_progress_aux :
  forall n a, size_tm (erase_tm a) <= n ->
         forall θ , CoValue a ->
                Typing nil θ a a_Nat ->
                exists v, aCoReds nil θ a v /\ succ_or_zero v.
Proof.
  induction n.
  - intros.
    assert (size_tm (erase_tm a) >= 1) by hauto l:on use:size_tm_geq_one.
    lia.
  - intros.
    assert (h0: not_conv_b a = true \/ exists v g, not_conv_b v = true /\ aCoReds nil θ a (a_Conv v g) /\ size_tm (erase_tm v) = size_tm (erase_tm a) /\ CoValue v) by hauto l:on use:covalue_semi_progress.
    destruct h0.
    + hauto l:on use:covalue_not_conv_nat, lc_mutual.
    + destruct H2 as [v [g ?]].
      split_hyp.
      assert (h_t : Typing nil θ (a_Conv v g) a_Nat) by sfirstorder use:preservation_coreds.
      inversion h_t; subst.
      simpl in H13.
      assert (tr0 : Consistent A a_Nat) by sfirstorder use:defeq_consist.
      inversion H5; subst.
      * inversion H6; subst; try (exfalso; hauto l:on depth:1 inv:Typing).
        ** exists a_Zero.
           split.
           inversion H8; subst.
           sauto lq:on rew:off use:coreds_one, coreds_trans.
           sfirstorder.
        ** exists (a_Succ a0).
           split.
           inversion H8; subst.
           apply coreds_trans with (b := (a_Conv (a_Succ a0) g)); auto.
           eapply coreds_one; eauto.
           eapply CR_ConvRefl; eauto.
           hauto l:on use:lc_mutual.
           sfirstorder.
      * scongruence.
      * simpl in H4.
        specialize (IHn a0 ltac:(sfirstorder) θ ltac:(auto) ltac:(hauto lq:on rew:off inv:Typing)).
        exists (a_Succ a0).
        inversion H8; subst.
        split; auto.
        apply coreds_trans with (b := (a_Conv (a_Succ a0) g)); auto.
        eapply coreds_one; eauto.
        eapply CR_ConvRefl; eauto.
        hauto l:on use:lc_mutual.
        constructor; auto.
Qed.

(* Lemma 4.20 (Progress(Co-Nat)) *)
(* See covalue_nat_progress_aux for the main proof, which uses induction over the size of the erased term *)
Lemma covalue_nat_progress :
  forall a θ , CoValue a ->
           Typing nil θ a a_Nat ->
           (* -------------------------------- *)
           exists v, aCoReds nil θ a v /\ succ_or_zero v.
Proof. hauto l:on use:covalue_nat_progress_aux. Qed.

Lemma abs_push_aBeta_to_CoRed :
  forall G θ δ0 a b A,
    aBeta G θ (a_Abs δ0 A a) b ->
    aCoRed G θ (a_Abs δ0 A a) b.
  inversion 1; subst; auto.
Qed.

Lemma abs_push_cored_exists :
  forall x G θ δ0 A1 a1 g A2 a2 g2 A θ0 B1 B2,
    x `notin` fv_tm a1 \u fv_tm a2 \u fv_co g \u fv_co g2->
     Typing G θ (a_Conv  ( (a_Abs δ0 A1 a1) )  g) A ->
      (  θ0  ≤  θ  )  ->
      DefEq  (meet_ctx_l_rho q_R  G  )  g  nil  θ0  (a_Pi δ0 A1 B1) (a_Pi δ0 A2 B2)  ->
      open_tm_wrt_tm a2 (a_Var_f x)   =   open_tm_wrt_tm  a1   (a_Conv (a_Var_f x) (g_Sym  (g_PiFst θ0 g) ))  ->
      ( open_co_wrt_tm g2 (a_Var_f x) )   =  (g_PiSnd g θ0   ( (g_Reflex (a_Var_f x)) )   ( (g_Sym  ( (g_PiFst θ0 g) ) ) ))  ->
      aCoRed G θ  (a_Conv  ( (a_Abs δ0 A1 a1) )  g)   (a_Abs δ0 A2  ( (a_Conv a2 g2) ) ).
Proof.
  intros x G θ δ0 A1 a1 g A2 a2 g2 A θ0 B1 B2 h_fv h_t h1 h2 h3 h4.
  assert (tr0 : lc_tm (a_Conv (a_Abs δ0 A1 a1) g)) by sfirstorder use:typing_lc1.
  assert (tr1 : lc_co g) by hauto lq:on rew:off inv:lc_tm.
  pick fresh y and apply CR_AbsPush; eauto.
  rewrite (subst_tm_intro x a2); auto.
  rewrite (subst_tm_intro x a1); auto.
  rewrite h3.
  rewrite subst_tm_open_tm_wrt_tm; auto.
  simpl.
  rewrite eq_dec_refl.
  rewrite subst_tm_fresh_eq; auto.
  rewrite subst_tm_open_tm_wrt_tm; auto.
  simpl.
  rewrite eq_dec_refl.
  rewrite subst_tm_fresh_eq; auto.
  rewrite subst_co_fresh_eq; auto.
  rewrite (subst_co_intro x g2); auto.
  replace (g_PiSnd g θ0 (g_Reflex (a_Var_f y)) (g_Sym (g_PiFst θ0 g))) with (subst_co (a_Var_f y) x (g_PiSnd g θ0 (g_Reflex (a_Var_f x)) (g_Sym (g_PiFst θ0 g)))).
  rewrite h4.
  simpl.
  rewrite eq_dec_refl; auto.
  simpl.
  rewrite eq_dec_refl.
  rewrite subst_co_fresh_eq; auto.
Qed.


(* Lemma 4.19 (Progress(Co-Abs)) *)
Lemma covalue_progress_abs :
  forall θ a, CoValue a ->
         forall δ0 A B,
         Typing nil θ a (a_Pi δ0 A B) ->
         (* --------------------------- *)
         exists v, Value v /\ aCoReds nil θ a v.
Proof.
  intros θ a h0 δ0 A B h1.
  assert (not_conv_b a = true \/ exists v g, not_conv_b v = true /\ aCoReds nil θ a (a_Conv v g) /\ CoValue v)
    by hauto l:on depth:1 use:covalue_semi_progress.
  destruct H.
  - exists a.
    inversion h0; subst.
    + hauto l:on  l:on use:typing_lc1.
    + scongruence.
    + hauto lq:on inv:Typing.
  - destruct H as [v [g [h2 [h3 h4]]]].
    assert (h5 : Typing nil θ (a_Conv v g) (a_Pi δ0 A B))
      by hauto l:on use:preservation_coreds.
    assert (tr2 : lc_tm (a_Pi δ0 A B)) by hauto l:on use:typing_lc2.
    assert (tr3 : lc_tm A) by hauto lq:on inv:lc_tm.
    inversion tr2; subst.
    inversion h5; subst.
    assert (tr4 : Consistent A0 (a_Pi δ0 A B)) by sfirstorder use:defeq_consist.
    inversion h4; subst.
    + inversion H; subst; try (exfalso; hauto l:on depth:1 inv:Typing).
      inversion H2; subst.
      assert (tr0 : lc_co g ) by hauto l:on use:defeq_lc1.
      assert (h_l : delta5 = δ0) by hauto l:on use:defeq_consist; subst.
      destruct δ0 as [ρ0 θ0].
      pick fresh x for (fv_tm B0 \u L \u (fv_tm a0) \u
                          (union (fv_co g) (fv_co (g_PiSnd g θ (g_Reflex (a_Var_b 0)) (g_Sym  ( (g_PiFst θ g) ) ))))); repeat (spec x).
      exists (a_Abs (ρ0, θ0) A
           (a_Conv (close_tm_wrt_tm x
                      (subst_tm (a_Conv (a_Var_f x) (g_Sym (g_PiFst θ g)))
                         x (open_tm_wrt_tm a0 (a_Var_f x)))) (g_PiSnd g θ (g_Reflex (a_Var_b 0)) (g_Sym  ( (g_PiFst θ g) ) )) )).
      (* strengthen joinability *)
      assert (h_c : aCoReds nil θ a
                (a_Abs (ρ0, θ0) A
                   (a_Conv (close_tm_wrt_tm x (subst_tm (a_Conv (a_Var_f x) (g_Sym (g_PiFst θ g))) x (open_tm_wrt_tm a0 (a_Var_f x))))
                      (g_PiSnd g θ (g_Reflex (a_Var_b 0)) (g_Sym  ( (g_PiFst θ g) ) ))))).
      {
        apply coreds_trans with (b := (a_Conv (a_Abs (ρ0, θ0) A1 a0) g)); auto.
        eapply coreds_one; eauto.
        eapply (abs_push_cored_exists x); eauto.
        - rewrite fv_tm_close_tm_wrt_tm.
          auto.
        - reflexivity.
        - rewrite <- subst_tm_spec.
          rewrite subst_tm_open_tm_wrt_tm; auto.
          simpl.
          rewrite eq_dec_refl.
          rewrite (subst_tm_fresh_eq _ (a_Conv (a_Var_f x) (g_Sym (g_PiFst θ g)))); auto.
          rewrite subst_tm_open_tm_wrt_tm; auto.
          simpl.
          rewrite eq_dec_refl.
          rewrite subst_tm_fresh_eq; auto.
          rewrite subst_co_fresh_eq; auto.
        - simp open_aux.
          rewrite open_co_wrt_tm_lc_co; auto.
          rewrite open_co_wrt_tm_lc_co; auto.
      }
      assert (tr7 : lc_tm (a_Abs (ρ0, θ0) A
                   (a_Conv (close_tm_wrt_tm x (subst_tm (a_Conv (a_Var_f x) (g_Sym (g_PiFst θ g))) x (open_tm_wrt_tm a0 (a_Var_f x))))
                      (g_PiSnd g θ (g_Reflex (a_Var_b 0)) (g_Sym  ( (g_PiFst θ g) ) ))))) by qauto l:on use:preservation_coreds, typing_lc1.
      eauto.
    + simpl in *; congruence.
    + inversion H2; subst.
      scongruence.
Qed.

(* Theorem 4.21 (Progress) *)
Lemma progress :
  forall θ a A,
    Typing nil θ a A ->
    CoValue a \/ exists b, aRed nil θ a b.
Proof.
  intros θ a A h.
  pose proof h as h_backup.
  dependent induction h; eauto with lc.
  - hauto l:on use:lc_mutual.
  - sfirstorder.
  - assert (Typing nil theta (a_Pi (rho0, theta0) A B) a_TYPE) by hauto l:on.
    sauto lq:on use:typing_lc1.
  - assert (Typing nil theta (a_Abs delta0 A b) (a_Pi delta0 A B)) by hauto l:on.
    sauto lq:on rew:off use:typing_lc1.
  - right.
    specialize (IHh ltac:(auto)).
    destruct IHh; auto.
    + assert (h0 : exists v, Value v /\ aCoReds nil theta b v) by sfirstorder use:covalue_progress_abs.
      destruct h0 as [v [h_v h_coreds]].
      assert (ht : Typing nil theta v (a_Pi delta0 A B)) by sfirstorder use:preservation_coreds.
      inversion h_v; subst; inversion ht; subst; try congruence.
      exists (open_tm_wrt_tm a0 a).
      eapply R_AppAbs; eauto with lc.
    + sauto lq:on use:lc_mutual.
  - sauto lq:on rew:off use:lc_mutual.
  - hauto l:on.
  - destruct IHh2; auto.
    + assert (h00 : exists v, aCoReds nil t_L a1 v /\ succ_or_zero v)  by hauto l:on use: covalue_nat_progress.
      destruct h00 as [v [hcoreds h_succ]].
      inversion h_succ; subst.
      * qauto l:on use:subsumption_mutual, ind_succ_intro.
      * qauto l:on use:subsumption_mutual, ind_zero_intro.
    + right.
      destruct H1 as [a1' hred].
      pose proof ind_cong_intro as cong_intro.
      hauto l:on use:subsumption_mutual, ind_cong_intro.
Qed.

End progress.
