(* Every term can have only a single type *)
From LP Require Import lp_inf lp_ind lp_tactics lp_labels sigs.

From Hammer Require Import Tactics.
From Ltac2 Require Import Ltac2 Constr Control.
Require Import Coq.Program.Equality.

Set Default Proof Mode "Classic".

Module regularity
  (Import lc : lc_sig)
  (Import preservation : preservation_sig)
  (Import wff : wff_sig)
  (Import unique : unique_sig)
  (Import subst : subst_sig)
  (Import narrow : typing_narrowing_sig)
  (Import weak : weak_sig)
  (Import subsumption : subsumption_sig) <: regularity_sig.

Lemma defeq_avail_narrowing :
  forall Γ0 g Γ1 Γ2 θ a b,
    DefEq Γ0 g (Γ2 ++ Γ1) θ a b ->
    DefEq (Γ1 ++ Γ0) g Γ2 θ a b.
Proof.
  intros Γ0 g Γ1 Γ2 θ a b h.
  dependent induction h; simpl_env in *; eauto.
  - simpl_env in H0.
    assert (tr0: Ctx (Γ1 ++ G)) by sfirstorder use:ctx_weakening.
    econstructor; sfirstorder use:typing_weakening.
  - assert (tr0: Ctx (Γ1 ++ G)) by sfirstorder use:ctx_weakening.
    econstructor; eauto;
      simpl_env;
      sfirstorder.
  - pick fresh x and apply E_AbsCong; eauto.
    simpl_env; eauto.
  - econstructor; eauto.
    simpl_env.
    sfirstorder.
  - econstructor; eauto;
      simpl_env;
      sfirstorder.
  - pick fresh x and apply E_IndCong; eauto.
    simpl_env; eauto.
Qed.

Lemma defeq_avail_narrowing_nil :
  forall Γ0 g Γ1 θ a b,
    DefEq Γ0 g Γ1 θ a b ->
    DefEq (Γ1 ++ Γ0) g nil θ a b.
Proof.
  sfirstorder use:defeq_avail_narrowing.
Qed.

Lemma regularity :
  (forall Γ θ a A, Typing Γ θ a A -> A = a_TYPE \/ Typing (meet_ctx_l_rho q_R Γ) θ A a_TYPE) /\
    (forall Γ g Γ0 θ a b, DefEq Γ g Γ0 θ a b -> exists A, Typing (Γ0 ++ Γ) θ a A /\ Typing (Γ0 ++ Γ) θ b A) /\
    (forall Γ, Ctx Γ -> forall x ρ0 θ0 A, binds x (ρ0, θ0, A) Γ -> Typing (meet_ctx_l_rho q_R Γ) θ0 A a_TYPE) /\
    (forall Γ θ a b, aBeta Γ θ a b ->  True) /\
    (forall Γ δ a A, CTyping Γ δ a A ->
                  forall ρ θ, (ρ,θ) = δ ->
                  A = a_TYPE \/ Typing (meet_ctx_l_rho q_R Γ) θ A a_TYPE).
Proof.
  apply typing_mutual; intros; eauto.
  - sauto lq: on rew: off rew: off use: subsumption_mutual.
  (* Ind *)
  - destruct H; try congruence.
    right.
    inversion H; subst.
    pick fresh x; repeat (spec x).
    change a_TYPE with (subst_tm a x a_TYPE).
    rewrite (subst_tm_intro x); auto.
    eapply typing_subst_nil; eauto.
    inversion c; subst; auto.
    hauto l:on use:typing_meet_ctx_l.
  - sauto lq:on depth:2 use:ctx_meet_ctx_l.
  (* Reflection *)
  - clear H.
    inversion t; subst.
    pick fresh y; repeat (spec y).
    right.
    rewrite (subst_tm_intro y); auto.
    change a_TYPE with (subst_tm a1 y a_TYPE).
    eapply typing_substc_nil; eauto.
    qauto l:on use:typing_subsumption.
    sauto lq:on use:typing_subsumption, ctyping_meet_ctx_l.
  - hauto l:on use:typing_weakening.
  (* EqCong *)
  - destruct H as [A0 [h0 h1]].
    destruct H0 as [A1 [h2 h3]].
    inversion t; subst.
    assert (A = A0 /\ A = A1) by hauto l:on use:typing_unique; split_hyp.
    subst.
    sfirstorder.
  (* ReifyCong *)
  - destruct H1 as [A0 [h0 h1]].
    destruct H2 as [A1 [h2 h3]].
    simpl in *.
    exists (a_Eq theta0 a b).
    split.
    constructor; auto.
    econstructor; eauto with narrow.
    econstructor; eauto with narrow.
  - qauto l:on use:preservation_primitive.
  - firstorder.
  - hauto l:on use:typing_unique.
  (* PiCong *)
  - exists a_TYPE.
    destruct H as [A [h1 h2]].
    assert (Typing (G0 ++ G) theta0 A1 a_TYPE) by hauto lq:on inv:Typing.
    assert (tr0: Ctx (G0 ++ G)) by hauto l:on use:typing_wff.
    assert (A = a_TYPE) by hauto l:on use:typing_unique; subst.
    clear H1.
    clear H2.
    split; auto.
    inversion t; subst.
    inversion t0; subst.
    pick fresh y and apply T_Pi; repeat (spec y); eauto.
    assert (tr1 : Ctx (y ~ (q_R, theta0, A1) ++ G0 ++ G)) by hauto l:on use:typing_wff.
    assert (tr12 : Typing (meet_ctx_l_rho q_R (G0 ++ G)) theta0 A2 a_TYPE) by eauto with narrow.
    assert (tr2 : Ctx (y ~ (q_R, theta0, A2) ++ G0 ++ G)) by hauto l:on.
    assert (tr3 : (Ctx (meet_ctx_l_rho q_R (y ~ (q_R, theta0, A2)) ++ meet_ctx_l_rho q_R G0 ++ meet_ctx_l_rho q_R G)))
             by (change (Ctx (meet_ctx_l_rho q_R (y ~ (q_R, theta0, A2)) ++ meet_ctx_l_rho q_R G0 ++ meet_ctx_l_rho q_R G)); eauto with narrow).
    rewrite H3.
    destruct H4 as [A [h3 h4]].
    simpl_env in h3.
    assert (A = a_TYPE) by eauto using typing_unique; subst.
    clear h1 H H5.
    pick fresh x for (add y (dom G) \u dom G0 \u fv_tm B2).
    apply typing_rename with (y := x) in H1; auto.
    rewrite subst_tm_open_tm_wrt_tm in H1; auto.
    rewrite subst_tm_fresh_eq in H1; auto.
    simpl in H1.
    rewrite eq_dec_refl in H1.
    simpl_env in H1.
    apply typing_weakening_middle with (E := (y ~ (q_R, theta0, A2))) in H1.
    assert (h_s : Typing (y ~ (q_R, theta0, A2) ++ G0 ++ G) theta (subst_tm (a_Conv (a_Var_f y) (g_Sym g1)) x (open_tm_wrt_tm B2 (a_Var_f x))) (subst_tm (a_Conv (a_Var_f y) (g_Sym g1)) x a_TYPE)).
    apply typing_subst_nil with (θ0 := theta0) (A := A1); eauto.
    apply T_Conv with (A := A2).
    econstructor; auto.
    reflexivity.
    simpl_env.
    apply typing_weakening; eauto with narrow.
    simpl_env.
    apply defeq_weakening; eauto with narrow.
    (* Need "narrowing" property for G, G0 *)
    constructor.
    apply defeq_avail_narrowing_nil in d.
    rewrite <- meet_ctx_l_app.
    sfirstorder use:defeq_meet_ctx_l.
    rewrite subst_tm_open_tm_wrt_tm in h_s; eauto with lc.
    simpl in h_s.
    rewrite eq_dec_refl in h_s.
    rewrite subst_tm_fresh_eq in h_s; auto.
    constructor; eauto.
    simpl_env.
    apply typing_weakening; eauto.
    rewrite <- meet_ctx_l_app; eauto with narrow.
  - clear H.
    inversion t0; subst.
    pick fresh x; repeat (spec x).
    destruct H2 as [A0 [h0 h1]].
    exists (a_Pi (rho0, theta0) A B0); split; auto.
    simpl_env in h1.
    assert (A0 = (open_tm_wrt_tm B0 (a_Var_f x))) by hauto l:on use:typing_unique; subst.
    simpl_env in h0.
    pick fresh y and apply T_Abs; eauto.
    apply typing_rename with (y := y) in h0; auto.
    rewrite subst_tm_open_tm_wrt_tm in h0; auto.
    rewrite subst_tm_open_tm_wrt_tm in h0; auto.
    simpl in h0.
    rewrite eq_dec_refl in h0.
    rewrite subst_tm_fresh_eq in h0; auto.
    rewrite subst_tm_fresh_eq in h0; auto.

  - destruct H as [A0 [h0 h1]].
    destruct H0 as [A1 [h2 h3]].
    inversion t; subst.
    assert (A0 = (a_Pi (q_R, theta0) A2 B0)) by hauto l:on use:typing_unique; subst.
    inversion t0; subst.
    assert ((a_Pi (q_R, theta0) A2 B0) = (a_Pi (q_R, theta0) A B1)) by hauto l:on use:typing_unique.
    inversion H; subst.

    exists (open_tm_wrt_tm B1 b2).
    split; auto.
    apply T_Conv with (open_tm_wrt_tm B1 b1); auto.
    destruct H2 as [h_t | h_t]; subst; eauto.
    destruct theta.
    + rewrite h_t; eauto.
      destruct H3 as [A4 [h4 h5]].
      rewrite h_t in h5.
      inversion h5.
    + rewrite h_t; eauto.
      econstructor; eauto.
      sfirstorder use:ctx_meet_ctx_l, wff_mutual.
  (* AppCongIrrel *)
  - clear H.
    destruct H4 as [A9 [h8 h9]].
    exists B2.
    split; auto.
    apply T_Conv with (A := B1); auto.
    destruct H3; subst.
    + destruct theta; eauto.
      * inversion h9.
      * constructor; hauto l:on use:typing_wff.
    + auto.
  - destruct H as [A [h0 h1]].
    inversion h0; subst.
    inversion h1; subst.
    exists a_TYPE.
    sfirstorder use:subsumption_mutual.
  (* PiSnd *)
  - destruct H as [A0 [h0 h1]].
    assert (tr0 : Ctx (G0 ++ G)) by hauto l:on use:typing_wff.
    assert (tr1 : Ctx G) by hauto l:on use:ctx_weakening.
    inversion h0; subst.
    exists a_TYPE.
    split.
    + pick fresh y; repeat (spec y).
      rewrite (subst_tm_intro y); auto.
      change a_TYPE with (subst_tm (a_Conv a1 g2) y a_TYPE).
      apply typing_subst_nil with (θ0 := theta1) (A := A1); eauto.
      hauto l:on use:typing_subsumption.
    + inversion h1; subst.
      pick fresh y; repeat (spec y); eauto.
      rewrite (subst_tm_intro y); auto.
      change a_TYPE with (subst_tm a2 y a_TYPE).
      eapply typing_subst_nil.
      sfirstorder use:subsumption_mutual.
      eauto using typing_weakening.
  - exists a_Nat.
    split.
    + sfirstorder.
    + destruct H as [A [h0 h1]].
      assert (A = a_Nat) by hauto l:on use:typing_unique; subst.
      sfirstorder.
  - exists B0; split; auto.
    apply T_Conv with (A := A0); auto.
    destruct H3; auto; subst.
    destruct H4 as [T [h0 h1]].
    destruct theta.
    + inversion h1.
    + hauto l:on use:wff_mutual.
  - firstorder.
  - clear H0.
    assert (tr0 : uniq G) by sfirstorder use:Ctx_uniq.
    apply binds_app_uniq_iff in H1; auto.
    destruct H1; split_hyp.
    + apply binds_one_iff in H0.
      split_hyp; subst.
      inversion H2; subst.
      simpl_env.
      apply typing_weakening; auto.
      constructor; eauto.
      sfirstorder use:ctx_meet_ctx_l.
      simpl_env; auto.
      rewrite dom_meet_ctx_l; auto.
    + assert (h0 : Typing (meet_ctx_l_rho q_R G) θ0 A0 a_TYPE) by sfirstorder.
      simpl_env.
      apply typing_weakening; auto.
      constructor; eauto.
      sfirstorder use:ctx_meet_ctx_l.
      simpl_env; auto.
      rewrite dom_meet_ctx_l; auto.
  - inversion H0; subst.
    sfirstorder.
  - inversion H0; subst.
    scongruence use: meet_ctx_l_meet_ctx_l.
Qed.

(* Lemma 3.5 (Regularity) *)
(* See regularity for the main proof *)
Lemma typing_regularity :
  forall G θ a A,
    Typing G θ a A ->
    (* -------------------------------------------------- *)
    Typing (meet_ctx_l_rho q_R G) θ A a_TYPE \/ A = a_TYPE.
Proof. hauto l:on use:regularity. Qed.

(* Lemma 3.7 (DefEq regularity) *)
(* See regularity for the main proof *)
Lemma defeq_regularity :
  forall G g G0 θ a b,
    DefEq G g G0 θ a b ->
    (* ------------------------ *)
    exists T,
      (Typing (G0 ++ G) θ a T) /\
      (Typing (G0 ++ G) θ b T).
Proof. hauto l:on use:regularity. Qed.

Lemma ctx_regularity :
  forall Γ, Ctx Γ -> forall x ρ0 θ0 A, binds x (ρ0, θ0, A) Γ -> Typing (meet_ctx_l_rho q_R Γ) θ0 A a_TYPE.
sfirstorder use:regularity. Qed.



Lemma defeq_same_type : forall G g G0 θ a b A,
    Typing (G0 ++ G) θ a A -> DefEq G g G0 θ a b -> Typing (G0 ++ G) θ b A.
Proof.
  qauto use:defeq_regularity, typing_unique.
Qed.

Lemma defeq_same_type_nil : forall G g  θ a b A,
    Typing G θ a A -> DefEq G g nil θ a b -> Typing G θ b A.
Proof.
  sfirstorder use:defeq_same_type.
Qed.

End regularity.
