From LP Require Import lp_inf forall_depth_inf lp_ott.
(* From LP Require Import sn_def. *)

Module Type lc_sig.
  Axiom lc_mutual :
    (forall G θ a A, Typing G θ a A -> lc_tm a /\ lc_tm A) /\
      (forall G g G0 θ A B, DefEq G g G0 θ A B -> lc_co g /\ lc_tm A /\ lc_tm B) /\
      (forall G, Ctx G -> forall x δ a, binds x (δ, a) G -> lc_tm a) /\
      (forall G δ a b, aBeta G δ a b -> lc_tm a) /\ (* lc_tm b is given in the defeq red rule *)
      (forall G δ a A, CTyping G δ a A -> lc_tm a /\ lc_tm A).

  Axiom typing_lc1 : forall G θ a A, Typing G θ a A -> lc_tm a.
  Axiom typing_lc2 : forall G θ a A, Typing G θ a A -> lc_tm A.
  Axiom defeq_lc1 : forall G g G0 θ A B, DefEq G g G0 θ A B -> lc_co g.
  Axiom defeq_lc2 : forall G g G0 θ A B, DefEq G g G0 θ A B -> lc_tm A.
  Axiom defeq_lc3 : forall G g G0 θ A B, DefEq G g G0 θ A B -> lc_tm B.
  Axiom ctyping_lc1 : forall G δ a A, CTyping G δ a A -> lc_tm a.
  Axiom ctyping_lc2 : forall G δ a A, CTyping G δ a A -> lc_tm A.


  Create HintDb lc.
  #[export] Hint Resolve
    typing_lc1
    typing_lc2
    defeq_lc1
    defeq_lc2
    defeq_lc3
    ctyping_lc1
    ctyping_lc2 : lc.
End lc_sig.


Module Type wff_sig.
  Axiom wff_mutual :
    (forall G θ a A, Typing G θ a A -> Ctx G) /\
      (forall G g G0 θ A B, DefEq G g G0 θ A B -> Ctx (G0 ++ G)) /\
      (forall G, Ctx G -> True) /\
      (forall G δ a b, aBeta G δ a b -> Ctx G) /\
      (forall G δ a A, CTyping G δ a A -> True).
  Axiom typing_wff : forall G θ a A, Typing G θ a A -> Ctx G.
  Axiom Ctx_uniq : forall G, Ctx G -> uniq G.
  Axiom uniq_mutual :
    (forall G θ a A, Typing G θ a A -> uniq G) /\
      (forall G g G0 θ A B, DefEq G g G0 θ A B -> uniq (G0 ++ G)) /\
      (forall G, Ctx G -> uniq G) /\
      (forall G δ a b, aBeta G δ a b -> uniq G) /\
      (forall G δ a A, CTyping G δ a A -> True).
End wff_sig.

Module Type typing_fv_sig.
  Axiom typing_empty_fv : forall θ a A, Typing nil θ a A -> fv_tm a [=] empty /\ fv_tm A [=] empty.
  Axiom typing_empty_fv1 : forall θ a A, Typing nil θ a A -> fv_tm a [=] empty.
  Axiom typing_empty_fv2 : forall θ a A, Typing nil θ a A -> fv_tm A [=] empty.
  Axiom defeq_empty_fv1 : forall g θ A B,
      DefEq nil g nil θ A B -> fv_co g [=] empty.
  Axiom typing_fv1 : forall Γ θ a A, Typing Γ θ a A -> fv_tm a [<=] dom Γ.
  Axiom typing_fv2 : forall Γ θ a A, Typing Γ θ a A -> fv_tm A [<=] dom Γ.
  Axiom ctx_fv : forall G, Ctx G -> forall x A δ0, binds x (δ0, A) G -> x `in` dom G /\ fv_tm A [<=] remove x (dom G).
End typing_fv_sig.

Module Type typing_narrowing_sig.
Axiom ctx_weakening : forall G G0,
    Ctx (G ++ G0) ->
    Ctx G0.

Axiom ared_meet_ctx_l :
  forall Γ θ a b,
    Ctx Γ ->
    aRed Γ θ a b ->
    aRed (meet_ctx_l_rho q_R Γ) θ a b.

Axiom acoreds_meet_ctx_l :
  forall Γ θ a b,
    Ctx Γ ->
    aCoReds Γ θ a b ->
    aCoReds (meet_ctx_l_rho q_R Γ) θ a b.

Axiom typing_meet_ctx_l : forall G θ a A,  Typing G θ a A -> forall rho, Typing (meet_ctx_l_rho rho G) θ a A.

Axiom ctyping_meet_ctx_l : forall G δ a A,  CTyping G δ a A -> forall ρ, CTyping (meet_ctx_l_rho ρ G) δ a A.

Axiom ctx_meet_ctx_l : forall G rho, Ctx G -> Ctx (meet_ctx_l_rho rho G).

Axiom ctx_meet_ctx_l_app2 : forall G1 G2 rho, Ctx (G1 ++ G2) -> Ctx (meet_ctx_l_rho rho G1 ++ meet_ctx_l_rho rho G2).

Axiom ctx_meet_ctx_l_app3 :
  forall G1 G2 G3 rho, Ctx (G1 ++ G2 ++ G3) -> Ctx (meet_ctx_l_rho rho G1 ++ meet_ctx_l_rho rho G2 ++ meet_ctx_l_rho rho G3).

Axiom ctx_meet_ctx_l_app4 :
  forall G1 G2 G3 G4 rho, Ctx (G1 ++ G2 ++ G3 ++ G4) -> Ctx (meet_ctx_l_rho rho G1 ++ meet_ctx_l_rho rho G2 ++ meet_ctx_l_rho rho G3 ++ meet_ctx_l_rho rho G4).

Axiom typing_meet_ctx_l_app2 : forall G1 G2 θ a A,  Typing (G1 ++ G2) θ a A -> forall rho, Typing (meet_ctx_l_rho rho G1 ++ meet_ctx_l_rho rho G2) θ a A.

Axiom typing_meet_ctx_l_app3 : forall G1 G2 G3 θ a A,  Typing (G1 ++ G2 ++ G3) θ a A -> forall rho, Typing (meet_ctx_l_rho rho G1 ++ meet_ctx_l_rho rho G2 ++ meet_ctx_l_rho rho G3) θ a A.

Axiom defeq_meet_ctx_l : forall G g G0 θ A B, DefEq G g G0 θ A B -> DefEq (meet_ctx_l_rho q_R G) g (meet_ctx_l_rho q_R G0) θ A B.

Create HintDb narrow.
#[export]Hint Resolve
  typing_meet_ctx_l
  ctx_meet_ctx_l
  ctx_meet_ctx_l_app2
  ctx_meet_ctx_l_app3
  typing_meet_ctx_l_app2
  typing_meet_ctx_l_app3
  ctx_meet_ctx_l_app4
  ctyping_meet_ctx_l : narrow.
End typing_narrowing_sig.

Module Type weak_sig.
Axiom typing_weakening_mutual:
  (forall G θ a A,  Typing G θ a A ->
     forall F E Q, (G = F ++ Q) -> Ctx (F ++ E ++ Q) -> Typing (F ++ E ++ Q) θ a A) /\
  (forall G g1 G0 θ A1 A2 ,  DefEq G g1 G0 θ A1 A2 ->
     forall F E Q, (G = F ++ Q) -> Ctx (F ++ E ++ Q) -> Ctx (G0 ++ F ++ E ++ Q) -> DefEq (F ++ E ++ Q) g1 G0 θ A1 A2) /\
  (forall G,         Ctx G ->
     forall F E Q, (G = F ++ Q) -> Ctx (F ++ E ++ Q) -> Ctx (F ++ E ++ Q)) /\
  (forall G θ a b, aBeta G θ a b ->
               forall F E Q, (G = F ++ Q) -> Ctx (F ++ E ++ Q) -> aBeta (F ++ E ++ Q) θ a b) /\
  (forall G δ a A, CTyping G δ a A ->
               forall F E Q, (G = F ++ Q) -> Ctx (F ++ E ++ Q) -> CTyping (F ++ E ++ Q) δ a A).

Axiom typing_weakening_middle :
  forall F G θ a A,  Typing (F ++ G) θ a A -> forall E, Ctx (F ++ E ++ G) -> Typing (F ++ E ++ G) θ a A.

Axiom typing_weakening : forall G1 θ a A,
    Typing G1 θ a A ->
    forall G2, Ctx (G2 ++ G1) ->
    Typing (G2 ++ G1) θ a A.

Axiom defeq_weakening_middle :
  forall F Q g1 G0 θ A1 A2 ,  DefEq (F ++ Q) g1 G0 θ A1 A2 ->
                       forall E, Ctx (F ++ E ++ Q) -> Ctx (G0 ++ F ++ E ++ Q) -> DefEq (F ++ E ++ Q) g1 G0 θ A1 A2.

Axiom defeq_weakening :
  forall Q g1 G0 θ A1 A2 ,  DefEq Q g1 G0 θ A1 A2 ->
                       forall E, Ctx (E ++ Q) -> Ctx (G0 ++ E ++ Q) -> DefEq (E ++ Q) g1 G0 θ A1 A2.

End weak_sig.

Module Type subsumption_sig.
  Axiom subsumption_mutual :
  (forall G θ a A, Typing G θ a A -> forall θ0, θ ≤ θ0 -> Typing G θ0 a A) /\
  (forall G g G0 θ A B, DefEq G g G0 θ A B -> forall θ0, θ ≤ θ0 -> DefEq G g G0 θ0 A B) /\
  (forall G, Ctx G -> True) /\
  (forall G θ a b, aBeta G θ a b -> forall θ0, θ ≤ θ0 -> aBeta G θ0 a b) /\
    (forall G δ a A, CTyping G δ a A -> forall δ0, δ ≤ δ0 -> CTyping G δ0 a A).

  Axiom typing_subsumption : forall G θ a A, Typing G θ a A -> forall θ0, θ ≤ θ0 -> Typing G θ0 a A.


  Axiom ctyping_subsumption : forall G δ a A, CTyping G δ a A -> forall δ0, δ ≤ δ0 -> CTyping G δ0 a A.


  Axiom defeq_subsumption : forall G g G0 θ A B, DefEq G g G0 θ A B -> forall θ0, θ ≤ θ0 -> DefEq G g G0 θ0 A B.

  Axiom abeta_subsumption : forall G θ a b, aBeta G θ a b -> forall θ0, θ ≤ θ0 -> aBeta G θ0 a b.
End subsumption_sig.

Module Type unique_sig.
  Axiom typing_unique_mutual :
    (forall G θ a A, Typing G θ a A -> forall B, Typing G θ a B -> A = B) /\
      (forall G g G0 θ A B, DefEq G g G0 θ A B -> forall A1 B1, DefEq G g G0 θ A1 B1 -> A = A1 /\ B = B1) /\
      (forall G, Ctx G -> True) /\
      (forall G θ a b, aBeta G θ a b -> True) /\
      (forall G δ a A, CTyping G δ a A -> forall B, CTyping G δ a B -> A = B).

  Axiom typing_unique : forall G θ a A, Typing G θ a A -> forall B, Typing G θ a B -> A = B.
  Axiom defeq_unique1 : forall G g G0 θ A B, DefEq G g G0 θ A B -> forall A1 B1, DefEq G g G0 θ A1 B1 -> A = A1.
  Axiom defeq_unique2 : forall G g G0 θ A B, DefEq G g G0 θ A B -> forall A1 B1, DefEq G g G0 θ A1 B1 -> B = B1.
  Axiom ctyping_unique : forall G δ a A, CTyping G δ a A -> forall B, CTyping G δ a B -> A = B.
End unique_sig.

Module Type subst_sig.
  (* It's already proved in preservation *)
  (* Just move it to the right place *)
  Axiom typing_substc_nil :
  forall {x δ0 A K θ b B},
    Typing ((x ~ (δ0, A)) ++ K) θ b B ->
    forall {a}, CTyping K δ0 a A ->
           Typing K θ (subst_tm a x b) (subst_tm a x B).

  Axiom typing_substc :
    forall F x δ0 A K θ b B,
      Typing (F ++ (x ~ (δ0, A)) ++ K) θ b B ->
      forall a, CTyping K δ0 a A ->
           Typing (subst_ctx a x F ++ K) θ (subst_tm a x b) (subst_tm a x B).

  Axiom typing_subst_nil :
    forall x θ0 A K θ b B,
      Typing ((x ~ (q_R, θ0, A)) ++ K) θ b B ->
      forall {a}, Typing K θ0 a A ->
             Typing K θ (subst_tm a x b) (subst_tm a x B).

  Axiom typing_substc_nil2 :
    forall F x δ0 A θ b B,
      Typing (F ++ (x ~ (δ0, A))) θ b B ->
      forall a, CTyping nil δ0 a A ->
           Typing (subst_ctx a x F) θ (subst_tm a x b) (subst_tm a x B).

  Axiom abeta_substc_nil2 :
    forall F x δ0 A θ b B,
      aBeta (F ++ (x ~ (δ0, A))) θ b B ->
      forall a, CTyping nil δ0 a A ->
           aBeta (subst_ctx a x F) θ (subst_tm a x b) (subst_tm a x B).

  Axiom defeq_substc_nil2 :
    forall F x δ0 A g θ A0 B0,
      DefEq (F ++ (x ~ (δ0, A))) g nil θ A0 B0 ->
      forall a, CTyping nil δ0 a A ->
           DefEq (subst_ctx a x F) (subst_co a x g) nil θ (subst_tm a x A0) (subst_tm a x B0).


End subst_sig.

Module Type par_sig.
(* Should belong to the par module *)

  Axiom Par_cong_nil :
  forall x ρ P3 A1 A2,
    Par (x ~ ρ ++ P3) A1 A2 ->
        forall B1 B2,
          CPar P3 ρ B1 B2 ->
          Par P3 (subst_tm B1 x A1) (subst_tm B2 x A2).

  Axiom Join_Pi_Proj2 :
    forall P ρ0 θ0 A1 B1 A2 B2,
      Joins P (a_Pi (ρ0, θ0) A1 B1) (a_Pi (ρ0, θ0) A2 B2) ->
      exists L,
      forall x,
        x `notin` L ->
        Joins (x ~ q_R ++ P) (open_tm_wrt_tm B1 (a_Var_f x)) (open_tm_wrt_tm B2 (a_Var_f x)).

  Axiom Par_γ_left :
    forall x ρ0 P B1 γ B2,
      lc_co γ ->
      x `notin` fv_tm B1 ->
      x `notin` fv_tm B2 ->
      Par (x ~ ρ0 ++ P) (open_tm_wrt_tm B1 (a_Var_f x)) (open_tm_wrt_tm B2 (a_Var_f x)) ->
      Par (x ~ ρ0 ++ P) (open_tm_wrt_tm B1 (a_Conv (a_Var_f x) γ)) (open_tm_wrt_tm B2 (a_Var_f x)).

  Axiom Join_weak_from_nil : forall P A B,
    Joins nil A B ->
    uniq P ->
    Joins P A B.
  Axiom Joins_sym : forall P A1 A2, Joins P A1 A2 -> Joins P A2 A1.
  Axiom Join_Consistent :
  forall P A B, Joins P A B ->
           Consistent A B.
  Axiom Join_forall_depth_same : forall P A1 A2, Joins P A1 A2 -> LTy A1 -> LTy A2 -> tm_forall_depth A1 = tm_forall_depth A2.
  Axiom Join_Pi_Proj1 :
    forall P δ0 A1 B1 A2 B2, Joins P (a_Pi δ0 A1 B1) (a_Pi δ0 A2 B2) -> Joins P A1 A2.
  Axiom Join_Pi_Proj1' :
    forall P δ0 δ1 A1 B1 A2 B2, Joins P (a_Pi δ0 A1 B1) (a_Pi δ1 A2 B2) -> Joins P A1 A2 /\ δ0 = δ1.

  Axiom Join_conv_intro :
    forall P a1 a2 g1 g2,
      Joins P a1 a2 ->
      lc_co g1 ->
      lc_co g2 ->
      Joins P (a_Conv a1 g1) (a_Conv a2 g2).

  Axiom Join_Eq_Proj :
    forall P θ1 A1 B1 θ2 A2 B2,
      Joins P (a_Eq θ1 A1 B1) (a_Eq θ2 A2 B2) ->
      Joins P A1 A2 /\
        Joins P B1 B2 /\
        θ1 = θ2.

  Axiom Join_trans :
    forall P a1 a2 a3,
      Joins P a1 a2 ->
      Joins P a2 a3 ->
      Joins P a1 a3.

  Axiom Join_γ_Pi_Proj2 :
    forall P ρ0 θ0 A1 B1 A2 B2 g,
      lc_co g ->
      Joins P (a_Pi (ρ0, θ0) A1 B1) (a_Pi (ρ0, θ0) A2 B2) ->
      exists L,
      forall x,
        x `notin` L ->
        Joins (x ~ q_R ++ P) (open_tm_wrt_tm B1 (a_Conv (a_Var_f x) g)) (open_tm_wrt_tm B2 (a_Var_f x)).

  Axiom MultiPar_join :
    forall P a1 a2,
      MultiPar P a1 a2 ->
      Joins P a1 a2.

  Axiom MultiPar_γ_left :
    forall x ρ0 P B1 γ B2,
      lc_co γ ->
      x `notin` fv_tm B1 ->
      MultiPar (x ~ ρ0 ++ P) (open_tm_wrt_tm B1 (a_Var_f x)) (open_tm_wrt_tm B2 (a_Var_f x)) ->
      MultiPar (x ~ ρ0 ++ P) (open_tm_wrt_tm B1 (a_Conv (a_Var_f x) γ)) (open_tm_wrt_tm B2 (a_Var_f x)).

  Axiom Par_grade_mutual :
    (forall P A1 B1,
        Par P A1 B1 ->
        Par P B1 B1 /\ Par P A1 A1) /\
      (forall P ρ A1 B1,
          CPar P ρ A1 B1 ->
          CPar P ρ A1 A1 /\
            CPar P ρ B1 B1).

  Axiom MultiPar_grade :
    forall P a1 a2,
      MultiPar P a1 a2 ->
      Par P a1 a1 /\
        Par P a2 a2.

  Axiom Join_grade :
    forall P a1 a2,
      Joins P a1 a2 ->
      Par P a1 a1 /\
        Par P a2 a2.

  Axiom Join_eq_intro :
    forall P θ a1 a2 b1 b2,
      Joins P a1 a2 ->
      Joins P b1 b2 ->
      Joins P (a_Eq θ a1 b1) (a_Eq θ a2 b2).
  Axiom Join_app_intro : forall P ρ θ a a' b b',
      Joins P a a' ->
      CJoins P ρ b b' ->
      Joins P (a_App a (ρ, θ) b) (a_App a' (ρ, θ) b').


  Axiom Join_app_intro_γ : forall P ρ θ a a' b b' γ,
      lc_co γ ->
      Joins P a a' ->
      CJoins P ρ b b' ->
      Joins P (a_Conv (a_App a (ρ, θ) b) γ) (a_App a' (ρ, θ) b').

  Axiom Join_γ_intro : forall P a a',
    Joins P a a' ->
    forall γ,
      lc_co γ ->
      Joins P (a_Conv a γ) a'.

  Axiom Join_reify_intro :
    forall P θ g1 g2,
      uniq P ->
      lc_co g1 -> lc_co g2 ->
      Joins P (a_Reify θ g1) (a_Reify θ g2).

  Axiom Join_γ_Pi_Proj2' :
    forall P ρ0 θ0 A1 B1 A2 B2 a g,
      Par P a a ->
      lc_co g ->
      Joins P (a_Pi (ρ0, θ0) A1 B1) (a_Pi (ρ0, θ0) A2 B2) ->
      Joins P (open_tm_wrt_tm B1 (a_Conv a g)) (open_tm_wrt_tm B2 a).

  Axiom Join_γ_open_Proj:
    forall a b x ρ P B1 g B2,
      x `notin` fv_tm B1 \u fv_tm B2 \u fv_co g \u dom P ->
      CJoins P ρ a b ->
      Joins (x ~ ρ ++ P) (open_tm_wrt_tm B1 (a_Conv (a_Var_f x) g)) (open_tm_wrt_tm B2 (a_Var_f x)) ->
      Joins P (open_tm_wrt_tm B1 (a_Conv a g)) (open_tm_wrt_tm B2 b).

  Axiom Joins_AbsCong_intro :
    forall P A1 A2,
      lc_tm A1 ->
      lc_tm A2 ->
      forall B1 B2 ρ0 θ0 x,
        x `notin` fv_tm B1 \u fv_tm B2 ->
        Joins (x ~ ρ0 ++ P) (open_tm_wrt_tm B1 (a_Var_f x)) (open_tm_wrt_tm B2 (a_Var_f x)) ->
        Joins P (a_Abs (ρ0,θ0) A1 B1) (a_Abs (ρ0,θ0) A2 B2).

  Axiom Joins_PiCong_intro :
    forall P A1 A2,
      Joins P A1 A2 ->
      forall B1 B2 δ0 x,
        x `notin` fv_tm B1 \u fv_tm B2 ->
        Joins (x ~ q_R ++ P) (open_tm_wrt_tm B1 (a_Var_f x)) (open_tm_wrt_tm B2 (a_Var_f x)) ->
        Joins P (a_Pi δ0 A1 B1) (a_Pi δ0 A2 B2).

  Axiom Join_succ_intro : forall P a a',
      Joins P a a' ->
      Joins P (a_Succ a) (a_Succ a').

  Axiom Join_ind_intro:
    forall P x A1 A2 a1 a2 cz1 cz2 cs1 cs2,
      lc_tm A1 ->
      lc_tm A2 ->
      x `notin` fv_tm cs1 \u fv_tm cs2 ->
      Joins P a1 a2 ->
      Joins P cz1 cz2 ->
      Joins (x ~ q_R ++ P) (open_tm_wrt_tm cs1 (a_Var_f x)) (open_tm_wrt_tm cs2 (a_Var_f x)) ->
      Joins P (a_Ind a1 cz1 cs1 A1) (a_Ind a2 cz2 cs2 A2).

  Axiom Joins_cong_nil :
    forall x ρ P3 A1 A2,
      Joins (x ~ ρ ++ P3) A1 A2 ->
      forall B1 B2,
        CJoins P3 ρ B1 B2 ->
        Joins P3 (subst_tm B1 x A1) (subst_tm B2 x A2).
End par_sig.

Module Type regularity_sig.
  Axiom defeq_avail_narrowing_nil :
    forall Γ0 g Γ1 θ a b,
      DefEq Γ0 g Γ1 θ a b ->
      DefEq (Γ1 ++ Γ0) g nil θ a b.

  Axiom typing_regularity :
    forall G θ a A, Typing G θ a A -> Typing (meet_ctx_l_rho q_R G) θ A a_TYPE \/ A = a_TYPE.
  Axiom defeq_regularity :
    forall G g G0 θ a b, DefEq G g G0 θ a b ->
                     exists T,
                       (Typing (G0 ++ G) θ a T) /\
                         (Typing (G0 ++ G) θ b T).
  Axiom ctx_regularity :
    forall Γ, Ctx Γ -> forall x ρ0 θ0 A, binds x (ρ0, θ0, A) Γ -> Typing (meet_ctx_l_rho q_R Γ) θ0 A a_TYPE.


  Axiom defeq_same_type : forall G g G0 θ a b A,
      Typing (G0 ++ G) θ a A -> DefEq G g G0 θ a b -> Typing (G0 ++ G) θ b A.

  Axiom defeq_same_type_nil : forall G g  θ a b A,
      Typing G θ a A -> DefEq G g nil θ a b -> Typing G θ b A.

End regularity_sig.

Module Type preservation_sig.
  Axiom typing_implies_ctyping :
    forall Γ θ a A, Typing Γ θ a A -> forall ρ, CTyping Γ (ρ,θ) a A.

  Axiom ind_has_kind_TYPE :
    forall G theta a0 a2 a3 A B0,
      Typing G theta (a_Ind a0 a2 a3 (a_Pi (q_R, t_L) a_Nat A)) B0 ->
      Typing (meet_ctx_l_rho q_R G) theta B0 a_TYPE.

  Axiom preservation_primitive0 :
    forall G θ a b, aBeta G θ a b -> forall A, Typing G θ a A -> Typing G θ b A.

  Axiom preservation_primitive :
  forall G θ a b, aBeta G θ a b -> exists A, (Typing G θ b A /\ Typing G θ a A).

  Axiom coreds_conv_cong :
    forall G θ a b, aCoReds G θ a b ->
                forall g, lc_co g -> aCoReds G θ (a_Conv a g) (a_Conv b g).

  Axiom reds_succ_cong :
    forall G θ a b, aReds G θ a b -> aReds G θ (a_Succ a) (a_Succ b).

  Axiom coreds_succ_cong :
    forall G θ a b, aCoReds G θ a b -> aCoReds G θ (a_Succ a) (a_Succ b).

  Axiom reds_conv_cong :
    forall G θ a b, aReds G θ a b ->
                forall g, lc_co g -> aReds G θ (a_Conv a g) (a_Conv b g).

  Axiom preservation_red :
    forall G θ a b,aRed G θ a b -> forall A, Typing G θ a A -> Typing G θ b A.

  Axiom preservation_reds :
    forall G θ a A, Typing G θ a A -> forall b, aReds G θ a b -> Typing G θ b A.

  Axiom preservation_cored1 :
    forall G θ a b A, Typing G θ a A -> aCoRed G θ a b -> Typing G θ b A.


  Axiom preservation_coreds :
    forall G θ a A, Typing G θ a A -> forall b, aCoReds G θ a b -> Typing G θ b A.

  Axiom reds_app_cong :
    forall G θ a δ0 b,
      aReds G θ a b ->
      forall c, lc_tm c -> aReds G θ (a_App a δ0 c) (a_App b δ0 c).

  Axiom coreds_trans :
    forall b G θ a,
      aCoReds G θ a b ->
      forall c,
        aCoReds G θ b c ->
        aCoReds G θ a c.

  Axiom reds_trans :
    forall b G θ a,
      aReds G θ a b ->
      forall c,
        aReds G θ b c ->
        aReds G θ a c.

  Axiom reds_one :
    forall G A θ a b,
      Typing G θ a A ->
      aRed G θ a b ->
      aReds G θ a b.

  Axiom coreds_one :
    forall G A θ a b,
      Typing G θ a A ->
      aCoRed G θ a b ->
      aCoReds G θ a b.

  Axiom typing_rename :
  forall {G x δ0 A0 θ a A},
    Typing (x ~ (δ0, A0) ++ G) θ a A ->
    forall y,
      y `notin` add x (dom G) ->
      Typing (y ~ (δ0, A0) ++ G) θ (subst_tm (a_Var_f y) x a) (subst_tm (a_Var_f y) x A).

End preservation_sig.

Module Type simulation_sig.
  Axiom simulation_reds :
    forall G1 θ1 a1 A,
      Typing G1 θ1 a1 A ->
      forall a2,
        aReds G1 θ1 a1 a2 ->
        forall G2 θ2  b1 B,
          Typing G2 θ2 b1 B -> erase_tm a1 = erase_tm b1 ->
          exists b2, aReds G2 θ2 b1 b2 /\ erase_tm a2 = erase_tm b2.

  Axiom erase_covalue :
    forall a, CoValue a -> forall b, lc_tm b -> erase_tm a = erase_tm b -> CoValue b.

End simulation_sig.

Module Type LTy_sig.
  Axiom type_in_type_impossible :
    forall Γ, ~ Typing Γ t_L a_TYPE a_TYPE.

  Axiom LTy_subst : forall A, LTy A -> forall x a, lc_tm a -> LTy (subst_tm a x A).

  Axiom ctx_no_tyvar : forall G,
  Ctx G -> forall x ρ0 A,
        binds x (ρ0, t_L, A) G -> A <> a_TYPE.

  Axiom LTy_Pi_inv : forall ρ0 θ0 A1 A2, LTy (a_Pi (ρ0, θ0) A1 A2) ->
                                      forall x, LTy (open_tm_wrt_tm A2 (a_Var_f x)).

  Axiom L_typing_special_form :
    forall Γ A, Typing Γ t_L A a_TYPE -> LTy A.

  Axiom subst_forall_depth :
    forall B, LTy B -> forall x a, lc_tm a -> tm_forall_depth (subst_tm a x B) = tm_forall_depth B.

  Axiom subst_valuation_LTy : forall ξ B, LTy B -> valuation_lc ξ -> LTy (subst_valuation ξ B).

  Axiom subst_valuation_forall_depth :
    forall ξ B, LTy B -> valuation_lc ξ -> tm_forall_depth (subst_valuation ξ B) = tm_forall_depth B.

End LTy_sig.

Module Type consistent_sig.
  Axiom defeq_consist : forall θ g A B, DefEq nil g nil θ A B -> Consistent A B.
  Axiom nil_context_nat_value'  :
    forall a, Value a ->
         forall θ,
           Typing nil θ a a_Nat ->
           exists n, inject_nat n = a.


  Axiom ind_zero_intro :
    forall Γ a0,
      CoValue a0 ->
      aCoReds Γ  t_L  a0 a_Zero ->
      forall θ a2 a3 A,
        Typing Γ θ (a_Ind a0 a2 a3 ((a_Pi  (q_R, t_L)  a_Nat A) )) (open_tm_wrt_tm A a0) ->
        (Joins (context_to_econtext (meet_ctx_l_rho q_R Γ)) (open_tm_wrt_tm A a0) (open_tm_wrt_tm A a_Zero)) /\
          exists γ,
            DefEq (meet_ctx_l_rho q_R Γ) γ nil t_L (open_tm_wrt_tm A a_Zero) (open_tm_wrt_tm A a0) /\
              aRed Γ θ (a_Ind a0 a2 a3 (a_Pi (q_R, t_L) a_Nat A)) (a_Conv a2 γ).

  Axiom ind_succ_intro :
    forall Γ a0 a1,
      CoValue a0 ->
      aCoReds Γ  t_L  a0 (a_Succ a1) ->
      forall θ a2 a3 A,
        Typing Γ θ (a_Ind a0 a2 a3 ((a_Pi  (q_R, t_L)  a_Nat A) )) (open_tm_wrt_tm A a0) ->
        (Joins (context_to_econtext (meet_ctx_l_rho q_R Γ)) (open_tm_wrt_tm A a0) (open_tm_wrt_tm A (a_Succ a1))) /\
          exists γ,
            DefEq (meet_ctx_l_rho q_R Γ) γ nil t_L (open_tm_wrt_tm A (a_Succ a1)) (open_tm_wrt_tm A a0) /\
              aRed Γ θ (a_Ind a0 a2 a3 (a_Pi (q_R, t_L) a_Nat A)) (a_Conv ( (a_App (open_tm_wrt_tm  a3   a1 )   (   q_R  ,   t_L   )   ( (a_Ind a1 a2 a3  ( (a_Pi  (   q_R  ,   t_L   )  a_Nat A) ) ) ) ) ) γ).

  Axiom ind_cong_intro :
    forall Γ a1 b1,
      aRed Γ t_L a1 b1 ->
      Typing Γ t_L a1 a_Nat ->
      forall θ a2 a3 A,
        Typing Γ θ (a_Ind a1 a2 a3 (a_Pi (q_R, t_L) a_Nat A)) (open_tm_wrt_tm A a1) ->
        (Joins (context_to_econtext (meet_ctx_l_rho q_R Γ)) (open_tm_wrt_tm A a1) (open_tm_wrt_tm A b1) /\
           exists γ,
             DefEq (meet_ctx_l_rho q_R Γ) γ nil t_L (open_tm_wrt_tm A b1) (open_tm_wrt_tm A a1) /\
               aRed Γ θ (a_Ind a1 a2 a3 (a_Pi (q_R, t_L) a_Nat A)) (a_Conv (a_Ind b1 a2 a3 (a_Pi (q_R, t_L) a_Nat A)) γ)).

End consistent_sig.

Module Type introalt_sig.
  Axiom pisnd_intro_same_type :
    forall G g theta0 g1 G0 theta B1 a1 B2 a2 rho1 theta1 A,
      theta0  ≤  theta  ->
      DefEq G g G0 theta0  (a_Pi  (rho1 ,  theta1)  A B1)   (a_Pi  (rho1, theta1)  A B2)  ->
      DefEq G g1 G0 theta1 a1 a2 ->
      Typing (G0 ++ G) theta1 a2 A ->
      exists g0,
        DefEq G g0 G0 theta  (open_tm_wrt_tm B1 a1)  (open_tm_wrt_tm B2 a2).

  Axiom ered_intro :
  forall (G:context) (a b:tm) (G0:context) (theta:fragment),
     aBeta  ( G0  ++  G )  theta a b ->
     DefEq G (g_Beta a b) G0 theta a b.

  Axiom cored_defeq_inj :
    forall Γ θ a b,
      aCoRed Γ θ a b ->
      forall A, Typing Γ θ a A ->
           exists g, DefEq Γ g nil θ a b.

  Axiom red_defeq_inj :
    forall Γ θ a b,
      aRed Γ θ a b ->
      forall A, Typing Γ θ a A ->
           exists g, DefEq Γ g nil θ a b.

  Axiom coreds_defeq_inj :
    forall Γ θ a b,
      aCoReds Γ θ a b ->
      forall A,
        Typing Γ θ a A ->
        exists g, DefEq Γ g nil θ a b.

  Axiom reds_defeq_inj :
    forall Γ θ a b,
      aReds Γ θ a b ->
      forall A, Typing Γ θ a A ->
           exists g, DefEq Γ g nil θ a b.
End introalt_sig.
