From LP Require Import sigs lp_ott lp_inf lp_ind lp_labels lp_tactics.
From Hammer Require Import Tactics.
From Ltac2 Require Import Ltac2 Constr Control.
Require Import Coq.Program.Equality.


Module simulation
  (Import lc : lc_sig)
  (Import wff : wff_sig)
  (Import preservation : preservation_sig).
Set Default Proof Mode "Classic".


Lemma erase_tm_open_tm_wrt_tm_rec : forall B a n,
    erase_tm (open_tm_wrt_tm_rec n a B) = open_tm_wrt_tm_rec n (erase_tm a) (erase_tm B).
Proof.
  induction B; try scongruence.
  - simpl.
    intros a n0.
    destruct delta5.
    destruct r.
    simpl.
    scongruence.
    scongruence.
  - intros a n0.
    pose proof (lt_eq_lt_dec n n0) as h.
    hauto lq:on rew:off.
Qed.

Lemma erase_tm_open_tm_wrt_tm : forall B a,
    erase_tm (open_tm_wrt_tm B a) = open_tm_wrt_tm (erase_tm B) (erase_tm a).
Proof.
  hauto use:erase_tm_open_tm_wrt_tm_rec.
Qed.

Lemma erase_tm_lc_tm : forall a,
    lc_tm a -> lc_tm (erase_tm a).
Proof.
  induction 1; eauto.
  - simpl.
    pick fresh x.
    apply (lc_a_EAbs_exists x).
    specialize (H1 x).
    rewrite erase_tm_open_tm_wrt_tm in H1.
    simpl in H1.
    auto.
  - simpl.
    pick fresh x.
    apply (lc_a_EAbs_exists x).
    specialize (H0 x).
    rewrite erase_tm_open_tm_wrt_tm in H0.
    simpl in H0.
    auto.
  - sfirstorder.
  - hauto l:on.
  - sfirstorder.
  - sfirstorder.
  - simpl.
    pick fresh x.
    apply (lc_a_EInd_exists x); auto.
    specialize (H2 x).
    rewrite erase_tm_open_tm_wrt_tm in H2; auto.
  - simpl.
    pick fresh x.
    apply (lc_a_EInd_exists x); auto.
    specialize (H2 x).
    rewrite erase_tm_open_tm_wrt_tm in H2; auto.
Qed.

(* Lemma 3.8 (Simulation (Co)) *)
Lemma cored_simulation :
  forall Γ θ a b,
    aCoRed Γ θ a b ->
    (* -------------------- *)
    erase_tm a = erase_tm b.
Proof.
  intros Γ θ a b.
  induction 1; subst; auto.
  - simpl.
    pick fresh y for (fv_tm (erase_tm a1) \u fv_tm (erase_tm a2) \u fv_tm a1 \u fv_tm a2 \u L); repeat (spec y).
    assert (tr0 : erase_tm (open_tm_wrt_tm a2 (a_Var_f y)) = erase_tm (open_tm_wrt_tm a1 (a_Conv (a_Var_f y) (g_Sym (g_PiFst theta0 g))))) by congruence.
    repeat (rewrite erase_tm_open_tm_wrt_tm in tr0).
    simpl in tr0.
    destruct_notin.
    enough (erase_tm a1 = erase_tm a2) by congruence.
    assert (tr1 : close_tm_wrt_tm y (open_tm_wrt_tm (erase_tm a2) (a_Var_f y)) = close_tm_wrt_tm y (open_tm_wrt_tm (erase_tm a1) (a_Var_f y))) by congruence.
    rewrite close_tm_wrt_tm_open_tm_wrt_tm in tr1; auto.
    rewrite close_tm_wrt_tm_open_tm_wrt_tm in tr1; auto.
  - sfirstorder.
Qed.

Lemma coreds_simulation :
  forall Γ θ a b,
    aCoReds Γ θ a b ->
    erase_tm a = erase_tm b.
Proof.
  induction 1; qauto l:on use:cored_simulation.
Qed.

Definition cerase_tm (ρ : relevance) (a : tm) :=
  if ρ then erase_tm a else a_Hole.

Lemma cerase_tm_lc_tm : forall ρ a,
    lc_tm a -> lc_tm (cerase_tm ρ a).
Proof.
  hauto lq:on ctrs:lc_tm inv:lattice.relevance use:erase_tm_lc_tm.
Qed.

Lemma app_cerase_tm_unsubst :
  forall (ρ0 : relevance) a b,
    (if ρ0 then a_EApp (erase_tm a) (erase_tm b) else a_EApp (erase_tm a) a_Hole) =
      a_EApp (erase_tm a) (cerase_tm ρ0 b).
Proof.
  hauto lq:on.
Qed.

Lemma subst_cerase:
  (forall G θ b B,
      Typing G θ b B ->
      forall K δ0 a A, CTyping K δ0 a A ->
                   forall F x,
                     (G = F ++ (x ~ (δ0, A)) ++ K) ->
                     forall ρ0 θ0, δ0 = (ρ0,θ0) ->
                                subst_tm (erase_tm a) x (erase_tm b) =
                                  subst_tm (cerase_tm ρ0 a) x (erase_tm b)) /\
    (forall G g G0 θ B0 B1,
        DefEq G g G0 θ B0 B1 -> True) /\
    (forall G, Ctx G -> True) /\
    (forall G θ b1 b2, aBeta G θ b1 b2 -> True) /\
    (forall G δ b B, CTyping G δ b B ->
                 forall K δ0 a A, CTyping K δ0 a A ->
                              forall F x,
                                (G = F ++ (x ~ (δ0, A)) ++ K) ->
                                forall ρ0 θ0, δ0 = (ρ0,θ0)  ->
                                           forall ρ1 θ1, δ = (ρ1,θ1) -> if ρ1 then subst_tm (erase_tm a) x (erase_tm b) =
                                                                                      subst_tm (cerase_tm ρ0 a) x (erase_tm b) else True ).
Proof.
  apply typing_mutual; eauto.
  - intros; subst.
    assert (tr0: uniq (F ++ x0 ~ (ρ0, θ0, A0) ++ K)) by sfirstorder use:Ctx_uniq.
    assert (tr1: uniq (x0 ~ (ρ0, θ0, A0) ++ K)) by sfirstorder use:uniq_app_iff.
    apply binds_app_uniq_iff in b.
    destruct b; split_hyp; subst.
    + simpl.
      destruct (x == x0).
      destruct_notin.
      assert (x <> x0) by auto.
      congruence.
      reflexivity.
    + apply binds_app_uniq_iff in H1; auto.
      destruct H1; split_hyp.
      simpl.
      apply binds_one_iff in H1; split_hyp; subst.
      rewrite eq_dec_refl.
      inversion H4; subst.
      reflexivity.
      simpl.
      destruct (x == x0); subst; auto.
      simpl in H3.
      fsetdec.
    + auto.
  - intros; subst.
    simpl.
    pick fresh y for
               (L \u fv_tm (subst_tm (cerase_tm ρ0 a) x (erase_tm b)) \u fv_tm (subst_tm (erase_tm a) x (erase_tm b)) \u fv_tm a \u fv_tm b \u {{x}});
     repeat (spec y).
    specialize (H2 K (ρ0, θ0) a A0 ltac:(auto) (y ~ (delta0, A) ++ F) x ltac:(simpl_env; auto) _ _ ltac:(reflexivity)).
    rewrite erase_tm_open_tm_wrt_tm in H2.
    simpl in H2.
    rewrite subst_tm_open_tm_wrt_tm in H2; auto.
    rewrite subst_tm_open_tm_wrt_tm in H2; auto.
    simpl in H2.
    pose (y == x) as q.
    replace (y == x) with q in H2; auto.
    destruct q; subst.
    fsetdec.
    assert (h2 : close_tm_wrt_tm y (open_tm_wrt_tm (subst_tm (erase_tm a) x (erase_tm b)) (a_Var_f y)) =
                   close_tm_wrt_tm y (open_tm_wrt_tm (subst_tm (cerase_tm ρ0 a) x (erase_tm b)) (a_Var_f y))) by congruence.
    rewrite close_tm_wrt_tm_open_tm_wrt_tm in h2; auto.
    rewrite close_tm_wrt_tm_open_tm_wrt_tm in h2; auto.
    rewrite h2.
    reflexivity.

    hauto lq:on rew:off use:ctyping_lc1, cerase_tm_lc_tm.
    hauto lq:on rew:off use:ctyping_lc1, erase_tm_lc_tm.
  - hauto lq:on rew:off.
  - hauto lq:on rew:off.
  - intros; subst.
    simpl.
    f_equal; eauto.
    pick fresh y for (L \u {{x}} \u fv_tm (subst_tm (cerase_tm ρ0 a) x (erase_tm a3)) \u fv_tm (  subst_tm (erase_tm a) x (erase_tm a3))); repeat (spec y).
    specialize (H4 K (ρ0, θ0) a A0 H3 (y ~ (q_R, t_L, a_Nat) ++ F) x ltac:(simpl_env; auto) ρ0 θ0 ltac:(reflexivity)).
    rewrite erase_tm_open_tm_wrt_tm in H4.
    simpl in H4.
    rewrite subst_tm_open_tm_wrt_tm in H4; auto.
    rewrite subst_tm_open_tm_wrt_tm in H4; auto.
    simpl in H4.
    pose (y == x) as q.
    replace (y == x) with q in H4; auto.
    destruct q; subst; auto.
    fsetdec.
    assert (h00 : close_tm_wrt_tm y (open_tm_wrt_tm (subst_tm (erase_tm a) x (erase_tm a3)) (a_Var_f y)) =
                    close_tm_wrt_tm y (open_tm_wrt_tm (subst_tm (cerase_tm ρ0 a) x (erase_tm a3)) (a_Var_f y))) by congruence; auto.
    rewrite close_tm_wrt_tm_open_tm_wrt_tm in h00; auto.
    rewrite close_tm_wrt_tm_open_tm_wrt_tm in h00; auto.
    hauto lq:on rew:off use:ctyping_lc1, cerase_tm_lc_tm.
    hauto lq:on rew:off use:ctyping_lc1, erase_tm_lc_tm.
  - sauto lq:on rew:off.
  - sauto lq:on rew:off.
Qed.

Lemma typing_subst_cerase :
  forall F x ρ0 θ0 A K θ b B,
    Typing (F ++ (x ~ (ρ0, θ0, A)) ++ K) θ b B ->
    forall a, CTyping K (ρ0, θ0) a A ->
           subst_tm (erase_tm a) x (erase_tm b) =
             subst_tm (cerase_tm ρ0 a) x (erase_tm b).
Proof.
  hauto l:on use:subst_cerase.
Qed.


Lemma typing_subst_cerase_nil :
  forall x ρ0 θ0 A K θ b B,
    Typing ((x ~ (ρ0, θ0, A)) ++ K) θ b B ->
    forall a, CTyping K (ρ0, θ0) a A ->
           subst_tm (erase_tm a) x (erase_tm b) =
             subst_tm (cerase_tm ρ0 a) x (erase_tm b).
Proof.
  specialize typing_subst_cerase with (F := nil); sfirstorder.
Qed.

(* Lemma 3.9 (Simulation) *)
Lemma red_simulation :
  forall Γ θ a b,
    aRed Γ θ a b ->
    forall A,
    Typing Γ θ a A ->
    (* ---------------------------- *)
    ERed (erase_tm a) (erase_tm b).
Proof.
  induction 1; intros A0 ha.
  - inversion ha; subst.
    assert (t_abs : Typing G theta (a_Abs delta0 A a1) (a_Pi delta0 A1 B))
      by sfirstorder use:preservation_coreds.
    assert (lc_abs : lc_tm (a_Abs delta0 A a1))
      by hauto lq:on use:typing_lc1.
    destruct delta0 as [ρ0 θ0].
    assert (h_eaeq : erase_tm (a_Abs (ρ0, θ0) A a1) = erase_tm a)
      by hauto lq:on use:coreds_simulation.
    assert (lc_ea : lc_tm (erase_tm a))
      by qauto l:on use:erase_tm_lc_tm.
    assert (lc_b : lc_tm b)
      by hauto l:on use:ctyping_lc1.
    assert (lc_eb : lc_tm (cerase_tm ρ0 b))
      by hauto l:on use:cerase_tm_lc_tm.
    simpl.
    rewrite -> app_cerase_tm_unsubst.
    rewrite <- h_eaeq.
    (* intros h_ered. *)
    (* inversion h_ered; subst. *)
    rewrite erase_tm_open_tm_wrt_tm.
    inversion t_abs; subst.
    replace (open_tm_wrt_tm (erase_tm a1) (erase_tm b)) with
      (open_tm_wrt_tm (erase_tm a1) (cerase_tm ρ0 b)).
    eapply ER_AppAbs; eauto.
    scongruence.
    pick fresh x for (fv_tm (erase_tm a1) \u L); repeat (spec x); auto.
    rewrite (subst_tm_intro x _ (erase_tm b)); auto.
    rewrite (subst_tm_intro x _ (cerase_tm ρ0 b)); auto.
    change (a_Var_f x) with (erase_tm (a_Var_f x)).
    rewrite <- erase_tm_open_tm_wrt_tm.
    qauto l:on use:typing_subst_cerase_nil.
  - destruct delta0 as [ρ0 θ0].
    assert (lc_eb : lc_tm (erase_tm b))
             by sfirstorder use:erase_tm_lc_tm.
    destruct ρ0; simpl in *; sauto.
  - sauto lq:on use:erase_tm_lc_tm, cerase_tm_lc_tm.
  - sauto lq:on use:erase_tm_lc_tm, cerase_tm_lc_tm.
  - simpl.
    assert (tr00 : Typing G t_L a0 a_Nat) by sauto lq:on inv:Typing.
    assert (tr0: erase_tm a0 = a_Succ (erase_tm a1)) by sauto lq:on use:coreds_simulation.
    rewrite tr0.
    rewrite erase_tm_open_tm_wrt_tm.
    assert (tr1 : lc_tm (a_Ind (a_Succ a1) a2 a3 (a_Pi (q_R, t_L) a_Nat A))) by hauto l:on use:lc_mutual.
    assert (tr2 : lc_tm (erase_tm (a_Ind (a_Succ a1) a2 a3 (a_Pi (q_R, t_L) a_Nat A)))) by hauto l:on use:erase_tm_lc_tm.
    simpl in tr2.
    qauto l:on use:ER_IndSucc inv:lc_tm.
  - simpl.
    assert (tr00 : Typing G t_L a1 a_Nat) by sauto lq:on inv:Typing.
    assert (tr0: erase_tm a1 = a_Zero) by sauto lq:on use:coreds_simulation.
    rewrite tr0.
    assert (tr1 : lc_tm (a_Ind a_Zero a2 a3 (a_Pi (q_R, t_L) a_Nat A))) by hauto l:on use:lc_mutual.
    assert (tr2 : lc_tm (erase_tm (a_Ind a_Zero a2 a3 (a_Pi (q_R, t_L) a_Nat A)))) by hauto l:on use:erase_tm_lc_tm.
    simpl in tr2.
    qauto l:on use:ER_IndZero inv:lc_tm.
  - assert (tr0 : Typing G t_L a1 a_Nat) by hauto l:on rew:off inv:Typing.
    assert (tr1 : lc_tm (a_Ind a1 a2 a3 (a_Pi (q_R, t_L) a_Nat A))) by hauto l:on use:lc_mutual.
    assert (tr2 : lc_tm (erase_tm (a_Ind a1 a2 a3 (a_Pi (q_R, t_L) a_Nat A)))) by hauto l:on use:erase_tm_lc_tm.
    simpl in tr2.
    specialize (IHaRed a_Nat ltac:(auto)).
    simpl.
    apply ER_Ind; eauto;
    hauto lq:on inv:lc_tm.
Qed.

End simulation.
