From LP Require Import lp_ott lp_inf.
Require Import Coq.micromega.Lia.
From Equations Require Import Equations.
From Hammer Require Import Tactics.
Require Import List.

(* Check this thread (and also cpdt) to get mutual recursion to work:
https://coq.discourse.group/t/mutual-recursion-with-function-unfolding/869/2
Equations still does not support wf relation on mutually recursive
definitions *)

Inductive interp_type :=
| V
| C.

Definition SN_metric (i_type : interp_type) (θ : fragment) A :=
  if θ
  then
    (if i_type then 2 * size_tm (A) else 2 * size_tm ( A) + 1)
  else 0.

(* TODO: move to a more proper place *)
(* Lemma erase_tm_open_tm_wrt_tm_rec : forall B a n, *)
(*     erase_tm (open_tm_wrt_tm_rec n a B) = open_tm_wrt_tm_rec n (erase_tm a) (erase_tm B). *)
(* Proof. *)
(*   induction B; try scongruence. *)
(*   simpl. *)
(*   intros a n0. *)
(*   pose proof (lt_eq_lt_dec n n0) as h. *)
(*   hauto lq:on rew:off. *)
(* Qed. *)

Equations? SN (i_type : interp_type) (θ : fragment) (A : tm) (ξ : valuation) : tm -> Prop by
  wf (SN_metric i_type θ A) lt :=
  SN _ t_P A ξ a := Typing nil t_P a (subst_valuation ξ A);
  SN V t_L (a_Eq θ0 A B) ξ a :=
    CoValue a /\
    Typing nil t_L a (subst_valuation ξ (a_Eq θ0 A B)) /\
      Joins nil (subst_valuation ξ A) (subst_valuation ξ B);
  SN V t_L (a_Pi (ρ0, θ0) A B) ξ b :=
    Typing nil t_L b (subst_valuation ξ (a_Pi (ρ0, θ0) A B)) /\
      CoValue b /\
      (exists b1, aCoReds nil t_L b (a_Abs (ρ0, θ0) (subst_valuation ξ A) b1) /\
              forall a, SN C θ0 A ξ a ->
                   exists L, forall x, x `notin` L ->
                             SN C t_L (open_tm_wrt_tm B (a_Var_f x)) (x~ a ++ ξ) (open_tm_wrt_tm b1 a));
  SN V t_L a_TYPE ξ a :=
    (* of course it is equal to a_TYPE but keeping a_TYPE in such a *)
  (*   form makes the proof easier *)
    CoValue a /\
    Typing nil t_L a (subst_valuation ξ a_TYPE);
  SN V t_L a_Nat ξ a :=
    CoValue a /\
      Typing nil t_L a a_Nat /\
      exists v, aCoReds nil t_L a v /\ Value v;
  SN C t_L A ξ a :=
    Typing nil t_L a (subst_valuation ξ A) /\
      exists v, SN V t_L A ξ v /\ aReds nil t_L a v;
  (* (* We will never hit this case *) *)
  SN _ _ _ _ _ := False.
Proof.
  - destruct θ0; simpl; lia.
  -
replace (open_tm_wrt_tm B (a_Var_f x)) with (open_tm_wrt_tm_rec 0 (a_Var_f x) B); auto.
    rewrite -> size_tm_open_tm_wrt_tm_rec_var.
    lia.
  - lia.
Qed.

Inductive valuation_wff : valuation -> context -> Prop :=
| valuation_empty : valuation_wff nil nil
| valuation_cons : forall x a ξ ρ0 θ0 A Γ,
    SN C θ0 A ξ a ->
    valuation_wff ξ Γ ->
    valuation_wff (x ~ a ++ ξ) (x ~ ((ρ0,θ0), A) ++ Γ).

(* Definition 4.12 *)
Definition SemTyping (Γ : context) (θ : fragment) (a : tm) (A : tm) :=
  forall ξ, valuation_wff ξ Γ -> SN C θ A ξ (subst_valuation ξ a).

(* Definition 4.13 *)
Definition SemDefEq (Γ Γ0 : context) (a b : tm) : Prop :=
  forall ξ, valuation_wff ξ Γ ->
        Joins (context_to_econtext Γ0) (subst_valuation ξ a) (subst_valuation ξ b).

#[export] Hint Constructors valuation_wff : core.
