From LP Require Import lp_ott lp_inf lp_labels lp_ind lp_tactics sn_def sigs forall_depth_inf.
Require Import Coq.micromega.Lia.
From Hammer Require Import Tactics.
From Equations Require Import Equations.
Require Import Coq.Program.Equality.
From Ltac2 Require Import Ltac2.
Set Default Proof Mode "Classic".

Module normalization
  (Import introalt : introalt_sig)
  (Import narrow : typing_narrowing_sig)
  (Import lc : lc_sig)
  (Import fv : typing_fv_sig)
  (Import wff : wff_sig)
  (Import regularity : regularity_sig)
  (Import par : par_sig)
  (Import subst : subst_sig)
  (Import preservation : preservation_sig)
  (Import unique : unique_sig)
  (Import lty : LTy_sig)
  (Import subsumption : subsumption_sig) <: consistent_sig.

Lemma subst_valuation_eabs : forall ξ a, subst_valuation ξ (a_EAbs a) = a_EAbs (subst_valuation ξ a).
  induction ξ; qauto l:on.
Qed.

Lemma subst_valuation_eapp : forall ξ a b, subst_valuation ξ (a_EApp a b) = a_EApp (subst_valuation ξ a) (subst_valuation ξ b).
  induction ξ; qauto l:on.
Qed.

Lemma subst_valuation_hole : forall ξ, subst_valuation ξ a_Hole = a_Hole.
  induction ξ; qauto l:on.
Qed.

Lemma subst_valuation_abs : forall ξ ρ A b, subst_valuation ξ (a_Abs ρ A b) = a_Abs ρ (subst_valuation ξ A) (subst_valuation ξ b).
  induction ξ; qauto l:on.
Qed.

Lemma subst_valuation_app : forall ξ b ρ a,
    subst_valuation ξ (a_App b ρ a) = a_App (subst_valuation ξ b) ρ (subst_valuation ξ a).
induction ξ; qauto l:on.
Qed.

Lemma subst_valuation_conv : forall ξ a g, subst_valuation ξ (a_Conv a g) = a_Conv (subst_valuation ξ a) (subst_valuation_co ξ g).
  induction ξ; qauto l:on.
Qed.

Lemma subst_valuation_pi : forall ξ ρ A B, subst_valuation ξ (a_Pi ρ A B) = a_Pi ρ (subst_valuation ξ A) (subst_valuation ξ B).
  induction ξ; qauto l:on.
Qed.

Lemma subst_valuation_type : forall ξ, subst_valuation ξ a_TYPE = a_TYPE.
  induction ξ; hauto lq:on.
Qed.


Lemma subst_valuation_eq : forall ξ θ A B, subst_valuation ξ (a_Eq θ A B) = a_Eq θ (subst_valuation ξ A) (subst_valuation ξ B).
  induction ξ; hauto lq:on.
Qed.

Lemma subst_valuation_reify : forall ξ θ g,
    subst_valuation ξ (a_Reify θ g) = a_Reify θ (subst_valuation_co ξ g).
  induction ξ; hauto q:on.
Qed.

Lemma subst_valuation_a_var_b : forall ξ n,
    subst_valuation ξ (a_Var_b n) = a_Var_b n.
Proof.
  induction ξ; qauto l:on.
Qed.

Lemma subst_valuation_nat : forall ξ,
    subst_valuation ξ a_Nat = a_Nat.
Proof.
  induction ξ; qauto l:on.
Qed.

Lemma subst_valuation_zero : forall ξ,
    subst_valuation ξ a_Zero = a_Zero.
Proof.
  induction ξ; qauto l:on.
Qed.

Lemma subst_valuation_succ : forall ξ a,
    subst_valuation ξ (a_Succ a) = a_Succ (subst_valuation ξ a).
Proof.
  induction ξ; qauto l:on.
Qed.

Lemma subst_valuation_ind : forall ξ a1 a2 a3 A,
    subst_valuation ξ (a_Ind a1 a2 a3 A) =
      a_Ind
        (subst_valuation ξ a1)
        (subst_valuation ξ a2)
        (subst_valuation ξ a3)
        (subst_valuation ξ A).
Proof.
  induction ξ; qauto l:on.
Qed.

Lemma subst_valuation_eind : forall ξ a1 a2 a3,
    subst_valuation ξ (a_EInd a1 a2 a3) =
      a_EInd
        (subst_valuation ξ a1)
        (subst_valuation ξ a2)
        (subst_valuation ξ a3).
Proof.
  induction ξ; qauto l:on.
Qed.

Create HintDb subst_valuation.
#[export]Hint Rewrite -> subst_valuation_abs subst_valuation_app subst_valuation_conv subst_valuation_pi subst_valuation_type subst_valuation_eq subst_valuation_reify subst_valuation_a_var_b subst_valuation_hole subst_valuation_eabs subst_valuation_eapp subst_valuation_nat subst_valuation_zero subst_valuation_succ subst_valuation_ind subst_valuation_eind : subst_valuation.

Create HintDb subst_valuation_backward.
#[export]Hint Rewrite <- subst_valuation_abs subst_valuation_app subst_valuation_conv subst_valuation_pi subst_valuation_type subst_valuation_eq subst_valuation_reify subst_valuation_a_var_b subst_valuation_hole subst_valuation_eabs subst_valuation_eapp subst_valuation_app subst_valuation_zero subst_valuation_succ subst_valuation_ind subst_valuation_eind : subst_valuation_backward.

Lemma valuation_closed_app (ξ1 ξ2 : valuation) : valuation_closed (ξ1 ++ ξ2) -> valuation_closed ξ1 /\ valuation_closed ξ2.
Proof.
  hauto use: binds_app_r, binds_app_l unfold: tmvar, valuation_closed, valuation.
Qed.

Lemma valuation_closed_app3 (ξ0 ξ1 ξ2 : valuation) : valuation_closed (ξ0 ++ ξ1 ++ ξ2) -> valuation_closed ξ0 /\ valuation_closed ξ1 /\ valuation_closed ξ2.
Proof.
  hauto l:on use:valuation_closed_app.
Qed.

Lemma type_level_app_impossible :
  forall Γ a δ0 b, ~ Typing Γ t_L (a_App a δ0 b) a_TYPE.
Proof.
  hauto lq:on inv:LTy use:L_typing_special_form.
Qed.

Lemma Typing_CLTy :
  forall Γ θ A, Typing Γ θ A a_TYPE -> CLTy θ A.
Proof.
  hauto inv:lattice.fragment  use:L_typing_special_form db:lc.
Qed.

(* Lemma 4.7 *)
Lemma SN_typing : forall t θ A ξ a,
    SN t θ A ξ a ->
    (* --------------------------------- *)
    Typing nil θ a (subst_valuation ξ A).
Proof.
  destruct A; destruct θ; destruct t; intros;
    hauto l:on rew:db:SN,subst_valuation.
Qed.

(* Lemma 4.8 *)
Lemma SN_subsumption : forall t θ0 θ1 A ξ a,
    θ0 ≤ θ1 ->
    SN t θ0 A ξ a ->
    (* ------------ *)
    SN t θ1 A ξ a.
Proof.
  intros.
  destruct θ0; destruct θ1; auto.
  - apply SN_typing in H0.
    simp SN.
    sfirstorder use: typing_subsumption.
  - sauto q:on.
Qed.

Lemma SN_fv_empty : forall t θ A ξ a,
    SN t θ A ξ a ->
    fv_tm a [=] empty.
Proof.
  sauto lq:on use:SN_typing, typing_empty_fv1.
Qed.

#[local]Hint Resolve SN_typing SN_fv_empty : core.

Lemma SN_V_is_SN_C : forall θ A ξ a,
    lc_tm a ->
    SN V θ A ξ a ->
    SN C θ A ξ a.
Proof.
  intros [|] A ξ a h1 h2; auto.
  assert (SN_graph V t_L A ξ a (SN V t_L A ξ a)).
  apply SN_graph_correct.
  dependent induction X using SN_graph_rect; try contradiction; intros; simp SN; hauto l:on rew:db:SN.
Qed.

Lemma SN_V_is_covalue : forall A ξ v,
    lc_tm v ->
    SN V t_L A ξ v ->
    CoValue v.
Proof.
  intros A ξ v h h0.
  destruct A; ltac2:(inv_atom_rel_tm); try hauto l:on rew:db:SN.
Qed.

Fixpoint embed_nat (a : tm) : option nat :=
  match a with
  | a_Zero => Some 0
  | a_Succ a => option_map S (embed_nat a)
  | _ => None
  end.

(* This version seems easier to use *)
Lemma nil_context_nat_value'  :
  forall a, Value a ->
       forall θ,
         Typing nil θ a a_Nat ->
         exists n, inject_nat n = a.
Proof.
  induction 1; intros θ h_t; try solve [inversion h_t].
  - exists 0.
    auto.
  - specialize (IHValue θ ltac:(hauto l:on inv:Typing)).
    destruct IHValue as [n hn].
    exists (S n).
    sfirstorder.
Qed.

Lemma inj_nat_value :
  forall n, Value (inject_nat n).
Proof.
  induction n; sfirstorder.
Qed.

Lemma inj_nat_typing_nil :
  forall θ n, Typing nil θ (inject_nat n) a_Nat.
  induction n; sfirstorder.
Qed.

Lemma inj_nat_lc :
  forall n, lc_tm (inject_nat n).
  hauto l:on use:inj_nat_typing_nil,lc_mutual.
Qed.

Lemma inj_nat_fv_tm :
  forall n, fv_tm (inject_nat n) [=] empty.
Proof.
  induction n; simpl in *; fsetdec.
Qed.

Lemma nil_context_nat_value :
  forall a, Value a ->
       forall θ,
         Typing nil θ a a_Nat ->
         exists n, embed_nat a = Some n.
Proof.
  induction 1; intros θ h_t; try solve [inversion h_t].
  - sfirstorder.
  - hauto q:on inv:Typing.
Qed.

Lemma valuation_lc_one :
  forall x a, lc_tm a -> valuation_lc (x ~ a).
Proof.
  qauto use: binds_one_iff unfold: valuation_lc.
Qed.

Lemma valuation_lc_app_intro :
  forall ξ0 ξ1, valuation_lc ξ0 -> valuation_lc ξ1 -> valuation_lc (ξ0 ++ ξ1).
Proof.
  qauto use: binds_app_iff unfold: valuation_lc.
Qed.

Lemma valuation_lc_cons :
  forall x a ξ, lc_tm a -> valuation_lc ξ -> valuation_lc ( x ~ a ++ ξ).
Proof.
  hauto lq:on use:valuation_lc_one, valuation_lc_app_intro.
Qed.

(* Lemma 4.10 (Narrowing(Valuation)) *)
Lemma valuation_meet_ctx_l :
  forall ξ Γ, valuation_wff ξ Γ ->
         (* ---------------- *)
         valuation_wff ξ (meet_ctx_l_rho q_R Γ).
Proof.
  induction 1; simpl; eauto.
  constructor; auto.
Qed.

Lemma valuation_meet_ctx_l2 :
  forall ξ Γ, valuation_wff ξ (meet_ctx_l_rho q_R Γ) -> valuation_wff ξ Γ.
Proof.
  intros ξ Γ H.
  dependent induction H; simpl;
  sauto.
Qed.

Ltac2 notin_empty_fv () :=
  lazy_match! goal with
  | [ h3 : fv_tm ?a [=] empty |- ?x `notin` fv_tm ?a] =>
      let h3_c := Control.hyp h3 in
      rewrite $h3_c;
      auto
  end.

Tactic Notation "notinemptyfv" := ltac2:(notin_empty_fv ()).

Ltac2 gen_uniq_from_typing () :=
  lazy_match! goal with
  | [h : Typing ?g _ _ _ |- _] =>
      let h1 := Fresh.in_goal @h in
      assert ($h1 : uniq $g) by (eapply typing_wff in $h) ; eauto using Ctx_uniq
  end.

Lemma valuation_wff_same_dom : forall ξ Γ, valuation_wff ξ Γ -> dom ξ = dom Γ.
Proof.
  induction 1; eauto.
  hauto lq:on.
Qed.

Tactic Notation "uniqfromtyping" :=
  ltac2:(gen_uniq_from_typing ()).


Lemma valuation_closed_one :
  forall x a, fv_tm a [=] empty -> valuation_closed (x ~ a).
Proof.
  qauto use: binds_one_iff unfold: valuation_closed.
Qed.

Lemma valuation_closed_app_intro :
  forall ξ0 ξ1, valuation_closed ξ0 -> valuation_closed ξ1 -> valuation_closed (ξ0 ++ ξ1).
Proof.
  qauto use: binds_app_iff unfold: valuation_closed.
Qed.

Lemma valuation_closed_cons :
  forall x a ξ, fv_tm a [=] empty -> valuation_closed ξ -> valuation_closed ( x ~ a ++ ξ).
Proof.
  hauto lq:on use:valuation_closed_one, valuation_closed_app_intro.
Qed.

Lemma valuation_wff_no_fv : forall ξ Γ, valuation_wff ξ Γ -> valuation_closed ξ.
Proof.
  induction 1; intros.
  - sfirstorder.
  - apply valuation_closed_cons.
    hauto l:on use:SN_fv_empty.
    auto.
Qed.

#[local]Hint Resolve valuation_wff_no_fv : core.

Lemma binds_gamma_valuation :
  forall ξ Γ, valuation_wff ξ Γ -> forall x s , binds x s Γ -> exists a, binds x a ξ.
Proof.
  induction 1; intros; auto.
  inversion H.
  destruct (x0 == x); subst.
  - exists a; auto.
  - sfirstorder.
Qed.

Lemma binds_valuation_gamma :
  forall ξ Γ, valuation_wff ξ Γ -> forall x a , binds x a ξ -> exists s, binds x s Γ.
Proof.
  induction 1; intros; auto.
  inversion H.
  destruct (x0 == x); subst.
  - exists (ρ0, θ0, A); auto.
  - enough (binds x0 a0 ξ) by hauto l:on.
    apply binds_app_iff in H1.
    destruct H1.
    apply binds_one_iff in H1.
    split_hyp.
    congruence.
    assumption.
Qed.

Lemma subst_tm_valuation_commute : forall ξ x,
    valuation_closed ξ ->
    x `notin` dom ξ ->
    forall a,
      fv_tm a [=] empty ->
      forall b,
    subst_tm a x (subst_valuation ξ b) = subst_valuation ξ (subst_tm a x b).
Proof.
  induction ξ; intros; auto.
  destruct a as [x0 a].
  simpl.
  enough (h0 : subst_tm a0 x (subst_tm a x0 (subst_valuation ξ b)) = subst_tm a x0 (subst_tm a0 x (subst_valuation ξ b))); auto.
  rewrite h0.
  rewrite IHξ; eauto. sfirstorder.
  rewrite subst_tm_subst_tm; eauto.
  - replace (subst_tm a0 x a) with a; eauto.
    assert (fv_tm a [=] empty); eauto.
    rewrite subst_tm_fresh_eq; eauto.
    fsetdec.
  - rewrite H1; auto.
Qed.

Lemma subst_valuation_commute :
  forall ξ1 ξ2, disjoint ξ1 ξ2 -> valuation_closed ξ1 -> valuation_closed ξ2 ->
             forall a, subst_valuation ξ1 (subst_valuation ξ2 a) = subst_valuation ξ2 (subst_valuation ξ1 a).
Proof.
  induction ξ1; intros; auto.
  destruct a as [x a].
  simpl.
  rewrite IHξ1; eauto.
  rewrite subst_tm_valuation_commute; eauto.
  strivial use: disjoint_cons_l, disjoint_cons_1.
  strivial use: disjoint_cons_l.
  sfirstorder.
Qed.

Definition subst_valuation_ctx (ξ : valuation) : context -> context :=
  map (fun '(δ0, A) => (δ0, subst_valuation ξ A)).

Lemma subst_valuation_ctx_nil :
  forall Γ, subst_valuation_ctx nil Γ = Γ.
  induction Γ; sauto.
Qed.

Lemma subst_valuation_concat :
  forall ξ1 ξ2 a, subst_valuation ξ1 (subst_valuation ξ2 a) = subst_valuation (ξ1 ++ ξ2) a.
Proof.
  sfirstorder use:fold_right_app.
Qed.

Lemma subst_valuation_ctx_app ξ0 ξ1 Γ :
  subst_valuation_ctx (ξ0 ++ ξ1) Γ = subst_valuation_ctx ξ0 (subst_valuation_ctx ξ1 Γ).
Proof.
  induction Γ; eauto.
  hauto lq:on use:fold_right_app, subst_valuation_concat unfold:subst_valuation_ctx.
Qed.

Lemma subst_valuation_one : forall x a Γ0,
    subst_valuation_ctx (x ~ a) Γ0 = subst_ctx a x Γ0.
Proof.
  induction Γ0; eauto.
Qed.

Lemma subst_valuation_ctx_app2 ξ Γ0 Γ1 :
  subst_valuation_ctx ξ (Γ0 ++ Γ1) = subst_valuation_ctx ξ Γ0 ++ subst_valuation_ctx ξ Γ1.
Proof.
  sfirstorder use:map_app unfold:subst_valuation_ctx.
Qed.

#[local]Hint Resolve subst_valuation_ctx_nil : core.

Lemma subst_valuation_abeta :
  forall Γ ξ,
    valuation_wff ξ Γ ->
    forall Γ0 θ a A,
      aBeta (Γ0 ++ Γ) θ a A ->
      aBeta (subst_valuation_ctx ξ Γ0)
        θ
        (subst_valuation ξ a)
        (subst_valuation ξ A).
Proof.
  induction 1; eauto.
  - intros Γ0 θ a A h0.
    simpl.
    rewrite app_nil_2 in h0.
    rewrite -> subst_valuation_ctx_nil; auto.
  - intros Γ0 θ a0 A0 h0.
    assert (h1 : aBeta (subst_valuation_ctx ξ (Γ0 ++ x ~ (ρ0, θ0, A))) θ (subst_valuation ξ a0) (subst_valuation ξ A0) ).
    eapply IHvaluation_wff; eauto.
    rewrite app_assoc; eauto.

    simpl.
    simpl_env.

    rewrite subst_valuation_ctx_app.
    rewrite subst_valuation_one.

    apply abeta_substc_nil2 with (A := subst_valuation ξ A) (δ0 := (ρ0, θ0)).
    rewrite -> subst_valuation_ctx_app2 in h1.
    assumption.
    destruct θ0.
    + simp SN in H.
      split_hyp.
      hauto l:on use:typing_implies_ctyping.
    + simp SN in H.
      split_hyp.
      hauto l:on use:typing_implies_ctyping.
Qed.

Lemma subst_valuation_empty_aux :
  forall Γ ξ,
    valuation_wff ξ Γ ->
    forall Γ0 θ a A,
      Typing (Γ0 ++ Γ) θ a A ->
      Typing (subst_valuation_ctx ξ Γ0)
        θ
        (subst_valuation ξ a)
        (subst_valuation ξ A).
Proof.
  induction 1; eauto.
  - intros Γ0 θ a A h0.
    simpl.
    rewrite app_nil_2 in h0.
    rewrite -> subst_valuation_ctx_nil; auto.
  - intros Γ0 θ a0 A0 h0.
    assert (h1 : Typing (subst_valuation_ctx ξ (Γ0 ++ x ~ (ρ0, θ0, A))) θ (subst_valuation ξ a0) (subst_valuation ξ A0) ).
    eapply IHvaluation_wff; eauto.
    rewrite app_assoc; eauto.

    simpl.
    simpl_env.

    rewrite subst_valuation_ctx_app.
    rewrite subst_valuation_one.
    apply typing_substc_nil2 with (A := subst_valuation ξ A) (δ0 := (ρ0, θ0)).
    rewrite -> subst_valuation_ctx_app2 in h1.
    assumption.
    destruct θ0.
    + simp SN in H.
      split_hyp.
      hauto l:on use:typing_implies_ctyping.
    + simp SN in H.
      split_hyp.
      hauto l:on use:typing_implies_ctyping.
Qed.

Lemma subst_valuation_empty :
  forall Γ ξ,
    valuation_wff ξ Γ ->
    forall θ a A,
      Typing Γ θ a A ->
      Typing nil θ (subst_valuation ξ a) (subst_valuation ξ A).
Proof.
  intros Γ ξ H θ a A H1.
  eapply subst_valuation_empty_aux in H; eauto.
  assert (h0: subst_valuation_ctx ξ nil = nil).
  eauto.
  rewrite h0 in H.
  eassumption.
  eauto.
Qed.

Lemma subst_valuation_empty_defeq_aux :
  forall Γ ξ,
    valuation_wff ξ Γ ->
    forall Γ0 θ g A B,
      DefEq (Γ0 ++ Γ) g nil θ A B ->
      DefEq (subst_valuation_ctx ξ Γ0)
        (subst_valuation_co ξ g)
        nil
        θ
        (subst_valuation ξ A)
        (subst_valuation ξ B).
Proof.
  induction 1; eauto.
  - intros Γ0 θ g A B h0.
    simpl.
    rewrite app_nil_2 in h0.
    rewrite -> subst_valuation_ctx_nil; auto.
  - intros Γ0 θ g A0 B0 h0.
    assert (h1 : DefEq (subst_valuation_ctx ξ (Γ0 ++ x ~ (ρ0, θ0, A))) (subst_valuation_co ξ g) nil θ (subst_valuation ξ A0) (subst_valuation ξ B0) ).
    eapply IHvaluation_wff; eauto.
    rewrite app_assoc; eauto.
    simpl.
    simpl_env.

    rewrite subst_valuation_ctx_app.
    rewrite subst_valuation_one.
    apply defeq_substc_nil2 with (A := subst_valuation ξ A) (δ0 := (ρ0, θ0)).
    rewrite -> subst_valuation_ctx_app2 in h1.
    assumption.
    destruct θ0.
    + simp SN in H.
      split_hyp.
      hauto l:on use:typing_implies_ctyping.
    + simp SN in H.
      split_hyp.
      hauto l:on use:typing_implies_ctyping.
Qed.

Lemma subst_valuation_empty_defeq :
  forall Γ g θ A B,
    DefEq Γ g nil θ A B ->
    forall ξ,
      valuation_wff ξ Γ ->
      DefEq nil (subst_valuation_co ξ g) nil θ
        (subst_valuation ξ A) (subst_valuation ξ B).
Proof.
  intros Γ g θ A B h ξ H_ξ.
  specialize subst_valuation_empty_defeq_aux with (Γ0 := nil).
  hauto lq:on.
Qed.


Lemma valuation_wff_uniq : forall ξ Γ, valuation_wff ξ Γ -> uniq Γ -> uniq ξ.
Proof.
  induction 1; auto.
  sauto depth:3 lq: on use: valuation_wff_same_dom.
Qed.

(* Lemma subst_valuation_covalue : forall ξ, *)
(*     valuation_lc ξ -> *)
(*     forall b, *)
(*     CoValue b -> *)
(*     CoValue (subst_valuation ξ b). *)
(* Proof. *)
(*   induction ξ; eauto. *)
(*   intros. *)
(*   destruct a. *)
(*   simpl. *)
(*   apply subst_tm_covalue; eauto. *)
(*   sfirstorder. *)
(* Qed. *)

Lemma valuation_lc_app (ξ1 ξ2 : valuation) : valuation_lc (ξ1 ++ ξ2) -> valuation_lc ξ1 /\ valuation_lc ξ2.
Proof.
  hauto use: binds_app_r, binds_app_l unfold: tmvar, valuation_lc, valuation.
Qed.

Lemma valuation_lc_app3 (ξ0 ξ1 ξ2 : valuation) : valuation_lc (ξ0 ++ ξ1 ++ ξ2) -> valuation_lc ξ0 /\ valuation_lc ξ1 /\ valuation_lc ξ2.
Proof.
  hauto l:on use:valuation_lc_app.
Qed.

Lemma valuation_wff_lc : forall ξ Γ, valuation_wff ξ Γ -> valuation_lc ξ.
Proof.
  unfold valuation_lc; induction 1; intros; auto.
  - contradiction.
  - apply binds_cons_iff in H1.
    destruct H1; split_hyp; subst.
    + destruct θ0;
        simp SN in H;
        hauto l:on use:lc_mutual.
    + sauto lq:on.
Qed.

Lemma subst_valuation_helper :
  forall a {ξ0 ξ1 ξ2 Γ}, valuation_wff (ξ0 ++ ξ1 ++ ξ2) Γ -> Ctx Γ ->
                    subst_valuation (ξ0 ++ ξ2) (subst_valuation ξ1 a) = subst_valuation (ξ0 ++ ξ1 ++ ξ2) a.
Proof.
  intros.
  assert (uniq Γ).
  eauto using Ctx_uniq.
  repeat rewrite <- subst_valuation_concat.
  rewrite <- (subst_valuation_commute ξ1 ξ2).
  reflexivity.
  assert (uniq (ξ0 ++ ξ1 ++ ξ2)).
  sfirstorder use:valuation_wff_uniq.
  hauto lq:on use: uniq_remove_mid, uniq_reorder_2, uniq_app_3.
  hauto lq:on use:valuation_wff_no_fv, valuation_closed_app3.
  hauto lq:on use:valuation_wff_no_fv, valuation_closed_app3.
Qed.

Lemma SN_lc_aux : forall n t θ A, SN_metric t θ A <= n -> forall ξ a,
      SN t θ A ξ a -> lc_tm a.
Proof.
  induction n; intros; eauto.
  - destruct θ.
    + destruct t.
      * destruct A; simpl in H; try lia.
      * simpl in H; try lia.
    + hauto l:on rew:db:SN use:typing_lc1.
  - destruct θ.
    + destruct t.
      * destruct A; try contradiction; inv_atom_rel_tm;
        hauto l:on rew:db:SN use:typing_lc1.
      * hauto l:on rew:db:SN use:typing_lc1.
    + hauto l:on rew:db:SN use:typing_lc1.
Qed.

Lemma SN_lc : forall θ t A ξ a, SN t θ A ξ a -> lc_tm a.
Proof.
  hauto l:on use:SN_lc_aux.
Qed.

Lemma subst_valuation_open_tm_wrt_tm_var :
  forall ξ,
    valuation_lc ξ ->
    forall x a,
      x `notin` dom ξ ->
      open_tm_wrt_tm (subst_valuation ξ a) (a_Var_f x) = subst_valuation ξ (open_tm_wrt_tm a (a_Var_f x)).
Proof.
  induction ξ; intros; auto.
  destruct a.
  simpl.
  rewrite subst_tm_open_tm_wrt_tm_var; auto.
  f_equal.
  apply_first_hyp; eauto.
  sfirstorder.
  hauto lq:on use: binds_cons_2 unfold: valuation_lc.
Qed.

Lemma subst_valuation_open_tm_wrt_tm :
  forall ξ a1 a2,
    valuation_lc ξ ->
    subst_valuation ξ (open_tm_wrt_tm a1 a2) = open_tm_wrt_tm (subst_valuation ξ a1) (subst_valuation ξ a2).
Proof.
  induction ξ; intros a1 a2 h_lc; auto.
  destruct a as [x a].
  simpl.
  rewrite <- subst_tm_open_tm_wrt_tm; auto.
  f_equal.
  rewrite IHξ.
  reflexivity.
  simpl_env in h_lc.
  sfirstorder use: valuation_lc_app.
  hauto lq:on use: binds_cons_2 unfold: binds, valuation_lc.
Qed.

Lemma subst_valuation_fresh_eq :
  forall ξ a,
    valuation_closed ξ ->
    AtomSetImpl.inter (fv_tm a) (dom ξ) [=] empty ->
    subst_valuation ξ a = a.
Proof.
  induction ξ; intros a0 h_nofv h_disjoint.
  - auto.
  - destruct a as [x a].
    simpl.
    rewrite IHξ; auto.
    rewrite subst_tm_fresh_eq; auto.
    simpl in h_disjoint.
    fsetdec.
    sfirstorder.
    simpl in h_disjoint; fsetdec.
Qed.


Lemma SN_subst_valuation_iff_P :
  forall t A ξ a, SN t t_P A ξ a = SN t t_P (subst_valuation ξ A) nil a.
Proof.
  strivial rew:db:SN.
Qed.

Lemma SN_subst_valuation_iff_aux1 :
  forall n t A, SN_metric t t_L A <= n -> forall ξ0 ξ, valuation_lc (ξ0 ++ ξ) -> forall a,
        LTy A -> SN t t_L A (ξ0 ++ ξ) a <-> SN t t_L (subst_valuation ξ A) ξ0 a.
Proof.
  induction n; intros t A h0 ξ0 ξ h_wff a h_wt.
  - unfold SN_metric in h0.
    destruct t;
      destruct A; simpl in h0; try lia.
  - destruct t.
      * destruct A; simp SN; simpl in h0; try hauto depth:1 l:on rew:db:SN, subst_valuation.
        ** autorewrite with subst_valuation.
           destruct delta5 as [ρ0 θ0].
           simp SN.
           split.
           *** split_hyp; repeat split; try tauto.
               qauto l:on rew:db: subst_valuation use:subst_valuation_concat.
               destruct H as [h_t [h_cv [b1 [h_red h1]]]].
               exists b1.
               split; auto.
               scongruence use:subst_valuation_concat.
               intros a0 h2.
               assert (h_a0 : SN C θ0 A1 (ξ0 ++ ξ) a0).
               destruct θ0.
               rewrite <- IHn in h2; eauto.
               simpl in *; lia.
               lazymatch goal with [ |- LTy ?a] => sauto lq:on rew:off inv:LTy end.
               rewrite SN_subst_valuation_iff_P.
               rewrite -> SN_subst_valuation_iff_P in h2.
               scongruence use:subst_valuation_concat.
               specialize (h1 _ h_a0).
               destruct h1 as [L h3].
               exists ((union L (union (fv_tm A1) (union (fv_tm A2) (union (fv_tm a) (union (fv_tm b1) (union (fv_tm a0) (dom ξ)))))))).
               intros x h_fresh.
               repeat (spec x).
               rewrite <- app_assoc in H.
               rewrite IHn in H; eauto.
               rewrite subst_valuation_open_tm_wrt_tm_var; auto.
               (* valuation_lc *)
               **** hauto l:on use:valuation_lc_app.
               **** simpl.
                    rewrite -> size_tm_open_tm_wrt_tm_var.
                    lia.
               **** assert (lc_tm a0) by hauto l:on use:SN_lc.
                    hauto l:on use:valuation_lc_app, valuation_lc_cons.
               **** hauto l:on use:LTy_Pi_inv.
           *** split_hyp; repeat split; try tauto.
               qauto l:on rew:db: subst_valuation use:subst_valuation_concat.
               destruct H as [h_t [h_cv [b1 [h_red h1]]]].
               exists b1.
               split; auto.
               scongruence use:subst_valuation_concat.
               intros a0 h2_backup.
               assert (h2 : SN C θ0 (subst_valuation ξ A1) ξ0 a0).
               destruct θ0.
               rewrite -> IHn in h2_backup; eauto.
               simpl in *; lia.
               inversion h_wt; subst; auto.
               rewrite SN_subst_valuation_iff_P.
               rewrite -> SN_subst_valuation_iff_P in h2_backup.
               scongruence use:subst_valuation_concat.

               specialize (h1 _ h2).
               destruct h1 as [L h3].
               exists ((union L (union (fv_tm A1) (union (fv_tm A2) (union (fv_tm a) (union (fv_tm b1) (union (fv_tm a0) (dom ξ)))))))).
               intros x h_fresh.
               repeat (spec x).
               rewrite <- app_assoc.
               rewrite IHn; eauto.
               rewrite <- subst_valuation_open_tm_wrt_tm_var; auto.
               (* valuation_lc *)
               **** hauto use:valuation_lc_app.
               **** simpl.
                    rewrite -> size_tm_open_tm_wrt_tm_var.
                    lia.
               **** assert (lc_tm a0) by hauto l:on use:SN_lc.
                    hauto l:on use:valuation_lc_app, valuation_lc_cons.
               ****  hauto l:on use:LTy_Pi_inv.
        ** sauto use:type_in_type_impossible, ctx_no_tyvar.
        ** simp subst_valuation SN.
           split.
           *** intros; split_hyp; repeat split; auto.
               scongruence use:subst_valuation_concat.
               scongruence use:subst_valuation_concat.
           *** intros; split_hyp; repeat split; auto.
               scongruence use:subst_valuation_concat.
               scongruence use:subst_valuation_concat.
      * simp SN.
        split.
        ** intros; split_hyp; split; auto.
           rewrite subst_valuation_concat; auto.
           destruct H0 as [v h1].
           exists v.
           rewrite <- IHn; eauto.
           hauto l:on.
        ** intros; split_hyp; split; auto.
           rewrite <- subst_valuation_concat; auto.
           destruct H0 as [v h1].
           exists v.
           rewrite -> IHn; eauto.
           hauto l:on.
Qed.

(* Lemma 4.9 (Substitution for the logical relation) *)
(* See SN_subst_valuation_iff_aux1 for the main proof *)
(* SN_subst_valuation_iff_P is a trivial result obtained by unfolding the definition of SN *)
Lemma SN_subst_valuation_iff :
  forall t θ A ξ0 ξ, valuation_lc (ξ0 ++ ξ) -> forall a,
      CLTy θ A -> SN t θ A (ξ0 ++ ξ) a <-> SN t θ (subst_valuation ξ A) ξ0 a.
Proof.
  intros; destruct θ.
  - hauto l:on use:SN_subst_valuation_iff_aux1, SN_subst_valuation_iff_P.
  - qauto l:on use:SN_subst_valuation_iff_P, subst_valuation_concat.
Qed.

Lemma SN_subst_valuation_iff_empty :
  forall t θ A ξ, valuation_lc ξ -> forall a,
      CLTy θ A -> SN t θ A ξ a <-> SN t θ (subst_valuation ξ A) nil a.
Proof.
  specialize SN_subst_valuation_iff with (ξ0 := nil).
  hauto l:on.
Qed.

(* The P case is trivial because we only require them to be well-typed *)
Lemma conv_sn_P_helper :
  forall t T1 ξ Γ a g T2,
    valuation_wff ξ Γ ->
    Typing nil t_P a (subst_valuation ξ T1) ->
    DefEq nil g nil t_P (subst_valuation ξ T1) (subst_valuation ξ T2) ->
    SN t t_P T2 ξ (a_Conv a g).
Proof.
  econstructor; eauto.
  apply defeq_regularity in H1.
  apply typing_regularity in H0.
  destruct H0.
  - qauto l:on use:typing_unique.
  - destruct H1 as [T [h1 h2]].
    rewrite -> H0 in h1.
    inversion h1; subst; auto.
Qed.

Ltac solve_metric :=
      unfold SN_metric in *;
      simpl in *;
      lia.

Definition SN_erase_metric (i_type : interp_type) (θ : fragment) A :=
  if θ
  then
    (if i_type then 2 * size_tm (erase_tm A) else 2 * size_tm (erase_tm A) + 1)
  else 0.

Ltac solve_metric_g :=
  lazymatch goal with
    [ |- context[SN_metric]] => solve_metric
  | [ |- context[SN_erase_metric]] => solve_metric
  | [ |- _] => idtac
  end.


(* Very specific helpers that don't deserve a dedicated name *)

Lemma subst_valuation_pi_inv :
  forall ξ A0 ρ0 A1 B1, subst_valuation ξ A0 = a_Pi ρ0 A1 B1 ->
              is_a_Var_f A0 = false ->
              exists A2 B2, A0 = a_Pi ρ0 A2 B2.
Proof.
  destruct A0; intros; simp subst_valuation in *; try hauto l:on.
Qed.


Lemma joins_subst_valuation_pi_inv :
  forall ξ δ0 A1 B1 T2,
    valuation_lc ξ ->
    LTy T2 ->
    Joins nil (subst_valuation ξ (a_Pi δ0 A1 B1)) (subst_valuation ξ T2) ->
    exists A2 B2, T2 = a_Pi δ0 A2 B2.
Proof.
  intros ξ δ0 A1 B1 T2 H_wff H_T2 H_J.
  simp subst_valuation in H_J.
  inversion H_T2; subst; eauto.
  - qauto l:on rew:db:subst_valuation use:Join_Pi_Proj1'.
  - qauto l:on rew:db:subst_valuation use:Join_Pi_Proj1'.
  - simp subst_valuation in H_J.
    hauto use:Join_Consistent.
  - simp subst_valuation in H_J.
    hauto l:on use:Join_Consistent.
Qed.

Lemma joins_subst_valuation_eq_inv :
  forall ξ θ0 A1 B1 T2,
    valuation_lc ξ ->
    LTy T2 ->
    Joins nil (subst_valuation ξ (a_Eq θ0 A1 B1)) (subst_valuation ξ T2) ->
    exists A2 B2, T2 = a_Eq θ0 A2 B2.
Proof.
  intros ξ θ0 A1 B1 T2 H_wff H_T2 H_J.
  simp subst_valuation in H_J.
  inversion H_T2; subst; eauto.
  - hauto l:on rew:db:subst_valuation use:Join_Consistent.
  - hauto l:on rew:db:subst_valuation use:Join_Consistent.
  - hauto lq:on  rew:db:subst_valuation use:Join_Eq_Proj.
  - sauto l:on rew:db:subst_valuation use:Join_Consistent.
Qed.

Lemma joins_subst_valuation_nat_inv :
  forall ξ T2,
    valuation_lc ξ ->
    LTy T2 ->
    Joins nil (subst_valuation ξ a_Nat) (subst_valuation ξ T2) ->
    T2 = a_Nat.
Proof.
  intros ξ T2 H_wff H_T2 H_J.
  inversion H_T2; subst; eauto.
  - hauto l:on  rew:db:subst_valuation use:Join_Consistent.
  - hauto l:on  rew:db:subst_valuation use:Join_Consistent.
  - hauto l:on  rew:db:subst_valuation use:Join_Consistent.
Qed.

Ltac fix_pi_case_name θ0 ρ0 A0 B0 :=
  lazymatch goal with
  | [ h:context[a_Pi ?δ0 ?A ?B] |- _] => destruct δ0 as [ρ0 θ0]; rename A into A0; rename B into B0
  end.

Lemma size_tm_always_geq_1 : forall t, size_tm t >= 1.
Proof.
  induction t; simpl in *; lia.
Qed.

(* TODO: move to the right spot *)
(* Lemma erase_tm_open_tm_wrt_tm : forall B a, *)
(*     erase_tm (open_tm_wrt_tm B a) = open_tm_wrt_tm (erase_tm B) (erase_tm a). *)
(* Proof. *)
(*   hauto use:erase_tm_open_tm_wrt_tm_rec. *)
(* Qed. *)

Definition conv_metric (i_type : interp_type) (θ : fragment) A :=
  if θ
  then
    (if i_type then 2 * tm_forall_depth A else 2 * tm_forall_depth A + 1)
  else 0.

Lemma conv_well_kinded1 :
  forall θ a ξ T1 T2 g,
    CLTy θ T1 ->
    Typing nil θ a (subst_valuation ξ T1) ->
    DefEq nil g nil θ (subst_valuation ξ T1) T2 ->
    Typing nil θ (subst_valuation ξ T1) a_TYPE.
Proof.
  intros θ a ξ T1 T2 g H_T1 H0 H1.
  destruct θ.
  - apply defeq_regularity in H1.
    destruct H1 as [T [h0 h1]].
    inversion H_T1; subst.
    + simp subst_valuation in h0.
      simpl in h0.
      simp subst_valuation.
      inversion  h0; subst; auto.
    + simp subst_valuation in h0.
      simpl in h0.
      simp subst_valuation.
      inversion  h0; subst; auto.
    + simp subst_valuation in h0.
      simpl in h0.
      simp subst_valuation.
      inversion  h0; subst; auto.
    + hauto l:on rew:db:subst_valuation.
  - apply typing_regularity in H0.
    destruct H0; auto.
    rewrite H.
    eauto.
Qed.

Lemma conv_well_kinded2 :
  forall θ a ξ T1 T2 g,
    CLTy θ T1 ->
    Typing nil θ a (subst_valuation ξ T1) ->
    DefEq nil g nil θ (subst_valuation ξ T1) T2 ->
    Typing nil θ T2 a_TYPE.
Proof.
  intros.
  assert (Typing nil θ (subst_valuation ξ T1) a_TYPE)
    by hauto use:conv_well_kinded1.
  hauto use:defeq_same_type_nil.
Qed.

Lemma inter_empty : forall a, AtomSetImpl.inter empty a [=] empty.
Proof.
  fsetdec.
Qed.

Lemma inter_empty2 : forall a, AtomSetImpl.inter (union empty empty) a [=] empty.
  fsetdec.
Qed.

Lemma econtext_same_dom : forall G,
    dom G = dom (context_to_econtext G).
Proof.
  induction G; hauto.
Qed.

Lemma econtext_uniq : forall G,
    uniq G <-> uniq (context_to_econtext G).
Proof.
  induction G.
  - sfirstorder.
  - sauto lq:on inv:uniq use:econtext_same_dom.
Qed.

Lemma binds_econtext :
  forall G x ρ θ A,
    binds x (ρ, θ, A) G ->
    binds x ρ (context_to_econtext G).
Proof.
  induction G.
  - hauto lq:on.
  - intros.
    simpl in *.
    inv_atom_rel_tm.
    simpl in *.
    simpl_env in H.
    apply binds_app_iff in H.
    destruct H.
    + sfirstorder.
    + sauto.
Qed.

Lemma Typing_grade :
  (forall Γ θ a A, Typing Γ θ a A -> Par (context_to_econtext Γ) a a) /\
    (forall Γ g Γ0 θ a b, DefEq Γ g Γ0 θ a b -> True) /\
    (forall Γ, Ctx Γ -> uniq (context_to_econtext Γ) ) /\
    (forall Γ θ a b, aBeta Γ θ a b ->  Joins (context_to_econtext Γ) a b) /\
    (forall Γ δ a A, CTyping Γ δ a A -> forall θ ρ, δ = (ρ,θ) ->
         CPar (context_to_econtext Γ) ρ a a).
Proof.
  apply typing_mutual; eauto.
  - intros.
    assert (Ctx G) by sauto lq:on use:wff_mutual.
    assert (uniq G) by hauto l:on use:Ctx_uniq.
    assert (uniq (context_to_econtext G)) by hauto l:on use:econtext_uniq.
    hauto l:on use:lc_mutual.
  - hauto l:on use:lc_mutual.
  - hauto l:on use:binds_econtext.
  - intros.
    assert (tr_0 : lc_tm A) by hauto l:on inv:lc_tm use:typing_lc1.
    destruct delta0 as [ρ0 θ0].
    pick fresh y and apply P_Abs; repeat (spec y); auto.
  - hauto l:on.
  (* Ind *)
  - intros.
    pick fresh y and apply P_IndCong; repeat (spec y); eauto.
    hauto lq:on use:typing_lc1.
    hauto lq:on use:typing_lc1.
    apply econtext_uniq.
    apply Ctx_uniq.
    sfirstorder use:wff_mutual.
  (* - hauto l:on use:lc_mutual. *)
  - strivial.
  - sauto lq:on  use:Ctx_uniq, econtext_same_dom, econtext_uniq.
  - intros.
    assert (Par (context_to_econtext G) a a).
    {
      inversion H; subst; auto.
      hauto l:on use:Par_grade_mutual.
    }
    enough (Par (context_to_econtext G) (a_Conv a g) a) by hauto l:on.
    constructor; eauto with lc.
  - intros.
    enough (Par (context_to_econtext G) (a_App (a_Abs delta0 A a) delta0 b) (open_tm_wrt_tm a b)) by
      hauto l:on use:Par_grade_mutual.
    sauto l:on use:Par_grade_mutual.
  - intros.
    apply join with (b := a).
    + sauto lq:on use:Par_grade_mutual.
    + apply MP_One.
      apply P_Conv; auto.
      sauto lq:on use:Par_grade_mutual.
      qauto l:on inv:Par use:Par_grade_mutual.
  - intros.
    apply join with (b := (a_Abs delta0 A1 a1)).
    + apply MP_One.
      sauto lq:on rew:off use:Par_grade_mutual inv:Par.
    + apply MP_One.
      destruct delta0 as [ρ0 θ0].
      assert (h0 : exists L, forall x, x `notin` L ->
                Par (x ~ ρ0 ++ context_to_econtext G)
                  (open_tm_wrt_tm a1 (a_Var_f x))
                  (open_tm_wrt_tm a1 (a_Var_f x))).
      {
        inversion H; subst.
        - inversion H6; subst.
        - inversion H8; subst; eauto.
      }
      destruct h0 as [L0 h_L0].
      assert (tr0: lc_tm (a_Pi (ρ0, θ0) A2 B2)) by hauto l:on use:lc_mutual.
      assert (tr1: lc_tm A2) by hauto l:on inv:lc_tm.
      assert (tr2: lc_tm (a_Pi (ρ0, θ0) A1 B1)) by hauto l:on use:lc_mutual.
      assert (tr3: lc_tm A1) by hauto l:on inv:lc_tm.
      assert (tr4 : lc_co g) by hauto l:on use:lc_mutual.
      pick fresh x and apply P_Abs; repeat (spec x); auto.
      simp open_aux.
      apply P_Conv.
      rewrite H2.
      sfirstorder ctrs:lc_co.
      rewrite -> H3.
      apply Par_γ_left; auto.
  (* IndSucc *)
  - intros.
    (* I honestly don't know how the proof can possibly go through automatically in this case... *)
    (* don't be surprised if it ever breaks *)
    apply join with (b := (a_App (open_tm_wrt_tm a3 a1) (q_R, t_L) (a_Ind a1 a2 a3 (a_Pi (q_R, t_L) a_Nat A))));
      sauto ctrs:MultiPar,Par lq:on use:MultiPar_grade.
  (* IndZero *)
  - intros.
    apply join with (b := a2).
    inversion H; subst.
    + hauto l:on inv:Par  use:MultiPar_grade, lc_mutual, Par_grade_mutual.
    + hauto l:on inv:Par  use:MultiPar_grade, lc_mutual, Par_grade_mutual.
    + hauto l:on inv:Par  use:MultiPar_grade, lc_mutual, Par_grade_mutual.
  - hauto q:on db:lc use:meet_ctx_l_uniq2, typing_wff, Ctx_uniq, econtext_uniq.
  - hauto q:on db:lc use:meet_ctx_l_uniq2, typing_wff, Ctx_uniq, econtext_uniq.
Qed.

Lemma cored_join_inj :
  forall Γ θ a b,
    aCoRed Γ θ a b ->
    forall A, Typing Γ θ a A ->
         Joins (context_to_econtext Γ) a b.
Proof.
  induction 1.
  - sauto lq:on use:Typing_grade.
  - sauto lq:on use:Typing_grade.
  - sauto lq:on rew:off use:Typing_grade.
  - intros A h0.
    inversion h0; subst.
    specialize (IHaCoRed A0 H3).
    inversion IHaCoRed; subst.
    apply Join_trans with (a2 := a).
    apply join with (b := a);
      sfirstorder ctrs:MultiPar,Par use:Typing_grade, lc_mutual, MultiPar_grade.
    apply Join_trans with (a2 := b); auto.
    apply join with (b := b);
      sfirstorder ctrs:MultiPar,Par use:Typing_grade, lc_mutual, MultiPar_grade.
  - hauto lq:on inv:Typing use:Join_succ_intro.
Qed.

Lemma coreds_join_inj :
  forall Γ θ a b,
    aCoReds Γ θ a b ->
    forall A,
      Typing Γ θ a A ->
      Joins (context_to_econtext Γ) a b.
Proof.
  induction 1; intros A0 hA0.
  - hauto l:on use:Typing_grade.
  - sauto lq:on rew:off use:cored_join_inj, preservation_cored1, Join_trans.
Qed.

Lemma red_join_inj :
  forall Γ θ a b,
    aRed Γ θ a b ->
    forall A, Typing Γ θ a A ->
         Joins (context_to_econtext Γ) a b.
Proof.
  induction 1; intros A0 hA0.
  - inversion hA0; subst.
    assert (tr0 : Joins (context_to_econtext G) a (a_Abs delta0 A a1)) by sfirstorder use:coreds_join_inj.
    assert (tr1 : Typing G theta (a_Abs delta0 A a1) (a_Pi delta0 A1 B)) by sfirstorder use:preservation_coreds.
    apply Join_trans with (a2 := (a_App (a_Abs delta0 A a1) delta0 b)).
    destruct delta0 as [ρ0 θ0].
    eapply Join_app_intro; eauto.
    destruct ρ0.
    simpl.
    hauto l:on inv:CTyping use:Typing_grade.
    simpl.
    repeat split.
    sfirstorder use:ctyping_lc1.
    sfirstorder use:ctyping_lc1.
    apply econtext_uniq.
    qauto l:on use:Ctx_uniq, wff_mutual.
    sauto lq:on use:Typing_grade.
  (* need join app intro again *)
  - inversion hA0; subst.
    destruct delta0 as [ρ0 θ0].
    eapply Join_app_intro; eauto.
    inversion H8; subst.
    + hauto l:on inv:CTyping use:Typing_grade.
    + simpl; repeat split.
      sfirstorder use:ctyping_lc1.
      sfirstorder use:ctyping_lc1.
      apply econtext_uniq.
      qauto l:on use:Ctx_uniq, wff_mutual.
  (* conv cong *)
  - sauto lq:on use:Join_conv_intro.
  (* succ cong *)
  - sauto lq:on use:Join_succ_intro.
  (* ind succ *)
  - inversion hA0; subst.
    assert (tr0 : Typing G t_L (a_Succ a1) a_Nat) by sfirstorder use:preservation_coreds.
    assert (tr1 : Joins (context_to_econtext G) a0 (a_Succ a1)) by sfirstorder use:coreds_join_inj.
    assert (tr2 : Ctx G) by sfirstorder use:typing_wff.
    assert (tr3 : uniq G) by sfirstorder use:Ctx_uniq.
    assert (tr4 : uniq (context_to_econtext G)) by sfirstorder use:econtext_uniq.
    assert (tr5 : lc_co g) by hauto l:on use:lc_mutual.
    apply Join_trans with (a2 := (a_Ind (a_Succ a1) a2 a3 (a_Pi (q_R, t_L) a_Nat A))).
    (* need join ind cong intro  *)
    pick fresh x; repeat (spec x).
    apply Join_ind_intro with (x := x); eauto.
    hauto l:on use:lc_mutual.
    hauto l:on use:lc_mutual.
    hauto l:on use:Typing_grade.
    hauto l:on use:Typing_grade.
    apply join with (b := (a_App (open_tm_wrt_tm a3 a1) (q_R, t_L) (a_Ind a1 a2 a3 (a_Pi (q_R, t_L) a_Nat A)))).
    + apply MP_One.
      pick fresh y and apply P_IndSucc; (repeat spec y); eauto.
      * hauto lq:on use:typing_lc1.
      * hauto lq:on use:typing_lc1.
      * sfirstorder use:Typing_grade.
      * sfirstorder use:Typing_grade.
      * sfirstorder use:Typing_grade.
    + apply MP_One.
      apply P_Conv; eauto.
      assert (tr6: aBeta G theta (a_Ind (a_Succ a1) a2 a3 (a_Pi (q_R, t_L) a_Nat A)) (a_App (open_tm_wrt_tm a3 a1) (q_R, t_L) (a_Ind a1 a2 a3 (a_Pi (q_R, t_L) a_Nat A)))) by sfirstorder.
      assert (tr7: exists T, Typing G t_L (a_App (open_tm_wrt_tm a3 a1) (q_R, t_L) (a_Ind a1 a2 a3 (a_Pi (q_R, t_L) a_Nat A))) T)
               by sauto lq:on use:preservation_primitive0.
      sfirstorder use:Typing_grade.
  - assert (lc_g : lc_co g) by hauto l:on use:lc_mutual.
    assert (Par (context_to_econtext G) a2 a2) by hauto l:on inv:Typing use:Typing_grade.
    assert (tr2 : uniq G) by hauto lq:on use:Ctx_uniq, wff_mutual.
    apply Join_trans with (a2 := a2).
    apply Join_trans with (a2 := a_Ind a_Zero a2 a3 (a_Pi (q_R, t_L) a_Nat A)).
    (* Join cong intro *)
    inversion hA0; subst.
    pick fresh x0; repeat (spec x0).
    apply Join_ind_intro with (x := x0); eauto.
    hauto inv:lc_tm l:on use:lc_mutual.
    hauto inv:lc_tm l:on use:lc_mutual.
    hauto lq:on use:coreds_join_inj inv:Typing.
    hauto l:on use:Typing_grade.
    (* hauto l:on use:Typing_grade. *)
    assert (tr0 : aBeta G theta (a_Ind a_Zero a2 a3 (a_Pi (q_R, t_L) a_Nat A)) a2) by sfirstorder.
    sfirstorder use:Typing_grade.
    apply join with (b := a2); eauto.
  - inversion hA0; subst.
    assert (tr0 : lc_co g) by hauto l:on use:lc_mutual.
    specialize (IHaRed a_Nat H11).
    (* ind join intro *)
    apply Join_trans with (a2 := (a_Ind b1 a2 a3 (a_Pi (q_R, t_L) a_Nat A))).
    pick fresh x; repeat (spec x).
    apply Join_ind_intro with (x := x); eauto.
    hauto inv:lc_tm l:on use:lc_mutual.
    hauto inv:lc_tm l:on use:lc_mutual.
    hauto l:on use:Typing_grade.
    hauto l:on use:Typing_grade.
    apply join with (b := (a_Ind b1 a2 a3 (a_Pi (q_R, t_L) a_Nat A))).
    hauto l:on use:Typing_grade.
    apply MP_One.
    apply P_Conv; eauto.
    sfirstorder use:Typing_grade.
Qed.

Lemma SN_preservation_backward :
  forall ξ θ a A b, Typing nil θ a (subst_valuation ξ A) ->
               SN C θ A ξ b ->
               aReds nil θ a b ->
               SN C θ A ξ a.
Proof.
  intros ξ θ a A b h0 h1 h2.
  destruct θ.
  - hauto l:on rew:db:SN use:preservation_reds, reds_trans.
  - simp SN.
Qed.

Lemma SN_preservation_backward_co :
  forall ξ θ a A b, Typing nil θ a (subst_valuation ξ A) ->
               CoValue a ->
               SN V θ A ξ b ->
               aCoReds nil θ a b ->
               SN V θ A ξ a.
Proof.
  intros ξ θ a A b h0 h1 h2 h3.
  destruct θ.
  - destruct A; try sfirstorder rew:db:SN depth:1.
    + destruct delta5 as [ρ0 θ0].
      simp SN.
      repeat split; auto.
      simp SN in *.
      destruct h2 as [_ [coval_b [b1 [h4 h5]]]].
      exists b1;
      split; auto.
      apply (coreds_trans b); auto.
    + sauto l:on rew:db:SN,subst_valuation use:coreds_trans.
  - hauto l:on rew:db:SN use:SN_typing.
Qed.

Lemma conv_sn_iff_aux :
  forall n t θ T1,
    conv_metric t θ T1 <= n ->
    forall ξ Γ T2 a, CLTy θ T1 ->
                  CLTy θ T2 ->
                  valuation_wff ξ Γ ->
                  forall g, DefEq nil g nil θ (subst_valuation ξ T1) (subst_valuation ξ T2) ->
                       Joins nil (subst_valuation ξ T1) (subst_valuation ξ T2) ->
                       SN t θ T1 ξ a -> SN t θ T2 ξ (a_Conv a g).
Proof.
  induction n; intros t θ T1 h_metric ξ Γ T2 a h_LT1 h_LT2 h_wff g h_eq h_seq h_SNa;
    (* Lemmas that are needed in all cases *)
    assert (h_g : fv_co g [=] empty) by hauto use:defeq_empty_fv1;
    assert (h_a : Typing nil θ a (subst_valuation ξ T1))
      by hauto use:SN_typing;
    assert (h_T1 : Typing nil θ (subst_valuation ξ T1) a_TYPE) by
      hauto use:conv_well_kinded1;
    assert (h_T2 : Typing nil θ (subst_valuation ξ T2) a_TYPE) by
      hauto use:conv_well_kinded2;
    assert (lc_g : lc_co g) by hauto db:lc;
    assert (valuation_lc ξ) by hauto lq:on use:valuation_wff_lc.
  - unfold conv_metric in h_metric.
    destruct θ.
    + destruct t;
        destruct T1; try solve_metric.
      inv_atom_rel_tm.
      destruct f;simpl in h_metric;lia.
    + hauto rew:db:SN use:conv_sn_P_helper.
  (* First, we want to prove some useful facts at the beginning that will be reused in the proof body *)
  - unfold conv_metric in h_metric.
    destruct θ.
    + destruct t.
      (* Value interpretation *)
      ++ invert_lty h_LT1; simp SN; simpl in h_metric; try (solve [inversion h_T1]);
           try hauto depth:1 use:type_level_app_impossible l:on rew:db:SN, subst_valuation;assert (covalue_a : CoValue a) by hauto q:on rew:off use:SN_V_is_covalue, SN_lc.
      (* Pi *)
      -- fix_pi_case_name θ0 ρ0 A1 B1.
         assert (h_inv : exists A B, T2 = a_Pi ( ρ0, θ0) A B) by hauto use:joins_subst_valuation_pi_inv.
         destruct h_inv as [A2 [B2 h_inv]]; subst.
         assert (h_A2 : Typing nil θ0 (subst_valuation ξ A2) a_TYPE) by
           hauto l:on rew:db:subst_valuation inv:Typing.

         assert (Joins nil (subst_valuation ξ A1)  (subst_valuation ξ A2))
           by (simp subst_valuation in h_seq; hauto l:on use:Join_Pi_Proj1).

        (* The real deal *)
        simp SN.
        repeat split; eauto with lc.
        assert (CLTy θ0 A1 /\ CLTy θ0 A2) by sauto lq:on inv:LTy; split_hyp.
        (* metric can be recovered from join pi projection *)

        assert (h_input : forall a0, SN C θ0 A2 ξ a0 -> SN C θ0 A1 ξ (a_Conv a0 (g_Sym (g_PiFst t_L g)))). {
        intros a0 h_SN_a0.
        eapply IHn; eauto.
        destruct θ0.
        simpl.
        enough (tm_forall_depth A1 = tm_forall_depth A2) by
          (simpl in *; lia).
        apply Join_forall_depth_same in H0.
        rewrite subst_valuation_forall_depth in H0; auto.
        rewrite subst_valuation_forall_depth in H0; auto.
        hauto l:on use:subst_valuation_LTy.
        hauto l:on use:subst_valuation_LTy.
        simpl in *; lia.
        econstructor; eauto.
        econstructor; eauto.
        reflexivity.
        simp subst_valuation in h_eq.
        simp subst_valuation in h_seq.
        sauto lq:on rew:off use:Joins_sym, Join_Pi_Proj1.
        }

        simp SN in h_SNa.
        destruct h_SNa as [_ [_ [a1 [h_red1 h_a1]]]].
        pick fresh x.
        exists (a_Conv (close_tm_wrt_tm x (open_tm_wrt_tm a1 (a_Conv (a_Var_f x) (g_Sym (g_PiFst t_L g))))) (g_PiSnd g t_L (g_Reflex (a_Var_b 0)) (g_Sym (g_PiFst t_L g)))).
        split.
      (* Very difficult reduction *)
      *                     (* after applying cong *)
        assert (Typing nil t_L (a_Abs (ρ0, θ0) (subst_valuation ξ A1) a1) (subst_valuation ξ (a_Pi (ρ0, θ0) A1 B1))) by hauto use:preservation_coreds.

        apply (coreds_trans (a_Conv (a_Abs (ρ0, θ0) (subst_valuation ξ A1) a1) g)).
        hauto l:on use:coreds_conv_cong.

        eapply coreds_one; eauto.
        pick fresh y and apply CR_AbsPush.
        eapply T_Conv.
        eassumption.
        eapply h_T2.
        apply h_eq.
        reflexivity.
        simp subst_valuation in h_eq; eauto.
        rewrite <- subst_tm_spec.
        rewrite subst_tm_open_tm_wrt_tm.
        simpl.
        rewrite eq_dec_refl.
        rewrite subst_tm_fresh_eq; eauto with lc.
        rewrite subst_co_fresh_eq; eauto with lc.
        hauto lq:on ctrs:lc_tm.
        simp open_aux.
        f_equal.
        rewrite open_co_wrt_tm_lc_co; auto.
        rewrite open_co_wrt_tm_lc_co; eauto with lc.
          * assert (valuation_closed ξ) by eauto.
            intros input SN_input.
            assert (fv_input : fv_tm input [=] empty)
              by hauto use:SN_fv_empty.
            assert (ty_input : Typing nil θ0 input (subst_valuation ξ A2)) by
              hauto l:on use:SN_typing.
            assert (lc_input : lc_tm input) by hauto l:on use:typing_lc1.
            assert (Par nil input input) by hauto l:on use:Typing_grade.
            specialize (h_input _ SN_input).
            specialize (h_a1 _ h_input).
            destruct h_a1 as [L_a1 h_a1].
            exists (L \u L_a1 \u {{x}} \u fv_tm B1 \u fv_co g \u dom ξ \u fv_tm B2).
            intros x0 h_x0.
            simp open_aux.
            rewrite <- subst_tm_spec.
            rewrite subst_tm_open_tm_wrt_tm; eauto using SN_lc.
            simpl.
            rewrite eq_dec_refl.
            rewrite subst_co_fresh_eq; eauto.
            rewrite subst_tm_fresh_eq; eauto.
            rewrite open_co_wrt_tm_lc_co; eauto with lc.
            change ((open_tm_wrt_tm (a_Var_b 0) input)) with input.

            eapply IHn with (T1 := open_tm_wrt_tm B1 (a_Conv (a_Var_f x0) (g_Sym (g_PiFst t_L g)))).
            ** pick fresh y.
               rewrite (subst_tm_intro y); auto.
               simpl.
               rewrite -> subst_forall_depth; eauto.
               rewrite open_tm_wrt_tm_var_forall_depth.
               destruct θ0; simpl in h_metric; solve_metric.
            (* Use subst lemma *)
            ** pick fresh y.
               rewrite -> (subst_tm_intro y); eauto.
               simpl.
               apply LTy_subst; eauto with lc.
            ** inversion h_LT2; subst; eauto;
               pick fresh y; repeat (spec y);
               rewrite -> (subst_tm_intro y); eauto;
               simpl;
               apply LTy_subst; eauto with lc.
            ** econstructor; eauto.
            ** simpl.
               change (open_co_wrt_tm (g_Reflex (a_Var_b 0)) input) with (g_Reflex input).
               rewrite subst_tm_valuation_commute; eauto with lc.
               rewrite subst_tm_valuation_commute; eauto with lc.
               rewrite subst_tm_open_tm_wrt_tm; eauto using SN_lc.
               rewrite subst_tm_open_tm_wrt_tm; eauto using SN_lc.
               simpl.
               rewrite eq_dec_refl.
               rewrite subst_tm_fresh_eq; eauto.
               rewrite subst_tm_fresh_eq; eauto.
               rewrite subst_co_fresh_eq; eauto.
               rewrite subst_valuation_open_tm_wrt_tm; auto.
               rewrite subst_valuation_fresh_eq with (a := (a_Conv input (g_Sym (g_PiFst t_L g)))); auto.
               rewrite subst_valuation_open_tm_wrt_tm; auto.
               rewrite subst_valuation_fresh_eq with (a := input); auto.
               change (open_co_wrt_tm (g_Sym (g_PiFst t_L g)) input) with
                 (g_Sym (g_PiFst t_L (open_co_wrt_tm g input))).
               rewrite open_co_wrt_tm_lc_co; auto.
               econstructor; eauto.
               reflexivity.
               simp subst_valuation in h_eq.
               constructor; eauto.
               econstructor; eauto; simp subst_valuation in h_eq.
               reflexivity.
               (* hauto lq:on use:typing_implies_ctyping, SN_typing. *)
               (* simpl. *)
               (* simp subst_valuation in h_eq. *)
               (* simpl. *)
               (* hauto lq:on use:typing_implies_ctyping, SN_typing. *)
               rewrite fv_input.
               clear Fr.
               eauto using inter_empty.
               simpl.
               rewrite fv_input.
               rewrite h_g.
               eauto using inter_empty2.
            ** simpl.
               rewrite subst_valuation_open_tm_wrt_tm; auto.
               rewrite (subst_valuation_fresh_eq _ (a_Conv (a_Var_f x0) (g_Sym (g_PiFst t_L g))) ); auto.
               rewrite <- subst_valuation_open_tm_wrt_tm_var; auto.
               rewrite subst_tm_open_tm_wrt_tm; auto.
               rewrite subst_tm_open_tm_wrt_tm; auto.
               simpl.
               rewrite eq_dec_refl.
               rewrite subst_tm_fresh_eq.
               rewrite subst_co_fresh_eq.
               rewrite subst_tm_fresh_eq.
               eapply Join_γ_Pi_Proj2'; eauto.
               simp subst_valuation in h_seq.
               apply typing_empty_fv1 in h_T2.
               simp subst_valuation in h_T2.
               clear Fr.
               simpl in h_T2.
               fsetdec.
               clear Fr.
               fsetdec.
               apply typing_empty_fv in h_T1.
               simp subst_valuation in h_T1.
               clear Fr.
               simpl in h_T1.
               fsetdec.
               clear Fr.
               simpl.
               assert (x0 `notin` dom ξ) by fsetdec.
               clear h_x0.
               rewrite h_g.
               clear h_g fv_input.
               fsetdec.
            ** simpl_env.
               rewrite -> SN_subst_valuation_iff_empty; eauto.
               simpl.
               rewrite subst_tm_valuation_commute; eauto.
               rewrite subst_tm_open_tm_wrt_tm; eauto using SN_lc.
               rewrite subst_tm_fresh_eq; eauto.
               simpl. rewrite eq_dec_refl ;eauto.
               rewrite subst_co_fresh_eq; eauto.
               rewrite <- SN_subst_valuation_iff_empty; eauto.
               specialize (h_a1 x0 ltac:(auto)).
               rewrite -> SN_subst_valuation_iff_empty in h_a1; eauto.
               simpl in h_a1.
               rewrite subst_tm_valuation_commute in h_a1; eauto.
               rewrite subst_tm_open_tm_wrt_tm in h_a1; eauto using SN_lc.
               rewrite subst_tm_fresh_eq in h_a1; eauto.
               simpl in h_a1.
               rewrite eq_dec_refl in h_a1.
               rewrite <- SN_subst_valuation_iff_empty in h_a1; eauto.
               (* lty *)
               rewrite (subst_tm_intro x0); eauto.
               apply LTy_subst; eauto.
               sauto lq:on use:valuation_wff_lc.
               (* lty *)
               qauto l:on use:LTy_subst.
               (* lty *)
               rewrite (subst_tm_intro x0); eauto.
               hauto db:lc l:on use:LTy_subst, SN_lc.
               sauto lq:on use:valuation_wff_lc.
               (* lty *)
               rewrite (subst_tm_intro x0); eauto.
               apply LTy_subst; eauto.
      -- assert (h_inv : exists A B, T2 = a_Eq θ A B)
                 by hauto use:joins_subst_valuation_eq_inv.
         destruct h_inv as [A2 [B2 ?]]; subst.
         simp SN.
         repeat split; eauto.
         simp subst_valuation in h_seq.
         simp SN in h_SNa.
         simp subst_valuation in *.
         sauto lq: on use: Join_Eq_Proj, Join_trans, Joins_sym.
      -- subst.
         assert (h2 : T2 = a_Nat)
           by hauto l:on use:joins_subst_valuation_nat_inv; subst.
         eapply SN_preservation_backward_co with (b := a); eauto.
         eapply coreds_one; eauto.
         apply CR_ConvRefl with (A := a_Nat); eauto.
         hauto l:on use:SN_lc.
         simp subst_valuation in h_eq.
      (* Term interpretation *)
      ++ simp SN in *.
         split; auto.
         econstructor; eauto.
         (* not as trivial as one might think: need CLTy to ensures that T2 is not TYPE *)
         (* trivial from regularity *)
         destruct h_SNa as [h_ty [v ?]]; split_hyp.
         exists (a_Conv v g); split; eauto.
         assert (tm_forall_depth T1 = tm_forall_depth T2).
         enough (tm_forall_depth (subst_valuation ξ T1) = tm_forall_depth (subst_valuation ξ T2)).
         rewrite subst_valuation_forall_depth in H2; auto.
         rewrite subst_valuation_forall_depth in H2; auto.
         eapply Join_forall_depth_same; eauto.
         hauto use: subst_valuation_LTy.
         hauto use: subst_valuation_LTy.
         eapply IHn with (T1 := T1); auto.
         unfold conv_metric in *; simpl in *; lia.
         eauto.
         (* Compatibility of aReds *)
         hauto use:reds_conv_cong.
    + hauto rew:db:subst_valuation,SN use:conv_sn_P_helper.
      Unshelve.
      eauto.
Qed.

(* Lemma 4.11 (Semantic conversion) *)
(* See conv_sn_iff_aux for the main proof that uses size induction
over the κ metric (conv_metric) as described in the text *)
Lemma conv_sn_iff :
  forall t θ T1,
    forall ξ Γ T2 a, CLTy θ T1 ->
                CLTy θ T2 ->
                valuation_wff ξ Γ ->
                forall g, DefEq nil g nil θ (subst_valuation ξ T1) (subst_valuation ξ T2) ->
                Joins nil (subst_valuation ξ T1) (subst_valuation ξ T2) ->
                SN t θ T1 ξ a ->
                (* ------------------------- *)
                SN t θ T2 ξ (a_Conv a g).
Proof.
  hauto l:on use:conv_sn_iff_aux.
Qed.

Lemma subst_valuation_notin :
  forall ξ x,
    x `notin` dom ξ ->
    subst_valuation ξ (a_Var_f x) = a_Var_f x.
Proof.
  induction ξ.
  - sfirstorder.
  - simpl.
    destruct a as [x a].
    intros.
    rewrite IHξ; auto.
    rewrite subst_tm_fresh_eq; auto.
Qed.
(* Lemmas for the fundamental theorem  *)

Lemma valuation_binds :
  forall ξ Γ, valuation_wff ξ Γ ->
           Ctx Γ ->
           forall x ρ θ A,
             binds x (ρ, θ, A) Γ  -> SN C θ A ξ (subst_valuation ξ (a_Var_f x)).
Proof.
  induction 1; intros; auto.
  - sfirstorder.
  - assert (tr0 : uniq (x ~ (ρ0, θ0, A) ++ Γ)) by hauto l:on use:Ctx_uniq.
    assert (tr1 : valuation_closed ξ) by hauto l:on use:valuation_wff_no_fv.
    assert (tr2: valuation_lc ξ) by hauto l:on use:valuation_wff_lc.
    assert (tr3 : uniq Γ) by hauto l:on use:uniq_app_iff.
    assert (tr4 : dom ξ = dom Γ ) by hauto use:valuation_wff_same_dom.
    assert (tr5 : fv_tm a [=] empty) by hauto lq:on use:SN_fv_empty.
    assert (tr6 : valuation_wff (x ~ a ++ ξ) (x ~ (ρ0, θ0, A) ++ Γ)) by hauto l:on.
    assert (tr7 : valuation_lc (x ~ a ++ ξ)) by hauto l:on use:valuation_wff_lc.
    apply binds_app_uniq_iff in H2; auto.
    destruct H2; split_hyp.
    + apply binds_one_iff in H2; split_hyp.
      inversion H4; subst.
      rewrite <- subst_valuation_concat; auto.
      simpl.
      assert (tr8 : x `notin` dom ξ) by hauto lq:on.
      rewrite subst_tm_valuation_commute; auto.
      simpl.
      rewrite eq_dec_refl.
      rewrite subst_valuation_fresh_eq; auto.
      inversion H1; subst.
      assert (CLTy θ0 A) by hauto lq:on use:Typing_CLTy.
      rewrite -> SN_subst_valuation_iff_empty; auto.
      simpl.
      rewrite subst_tm_valuation_commute;auto.
      rewrite subst_tm_fresh_eq; auto.
      rewrite <- SN_subst_valuation_iff_empty; auto.
      apply typing_fv1 in H10.
      rewrite H10.
      rewrite dom_meet_ctx_l; auto.
      rewrite tr5; fsetdec.
    + assert (tr01: Ctx Γ) by hauto lq:on rew:off inv:Ctx.
      assert (tr02 : x `notin` dom ξ) by sauto use:uniq_app_iff.
      assert (tr03 : Typing (meet_ctx_l_rho q_R Γ) θ A0 a_TYPE) by hauto l:on use:ctx_regularity.
      assert (tr04 : CLTy θ A0) by hauto l:on use:Typing_CLTy.
      assert (tr05 : fv_tm A0 [<=] dom Γ) by hauto l:on use:typing_fv1, dom_meet_ctx_l.
      specialize (IHvaluation_wff tr01 x0 ρ θ A0 H2).
      rewrite <- subst_valuation_concat; auto.
      simpl.
      rewrite subst_tm_valuation_commute; auto.
      rewrite subst_tm_fresh_eq; auto.
      (* assert (CLTy θ A) by  best use:Typing_CLTy, SN_typing. *)
      rewrite -> SN_subst_valuation_iff_empty; auto.
      simpl.
      rewrite subst_tm_valuation_commute;auto.
      rewrite subst_tm_fresh_eq; auto.
      rewrite <- SN_subst_valuation_iff_empty; auto.
      rewrite tr05.
      congruence.
Qed.

Lemma subst_valuation_lc_co :
  forall ξ g,
    lc_co g ->
    valuation_lc ξ ->
    lc_co (subst_valuation_co ξ g).
Proof.
  induction ξ; intros; auto.
  - destruct a as [x a].
    simpl in *.
    assert (lc_tm a) by
      fcrush unfold:valuation_lc.
    simpl_env in H0.
    assert (valuation_lc ξ) by
      sfirstorder use:valuation_lc_app.
    specialize (IHξ _ H H2).
    sfirstorder use:subst_co_lc_co.
Qed.

Lemma subst_valuation_lc_tm :
  forall ξ g,
    lc_tm g ->
    valuation_lc ξ ->
    lc_tm (subst_valuation ξ g).
Proof.
  induction ξ; intros; auto.
  - destruct a as [x a].
    simpl in *.
    assert (lc_tm a) by
      fcrush unfold:valuation_lc.
    simpl_env in H0.
    assert (valuation_lc ξ) by
      sfirstorder use:valuation_lc_app.
    specialize (IHξ _ H H2).
    sfirstorder use:subst_tm_lc_tm.
Qed.

(* Definition size_covalue_nat (a : tm) (n : nat) : Prop := *)
(*   exists v, aCoReds nil t_L a v /\ Some n = embed_nat v. *)

(* Lemma size_covalue_nat_succ (a : tm) (n : nat) : *)
(*   size_covalue_nat (a_Succ a) (S n) -> *)
(*   size_covalue_nat *)

Lemma subst_valuation_econtext : forall ξ G,
    context_to_econtext (subst_valuation_ctx ξ G) = context_to_econtext G.
Proof.
  induction G; hauto lq:on.
Qed.

Lemma ind_zero_intro :
  forall Γ a0,
    CoValue a0 ->
    aCoReds Γ  t_L  a0 a_Zero ->
    forall θ a2 a3 A,
    Typing Γ θ (a_Ind a0 a2 a3 ((a_Pi  (q_R, t_L)  a_Nat A) )) (open_tm_wrt_tm A a0) ->
    (Joins (context_to_econtext (meet_ctx_l_rho q_R Γ)) (open_tm_wrt_tm A a0) (open_tm_wrt_tm A a_Zero)) /\
      exists γ,
        DefEq (meet_ctx_l_rho q_R Γ) γ nil t_L (open_tm_wrt_tm A a_Zero) (open_tm_wrt_tm A a0) /\
          aRed Γ θ (a_Ind a0 a2 a3 (a_Pi (q_R, t_L) a_Nat A)) (a_Conv a2 γ).
Proof.
  intros Γ a0 co_a0 h_coreds θ a2 a3 A h_indt.
  assert (tr0: Typing Γ t_L a0 a_Nat) by hauto lq:on inv:Typing.
  assert (tr1: Typing Γ t_L a_Zero a_Nat) by hauto lq:on use:preservation_coreds.
  assert (tr3: lc_tm a0) by hauto l:on use:lc_mutual.
  split.
  - inversion h_indt; subst.
    inversion H5; subst.
    pick fresh x; repeat (spec x).

    rewrite (subst_tm_intro x A a0); auto.
    rewrite (subst_tm_intro x A a_Zero); auto.
    assert (h_ctx : Ctx Γ) by strivial use:wff_mutual.
    assert (h_uniq : uniq Γ) by strivial use:Ctx_uniq.
    assert (co_a0' : aCoReds (meet_ctx_l_rho q_R Γ) t_L a0 a_Zero)
      by hauto l:on use:acoreds_meet_ctx_l.
    assert (h_joins : Joins (context_to_econtext (meet_ctx_l_rho q_R Γ)) a0 a_Zero) by hauto l:on use:coreds_join_inj, typing_meet_ctx_l.
    eapply Joins_cong_nil with (ρ := q_R); eauto.
    enough (Par (x ~ q_R ++ context_to_econtext (meet_ctx_l_rho q_R Γ)) (open_tm_wrt_tm A (a_Var_f x))
              (open_tm_wrt_tm A (a_Var_f x))) by hauto l:on.
    sfirstorder use:Typing_grade, rel_meet_R2.
  - assert (h1 : exists g, DefEq Γ g nil t_L a0 a_Zero) by sfirstorder use:coreds_defeq_inj.
    destruct h1 as [g hg].
    apply defeq_meet_ctx_l in hg.
    assert (h0 : exists γ0, DefEq (meet_ctx_l_rho q_R Γ) γ0 nil t_L (open_tm_wrt_tm A a_Zero) (open_tm_wrt_tm A a0)).
    eapply pisnd_intro_same_type with (theta0 := t_L) (theta1 := t_L) (rho1 := q_R) (A := a_Nat); eauto.
    reflexivity.
    eapply E_Reflex; eauto.
    qauto l:on inv:Typing.
    hauto q:on use: preservation_red, typing_meet_ctx_l.
    destruct h0 as [γ hγ].
    exists γ; split; auto.
    econstructor; eauto.
    inversion h_indt; subst.
    pick fresh x and apply T_Ind; eauto.
    qauto l:on use:subsumption_mutual.
Qed.


Lemma ind_succ_intro :
  forall Γ a0 a1,
    CoValue a0 ->
    aCoReds Γ  t_L  a0 (a_Succ a1) ->
    forall θ a2 a3 A,
    Typing Γ θ (a_Ind a0 a2 a3 ((a_Pi  (q_R, t_L)  a_Nat A) )) (open_tm_wrt_tm A a0) ->
    (Joins (context_to_econtext (meet_ctx_l_rho q_R Γ)) (open_tm_wrt_tm A a0) (open_tm_wrt_tm A (a_Succ a1))) /\
      exists γ,
        DefEq (meet_ctx_l_rho q_R Γ) γ nil t_L (open_tm_wrt_tm A (a_Succ a1)) (open_tm_wrt_tm A a0) /\
          aRed Γ θ (a_Ind a0 a2 a3 (a_Pi (q_R, t_L) a_Nat A)) (a_Conv ( (a_App (open_tm_wrt_tm  a3   a1 )   (   q_R  ,   t_L   )   ( (a_Ind a1 a2 a3  ( (a_Pi  (   q_R  ,   t_L   )  a_Nat A) ) ) ) ) ) γ).
Proof.
  intros Γ a0 a1 co_a0 h_coreds θ a2 a3 A h_indt.
  assert (tr0: Typing Γ t_L a0 a_Nat) by hauto lq:on inv:Typing.
  assert (tr1: Typing Γ t_L (a_Succ a1) a_Nat) by hauto lq:on use:preservation_coreds.
  assert (tr2: Typing Γ t_L a1 a_Nat) by hauto l:on inv:Typing.
  assert (tr3: lc_tm a1) by hauto l:on use:lc_mutual.
  split.
  - inversion h_indt; subst.
    inversion H5; subst.
    pick fresh x; repeat (spec x).

    rewrite (subst_tm_intro x A a0); auto.
    rewrite (subst_tm_intro x A (a_Succ a1)); auto.
    assert (h0 : Par (context_to_econtext (x ~ (q_R, t_L, a_Nat) ++ meet_ctx_l_rho q_R Γ)) (open_tm_wrt_tm A (a_Var_f x)) (open_tm_wrt_tm A (a_Var_f x))) by sfirstorder use:Typing_grade.
    simpl in h0; simpl_env in h0.
    assert (h_ctx : Ctx Γ) by strivial use:wff_mutual.
    assert (h_uniq : uniq Γ) by strivial use:Ctx_uniq.
    assert (h_uniq2 : uniq (meet_ctx_l_rho q_R Γ)) by strivial use:meet_ctx_l_uniq2.
    assert (co_a1' : aCoReds (meet_ctx_l_rho q_R Γ) t_L a0 (a_Succ a1))
      by hauto l:on use:acoreds_meet_ctx_l.
    apply Joins_cong_nil with (ρ := q_R).
    hauto l:on use:Typing_grade.
    hauto lq:on use:coreds_join_inj, typing_meet_ctx_l.
  - assert (h1 : exists g, DefEq Γ g nil t_L a0 (a_Succ a1)) by sfirstorder use:coreds_defeq_inj.
    destruct h1 as [g hg].
    apply defeq_meet_ctx_l in hg.
    assert (h0 : exists γ0, DefEq (meet_ctx_l_rho q_R Γ) γ0 nil t_L (open_tm_wrt_tm A a0) (open_tm_wrt_tm A (a_Succ a1))).
    eapply pisnd_intro_same_type with (theta0 := t_L) (theta1 := t_L) (rho1 := q_R) (A := a_Nat); eauto.
    reflexivity.
    eapply E_Reflex; eauto.
    inversion h_indt; subst.
    eassumption.
    hauto q:on use: preservation_red, typing_meet_ctx_l.
    destruct h0 as [γ hγ].
    exists (g_Sym γ); split; auto.
    econstructor; eauto.
    inversion h_indt; subst.
    pick fresh x and apply T_Ind; eauto.
    hauto l:on use:subsumption_mutual.
Qed.

(* R-IndAlt *)
(* The lemma is strengthened to include some extra conditions we want to know w.r.t joinability and DefEq *)
Lemma ind_cong_intro :
  forall Γ a1 b1,
    aRed Γ t_L a1 b1 ->
    Typing Γ t_L a1 a_Nat ->
    forall θ a2 a3 A,
    Typing Γ θ (a_Ind a1 a2 a3 (a_Pi (q_R, t_L) a_Nat A)) (open_tm_wrt_tm A a1) ->
    (* ---------------------------------------------------------------------------------------------- *)
    (Joins (context_to_econtext (meet_ctx_l_rho q_R Γ)) (open_tm_wrt_tm A a1) (open_tm_wrt_tm A b1) /\
     exists γ,
     DefEq (meet_ctx_l_rho q_R Γ) γ nil t_L (open_tm_wrt_tm A b1) (open_tm_wrt_tm A a1) /\
     aRed Γ θ (a_Ind a1 a2 a3 (a_Pi (q_R, t_L) a_Nat A)) (a_Conv (a_Ind b1 a2 a3 (a_Pi (q_R, t_L) a_Nat A)) γ)).
Proof.
  intros Γ a1 b1 h_red h_t θ a2 a3 A h_indt.
  split.
  - inversion h_indt; subst.
    inversion H5; subst.
    pick fresh x.
    rewrite (subst_tm_intro x A a1); auto.
    rewrite (subst_tm_intro x A b1); auto.
    repeat (spec x).
    assert (h0 : Par (context_to_econtext (x ~ (q_R, t_L, a_Nat) ++ meet_ctx_l_rho q_R Γ)) (open_tm_wrt_tm A (a_Var_f x)) (open_tm_wrt_tm A (a_Var_f x))) by sfirstorder use:Typing_grade.
    simpl in h0; simpl_env in h0.
    assert (h_ctx : Ctx Γ) by strivial use:wff_mutual.
    assert (h_uniq : uniq Γ) by strivial use:Ctx_uniq.
    assert (co_a0' : aRed (meet_ctx_l_rho q_R Γ) t_L a1 b1)
      by hauto l:on use:ared_meet_ctx_l.
    assert (h_joins : Joins (context_to_econtext (meet_ctx_l_rho q_R Γ)) a1 b1) by hauto l:on use:red_join_inj, typing_meet_ctx_l.
    apply Joins_cong_nil with (ρ := q_R); auto.
    hauto l:on use:Typing_grade.
  - assert (h1 : exists g, DefEq Γ g nil t_L a1 b1) by sfirstorder use:red_defeq_inj.
    destruct h1 as [g hg].
    apply defeq_meet_ctx_l in hg.
    assert (h0 : exists γ0, DefEq (meet_ctx_l_rho q_R Γ) γ0 nil t_L (open_tm_wrt_tm A a1) (open_tm_wrt_tm A b1)).
    eapply pisnd_intro_same_type with (theta0 := t_L) (theta1 := t_L) (rho1 := q_R) (A := a_Nat); eauto.
    reflexivity.
    eapply E_Reflex; eauto.
    qauto l:on inv:Typing.
    hauto q:on use: preservation_red, typing_meet_ctx_l.
    destruct h0 as [γ hγ].
    exists (g_Sym γ); split; auto.
    econstructor; eauto.
    inversion h_indt; subst.
    pick fresh x and apply T_Ind; eauto.
    hauto l:on use:preservation_red.
    hauto l:on use:subsumption_mutual.
Qed.

Lemma ind_cong_sn :
  forall Γ a1 b1,
    aReds nil t_L a1 b1 ->
    forall ξ, valuation_wff ξ Γ ->
    Typing nil t_L a1 a_Nat ->
    forall a2 a3 A,
      LTy (a_Pi (q_R, t_L) a_Nat A) ->
      Typing nil t_L
        (a_Ind a1 a2 a3 (a_Pi (q_R, t_L) a_Nat (subst_valuation ξ A)))
        (open_tm_wrt_tm (subst_valuation ξ A) a1) ->
      SN C t_L (open_tm_wrt_tm A b1) ξ (a_Ind b1 a2 a3 (a_Pi (q_R, t_L) a_Nat (subst_valuation ξ A))) ->
      SN C t_L (open_tm_wrt_tm A a1) ξ (a_Ind a1 a2 a3 (a_Pi (q_R, t_L) a_Nat (subst_valuation ξ A))).
Proof.
  intros Γ a1 b1 h_reds.
  dependent induction h_reds; auto.
  intros ξ H_ξ a1_is_nat cont_z cont_s A h_LTy h_A h_SN.
  assert (tr0 : valuation_lc ξ) by hauto l:on use:valuation_wff_lc.
  assert (tr1 : valuation_closed ξ) by hauto l:on use:valuation_wff_no_fv.
  assert (a2_is_nat : Typing nil t_L a2 a_Nat) by hauto l:on use:preservation_red.
  assert (tr3 : fv_tm a1 [=] empty) by
    (apply typing_empty_fv1 in h_A; simpl in h_A; fsetdec).
  assert (tr4 : (subst_valuation ξ (open_tm_wrt_tm A a1)) = (open_tm_wrt_tm (subst_valuation ξ A) a1)).
  {
    rewrite subst_valuation_open_tm_wrt_tm; auto.
    rewrite (subst_valuation_fresh_eq ξ a1); auto.
    rewrite tr3; fsetdec.
  }
  assert (lc_a1 : lc_tm a1) by hauto l:on use:lc_mutual.
  assert (lc_a2 : lc_tm a2) by hauto l:on use:lc_mutual.
  assert (tr2 : Typing nil t_L (a_Ind a2 cont_z cont_s (a_Pi (q_R, t_L) a_Nat (subst_valuation ξ A))) (open_tm_wrt_tm (subst_valuation ξ A) a2)).
  {
    inversion h_A; subst.
    pick fresh y and apply T_Ind; repeat (spec y); eauto.
  }
  specialize (IHh_reds ltac:(reflexivity) ltac:(reflexivity) ξ H_ξ a2_is_nat cont_z cont_s A ltac:(auto) ltac:(auto)).
  pose proof ind_cong_intro as h1.
  specialize (h1 nil a1 a2 H ltac:(auto) t_L cont_z cont_s (subst_valuation ξ A) ltac:(auto)).
  destruct h1 as [h1 [γ [hγ h_red]]].
  apply SN_preservation_backward with (b := (a_Conv (a_Ind a2 cont_z cont_s (a_Pi (q_R, t_L) a_Nat (subst_valuation ξ A))) γ)); eauto.
  congruence.
  assert (tr5 : (subst_valuation ξ (open_tm_wrt_tm A a2)) = (open_tm_wrt_tm (subst_valuation ξ A) a2)).
  {
    rewrite subst_valuation_open_tm_wrt_tm; auto.
    rewrite (subst_valuation_fresh_eq ξ a2); auto.
    apply typing_empty_fv1 in a2_is_nat.
    rewrite a2_is_nat; fsetdec.
  }
  inversion h_LTy; subst.
  apply conv_sn_iff with (Γ := Γ) (T1 := (open_tm_wrt_tm A a2)); eauto; try congruence.
  simpl.
  pick fresh y; repeat (spec y).
  rewrite (subst_tm_intro y).
  apply LTy_subst; eauto.
  fsetdec.
  pick fresh y; repeat (spec y).
  rewrite (subst_tm_intro y).
  apply LTy_subst; eauto.
  fsetdec.
  hauto lq:on.
  apply Joins_sym in h1; scongruence.
  eapply reds_one; eauto.
Qed.

Lemma LTy_Pi:
  forall δ0 A B,
    LTy (a_Pi δ0 A B) ->
    forall a, lc_tm a ->
         LTy (open_tm_wrt_tm B a).
Proof.
  intros δ0 A B h0.
  invert_lty h0; try congruence.
  intros a h_lc.
  inversion H; subst.
  pick fresh x; (spec x).
  rewrite (subst_tm_intro x); auto.
  hauto l:on use:LTy_subst.
Qed.

Lemma SN_inject_nat :
  forall ξ n,
    SN V t_L a_Nat ξ (inject_nat n).
  intros ξ n.
  simp SN.
  repeat split.
  - sfirstorder use:inj_nat_value.
  - sfirstorder use:inj_nat_typing_nil.
  - exists (inject_nat n).
    split.
    + sfirstorder use:inj_nat_lc.
    + sfirstorder use:inj_nat_value.
Qed.



Lemma SN_subst_valuation_iff_one :
  forall t θ A y a ξ b,
  valuation_closed ξ ->
  lc_tm a ->
  fv_tm a [=] empty ->
  y `notin` dom ξ ->
  CLTy θ A ->
  valuation_lc ξ ->
  SN t θ A  (y ~ a ++ ξ) b ->
  SN t θ (subst_tm a y A) ξ b.
Proof.
  intros t θ A y a ξ b h_closed h_lc h_empty h_notin h_LTy h_wfflc h0.
  rewrite SN_subst_valuation_iff_empty; eauto.
  rewrite SN_subst_valuation_iff_empty in h0.
  rewrite <- subst_tm_valuation_commute; auto.
  hauto l:on use:valuation_lc_cons.
  hauto l:on.
  destruct θ.
  apply LTy_subst; auto.
  simpl.
  simpl in h_LTy.
  strivial use: subst_tm_lc_tm unfold: tmvar.
Qed.

Lemma SN_app' :
  forall ρ0 θ0 A B ξ f a,
    valuation_lc ξ ->
    valuation_closed ξ ->
    LTy (a_Pi (ρ0, θ0) A B) ->
    SN C t_L (a_Pi (ρ0, θ0) A B) ξ f ->
    SN C θ0 A ξ a ->
    SN C t_L (open_tm_wrt_tm B a) ξ (a_App f (ρ0,θ0) a).
Proof.
  intros ρ0 θ0 A B ξ f a ξ_lc ξ_empty lty_pi h0 h1.
  assert (wt_a : Typing nil θ0 a (subst_valuation ξ A)) by hauto l:on use:SN_typing.
  assert (cwt_a : CTyping nil (ρ0,θ0) a (subst_valuation ξ A)) by hauto lq:on use:typing_implies_ctyping.
  assert (fv_a : fv_tm a [=] empty) by hauto l:on use:typing_empty_fv1.
  assert (lc_a : lc_tm a) by hauto l:on use:lc_mutual.
  simp SN in h0.
  destruct h0 as [wt_f [cv [SN_cv h_reds]]].
  eapply SN_preservation_backward with (b := (a_App cv (ρ0, θ0) a)); eauto.
  3 : {   hauto l:on use: reds_app_cong.  }
  simp subst_valuation in wt_f.
  rewrite subst_valuation_open_tm_wrt_tm; auto.
  rewrite (subst_valuation_fresh_eq ξ a); auto.
  econstructor; eauto.
  rewrite fv_a; fsetdec.
  simp SN in SN_cv.
  destruct SN_cv as [wt_cv [co_cv [b1 [hcoreds h_SN]]]].
  eapply SN_preservation_backward with (b := (open_tm_wrt_tm b1 a)); eauto.
  rewrite subst_valuation_open_tm_wrt_tm; eauto.
  rewrite (subst_valuation_fresh_eq ξ a); auto.
  econstructor; eauto.
  simp subst_valuation in wt_cv.
  rewrite fv_a; fsetdec.
  specialize (h_SN a ltac:(auto)).
  destruct h_SN as [L h_SN].
  pick fresh x; repeat (spec x).
  apply SN_subst_valuation_iff_one in H; eauto.
  rewrite subst_tm_open_tm_wrt_tm in H; auto.
  rewrite subst_tm_fresh_eq in H; auto.
  simpl in H.
  rewrite eq_dec_refl in H; auto.
  sauto lq:on use:LTy_Pi.
  eapply reds_one; eauto.
  econstructor; eauto.
  simp subst_valuation in wt_cv.
Qed.

Lemma SN_app :
  forall ρ0 θ0 A B ξ f a,
    LTy (a_Pi (ρ0, θ0) A B) ->
    valuation_lc ξ ->
    valuation_closed ξ ->
    lc_tm B ->
    SN C t_L (a_Pi (ρ0, θ0) A B) ξ f ->
    SN C θ0 A ξ a ->
    SN C t_L B ξ (a_App f (ρ0,θ0) a).
Proof.
  intros.
  replace B with (open_tm_wrt_tm B a).
  hauto lq:on use:SN_app'.
  hauto lq:on use:open_tm_wrt_tm_lc_tm.
Qed.

Theorem fundamental_property :
  (forall Γ θ a A, Typing Γ θ a A -> SemTyping Γ θ a A) /\
    (forall Γ g Γ0 θ a b, DefEq Γ g Γ0 θ a b -> SemDefEq Γ Γ0 a b) /\
    (forall Γ, Ctx Γ -> True ) /\
    (forall Γ θ a b, aBeta Γ θ a b -> True) /\
    (forall Γ δ a A, CTyping Γ δ a A -> forall θ ρ, δ = (ρ,θ) -> SemTyping Γ θ a A).
Proof.
  apply typing_mutual; intros; subst; eauto; unfold SemTyping in *; unfold SemDefEq in *.
  - intros.
    assert (Typing G theta (a_Reify theta0 g) (a_Eq theta0 a b)) by hauto.
    assert (Typing nil theta (subst_valuation ξ (a_Reify theta0 g))
              (subst_valuation ξ (a_Eq theta0 a b)))
      by hauto use:subst_valuation_empty.
    assert (lc_tm (a_Reify theta0 g)) by hauto db:lc.
    assert (lc_tm (subst_valuation ξ (a_Reify theta0 g))) by hauto db:lc.
    destruct theta; [ | simp SN].
    simp SN in *.
    split; auto.
    exists (a_Reify theta0 (subst_valuation_co ξ g)).
    split; auto.
    simp SN; repeat split.
    + sauto lq:on use:CV_Nil rew:db:subst_valuation inv:lc_tm.
    + simp subst_valuation_backward; auto.
    + sfirstorder use:valuation_meet_ctx_l.
    + simp subst_valuation_backward.
      apply Rs_Refl; auto.
  - intros ξ H_ξ.
    assert (valuation_wff ξ (meet_ctx_l_rho q_R G))
      by hauto l:on use:valuation_meet_ctx_l.
    assert (Typing (meet_ctx_l_rho q_R G) theta A a_TYPE)
             by sauto lq:on drew:off  use:defeq_same_type_nil.
    simp subst_valuation.
    apply conv_sn_iff with (T1 := A) (Γ := G); eauto.
    hauto l:on use:Typing_CLTy.
    hauto l:on use:Typing_CLTy.
    hauto l:on use:subst_valuation_empty_defeq.
  - intros.
    enough (SN C theta0 A ξ (subst_valuation ξ (a_Var_f x))) by hauto lq:on  use:SN_subsumption.
    eauto using valuation_binds.
  - intros ξ H_ξ.
    assert (Typing G theta (a_Pi (rho0, theta0) A B) a_TYPE) by
      hauto l:on.
    assert (Typing nil theta (subst_valuation ξ (a_Pi (rho0, theta0) A B)) a_TYPE) by hauto l:on rew:db:SN,subst_valuation use:subst_valuation_empty.
    assert (lc_tm (subst_valuation ξ (a_Pi (rho0, theta0) A B))) by
      eauto with lc.
    destruct theta; simp SN subst_valuation in *.
    split.
    simp subst_valuation in *.
    exists (subst_valuation ξ (a_Pi (rho0, theta0) A B)).
    split;
    simp SN subst_valuation; try split.
    + sauto lq:on.
    + simp SN subst_valuation.
    + sauto lq:on.
  - intros ξ H_ξ.
    assert (tr_1 : Typing G theta (a_Abs delta0 A b) (a_Pi delta0 A B))
      by hauto l:on.

    assert (tr_2 : Typing nil theta (subst_valuation ξ (a_Abs delta0 A b)) (subst_valuation ξ (a_Pi delta0 A B))) by hauto use:subst_valuation_empty.
    assert (tr_lc : lc_tm (subst_valuation ξ (a_Abs delta0 A b))) by hauto use:typing_lc1.
    assert (tr_vlc : valuation_closed ξ) by hauto use:valuation_wff_no_fv.
    assert (tr_vc : valuation_lc ξ) by hauto use:valuation_wff_lc.

    destruct theta; simp SN; auto.
    split; auto.
    exists (subst_valuation ξ (a_Abs delta0 A b)).
    split; [ | eauto with lc].
    (* The actual interesting case about Abs *)
    + destruct delta0 as [ρ0 θ0].
      (* CoValue *)
      simp SN; repeat split; auto.
      simp subst_valuation in tr_lc.
      simp subst_valuation.
      sauto lq:on.

      exists (subst_valuation ξ b).
      split.
      simp subst_valuation_backward.
      apply CRs_Refl; eauto.
      intros a h_SN.
      assert (h_a_nofv : fv_tm a [=] empty) by hauto l:on use:SN_fv_empty.
      exists (L \u fv_tm b \u dom ξ).
      intros x h_x.
      assert (h_wff_cons : valuation_wff (x ~ a ++ ξ) (x ~ (ρ0, θ0, A) ++ G)) by hauto l:on.
      repeat (spec x).
      specialize (H1 _ h_wff_cons).
      simpl in H1.
      rewrite -> subst_tm_valuation_commute in H1; auto.
      rewrite <- subst_tm_intro in H1; auto.
      rewrite subst_valuation_open_tm_wrt_tm in H1; auto.
      rewrite subst_valuation_fresh_eq with (a := a) in H1; auto.
      fsetdec.
  (* App *)
  - intros ξ H_ξ.
    assert (Typing G theta (a_App b delta0 a) (open_tm_wrt_tm B a)) by
      hauto l:on.
    assert (Typing nil theta (subst_valuation ξ (a_App b delta0 a)) (subst_valuation ξ (open_tm_wrt_tm B a))) by hauto l:on rew:db:SN,subst_valuation use:subst_valuation_empty.
    assert (lc_tm (subst_valuation ξ (a_App b delta0 a))) by
      eauto with lc.
    (* Don't want to unfold SN C when theta = C *)
    destruct theta; try solve [simp SN].

    specialize (H ξ H_ξ).
    simp SN in H.
    destruct H as [h0 [v [h_SNv h_Redv]]].
    destruct delta0 as [ρ0 θ0].
    simp SN in h_SNv.
    destruct h_SNv as [h_wt_v [h_cvv [b1 [h_v_abs h_SN2]]]].
    specialize (H0 _ _ eq_refl ξ H_ξ).
    specialize (h_SN2 _ H0).
    destruct h_SN2 as [L h_SN_open].
    pick fresh x.
    assert (tr_1 : valuation_wff (x ~ subst_valuation ξ a ++ ξ) (x ~ (ρ0, θ0, A) ++ G) ) by sauto lq:on.
    assert (tr_2 : valuation_lc (x ~ subst_valuation ξ a ++ ξ) ) by hauto l:on use:valuation_wff_lc.
    assert (tr_22 : valuation_lc ξ ) by hauto l:on use:valuation_wff_lc.
    assert (tr_3 : valuation_closed (x ~ subst_valuation ξ a ++ ξ) ) by hauto l:on use:valuation_wff_no_fv.
    assert (tr_33 : valuation_closed ξ ) by hauto l:on use:valuation_wff_no_fv.
    assert (tr_4 : fv_tm (subst_valuation ξ a) [=] empty ) by hauto l:on use:SN_fv_empty.
    assert (tr_5 : lc_tm (subst_valuation ξ a) ) by hauto l:on use:SN_lc.
    assert (tr_6 : lc_tm a ) by hauto l:on use:ctyping_lc1.
    assert (h_lty : forall x, LTy (open_tm_wrt_tm B (a_Var_f x))).
    {
      intros x0.
      apply typing_regularity in t.
      destruct t; try congruence.
      assert (hh : LTy (a_Pi (ρ0, θ0) A B)) by hauto l:on use:L_typing_special_form.
      inversion hh; subst.
      pick fresh y; repeat (spec y).
      apply LTy_subst with (a := (a_Var_f x0)) (x := y) in H4; eauto.
      rewrite subst_tm_open_tm_wrt_tm in H4; eauto.
      simpl in H4.
      rewrite eq_dec_refl in H4.
      rewrite subst_tm_fresh_eq in H4; auto.
      pick fresh y; repeat (spec y).
      apply LTy_subst with (a := (a_Var_f x0)) (x := y) in H4; eauto.
      rewrite subst_tm_open_tm_wrt_tm in H4; eauto.
      simpl in H4.
      rewrite eq_dec_refl in H4.
      rewrite subst_tm_fresh_eq in H4; auto.
    }
    specialize (h_SN_open x ltac:(auto)).
    rewrite SN_subst_valuation_iff_empty in h_SN_open; auto.
    simpl in h_SN_open.
    rewrite subst_tm_valuation_commute in h_SN_open; auto.
    rewrite <- subst_tm_intro in h_SN_open; auto.
    rewrite -> subst_valuation_open_tm_wrt_tm in h_SN_open; auto.
    rewrite subst_valuation_fresh_eq with (a := subst_valuation ξ a) in h_SN_open; auto.
    rewrite <- subst_valuation_open_tm_wrt_tm in h_SN_open; auto.
    rewrite <- SN_subst_valuation_iff_empty in h_SN_open; auto.
    simp subst_valuation.
    (* Suffices to show backward preservation *)
    apply SN_preservation_backward with (b := (open_tm_wrt_tm b1 (subst_valuation ξ a))); auto.
    simp subst_valuation_backward.
    apply reds_trans with (b := a_App v (ρ0, θ0) (subst_valuation ξ a)).
    (* cong lemma *)
    apply reds_app_cong; auto.
    apply reds_one with (A := (subst_valuation ξ (open_tm_wrt_tm B a))); eauto.
    (* typing precondition of reds_one *)
    {
      simp subst_valuation in H2.
      sauto lq:on use:preservation_reds, reds_app_cong.
    }
    rewrite (subst_tm_intro x); eauto.
    apply LTy_subst; eauto.
    rewrite tr_4; clear Fr; fsetdec.
    hauto lq:on.
  (* Eq Type *)
  - intros.
    assert (Typing G theta (a_Eq theta0 a b) a_TYPE) by hauto.
    assert (Typing nil theta (subst_valuation ξ (a_Eq theta0 a b)) (subst_valuation ξ a_TYPE)) by hauto use:subst_valuation_empty.
    assert (lc_tm (a_Eq theta0 a b)) by hauto db:lc.
    assert (lc_tm (subst_valuation ξ (a_Eq theta0 a b))) by hauto db:lc.
    destruct theta; [ | simp SN].
    simp SN in *.
    split; auto.
    exists (a_Eq theta0 (subst_valuation ξ a) (subst_valuation ξ b)).
    split; auto.
    simp SN; repeat split.
    + apply CV_Nil.
      constructor;
      lazymatch goal with
        [ h : lc_tm (subst_valuation _ (a_Eq _ _ _)) |- _] =>
          simp subst_valuation in h;inversion h; hauto
      end.
    + simp subst_valuation_backward.
    + simp subst_valuation_backward.
      hauto ctrs:aReds.
  - hauto l:on rew:db:SN,subst_valuation.
  - intros ξ H_ξ.
    destruct theta; [ | simp SN subst_valuation; eauto].
    simp SN.
    split.
    hauto l:on rew:db:SN,subst_valuation.
    exists a_Zero.
    hauto l:on rew:db:SN,subst_valuation.
  - intros ξ H_ξ.
    specialize (H ξ H_ξ).
    destruct theta; [ | hauto l:on rew:db:SN,subst_valuation].
    simp subst_valuation.
    simp SN.
    split.
    hauto l:on rew:db:SN,subst_valuation.
    simp SN in H.
    destruct H as [h0 [v [h1 h2]]].
    exists (a_Succ v).
    split.
    + simp SN.
      repeat split; eauto using SN_V_is_covalue.
      sfirstorder depth:1 ctrs:- use:SN_V_is_covalue, CV_Succ.
      hauto l:on rew:db:subst_valuation use:SN_typing.
      simp SN in h1.
      destruct h1 as [h00 [h01 [v0 [h02 h03]]]].
      exists (a_Succ v0).
      sfirstorder use:coreds_succ_cong.
    + hauto rew:db:SN,subst_valuation l:on use:reds_succ_cong.
  - intros ξ H_ξ.
    destruct theta; [| hauto rew:db:SN,subst_valuation l:on].
    simp SN.
    split.
    hauto rew:db:SN,subst_valuation l:on.
    exists a_Nat.
    hauto rew:db:SN,subst_valuation l:on.
  (* Ind *)
  - intros ξ H_ξ.
    destruct theta; [|simp SN; sauto l:on use:subst_valuation_empty].
    assert (h_wt : Typing G t_L (a_Ind a1 a2 a3 (a_Pi (q_R, t_L) a_Nat A)) (open_tm_wrt_tm A a1)) by hauto l:on.

    assert (tr_vlc : valuation_closed ξ) by hauto use:valuation_wff_no_fv.
    assert (tr_vc : valuation_lc ξ) by hauto use:valuation_wff_lc.
    assert (tr_wff_meet : valuation_wff ξ (meet_ctx_l_rho q_R G)) by hauto use:valuation_meet_ctx_l.
    assert (h_LTy : LTy (a_Pi (q_R, t_L) a_Nat A)) by hauto lq:on use:Typing_CLTy.
    assert (h_wt' : Typing nil t_L (subst_valuation ξ (a_Ind a1 a2 a3 (a_Pi (q_R, t_L) a_Nat A))) (subst_valuation ξ (open_tm_wrt_tm A a1))) by hauto  l:on use:subst_valuation_empty.
    simp subst_valuation in h_wt'.
    rewrite subst_valuation_open_tm_wrt_tm in h_wt'; auto.
    simp subst_valuation.
    specialize (H0 ξ H_ξ).
    specialize (H1 ξ H_ξ).
    simp SN in H0.
    destruct H0 as [H_wta1 [cv [SNV_cv reds_a1_cv]]].
    specialize (H ξ ltac:(assumption)).
    assert (tr1 : Typing nil t_L (subst_valuation ξ a1) (subst_valuation ξ a_Nat))
      by hauto l:on use:SN_typing.
    simp subst_valuation in tr1.
    assert (cv_wt' : Typing nil t_L cv a_Nat) by hauto l:on use:preservation_reds.
    assert (cv_fv : fv_tm cv [=] empty). {
      apply typing_empty_fv1 in cv_wt'.
      auto.
    }
    assert (lc_cv : lc_tm cv) by hauto l:on use:lc_mutual.
    simp subst_valuation in tr1.
    assert (tr_subst_cv :  (subst_valuation ξ (open_tm_wrt_tm A cv)) = open_tm_wrt_tm (subst_valuation ξ A) cv).
    {
      rewrite subst_valuation_open_tm_wrt_tm; auto.
      rewrite (subst_valuation_fresh_eq ξ cv); auto.
      rewrite cv_fv; fsetdec.
    }

    assert (cut0 : SN C t_L (open_tm_wrt_tm A (subst_valuation ξ a1)) ξ
                     (a_Ind (subst_valuation ξ a1) (subst_valuation ξ a2) (subst_valuation ξ a3)
                        (a_Pi (q_R, t_L) a_Nat (subst_valuation ξ A)))).
    {
      eapply ind_cong_sn; eauto.
      simp SN in SNV_cv.
      destruct SNV_cv as [covalue_cv [wt_cv [v [coreds_cv_v value_v]]]].
      assert (Typing nil t_L v a_Nat) by hauto l:on use:preservation_coreds.

      pose proof nil_context_nat_value' as coqnat_to_v.
      specialize (coqnat_to_v v ltac:(auto) t_L ltac:(auto)).
      destruct coqnat_to_v as [n coqnat_to_v].
      clear reds_a1_cv.
      generalize dependent cv.
      generalize dependent v.
      assert (h_wk_A : Typing (meet_ctx_l_rho q_R nil) t_L (subst_valuation ξ (a_Pi (q_R, t_L) a_Nat A)) (subst_valuation ξ a_TYPE)) by hauto l:on use:typing_meet_ctx_l.
      simp subst_valuation in h_wk_A; simpl in h_wk_A.
      assert (h_t1' : Typing nil t_L (subst_valuation ξ a2) (subst_valuation ξ (open_tm_wrt_tm A a_Zero))) by
        hauto l:on use:subst_valuation_empty.
      rewrite subst_valuation_open_tm_wrt_tm in h_t1'; auto.
      simp subst_valuation in h_t1'.

      (* very important lemma; huge qol improvement once added to the context *)
      assert (h_wt0 : forall a, Typing nil t_L a a_Nat -> Typing nil t_L (a_Ind a (subst_valuation ξ a2) (subst_valuation ξ a3) (a_Pi (q_R, t_L) a_Nat (subst_valuation ξ A))) (open_tm_wrt_tm (subst_valuation ξ A) a)).
      {
        intros a ha.
        inversion h_wt'; subst.
        pick fresh x and apply T_Ind; (repeat spec x); eauto.
      }
      dependent induction n; auto.
      + intros.
        simpl in coqnat_to_v; subst.
        pose proof ind_zero_intro as h_red.
        specialize (h_red nil cv ltac:(auto) ltac:(auto) t_L (subst_valuation ξ a2) (subst_valuation ξ a3) (subst_valuation ξ A) ltac:(hauto l:on)).
        destruct h_red as [h_join [γ [h_γ h_red]]].
        apply SN_preservation_backward with (b := (a_Conv (subst_valuation ξ a2) γ)); eauto.
        rewrite tr_subst_cv.
        hauto l:on.
        apply conv_sn_iff with (T1 := (open_tm_wrt_tm A a_Zero)) (Γ := G); eauto.
        hauto l:on ctrs:LTy use:LTy_Pi unfold:CLTy.
        hauto l:on ctrs:LTy use:LTy_Pi unfold:CLTy.
        rewrite tr_subst_cv.
        rewrite subst_valuation_open_tm_wrt_tm; auto.
        simp subst_valuation.
        rewrite tr_subst_cv.
        rewrite subst_valuation_open_tm_wrt_tm; auto.
        simp subst_valuation.
        hauto l:on use:Joins_sym.
        eapply reds_one; eauto.
      + intros.
        simpl in coqnat_to_v; subst.
        assert (lc_inj_n : lc_tm (inject_nat n)) by hauto l:on use:inj_nat_lc.
        assert (lc_fv_tm_n : fv_tm (inject_nat n) [=] empty) by hauto l:on use:inj_nat_fv_tm.
        specialize (IHn
                      ltac:(auto)
                      ltac:(auto)
                      ltac:(auto)
                      (inject_nat n)
                      ltac:(strivial use:inj_nat_value)
                      ltac:(strivial use:inj_nat_typing_nil)
                      ltac:(reflexivity) (inject_nat n)
                      ltac:(hauto l:on use:inj_nat_value)
                      ltac:(strivial use:inj_nat_typing_nil)
                      ltac:(hauto l:on use:inj_nat_typing_nil, typing_lc1)
                      ltac:(strivial use:inj_nat_typing_nil)
                      ltac:(strivial use:inj_nat_fv_tm)
                             ltac:(strivial use:inj_nat_lc)).
        assert (h0 : subst_valuation ξ (open_tm_wrt_tm A (inject_nat n)) = open_tm_wrt_tm (subst_valuation ξ A) (inject_nat n)).
        {
          rewrite subst_valuation_open_tm_wrt_tm; auto.
          rewrite (subst_valuation_fresh_eq ξ (inject_nat n)); auto.
          rewrite inj_nat_fv_tm; eauto; fsetdec.
        }
        specialize (IHn h0).
        pose proof ind_succ_intro as h_red.
        specialize (h_red nil cv (inject_nat n) ltac:(auto) ltac:(auto) t_L (subst_valuation ξ a2) (subst_valuation ξ a3)
                     (subst_valuation ξ A) ltac:(hauto l:on)).
        destruct h_red as [h_join [γ [h_γ h_red]]].
        apply SN_preservation_backward with (b := (a_Conv
               (a_App (open_tm_wrt_tm (subst_valuation ξ a3) (inject_nat n)) (q_R, t_L)
                  (a_Ind (inject_nat n) (subst_valuation ξ a2) (subst_valuation ξ a3)
                     (a_Pi (q_R, t_L) a_Nat (subst_valuation ξ A)))) γ)); eauto.
        hauto lq:on.

        assert (h_rew : (subst_valuation ξ (open_tm_wrt_tm A (inject_nat (S n)))) =
                          (open_tm_wrt_tm (subst_valuation ξ A) (inject_nat (S n)))).
        {
          rewrite subst_valuation_open_tm_wrt_tm; eauto.
          rewrite (subst_valuation_fresh_eq ξ (inject_nat (S n))); auto.
          rewrite inj_nat_fv_tm; eauto.
          fsetdec.
        }
        apply conv_sn_iff with (T1 := (open_tm_wrt_tm A (inject_nat (S n)))) (Γ := G); eauto.
        hauto l:on ctrs:LTy use:LTy_Pi, inj_nat_lc unfold:CLTy.
        hauto l:on ctrs:LTy use:LTy_Pi, inj_nat_lc unfold:CLTy.
        rewrite tr_subst_cv;
          rewrite h_rew; auto.
        rewrite tr_subst_cv;
          rewrite h_rew; eauto using Joins_sym.
        2 : { eauto using reds_one.  }
        (* One step away from proving ind *)
        pick fresh y; repeat (spec y).
        pose (y ~ (inject_nat n) ++ ξ) as ξ0.
        assert (h_wff' : valuation_wff ξ0 (y ~ (q_R, t_L, a_Nat) ++ G))
          by hauto l:on use:SN_inject_nat, SN_V_is_SN_C, inj_nat_lc.
        specialize (H3 ξ0 h_wff').
        unfold ξ0 in H3.
        assert (lc_Pi : lc_tm (a_Pi (q_R, t_L) a_Nat A)) by hauto l:on use:typing_lc1.
        inversion lc_Pi; subst.

        apply SN_subst_valuation_iff_one in H3; eauto.
        simpl in H3.
        rewrite subst_tm_open_tm_wrt_tm in H3; auto.
        simpl in H3; rewrite eq_dec_refl in H3.
        rewrite subst_tm_fresh_eq in H3; auto.
        rewrite subst_tm_open_tm_wrt_tm in H3; auto.
        simpl in H3; rewrite eq_dec_refl in H3.
        rewrite subst_tm_fresh_eq in H3; auto.
        rewrite subst_tm_valuation_commute in H3; auto.
        rewrite subst_tm_open_tm_wrt_tm in H3; subst; auto.
        simpl in H3; rewrite eq_dec_refl in H3.
        rewrite subst_tm_fresh_eq in H3; auto.
        rewrite subst_valuation_open_tm_wrt_tm in H3; auto.
        rewrite -> (subst_valuation_fresh_eq ξ (inject_nat n)) in H3; auto.
        eapply SN_app; eauto 2.
        apply typing_regularity in H2.
        destruct H2; try congruence.
        apply Typing_CLTy in H2; eauto.
        rewrite (subst_tm_intro y); auto.
        replace (open_tm_wrt_tm A (inject_nat (S n))) with (subst_tm (inject_nat n) y (open_tm_wrt_tm A (a_Succ (a_Var_f y)))).
        hauto l:on use:LTy_subst.
        rewrite subst_tm_open_tm_wrt_tm; auto.
        simpl.
        rewrite eq_dec_refl; auto.
        rewrite subst_tm_fresh_eq; eauto.
        apply lc_body_tm_wrt_tm; eauto.
        hauto l:on use:inj_nat_lc.
        rewrite lc_fv_tm_n; clear Fr; fsetdec.
        pick fresh x and apply LTy_PiLogic.
        hauto l:on use:LTy_Pi.
        rewrite open_tm_wrt_tm_lc_tm.
        sauto lq:on rew:off use:LTy_Pi.
        apply lc_body_tm_wrt_tm; eauto.
    }
    assert (lc_a1 : lc_tm a1) by hauto l:on use:lc_mutual.
    rewrite -> SN_subst_valuation_iff_empty in cut0; eauto.
    rewrite subst_valuation_open_tm_wrt_tm in cut0; auto.
    rewrite (subst_valuation_fresh_eq _ (subst_valuation ξ a1)) in cut0; eauto.
    rewrite <- subst_valuation_open_tm_wrt_tm in cut0; auto.
    rewrite <- SN_subst_valuation_iff_empty in cut0; eauto.
    sauto lq:on rew:off use:LTy_Pi.
    apply typing_empty_fv1 in H_wta1.
    rewrite H_wta1; fsetdec.
    apply typing_lc1 in H_wta1.
    hauto lq:on rew:off use:LTy_Pi.
  - assert (uniq (G0 ++ G)) by hauto use:Ctx_uniq.
    assert (uniq G0) by hauto use:uniq_app_iff.
    assert (uniq (context_to_econtext G0)) by hauto l:on use:econtext_uniq.

    intros ξ H_ξ.
    specialize (H0 ξ ltac:(auto)).
    simp SN in H0.
    destruct H0 as [_ [v [h1 h2]]].
    simp SN in h1.
    hauto use:Join_weak_from_nil.
  (* ConvCong *)
  - intros ξ H_ξ.
    clear H0 H1.
    specialize (H ξ H_ξ).
    simp subst_valuation.
    assert (lc_co g1 /\ lc_co g2).
    {
      apply typing_lc1 in t.
      apply typing_lc1 in t0.
      sauto lq:on.
    }
    split_hyp.
    assert (valuation_lc ξ) by sfirstorder use:valuation_wff_lc.
    enough (lc_co (subst_valuation_co ξ g1) /\ lc_co (subst_valuation_co ξ g2)) by hauto l:on use:Join_conv_intro.
    sfirstorder use:subst_valuation_lc_co.
  (* EqCong *)
  - qauto l:on use:Join_eq_intro rew:db:subst_valuation.
  (* Reflexivity *)
  - clear H.
    assert (Par (context_to_econtext (G0 ++ G)) a a)
      by hauto use:Typing_grade.
    intros ξ H_ξ.
    apply (subst_valuation_empty_aux G ξ) in t; auto.
    assert (h0 : Par (context_to_econtext (subst_valuation_ctx ξ G0)) (subst_valuation ξ a) (subst_valuation ξ a))
             by hauto l:on use:Typing_grade.
    rewrite subst_valuation_econtext in h0.
    hauto l:on.
  (* ReifyCong *)
  - assert (uniq (G0 ++ G)) by hauto use:Ctx_uniq.
    assert (uniq G0) by hauto use:uniq_app_iff.
    assert (uniq (context_to_econtext G0)) by hauto use:econtext_uniq.
    assert (lc_co g1 /\ lc_co g2) by eauto with lc; split_hyp.
    hauto lq:on
          rew:db:subst_valuation
          use:Join_reify_intro,
              valuation_wff_lc,
              subst_valuation_lc_co,
              Join_reify_intro.
  (* Reduction *)
  - intros ξ H_ξ.
    eapply subst_valuation_abeta in a0; eauto.
    assert (h2 : Joins (context_to_econtext (subst_valuation_ctx ξ G0)) (subst_valuation ξ a) (subst_valuation ξ b))
      by hauto l:on use:Typing_grade.
    rewrite subst_valuation_econtext in h2.
    assumption.
  (* Symmetry *)
  - sfirstorder use:Joins_sym.
  (* Transitivity *)
  - sfirstorder use:Join_trans.
  (* PiCong *)
  - intros ξ H_ξ.
    assert (tr_0 : valuation_lc ξ) by hauto use:valuation_wff_lc.
    assert (tr_33 : valuation_closed ξ ) by hauto l:on use:valuation_wff_no_fv.
    assert (tr_4 : lc_co g1) by hauto l:on rew:off db:lc.
    assert (tr_5 : lc_co (subst_valuation_co ξ (g_Sym g1))) by sauto lq:on rew:off use:subst_valuation_lc_co.
    pick fresh x for
      (union (fv_tm (subst_valuation ξ B2))
         (union (fv_tm (subst_valuation ξ B3))
            (union (fv_tm (subst_valuation ξ B1))
               (union L
                  (union (dom G)
                     (union (dom G0)
                        (union (fv_tm A1)
                           (union (fv_tm B1)
                              (union (fv_tm A2)
                                 (union (fv_tm B3) (union (fv_tm B2) (union (fv_co g1) (union (fv_co g2) (dom ξ)))))))))))))); repeat (spec x).
    specialize (H4 ξ H_ξ).
    specialize (H ξ H_ξ).
    rewrite <- subst_valuation_open_tm_wrt_tm_var in H4; auto.
    rewrite <- subst_valuation_open_tm_wrt_tm_var in H4; auto.
    simpl in H4.
    simpl_env in H4.
    enough (Joins (x ~ q_R ++ context_to_econtext G0) (open_tm_wrt_tm (subst_valuation ξ B1) (a_Var_f x))
              (open_tm_wrt_tm (subst_valuation ξ B3) (a_Var_f x))).
    simp subst_valuation in *.
    eapply Joins_PiCong_intro; eauto.
    (* Can I pick fv to be REALLY REALLY fresh? *)
  (* subst_valuation fv lemma *)
    apply Join_trans with (a2 := (open_tm_wrt_tm (subst_valuation ξ B2) (a_Var_f x))); auto.
    rewrite subst_valuation_open_tm_wrt_tm_var with (a := B3); auto.
    rewrite H3.
    rewrite -> subst_valuation_open_tm_wrt_tm; auto.
    simp subst_valuation.
    apply Joins_sym.
    apply join with (b := (open_tm_wrt_tm (subst_valuation ξ B2) (a_Var_f x))).
    rewrite subst_valuation_notin; auto.
    apply MultiPar_γ_left; eauto.
    (* multipar grade *)
    sauto depth:1 use:MultiPar_grade.
    sauto depth:1 use:MultiPar_grade.
  (* AbsCong *)
  - intros ξ H_ξ.
    pick fresh x for
    (union (dom ξ) (union (fv_tm (subst_valuation ξ a2))(union (fv_tm (subst_valuation ξ a1))(union L
                 (union (dom G)
                    (union (dom G0)
                       (union (fv_tm A)
                          (union (fv_tm a1)
                             (union (fv_tm a2) (union (fv_tm B) (fv_co g2))))))))))); repeat (spec x).
    clear H.
    clear H1.
    assert (tr0: Ctx (G0 ++ G)) by hauto l:on use:typing_wff.
    assert (tr1:  uniq (G0 ++ G)) by hauto l:on use:Ctx_uniq.
    assert (tr2:  uniq G0) by hauto l:on use:uniq_app_iff.
    assert (tr3 : uniq (context_to_econtext G0)) by hauto l:on use:econtext_uniq.
    simpl_env in t.
    assert (tr4 : lc_tm A) by hauto l:on use:typing_lc1.
    assert (tr5 : valuation_lc ξ) by hauto l:on use:valuation_wff_lc.
    assert (tr6 : lc_tm (subst_valuation ξ A)) by hauto l:on use:subst_valuation_lc_tm.
    specialize (H2 ξ H_ξ).
    simp subst_valuation.
    apply Joins_AbsCong_intro with (x := x); eauto.
    rewrite subst_valuation_open_tm_wrt_tm in H2; auto.
    rewrite subst_valuation_open_tm_wrt_tm in H2; auto.
    rewrite subst_valuation_notin in H2; auto.
  (* AppCong1 *)
  - assert (tr : lc_co g) by hauto db:lc.
    intros ξ H_ξ.
    assert (tr_1 : lc_co (subst_valuation_co ξ g)) by hauto use:subst_valuation_lc_co, valuation_wff_lc.
    hauto lq:on rew:db:subst_valuation use:Join_app_intro_γ.
  - assert (tr : lc_co g) by hauto db:lc.
    intros ξ H_ξ.
    assert (tr_0 : valuation_lc ξ) by hauto use:valuation_wff_lc.
    assert (tr_1 : lc_co (subst_valuation_co ξ g)) by hauto lq:on use:subst_valuation_lc_co.
    assert (tr_2 : lc_tm b1) by hauto lq:on db:lc.
    assert (tr_3 : lc_tm b2) by hauto lq:on db:lc.
    assert (uniq (G0 ++ G)) by hauto use:Ctx_uniq, wff_mutual.
    assert (uniq G0) by hauto use:uniq_app_iff.
    assert (uniq (context_to_econtext G0)) by hauto use:econtext_uniq.
    qauto l:on rew:db:subst_valuation use:Join_app_intro_γ, subst_valuation_lc_tm.
  - hauto lq:on rew:off rew:db:subst_valuation use:Join_Pi_Proj1.
  (* PiSnd *)
  - intros ξ H_ξ.
    assert (tr_0 : valuation_lc ξ) by hauto use:valuation_wff_lc.
    rewrite subst_valuation_open_tm_wrt_tm; auto.
    simp subst_valuation.
    clear H1 H2 H3.
    specialize (H ξ H_ξ).
    specialize (H0 ξ H_ξ).
    simp subst_valuation in H.
    assert (tr0: DefEq (subst_valuation_ctx ξ G0) (subst_valuation_co ξ g2) nil theta1 (subst_valuation ξ A2) (subst_valuation ξ A1)) by sfirstorder use: subst_valuation_empty_defeq_aux.
    assert (lcg2: lc_co (subst_valuation_co ξ g2)) by sfirstorder use: defeq_lc1.
    apply defeq_regularity in d.
    destruct d as [T [hT _]].
    inversion hT; subst.
    assert (tr1 : Typing (subst_valuation_ctx ξ G0) theta0 (subst_valuation ξ (a_Pi (rho1, theta1) A1 B1)) (subst_valuation ξ a_TYPE)) by sfirstorder use:subst_valuation_empty_aux.
    simp subst_valuation in tr1.
    inversion tr1; subst.
    apply Join_trans with (a2 := (open_tm_wrt_tm (subst_valuation ξ B1) (subst_valuation ξ a1))).
    + apply MultiPar_join.
      apply MP_One.
      pick fresh x for (L0 \u L \u fv_tm (subst_valuation ξ B1)
                          \u fv_tm (subst_valuation ξ B2)).
      repeat (spec x).
      rewrite (subst_tm_intro x); auto.
      rewrite (subst_tm_intro x _ (subst_valuation ξ a1)); auto.
      eapply Par_cong_nil with (ρ := q_R); auto.
      assert (tr2 : Par (context_to_econtext (x ~ (q_R, theta1, subst_valuation ξ A1) ++ subst_valuation_ctx ξ G0))
                      (open_tm_wrt_tm (subst_valuation ξ B1) (a_Var_f x)) (open_tm_wrt_tm (subst_valuation ξ B1) (a_Var_f x))) by hauto l:on use:Typing_grade.
      simpl in tr2.
      rewrite subst_valuation_econtext in tr2; auto.
      constructor.
      apply P_Conv; auto.
      sfirstorder use:Join_grade.
    + rewrite subst_valuation_open_tm_wrt_tm; auto.
      apply Join_Pi_Proj2 in H.
      destruct H as [L1 h0].
      pick fresh x for (L1 \u fv_tm (subst_valuation ξ B1)
                          \u fv_tm (subst_valuation ξ B2)); spec x.
      rewrite (subst_tm_intro x); auto.
      rewrite (subst_tm_intro x (subst_valuation ξ B2)); auto.
      apply Joins_cong_nil with (ρ := q_R); auto.
  (* Succ *)
  - hauto l: on rew:db: subst_valuation, SN use: Join_succ_intro.
  - intros ξ H_ξ.
    assert (tr_0 : valuation_lc ξ) by hauto use:valuation_wff_lc.
    assert (tr_1 : valuation_closed ξ) by hauto use:valuation_wff_no_fv.
    clear H2 H3 H4.
    specialize (H ξ H_ξ).
    specialize (H0 ξ H_ξ).
    simp subst_valuation.
    assert (tr_3 : valuation_wff ξ (meet_ctx_l_rho q_R G)) by sfirstorder use:valuation_meet_ctx_l.
    apply Join_trans with (a2 := (a_Ind (subst_valuation ξ a1) (subst_valuation ξ a2) (subst_valuation ξ a3)
                                    (a_Pi (q_R, t_L) a_Nat (subst_valuation ξ A)))).
    + apply MultiPar_join.
      apply MP_One.
      pick fresh x; repeat (spec x).
      simpl_env in d2.
      assert (tr_4 : DefEq (subst_valuation_ctx ξ (meet_ctx_l_rho q_R G0)) (subst_valuation_co ξ g) nil theta (subst_valuation ξ A0) (subst_valuation ξ B0)) by sfirstorder use:subst_valuation_empty_defeq_aux.
      apply P_Conv; auto.
      hauto l:on use:defeq_lc1.
      assert (tr_5 : Typing (subst_valuation_ctx ξ G0) theta (subst_valuation ξ (a_Ind a1 a2 a3 (a_Pi (q_R, t_L) a_Nat A))) (subst_valuation ξ A0)) by sfirstorder use:subst_valuation_empty_aux.
      simp subst_valuation in tr_5.
      assert (tr_6 : Par (context_to_econtext (subst_valuation_ctx ξ G0)) (a_Ind (subst_valuation ξ a1) (subst_valuation ξ a2) (subst_valuation ξ a3)
              (a_Pi (q_R, t_L) a_Nat (subst_valuation ξ A))) (a_Ind (subst_valuation ξ a1) (subst_valuation ξ a2) (subst_valuation ξ a3)
                                                                 (a_Pi (q_R, t_L) a_Nat (subst_valuation ξ A)))) by hauto l:on use:Typing_grade.
      rewrite subst_valuation_econtext in tr_6; auto.
    + pick fresh x for (L \u (fv_tm (subst_valuation ξ a3)) \u (fv_tm (subst_valuation ξ b3)) \u dom ξ); repeat (spec x).
      specialize (H2 ξ H_ξ).
      inversion t; subst.
      simpl_env in H9.
      assert (tr_4 : Typing (subst_valuation_ctx ξ G0) theta (subst_valuation ξ (a_Ind a1 a2 a3 (a_Pi (q_R, t_L) a_Nat A))) (subst_valuation ξ (open_tm_wrt_tm A a1))) by sfirstorder use:subst_valuation_empty_aux.
      simp subst_valuation in tr_4.
      inversion tr_4; subst.
      assert (lc_tm (a_Ind (subst_valuation ξ a1) (subst_valuation ξ a2) (subst_valuation ξ a3)
                       (a_Pi (q_R, t_L) a_Nat (subst_valuation ξ A)))) by hauto l:on use:lc_mutual.
      assert (lc_tm (a_Pi (q_R, t_L) a_Nat (subst_valuation ξ A))) by hauto l:on inv:lc_tm.
      apply Join_ind_intro with (x := x); auto.
      rewrite subst_valuation_open_tm_wrt_tm in H2; auto.
      rewrite subst_valuation_open_tm_wrt_tm in H2; auto.
      rewrite (subst_valuation_fresh_eq ξ (a_Var_f x)) in H2; auto.
      simpl.
      fsetdec.
  (* CTyping *)
  - hauto lq:on.
  - hauto lq:on use:valuation_meet_ctx_l.
Qed.


(* Theorem 4.14 (Fundamental theorem: typing) *)
(* See fundamental_property for the main proof *)
Lemma typing_implies_semtyping : forall Γ θ a A, Typing Γ θ a A -> SemTyping Γ θ a A.
Proof. hauto l:on use:fundamental_property. Qed.

(* Theorem 4.15 (Fundamental theorem: equality) *)
(* See fundamental_property for the main proof *)
Lemma defeq_implies_semdefeq : forall Γ g Γ0 θ a b, DefEq Γ g Γ0 θ a b -> SemDefEq Γ Γ0 a b.
Proof. hauto l:on use:fundamental_property. Qed.

(* Lemma 4.16 (DefEq Joinability) *)
Lemma defeq_join θ g A B
  (h0 :DefEq nil g nil θ A B) :
  (* ------------------------- *)
  Joins nil A B.
Proof.
  change nil with (context_to_econtext nil).
  change A with (subst_valuation nil A).
  change B with (subst_valuation nil B).
  hauto l:on use:defeq_implies_semdefeq.
Qed.

(* Lemma 4.17 (DefEq Consistency) *)
Lemma defeq_consist : forall θ g A B,
    DefEq nil g nil θ A B ->
    (* -------------------- *)
    Consistent A B.
Proof.
  intros θ g A B h.
  assert (h0 : valuation_wff nil nil) by sfirstorder.
  sfirstorder use:defeq_join,Join_Consistent.
Qed.

End normalization.
