From LP Require Import lp_ott lp_inf  lp_ind lp_tactics lp_labels sigs.
From Hammer Require Import Tactics.
From Ltac2 Require Import Ltac2 Control Constr.
From Coq Require Import ssreflect.

Module subsumption
  (Import narrow : typing_narrowing_sig) <: subsumption_sig.

Lemma subsumption_mutual :
  (forall G θ a A, Typing G θ a A -> forall θ0, θ ≤ θ0 -> Typing G θ0 a A) /\
  (forall G g G0 θ A B, DefEq G g G0 θ A B -> forall θ0, θ ≤ θ0 -> DefEq G g G0 θ0 A B) /\
  (forall G, Ctx G -> True) /\
  (forall G θ a b, aBeta G θ a b -> forall θ0, θ ≤ θ0 -> aBeta G θ0 a b) /\
  (forall G δ a A, CTyping G δ a A -> forall δ0, δ ≤ δ0 -> CTyping G δ0 a A).
Proof.
  apply typing_mutual;
    intros; inv_atom_rel_tm ; eauto.
  - apply T_Var with (theta0 := theta0); eauto.
    + ltac1:(hauto q:on use: @transitivity).
  - ltac1:(sauto q:on).
  - eapply E_Reflect with (theta0 := theta0); eauto.
    ltac1:(hauto q:on use:@transitivity).
  - econstructor; eauto.
  - econstructor; eauto.
  - eapply E_PiFst with (theta0 := theta0); eauto.
    ltac1:(hauto q:on use:@transitivity).
  - econstructor; eauto.
    ltac1:(hauto q:on use:@transitivity).
  (* - pick fresh y and apply E_IndCong; repeat (spec y); eauto. *)
  - pick fresh y and apply aBeta_AbsPush; repeat (spec y).
    eauto.
    ltac1:(transitivity theta); eauto.
    eauto.
    eauto.
    eauto.
  - apply prod_lattice_leq_iff in H0; split_hyp.
    destruct r; eauto.
    constructor.
    eauto with narrow.
  - apply prod_lattice_leq_iff in H0; split_hyp.
    destruct r; eauto.
    ltac1:(sauto q:on).
Qed.

(* Lemma 3.2 (Subsumption for θ) *)
(* See subsumption_mutual for the main proof *)
Lemma typing_subsumption : forall G θ a A,
    Typing G θ a A -> forall θ0,
    θ ≤ θ0 ->
    (* ------------------ *)
    Typing G θ0 a A.
Proof. ltac1:(sfirstorder use:subsumption_mutual). Qed.

(* Lemma 3.3 (Subsumption) *)
(* See subsumption_mutual for the main proof *)
Lemma ctyping_subsumption : forall G δ a A,
    CTyping G δ a A -> forall δ0,
    δ ≤ δ0 ->
    (* ------------------ *)
    CTyping G δ0 a A.
Proof. ltac1:(sfirstorder use:subsumption_mutual). Qed.

Lemma defeq_subsumption : forall G g G0 θ A B, DefEq G g G0 θ A B -> forall θ0, θ ≤ θ0 -> DefEq G g G0 θ0 A B.
Proof. ltac1:(sfirstorder use:subsumption_mutual). Qed.

Lemma abeta_subsumption : forall G θ a b, aBeta G θ a b -> forall θ0, θ ≤ θ0 -> aBeta G θ0 a b.
Proof. ltac1:(sfirstorder use:subsumption_mutual). Qed.

End subsumption.
