From LP Require
  sigs
  lp_lc
  typing_unique
  lp_wff
  lp_narrowing
  lp_weak
  subsumption
  lp_subst
  LTy
  typing_fv
  sn_proof
  par
  preservation
  regularity
  simulation
  progress
  introalt.

Import sigs.

Module par <: par_sig := par.par.
Module lc <: lc_sig := lp_lc.lc.
Module wff <: wff_sig := lp_wff.wff.
Module unique <: unique_sig := typing_unique.unique lc wff.
Module narrowing <: typing_narrowing_sig := lp_narrowing.narrowing wff.
Module weakening <: weak_sig := lp_weak.weak narrowing.
Module subsumption <: subsumption_sig := subsumption.subsumption narrowing.
Module fv <: typing_fv_sig := typing_fv.fv wff.
Module subst <: subst_sig := lp_subst.subst fv narrowing weakening lc wff subsumption.
Module preservation <: preservation_sig := preservation.preservation lc wff unique subst subsumption narrowing weakening.
Module simulation := simulation.simulation lc wff preservation.
Module regularity <: regularity_sig := regularity.regularity lc preservation wff unique subst narrowing weakening subsumption.
Module lty <: LTy_sig := LTy.LTy lc wff regularity subst narrowing.
Module introalt <: introalt_sig := introalt.introalt lty regularity narrowing wff subsumption unique preservation.
Module consistency <: consistent_sig := sn_proof.normalization introalt narrowing lc fv wff regularity par subst preservation unique lty subsumption.
Module progress := progress.progress subsumption preservation lc consistency.

Definition progress := progress.progress.
Definition preservation := preservation.preservation_red.
Definition simulation := simulation.red_simulation.

Print Assumptions progress.
Print Assumptions preservation.
Print Assumptions simulation.
