From LP Require Import lp_ott lp_inf lp_ind lp_tactics lp_labels sigs.
From Hammer Require Import Tactics.
From Ltac2 Require Import Ltac2 Constr Control.

Module fv (Import wff : wff_sig) <: typing_fv_sig.

Ltac2 fv_solve_binder () :=
  lazy_match! goal with
    [ _ : forall x:atom, x `notin` _ -> _ |- _ ] =>
      let h := Fresh.in_goal @h in
      pick fresh $h ; repeat (spec $h);
      try (rewrite <- fv_tm_open_tm_wrt_tm_lower in * );
      fsetdec
  end.

Ltac2 fv_solve_open () :=
  lazy_match! goal with
  | [ |- context[open_tm_wrt_tm] ] =>
      rewrite -> fv_tm_open_tm_wrt_tm_upper;
      fsetdec
  | [ |- context[open_co_wrt_tm] ] =>
      rewrite -> fv_co_open_co_wrt_tm_upper;
      fsetdec
  end.

Ltac2 Notation "fv_solve_binder" := fv_solve_binder ().

Ltac2 Notation "fv_solve_open" := fv_solve_open ().

Ltac2 simpl_env_all () :=
  Control.enter (fun _ =>
                   repeat (
                       match! goal with
                         [ h : context [dom (_ ++ _)] |- _  ] =>
                           progress (fun _ => simpl_env in $h)
                       end)).

Ltac2 Notation "simpl_env_all" := simpl_env_all ().

Lemma typing_fv_mutual :
  (forall G θ a A, Typing G θ a A -> fv_tm a \u fv_tm A [<=] dom G) /\
    (forall G g G0 θ A B, DefEq G g G0 θ A B -> fv_co g \u fv_tm A \u fv_tm B [<=] dom G \u dom G0) /\
    (forall G, Ctx G -> forall x A δ0, binds x (δ0, A) G -> x `in` dom G /\ fv_tm A [<=] remove x (dom G)) /\
    (forall G θ a b, aBeta G θ a b -> fv_tm a [<=] dom G /\ fv_tm b [<=] dom G) /\
    (forall G δ a A, CTyping G δ a A -> fv_tm a \u fv_tm A [<=] dom G).
Proof.
  apply typing_mutual; intros; try split; simpl in *; simpl_env_all; (try (rewrite dom_meet_ctx_l in * )); simpl_env_all; try (fsetdec).
  - apply H in b.
    fsetdec.
  - fv_solve_binder.
  - fv_solve_binder.
  - fv_solve_open.
  (* tricky cong case *)
  - pick fresh x; repeat (spec x).
    rewrite fv_tm_open_tm_wrt_tm_upper.
    apply KeySetProperties.union_subset_3; auto.
    apply KeySetProperties.union_subset_3; auto.
    fsetdec.
    apply KeySetProperties.union_subset_3; auto.
    fsetdec.
    apply KeySetProperties.union_subset_3; auto.
    rewrite <- fv_tm_open_tm_wrt_tm_lower in H3.
    fsetdec.
    fsetdec.
    fsetdec.
  - pick fresh x for (fv_tm B1 \u fv_tm B3 \u fv_co g2 \u L \u fv_tm B2); repeat (spec x).
    destruct_notin.
    assert (tr00 : fv_co g1 [<=] union (dom G) (dom G0)) by fsetdec.
    rewrite <- fv_tm_open_tm_wrt_tm_lower in H4.
    rewrite <- fv_tm_open_tm_wrt_tm_lower in H4.
    rewrite <- fv_co_open_co_wrt_tm_lower in H4.
    assert (tr0 : fv_co g2 [<=] union (dom G) (add x (dom G0))) by fsetdec.
    apply KeySetProperties.union_subset_3; auto.
    apply KeySetProperties.union_subset_3; auto.
    clear H H1 H2.
    fsetdec.
    apply KeySetProperties.union_subset_3; auto.
    apply KeySetProperties.union_subset_3; auto.
    fsetdec.
    assert (tr1 :  (fv_tm B1) [<=] union (dom G) (add x (dom G0))) by fsetdec.
    clear H4 H2 H.
    fsetdec.
    apply KeySetProperties.union_subset_3; auto.
    fsetdec.
    assert (tr1 : fv_tm (open_tm_wrt_tm B2 (a_Conv (a_Var_f x) (g_Sym g1))) [<=] fv_tm (a_Conv (a_Var_f x) (g_Sym g1)) \u fv_tm B2) by ltac1:(sfirstorder use:fv_tm_open_tm_wrt_tm_upper).
    simpl in tr1.
    rewrite <- H3 in tr1.
    rewrite <- fv_tm_open_tm_wrt_tm_lower in tr1.
    assert (tr2 : fv_tm B3 [<=] union  (fv_co g1) (fv_tm B2)).
    clear H H2 H4.
    fsetdec.
    ltac1:(transitivity (union (fv_co g1) (fv_tm B2))); auto.
    clear tr0 tr1 H H1 H2.
    fsetdec.
  - pick fresh x; repeat (spec x).
    rewrite <- fv_tm_open_tm_wrt_tm_lower in H2.
    rewrite <- fv_tm_open_tm_wrt_tm_lower in H2.
    rewrite <- fv_co_open_co_wrt_tm_lower in H2.
    destruct_notin.
    fsetdec.
  - rewrite fv_tm_open_tm_wrt_tm_upper.
    rewrite fv_tm_open_tm_wrt_tm_upper.
    simpl.
    fsetdec.
  (* Ind *)
  - pick fresh x for (fv_tm b3 \u L \u fv_co g3 \u fv_tm a3); repeat (spec x).
    destruct_notin.
    assert (fv_co g [<=] union (dom G) (dom G0)) by fsetdec.
    assert (fv_tm a1 [<=] union (dom G) (dom G0)) by fsetdec.
    assert (fv_tm a2 [<=] union (dom G) (dom G0)) by fsetdec.
    assert (fv_tm b1 [<=] union (dom G) (dom G0)) by fsetdec.
    assert (fv_tm b2 [<=] union (dom G) (dom G0)) by fsetdec.
    assert (fv_co g1 [<=] union (dom G) (dom G0)) by fsetdec.
    assert (fv_co g2 [<=] union (dom G) (dom G0)) by fsetdec.
    assert (fv_co g3 [<=] union (dom G) (dom G0)) by (clear H0 H2 H3; rewrite <- fv_co_open_co_wrt_tm_lower in H5; fsetdec).
    assert (fv_tm a3 [<=] union (dom G) (dom G0)) by (clear H0 H2 H3; rewrite <- fv_tm_open_tm_wrt_tm_lower in H5; fsetdec).
    assert (fv_tm b3 [<=] union (dom G) (dom G0)) by (clear H0 H2 H5;  fsetdec).
    assert (fv_tm A [<=] union (dom G) (dom G0)) by (clear H0 H2 H4 H5; fsetdec).
    clear H H0 H2 H3 H4 H5.
    fsetdec.
  (* binds cons *)
  - apply binds_cons_uniq_1 in H1.
    destruct H1; subst; eauto; split_hyp; subst.
    + inversion H2; subst.
      fsetdec.
    + ltac1:(sfirstorder final:fsetdec).
    + ltac1:(sfirstorder use:Ctx_uniq).
  - apply binds_cons_uniq_1 in H1.
    destruct H1; subst; eauto; split_hyp; subst.
    + inversion H2; subst.
      fsetdec.
    + assert (fv_tm A0 [<=] remove x0 (dom G)) by ltac1:(sfirstorder).
      fsetdec.
    + ltac1:(sfirstorder use:Ctx_uniq).
  - fv_solve_open.
  - pick fresh x; repeat (spec x).
    destruct_notin.
    apply KeySetProperties.union_subset_3; auto.
    fsetdec.

    assert (tr0: fv_tm (open_tm_wrt_tm a1 (a_Conv (a_Var_f x) (g_Sym (g_PiFst theta0 g)))) [<=]
                   fv_tm (a_Conv (a_Var_f x) (g_Sym (g_PiFst theta0 g))) \u fv_tm a1)
      by ltac1:(hauto lq:on rew:off use:fv_tm_open_tm_wrt_tm_upper).
    rewrite <- H2 in tr0.
    simpl in tr0.
    rewrite <- fv_tm_open_tm_wrt_tm_lower in tr0.
    assert (tr1 : fv_tm a2 [<=] union (fv_co g) (fv_tm a1)) by fsetdec.
    clear tr0.
    rewrite tr1.
    apply KeySetProperties.union_subset_3; auto.
    fsetdec.
    clear tr1.
    assert (fv_co (g_PiSnd g theta0 (g_Reflex (a_Var_f x)) (g_Sym (g_PiFst theta0 g))) [<=] union (fv_co g) (singleton x)).
    simpl.
    fsetdec.
    rewrite <- H1 in H3.
    rewrite <- fv_co_open_co_wrt_tm_lower in H3.
    fsetdec.
  - fv_solve_open.
Qed.

Set Default Proof Mode "Classic".
Lemma typing_fv1 : forall Γ θ a A, Typing Γ θ a A -> fv_tm a [<=] dom Γ.
Proof.
  qauto l:on use:typing_fv_mutual final:fsetdec.
Qed.

Lemma typing_fv2 : forall Γ θ a A, Typing Γ θ a A -> fv_tm A [<=] dom Γ.
Proof.
  qauto l:on use:typing_fv_mutual final:fsetdec.
Qed.

Lemma typing_empty_fv1 : forall θ a A, Typing nil θ a A -> fv_tm a [=] empty.
Proof.
  qauto l:on use:typing_fv1 final:fsetdec.
Qed.
Lemma typing_empty_fv2 : forall θ a A, Typing nil θ a A -> fv_tm A [=] empty.
Proof.
  qauto l:on use:typing_fv2 final:fsetdec.
Qed.

Lemma typing_empty_fv : forall θ a A, Typing nil θ a A -> fv_tm a [=] empty /\ fv_tm A [=] empty.
Proof.
  hauto l:on use:typing_empty_fv1, typing_empty_fv2.
Qed.

Lemma defeq_fv1 : forall Γ g Γ0 θ a b, DefEq Γ g Γ0 θ a b -> fv_co g [<=] dom Γ \u dom Γ0.
Proof.
  qauto l:on use:typing_fv_mutual final:fsetdec.
Qed.

Lemma defeq_empty_fv1 : forall g θ A B,
    DefEq nil g nil θ A B -> fv_co g [=] empty.
Proof.
  qauto l:on use:defeq_fv1 final:fsetdec.
Qed.

Lemma ctx_fv : forall G, Ctx G -> forall x A δ0, binds x (δ0, A) G -> x `in` dom G /\ fv_tm A [<=] remove x (dom G).
Proof.
  qauto l:on use:typing_fv_mutual final:fsetdec.
Qed.

End fv.
