(* Every term can have only a single type *)
From LP Require Import lp_inf lp_ott lp_ind lp_tactics sigs.
From Hammer Require Import Tactics.
From Ltac2 Require Import Ltac2 Constr Control.

Module unique
  (Import lc : lc_sig)
  (Import wff : wff_sig) <: unique_sig.


Lemma typing_unique_mutual :
  (forall G θ a A, Typing G θ a A -> forall B, Typing G θ a B -> A = B) /\
  (forall G g G0 θ A B, DefEq G g G0 θ A B -> forall A1 B1, DefEq G g G0 θ A1 B1 -> A = A1 /\ B = B1) /\
  (forall G, Ctx G -> True) /\
  (forall G θ a b, aBeta G θ a b -> True) /\
  (forall G δ a A, CTyping G δ a A -> forall B, CTyping G δ a B -> A = B).
Proof.
  apply typing_mutual; intros; eauto; try ltac1:(sauto lq:on rew:off depth:1); try split.
  - inversion H0; subst.
    enough ((q_R, theta0, A) = (q_R, theta2, B)) by ltac1:(congruence).
    ltac1:(sfirstorder use:binds_unique, Ctx_uniq solve:solve_uniq).
  - inversion H1; subst.
    pick fresh x; repeat (spec x).
    f_equal; auto.
    rewrite <- (close_tm_wrt_tm_open_tm_wrt_tm B x); auto.
    rewrite <- (close_tm_wrt_tm_open_tm_wrt_tm B1 x); auto.
    ltac1:(hauto lq:on rew:off).
  - inversion H3; subst.
    (assert (h0 : A1 = A3) by ltac1:(sfirstorder)); subst.
    f_equal; auto.
    pick fresh x.
    rewrite <- (close_tm_wrt_tm_open_tm_wrt_tm B1 x); auto.
    rewrite <- (close_tm_wrt_tm_open_tm_wrt_tm B4 x); auto.
    repeat (spec x); auto.
    ltac1:(hauto lq: on rew: off).
  - inversion H3; subst.
    (assert (h1 : A2 = A4 /\ A1 = A3) by ltac1:(sfirstorder)); split_hyp; subst.
    f_equal; auto.
    pick fresh x; repeat (spec x); auto.
    rewrite <- (close_tm_wrt_tm_open_tm_wrt_tm B3 x); auto.
    rewrite <- (close_tm_wrt_tm_open_tm_wrt_tm B5 x); auto.
    apply H9 in H5; split_hyp.
    rewrite H4.
    rewrite H6.
    clear H4 H0 H6 H7 H9 H15 H16 H1 t d H H2 H3.
    assert (lc_co g1) by eauto using defeq_lc1.
    destruct_notin.
    ltac1:(hauto drew: off use: close_tm_wrt_tm_open_tm_wrt_tm).
  - inversion H2; subst.
    pick fresh x; repeat (spec x).
    f_equal; eauto.
    apply H4 in H3; eauto; split_hyp.
    rewrite <- (close_tm_wrt_tm_open_tm_wrt_tm a1 x); auto.
    rewrite <- (close_tm_wrt_tm_open_tm_wrt_tm a0 x); auto.
    ltac1:(congruence).
  - inversion H2; subst.
    pick fresh x; repeat (spec x).
    f_equal; eauto.
    apply H4 in H3; eauto; split_hyp.
    rewrite <- (close_tm_wrt_tm_open_tm_wrt_tm a2 x); auto.
    rewrite <- (close_tm_wrt_tm_open_tm_wrt_tm a3 x); auto.
    rewrite H5.
    auto.
  - inversion H4; subst; auto.
    ltac1:(hauto lq:on rew:off).
  - inversion H4; subst; auto.
    ltac1:(hauto lq:on rew:off).
  - inversion H5; subst.
    pick fresh y; repeat (spec y).
    f_equal; eauto.
    f_equal; try ltac1:(hauto l:on depth:1).
    rewrite <- (close_tm_wrt_tm_open_tm_wrt_tm a3 y); auto.
    rewrite <- (close_tm_wrt_tm_open_tm_wrt_tm a5 y); auto.
    ltac1:(hauto lq:on rew:off).
  - inversion H5; subst.
    pick fresh y; repeat (spec y).
    f_equal; try ltac1:(hauto l:on depth:1).
    rewrite <- (close_tm_wrt_tm_open_tm_wrt_tm b3 y); auto.
    rewrite <- (close_tm_wrt_tm_open_tm_wrt_tm b5 y); auto.
    ltac1:(hauto lq:on rew:off).
Qed.

(* Lemma 3.6 (Unique typing) *)
(* See typing_unique_mutual for the main proof *)
Lemma typing_unique : forall G θ a A,
    Typing G θ a A -> forall B,
    (* ------------------ *)
    Typing G θ a B -> A = B.
  Proof. ltac1:(sfirstorder use:typing_unique_mutual). Qed.

Lemma defeq_unique1 : forall G g G0 θ A B, DefEq G g G0 θ A B -> forall A1 B1, DefEq G g G0 θ A1 B1 -> A = A1.
Proof. ltac1:(hauto use:typing_unique_mutual). Qed.
Lemma defeq_unique2 : forall G g G0 θ A B, DefEq G g G0 θ A B -> forall A1 B1, DefEq G g G0 θ A1 B1 -> B = B1.
Proof. ltac1:(hauto use:typing_unique_mutual). Qed.
Lemma ctyping_unique : forall G δ a A, CTyping G δ a A -> forall B, CTyping G δ a B -> A = B.
Proof. ltac1:(sfirstorder use:typing_unique_mutual). Qed.
End unique.
